#macro debugFrame (bottomLeftFrontVec, topRightBackVec, aradius)
    
    // BOTTOM
    
    cylinder {
        <bottomLeftFrontVec.x, bottomLeftFrontVec.y, bottomLeftFrontVec.z>
        <bottomLeftFrontVec.x, bottomLeftFrontVec.y, topRightBackVec.z>
        aradius
        pigment {color <0,0,1>}
    }

    cylinder {
        <bottomLeftFrontVec.x, bottomLeftFrontVec.y, topRightBackVec.z>
        <topRightBackVec.x, bottomLeftFrontVec.y, topRightBackVec.z>
        aradius
        pigment {color <0,1,0>}
    }


    cylinder {
        <topRightBackVec.x, bottomLeftFrontVec.y, topRightBackVec.z>
        <topRightBackVec.x, bottomLeftFrontVec.y, bottomLeftFrontVec.z>
        aradius
        pigment {color <1,0,0>}
    }

      
    cylinder {
        <topRightBackVec.x, bottomLeftFrontVec.y, bottomLeftFrontVec.z>
        <bottomLeftFrontVec.x, bottomLeftFrontVec.y, bottomLeftFrontVec.z>
        aradius
        pigment {color <1,1,0>}
    }
         
    // TOP
    
    cylinder {
        <bottomLeftFrontVec.x, topRightBackVec.y, bottomLeftFrontVec.z>
        <bottomLeftFrontVec.x, topRightBackVec.y, topRightBackVec.z>
        aradius
        pigment {color <0,0,1>}
    } 
    
    
    
    cylinder {
        <bottomLeftFrontVec.x, topRightBackVec.y, topRightBackVec.z>
        <topRightBackVec.x, topRightBackVec.y, topRightBackVec.z>
        aradius
        pigment {color <0,1,0>}
    }


    cylinder {
        <topRightBackVec.x, topRightBackVec.y, topRightBackVec.z>
        <topRightBackVec.x, topRightBackVec.y, bottomLeftFrontVec.z>
        aradius
        pigment {color <1,0,0>}
    }

      
    cylinder {
        <topRightBackVec.x, topRightBackVec.y, bottomLeftFrontVec.z>
        <bottomLeftFrontVec.x, topRightBackVec.y, bottomLeftFrontVec.z>
        aradius
        pigment {color <1,1,0>}
    }
            
    
    // SIDE
         
    cylinder {
        <bottomLeftFrontVec.x, bottomLeftFrontVec.y, bottomLeftFrontVec.z>
        <bottomLeftFrontVec.x, topRightBackVec.y, bottomLeftFrontVec.z>
        aradius
        pigment {color <1,1,1>}
    } 


    cylinder {
        <bottomLeftFrontVec.x, bottomLeftFrontVec.y, topRightBackVec.z>
        <bottomLeftFrontVec.x, topRightBackVec.y, topRightBackVec.z>
        aradius
        pigment {color <1,1,1>}
    } 
    
    
    cylinder {
        <topRightBackVec.x, topRightBackVec.y, topRightBackVec.z>
        <topRightBackVec.x, bottomLeftFrontVec.y, topRightBackVec.z>
        aradius
        pigment {color <1,1,1>}
    } 
    
      
    cylinder {
        <topRightBackVec.x, topRightBackVec.y, bottomLeftFrontVec.z>
        <topRightBackVec.x, bottomLeftFrontVec.y, bottomLeftFrontVec.z>
        aradius
        pigment {color <1,1,1>}
    } 
    
    
    // FLOOR ARROW
    
    cylinder {
        <bottomLeftFrontVec.x, bottomLeftFrontVec.y, bottomLeftFrontVec.z>
        <bottomLeftFrontVec.x + (topRightBackVec.x - bottomLeftFrontVec.x)/2, bottomLeftFrontVec.y, topRightBackVec.z>
        aradius
        pigment {color <1,0,1>}
    }


    
    cylinder {
        <topRightBackVec.x, bottomLeftFrontVec.y, bottomLeftFrontVec.z>
        <bottomLeftFrontVec.x + (topRightBackVec.x - bottomLeftFrontVec.x)/2, bottomLeftFrontVec.y, topRightBackVec.z>
        aradius
        pigment {color <1,0,1>}
    }
              

#end


#macro debugPoint (positionVec, aradius)
    sphere {
        positionVec, aradius
        pigment { color <1,0,0>}       
    
    }

#end