

// ----------------------------------------
// LIGHTS
// ---------------------------------------- 

#local backStrobeOn = rsclockRepeat(clock,(numberOfFrames)/60);  
#if (strobeAlwaysOn) 
    #local backStrobeOn = 1;
#end

#if(backLight)

 #if (cameraClock < 0.45)
     light_source {
        
        <0, bottomCorner.y *0.9, topCorner.z * 0.9>
        color rgb <0.4,0.4,0.6 + (0.2 * cameraClock)> * (1-cameraClock*2)       
        
        spotlight
        
        radius ballSpotRadius * 2  * (1-cameraClock*2)
        falloff ballSpotRadius * 3 * (1-cameraClock*2)
        
        tightness 10
       
        photons {           // photon block for a light source
        refraction off
        reflection off
        }
        
        //point_at ballPosition 
        //point_at <0,-roomSize/6,roomSize/3>                      
        point_at  actualDancerCenter
        
        
      }
  #else
  // create a regular point light source
        light_source {
          0*x                  // light's position (translated below)
          color rgb <0.4,0.4,0.6> * (cameraClock-0.45)    // light's color
          translate  ballPosition
        }
      
  #end
#end
  
   
#if (strobeAlwaysOn) 
    #local backStrobeOn = 0;
#end   

    #if (sideSpots)
    
        #local strobeOn = rsclockRepeat(clock,(numberOfFrames)/15);
        #if(strobeAlwaysOn)
            #local strobeOn = 0;
        #end
    
     
     #declare laserY = 20 - 40 * sin (radians((numberOfFrames)/7) * clock * 360);
     
    
     #if(strobeOn<0.5)  
     
     #local sideSpotRadius = ballSpotRadius *0.25;
    
     light_source {
        
        <-sideSpot_A_Pos.x, sideSpot_A_Pos.y, sideSpot_A_Pos.z>
        color rgb <3,4,3>
        spotlight
        radius sideSpotRadius/4
        falloff sideSpotRadius
        tightness 10
       
        photons {           // photon block for a light source
        refraction off
        reflection off
        }
        
        //point_at ballPosition 
        //point_at <0,-roomSize/6,roomSize/3>                      
        point_at  actualDancerCenter + <0,laserY,0>
        
        
        
      }     
          
    
     
      light_source {
        sideSpot_A_Pos
        color rgb <3,4,3>
        spotlight
        radius sideSpotRadius/4
        falloff sideSpotRadius
        tightness 10
       
        photons {           // photon block for a light source
        refraction off
        reflection off
        }
        
        //point_at ballPosition 
        //point_at <0,-roomSize/6,roomSize/3> 
        point_at  actualDancerCenter + <0,-laserY,0>
        
      }      
     
      #end
    
    #end 
 

//***** BLUE LASER **************************************************************************************************
#if(blueLaser)
 #declare laserZ = -160;


  



#local laserPlateRadius = 120;
#local boreholeRadius = 0.2;
#local xdisp = 10;
#local rotidx = 0;                                         

#local boreHole = cylinder {<0,-2,0> <0,2,0>, boreholeRadius pigment {color Blue}}                             
#declare laserPlate = union {    
    //cylinder { <0, 0, 0>, <0, 1, 0>, laserPlateRadius }
    
    #while (xdisp < laserPlateRadius)
        object {boreHole
            translate <xdisp, 0,0>
            rotate <0, rotidx, 0>
        }
        #local xdisp = xdisp + 2 * 0.875;
        #local rotidx = rotidx + 15;
    #end
}                     


#local laserPlateRotateClock = rsclockRepeat(clock,numberOfFrames/60);
 
 
    
 light_source {
    //<topCorner.x * 0.9, bottomCorner.y *0.9, topCorner.z * 0.9>
    //<0.0, 20, 0-(roomSize - (ballSize*3))>
    <0.0, ceilingLevel * 1.5, laserZ>
    color rgb <0,0,400>
    spotlight 
    
    radius ballSpotRadius*6
    falloff ballSpotRadius *6
    tightness 10
    
    projected_through {
        laserPlate 
    translate <0,ceilingLevel*0.6,laserZ>   
    rotate <0,360 * laserPlateRotateClock,0>

    }
    
    photons {           // photon block for a light source
    refraction on
    reflection on
    }
    
    //point_at <0,-roomSize/6,roomSize/3>                                               laserPlateRadius
    //point_at  actualDancerCenter
    point_at <0,0,laserZ>
    
  }  
 

/*
object {
    laserPlate 
    translate <0,ceilingLevel*0.6,laserZ>   
    rotate <0,360 * laserPlateRotateClock,0>
} 
  */
 
#end 
