// Persistence Of Vision raytracer version 2.0 data file.

// standard OREO cookie by gordon smith.
// Scale: 1mm = 1 Unit
// location is centered at the origin, OREO logo on top reads from -z to +z.

#declare oreo_diameter = 45
#declare oreo_radius = 22.5
#declare oreo_outline_r = 2
#declare oreo_top_y = oreo_outline_r
#declare oreo_bottom_y = -oreo_outline_r
#declare oreo_plateau = oreo_top_y - (oreo_outline_r/4)
#declare oreo_cone_base_radius = 0.375
#declare oreo_cone_top_radius = 0.1

#declare oreo_flower_center = 15
#declare oreo_cursor_center = 19.5
#declare oreo_logo_rim_center = 10

#declare oreo_height = oreo_top_y+oreo_outline_r

#declare flowers_subobject =
   union {
      box {<0,oreo_plateau,0>, <1,oreo_top_y,1>}
      cylinder {<0,oreo_plateau,0>, <0,oreo_top_y,0>, 0.5 translate <1,0,0.5>}
      cylinder {<0,oreo_plateau,0>, <0,oreo_top_y,0>, 0.5 translate <0.5,0,1>}
      translate <0.2, 0, 0.2>
      scale <5/3, 1, 5/3>
      }

#declare flowers_object = 
   union {
      object {flowers_subobject rotate <0,-45,0>}
      object {flowers_subobject rotate <0,45,0>}
      object {flowers_subobject rotate <0,135,0>}
      object {flowers_subobject rotate <0,225,0>}
      translate <oreo_flower_center,0,0>
      }

#declare flowers =
   union {
      object {flowers_object rotate <0,15.000,0>}
      object {flowers_object rotate <0,45.000,0>}
      object {flowers_object rotate <0,75.000,0>}
      object {flowers_object rotate <0,105.000,0>}
      object {flowers_object rotate <0,135.000,0>}
      object {flowers_object rotate <0,165.000,0>}
      object {flowers_object rotate <0,195.000,0>}
      object {flowers_object rotate <0,225.000,0>}
      object {flowers_object rotate <0,255.000,0>}
      object {flowers_object rotate <0,285.000,0>}
      object {flowers_object rotate <0,315.000,0>}
      object {flowers_object rotate <0,345.000,0>}
      }

#declare little_cone =
   cone {<0,oreo_plateau,0>, oreo_cone_base_radius, <0,oreo_plateau+(oreo_top_y-oreo_plateau)*2/3,0>, oreo_cone_top_radius}

#declare cones_object =
   union {
      object {little_cone translate <oreo_flower_center+2,0,0>}
      object {little_cone translate <oreo_flower_center-3,0,0>}
      object {
         little_cone
         translate <oreo_cursor_center,0,0>
         rotate <0,15.000,0>
         }
      }

#declare cones =
   union {
      object {cones_object rotate <0,0.000,0>}
      object {cones_object rotate <0,30.000,0>}
      object {cones_object rotate <0,60.000,0>}
      object {cones_object rotate <0,90.000,0>}
      object {cones_object rotate <0,120.000,0>}
      object {cones_object rotate <0,150.000,0>}
      object {cones_object rotate <0,180.000,0>}
      object {cones_object rotate <0,210.000,0>}
      object {cones_object rotate <0,240.000,0>}
      object {cones_object rotate <0,270.000,0>}
      object {cones_object rotate <0,300.000,0>}
      object {cones_object rotate <0,330.000,0>}
      }

#declare cursor_object =
   union {
      difference {
         cylinder {<0,oreo_plateau,0>, <0,oreo_top_y,0> oreo_cursor_center+0.5}
         cylinder {<0,oreo_plateau,0>, <0,oreo_top_y+1,0> oreo_cursor_center-0.25}
         plane {<0,0,1>, 0 rotate <0,8,0>}
         plane {<0,0,-1>, 0 rotate <0,-8,0>}
         bounded_by { sphere {<18,0,0>, 5}}
         }
      object {little_cone translate <oreo_flower_center+2,0,0>}
      object {little_cone translate <oreo_flower_center-3,0,0>}
      }

#declare cursors =
   union {
      object {cursor_object rotate <0,0.000,0>}
      object {cursor_object rotate <0,30.000,0>}
      object {cursor_object rotate <0,60.000,0>}
      object {cursor_object rotate <0,90.000,0>}
      object {cursor_object rotate <0,120.000,0>}
      object {cursor_object rotate <0,150.000,0>}
      object {cursor_object rotate <0,180.000,0>}
      object {cursor_object rotate <0,210.000,0>}
      object {cursor_object rotate <0,240.000,0>}
      object {cursor_object rotate <0,270.000,0>}
      object {cursor_object rotate <0,300.000,0>}
      object {cursor_object rotate <0,330.000,0>}
      }

#declare fins_object =
   union {
      sphere {<0,0,0>,oreo_outline_r scale <0.75,1,0.5>}
      cylinder {<0,oreo_bottom_y,0>, <0,0,0> 1 translate <0.5,0,0>}
      translate <oreo_radius-0.2,0,0>
      }

#declare fins = union {
   object {fins_object rotate <0,0.000,0>}
   object {fins_object rotate <0,3.600,0>}
   object {fins_object rotate <0,7.200,0>}
   object {fins_object rotate <0,10.800,0>}
   object {fins_object rotate <0,14.400,0>}
   object {fins_object rotate <0,18.000,0>}
   object {fins_object rotate <0,21.600,0>}
   object {fins_object rotate <0,25.200,0>}
   object {fins_object rotate <0,28.800,0>}
   object {fins_object rotate <0,32.400,0>}
   object {fins_object rotate <0,36.000,0>}
   object {fins_object rotate <0,39.600,0>}
   object {fins_object rotate <0,43.200,0>}
   object {fins_object rotate <0,46.800,0>}
   object {fins_object rotate <0,50.400,0>}
   object {fins_object rotate <0,54.000,0>}
   object {fins_object rotate <0,57.600,0>}
   object {fins_object rotate <0,61.200,0>}
   object {fins_object rotate <0,64.800,0>}
   object {fins_object rotate <0,68.400,0>}
   object {fins_object rotate <0,72.000,0>}
   object {fins_object rotate <0,75.600,0>}
   object {fins_object rotate <0,79.200,0>}
   object {fins_object rotate <0,82.800,0>}
   object {fins_object rotate <0,86.400,0>}
   object {fins_object rotate <0,90.000,0>}
   object {fins_object rotate <0,93.600,0>}
   object {fins_object rotate <0,97.200,0>}
   object {fins_object rotate <0,100.800,0>}
   object {fins_object rotate <0,104.400,0>}
   object {fins_object rotate <0,108.000,0>}
   object {fins_object rotate <0,111.600,0>}
   object {fins_object rotate <0,115.200,0>}
   object {fins_object rotate <0,118.800,0>}
   object {fins_object rotate <0,122.400,0>}
   object {fins_object rotate <0,126.000,0>}
   object {fins_object rotate <0,129.600,0>}
   object {fins_object rotate <0,133.200,0>}
   object {fins_object rotate <0,136.800,0>}
   object {fins_object rotate <0,140.400,0>}
   object {fins_object rotate <0,144.000,0>}
   object {fins_object rotate <0,147.600,0>}
   object {fins_object rotate <0,151.200,0>}
   object {fins_object rotate <0,154.800,0>}
   object {fins_object rotate <0,158.400,0>}
   object {fins_object rotate <0,162.000,0>}
   object {fins_object rotate <0,165.600,0>}
   object {fins_object rotate <0,169.200,0>}
   object {fins_object rotate <0,172.800,0>}
   object {fins_object rotate <0,176.400,0>}
   object {fins_object rotate <0,180.000,0>}
   object {fins_object rotate <0,183.600,0>}
   object {fins_object rotate <0,187.200,0>}
   object {fins_object rotate <0,190.800,0>}
   object {fins_object rotate <0,194.400,0>}
   object {fins_object rotate <0,198.000,0>}
   object {fins_object rotate <0,201.600,0>}
   object {fins_object rotate <0,205.200,0>}
   object {fins_object rotate <0,208.800,0>}
   object {fins_object rotate <0,212.400,0>}
   object {fins_object rotate <0,216.000,0>}
   object {fins_object rotate <0,219.600,0>}
   object {fins_object rotate <0,223.200,0>}
   object {fins_object rotate <0,226.800,0>}
   object {fins_object rotate <0,230.400,0>}
   object {fins_object rotate <0,234.000,0>}
   object {fins_object rotate <0,237.600,0>}
   object {fins_object rotate <0,241.200,0>}
   object {fins_object rotate <0,244.800,0>}
   object {fins_object rotate <0,248.400,0>}
   object {fins_object rotate <0,252.000,0>}
   object {fins_object rotate <0,255.600,0>}
   object {fins_object rotate <0,259.200,0>}
   object {fins_object rotate <0,262.800,0>}
   object {fins_object rotate <0,266.400,0>}
   object {fins_object rotate <0,270.000,0>}
   object {fins_object rotate <0,273.600,0>}
   object {fins_object rotate <0,277.200,0>}
   object {fins_object rotate <0,280.800,0>}
   object {fins_object rotate <0,284.400,0>}
   object {fins_object rotate <0,288.000,0>}
   object {fins_object rotate <0,291.600,0>}
   object {fins_object rotate <0,295.200,0>}
   object {fins_object rotate <0,298.800,0>}
   object {fins_object rotate <0,302.400,0>}
   object {fins_object rotate <0,306.000,0>}
   object {fins_object rotate <0,309.600,0>}
   object {fins_object rotate <0,313.200,0>}
   object {fins_object rotate <0,316.800,0>}
   object {fins_object rotate <0,320.400,0>}
   object {fins_object rotate <0,324.000,0>}
   object {fins_object rotate <0,327.600,0>}
   object {fins_object rotate <0,331.200,0>}
   object {fins_object rotate <0,334.800,0>}
   object {fins_object rotate <0,338.400,0>}
   object {fins_object rotate <0,342.000,0>}
   object {fins_object rotate <0,345.600,0>}
   object {fins_object rotate <0,349.200,0>}
   object {fins_object rotate <0,352.800,0>}
   object {fins_object rotate <0,356.400,0>}
   }

#declare db_minor_r = 3
#declare db_major_r = 15

#declare doodad_big =
   difference {
      cylinder {<0,oreo_plateau,0>, <0,oreo_top_y,0>, db_minor_r}
      cylinder {<0,oreo_plateau,0>, <0,oreo_top_y+1,0>, db_major_r translate <db_major_r-db_minor_r+1.5,0,0>}
      plane {<0,0,1>, -2.5}
      plane {<0,0,-1>, -2.5}
      translate <db_minor_r,0,0>
      bounded_by {sphere {<db_minor_r,0,0>, db_minor_r}}
      }

#declare dl_minor_r = 2
#declare dl_major_r = 15

#declare doodad_little =
   difference {
      cylinder {<0,oreo_plateau,0>, <0,oreo_top_y,0>, dl_minor_r}
      cylinder {<0,oreo_plateau,0>, <0,oreo_top_y+1,0>, dl_major_r translate <dl_major_r-db_minor_r+2,0,0>}
      plane {<0,0,1>, -1.75}
      plane {<0,0,-1>, -1.75}
      translate <dl_minor_r,0,0>
      bounded_by {sphere {<dl_minor_r,0,0>, dl_minor_r}}
      }

#declare logo =
   union {
      // bounding ellipse
      difference {
         cylinder {<0,oreo_plateau,0>, <0,oreo_top_y,0>, oreo_logo_rim_center+0.5}
         cylinder {<0,oreo_plateau,0>, <0,oreo_top_y+1,0>, oreo_logo_rim_center-0.25}
         scale <12/19,1,1>
         bounded_by {sphere {<0,0,0>, oreo_logo_rim_center+0.5}}
         }
      // antenna
      box {<oreo_logo_rim_center*-2/3,oreo_plateau,-0.5>, <-oreo_flower_center+2.5,oreo_top_y,0.5>}
      box {<-oreo_flower_center+5,oreo_plateau,-4>, <-oreo_flower_center+4.25,oreo_top_y,4>}
      box {<-oreo_flower_center+7,oreo_plateau,-5.25>, <-oreo_flower_center+6.25,oreo_top_y,5.25>}
      // O
      difference {
         cylinder {<0,oreo_plateau,0>, <0,oreo_top_y,0>, 3.0}
         cylinder {<0,oreo_plateau,0>, <0,oreo_top_y+1,0>, 2.25}
         scale <1,1,2/3>
         translate <0,0,-6>
//         bounded_by {sphere {<0,0,-6>, 3}}
         }
      // R
      union {
         box {<0,oreo_plateau,0>, <-6,oreo_top_y,0.75>}
         difference {
            difference {
               cylinder {<0,oreo_plateau,0>, <0,oreo_top_y,0>, 2.5}
               cylinder {<0,oreo_plateau,0>, <0,oreo_top_y+1,0>, 1.75}
               scale <2/3,1,1.25>
               translate <-6+2.5*2/3,0,0.5>
               }
            plane {<0,0,1>, 0}
            }
         difference {
            box {<0,oreo_plateau,0>, <-0.75,oreo_top_y,3.5>
               rotate <0,65,0>
               translate <-2.8,0,1.25>
               }
            plane {<-1,0,0>, 0}
            }
         translate <3,0,-3.5>
         }
      // E
      union {
         box {<0,oreo_plateau,0>, <-6,oreo_top_y,0.75>}
         box {<-6,oreo_plateau,0>, <-5.25,oreo_top_y,3>}
         box {<-2.65,oreo_plateau,0>, <-3.35,oreo_top_y,2>}
         box {<0,oreo_plateau,0>, <-0.75,oreo_top_y,3>}
         translate <3,0,0.5>
         }
      // O
      difference {
         cylinder {<0,oreo_plateau,0>, <0,oreo_top_y,0>, 3.0}
         cylinder {<0,oreo_plateau,0>, <0,oreo_top_y+1,0>, 2.25}
         scale <1,1,2/3>
         translate <0,0,6>
//         bounded_by {sphere {<0,0,6>, 3}}
         }
      object {doodad_big translate <-5.5,0,0>}
      object {doodad_big rotate <0,180,0> translate <5.5,0,0>}
      }

#declare flower3 =
   union {
      object {doodad_big rotate <0,-50,0> translate <0,0,0.35>}
      object {doodad_big rotate <0,50,0> translate <0,0,-0.35>}
      cylinder {<0,oreo_plateau,0>, <0,oreo_top_y,0>, 1 translate <-0.25,0,0>}
      }

#declare doodads =
   union {
         object {flower3 translate <oreo_logo_rim_center-1,0,0>}

         // next to flower
         object {doodad_little rotate <0,-30,0> translate <oreo_logo_rim_center-0.9,0,4>}
         object {doodad_little rotate <0,30,0> translate <oreo_logo_rim_center-0.9,0,-4>}

         // top left and right
         object {doodad_little rotate <0,153,0> translate <oreo_logo_rim_center-2.8,0,7.25>}
         object {doodad_little rotate <0,-153,0> translate <oreo_logo_rim_center-2.8,0,-7.25>}

         // bottom left and right
         object {doodad_little rotate <0,27,0> translate <-oreo_logo_rim_center+2.8,0,7.25>}
         object {doodad_little rotate <0,-27,0> translate <-oreo_logo_rim_center+2.8,0,-7.25>}
      }   	

#declare oreo_top =
   difference {
      union {
         object {fins}
         object {flowers}
         object {cursors}
         object {logo}
         object {cones}
         object {doodads}
         cylinder {<0,oreo_bottom_y,0>, <0,oreo_plateau,0>, oreo_radius}
         }
      plane {<0,1,0>, oreo_bottom_y+1}
      bounded_by {box {<oreo_radius+oreo_outline_r, oreo_top_y, oreo_radius+oreo_outline_r>, <-oreo_radius-oreo_outline_r,oreo_bottom_y+0.4, -oreo_radius-oreo_outline_r>}}
      }

#declare oreo_texture =
   texture {
//      pigment { color red 0.31 green 0.176 blue 0.067 } //RGB 79,45,17
      pigment { color red 0.11 green 0.066 blue 0.027 }
      finish {specular 0.1 roughness 0.3 ambient 0.3 brilliance 2.0}
      }

#declare oreo_fill_texture = texture { pigment { White } finish {ambient 0.6}}

#default { texture { oreo_texture }}

declare oreo =
   union {
      object {oreo_top translate <0,oreo_outline_r,0> texture {oreo_texture}}
      object {oreo_top rotate <180,79,0> translate <1.3,-oreo_outline_r,0.7> texture {oreo_texture}}
      torus  {oreo_radius-1*oreo_outline_r, oreo_outline_r texture {oreo_fill_texture}}
      }
