// Persistence Of Vision raytracer version 2.0 data file.

// Semi-cosmic oreo and milk scene by gordon smith.
// scale: 1 unit = 0.5mm

#include "colors.inc"
#include "textures.inc"
//#include "fov.inc"

#include "oreo.inc"
#include "ship.inc"
#include "table.inc"
#include "glass.inc"

camera {
  location  <-5, 17, -5>
  direction <0, 0, 1>
  up        <0, 1,  0>
  right   <4/3, 0,  0>
  look_at   <-100, 33, -60>
}

// left of view
light_source {<-10, 40, -100> color red 0.8 green 0.8 blue 0.8}

// right
light_source {<-100, 60, 45> color White}

// center
//light_source {<-1, 20, -15> color red 0.5 green 0.3 blue 0.375}

// under ship
//light_source {<-220, 60, -35> color red 1.0}
light_source {<-220, 60, -45> color red 1.0}
light_source {<-200, 60, -45> color red 1.0 green 0.7 blue 0.7}
light_source {<-200, 60, -35> color red 1.0}

object {table}

object {glass scale 50 translate <-145,-1.43,-205>}

object {oreo translate <-85,2*oreo_outline_r,-125> scale 0.5}
object {
   oreo
   rotate <25,0,0>
   translate <-95,3.3*oreo_height,-85>
   scale 0.5
   }

object {oreo_ship scale 5 rotate <15,0,5> translate <-200,80,-35>}
