//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 3 lights, 7 textures and 40 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE (c) 1991-1994 SoftTronics by Lutz Kretzschmar + Markus Lutz
//

//  Date : 04/27/1995    (27.04.1995)
//

//
//  This is the standard include file for POV.
//

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"


camera {  //  Camera StdCam
  location  <0.626, -15.149, 10.125>
  direction <0.0,     0.0,  3.0071>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <4.108, -1.877, 0.317>
}

// *******  L I G H T S *******
light_source {   // fill_light
  <-11.509, -7.525, 2.581>
  color rgb <0.235, 0.235, 0.267>
}

light_source {   // Main_light
  <7.623, -15.654, 12.708>
  color rgb <0.412, 0.412, 0.412>
}

light_source { // AreaL001
  <11.145, 8.698, 16.851>
  color  rgb<0.349, 0.349, 0.251>
  area_light <3.070, -1.775, -0.623>, <1.334, 2.895, -1.674>, 6, 6
  adaptive 1
}


//
// ********  T E X T U R E S  *******
//

#include "DINNER.INC"

// ********  O B J E C T S *******
#include "plate.inc"
#declare Bound00001 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.062501, 1.070942, 3.358890>
  translate <-0.008411, 0.004630, 3.288476>
}

#declare bottle_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.009804, 0.003688, 0.000000>  <-0.009804, 0.002848, 0.000000>  <-0.009807, 0.002835, 0.000000>  <-0.008964, 0.002843, 0.000000>
    <0.983676, 0.007471, 0.014690>  <0.983676, 0.998953, 0.014690>  <0.988149, 1.015053, 0.014690>  <-0.008441, 1.005158, 0.014690>
    <0.983676, 0.007471, 0.002869>  <0.983676, 0.998953, 0.002869>  <0.988149, 1.015053, 0.002869>  <-0.008441, 1.005158, 0.002869>
    <0.983676, 0.007471, 0.369011>  <0.983676, 0.998953, 0.369011>  <0.988149, 1.015053, 0.369011>  <-0.008441, 1.005158, 0.369011>  }
}
#declare bottle_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.008964, 0.002843, 0.000000>  <-0.008121, 0.002852, 0.000000>  <-0.008128, 0.002842, 0.000000>  <-0.008124, 0.003696, 0.000000>
    <-0.008441, 1.005158, 0.014690>  <-1.005030, 0.995263, 0.014690>  <-0.996320, 1.006087, 0.014690>  <-1.000498, -0.001969, 0.014690>
    <-0.008441, 1.005158, 0.002869>  <-1.005030, 0.995263, 0.002869>  <-0.996320, 1.006087, 0.002869>  <-1.000498, -0.001969, 0.002869>
    <-0.008441, 1.005158, 0.369011>  <-1.005030, 0.995263, 0.369011>  <-0.996320, 1.006087, 0.369011>  <-1.000498, -0.001969, 0.369011>  }
}
#declare bottle_3 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.008124, 0.003696, 0.000000>  <-0.008121, 0.004549, 0.000000>  <-0.008117, 0.004544, 0.000000>  <-0.008962, 0.004537, 0.000000>
    <-1.000498, -0.001969, 0.014690>  <-1.004676, -1.010024, 0.014690>  <-1.009331, -1.003983, 0.014690>  <-0.010591, -0.995897, 0.014690>
    <-1.000498, -0.001969, 0.002869>  <-1.004676, -1.010024, 0.002869>  <-1.009331, -1.003983, 0.002869>  <-0.010591, -0.995897, 0.002869>
    <-1.000498, -0.001969, 0.369011>  <-1.004676, -1.010024, 0.369011>  <-1.009331, -1.003983, 0.369011>  <-0.010591, -0.995897, 0.369011>  }
}
#declare bottle_4 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.008962, 0.004537, 0.000000>  <-0.009807, 0.004530, 0.000000>  <-0.009804, 0.004527, 0.000000>  <-0.009804, 0.003688, 0.000000>
    <-0.010591, -0.995897, 0.014690>  <0.988149, -0.987812, 0.014690>  <0.983676, -0.984012, 0.014690>  <0.983676, 0.007471, 0.014690>
    <-0.010591, -0.995897, 0.002869>  <0.988149, -0.987812, 0.002869>  <0.983676, -0.984012, 0.002869>  <0.983676, 0.007471, 0.002869>
    <-0.010591, -0.995897, 0.369011>  <0.988149, -0.987812, 0.369011>  <0.983676, -0.984012, 0.369011>  <0.983676, 0.007471, 0.369011>  }
}
#declare bottle_5 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.983676, 0.007471, 0.369011>  <0.983676, 0.998953, 0.369011>  <0.988149, 1.015053, 0.369011>  <-0.008441, 1.005158, 0.369011>
    <0.983676, 0.007471, 0.735154>  <0.983676, 0.998953, 0.735154>  <0.988149, 1.015053, 0.735154>  <-0.008441, 1.005158, 0.735154>
    <0.957516, 0.007471, 3.912997>  <0.957516, 0.998953, 3.912997>  <0.961870, 1.015053, 3.912997>  <-0.008285, 1.005158, 3.912997>
    <0.970596, 0.007471, 4.246875>  <0.970596, 0.998953, 4.246875>  <0.975009, 1.015053, 4.246875>  <-0.008363, 1.005158, 4.246875>  }
}
#declare bottle_6 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.008441, 1.005158, 0.369011>  <-1.005030, 0.995263, 0.369011>  <-0.996320, 1.006087, 0.369011>  <-1.000498, -0.001969, 0.369011>
    <-0.008441, 1.005158, 0.735154>  <-1.005030, 0.995263, 0.735154>  <-0.996320, 1.006087, 0.735154>  <-1.000498, -0.001969, 0.735154>
    <-0.008285, 1.005158, 3.912997>  <-0.978440, 0.995263, 3.912997>  <-0.969961, 1.006087, 3.912997>  <-0.974028, -0.001969, 3.912997>
    <-0.008363, 1.005158, 4.246875>  <-0.991735, 0.995263, 4.246875>  <-0.983140, 1.006087, 4.246875>  <-0.987263, -0.001969, 4.246875>  }
}
#declare bottle_7 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-1.000498, -0.001969, 0.369011>  <-1.004676, -1.010024, 0.369011>  <-1.009331, -1.003983, 0.369011>  <-0.010591, -0.995897, 0.369011>
    <-1.000498, -0.001969, 0.735154>  <-1.004676, -1.010024, 0.735154>  <-1.009331, -1.003983, 0.735154>  <-0.010591, -0.995897, 0.735154>
    <-0.974028, -0.001969, 3.912997>  <-0.978095, -1.010024, 3.912997>  <-0.982626, -1.003983, 3.912997>  <-0.010378, -0.995897, 3.912997>
    <-0.987263, -0.001969, 4.246875>  <-0.991385, -1.010024, 4.246875>  <-0.995979, -1.003983, 4.246875>  <-0.010485, -0.995897, 4.246875>  }
}
#declare bottle_8 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.010591, -0.995897, 0.369011>  <0.988149, -0.987812, 0.369011>  <0.983676, -0.984012, 0.369011>  <0.983676, 0.007471, 0.369011>
    <-0.010591, -0.995897, 0.735154>  <0.988149, -0.987812, 0.735154>  <0.983676, -0.984012, 0.735154>  <0.983676, 0.007471, 0.735154>
    <-0.010378, -0.995897, 3.912997>  <0.961870, -0.987812, 3.912997>  <0.957516, -0.984012, 3.912997>  <0.957516, 0.007471, 3.912997>
    <-0.010485, -0.995897, 4.246875>  <0.975009, -0.987812, 4.246875>  <0.970596, -0.984012, 4.246875>  <0.970596, 0.007471, 4.246875>  }
}
#declare bottle_9 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.970596, 0.007471, 4.246875>  <0.970596, 0.998953, 4.246875>  <0.975009, 1.015053, 4.246875>  <-0.008363, 1.005158, 4.246875>
    <0.983676, 0.007471, 4.580753>  <0.983676, 0.998953, 4.580753>  <0.988149, 1.015053, 4.580753>  <-0.008441, 1.005158, 4.580753>
    <0.472144, 0.003823, 5.088076>  <0.472144, 0.480217, 5.088076>  <0.474294, 0.487952, 5.088076>  <-0.004651, 0.483198, 5.088076>
    <0.461911, 0.002080, 5.277845>  <0.461911, 0.364696, 5.277845>  <0.361168, 0.470361, 5.277845>  <-0.002749, 0.467984, 5.277845>  }
}
#declare bottle_10 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.008363, 1.005158, 4.246875>  <-0.991735, 0.995263, 4.246875>  <-0.983140, 1.006087, 4.246875>  <-0.987263, -0.001969, 4.246875>
    <-0.008441, 1.005158, 4.580753>  <-1.005030, 0.995263, 4.580753>  <-0.996320, 1.006087, 4.580753>  <-1.000498, -0.001969, 4.580753>
    <-0.004651, 0.483198, 5.088076>  <-0.483596, 0.478444, 5.088076>  <-0.479410, 0.483644, 5.088076>  <-0.481418, -0.000713, 5.088076>
    <-0.002749, 0.467984, 5.277845>  <-0.366665, 0.465606, 5.277845>  <-0.466390, 0.366409, 5.277845>  <-0.467394, -0.000188, 5.277845>  }
}
#declare bottle_11 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.987263, -0.001969, 4.246875>  <-0.991385, -1.010024, 4.246875>  <-0.995979, -1.003983, 4.246875>  <-0.010485, -0.995897, 4.246875>
    <-1.000498, -0.001969, 4.580753>  <-1.004676, -1.010024, 4.580753>  <-1.009331, -1.003983, 4.580753>  <-0.010591, -0.995897, 4.580753>
    <-0.481418, -0.000713, 5.088076>  <-0.483426, -0.485069, 5.088076>  <-0.485663, -0.482167, 5.088076>  <-0.005685, -0.478282, 5.088076>
    <-0.467394, -0.000188, 5.277845>  <-0.468398, -0.366785, 5.277845>  <-0.367699, -0.467131, 5.277845>  <-0.003265, -0.465189, 5.277845>  }
}
#declare bottle_12 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.010485, -0.995897, 4.246875>  <0.975009, -0.987812, 4.246875>  <0.970596, -0.984012, 4.246875>  <0.970596, 0.007471, 4.246875>
    <-0.010591, -0.995897, 4.580753>  <0.988149, -0.987812, 4.580753>  <0.983676, -0.984012, 4.580753>  <0.983676, 0.007471, 4.580753>
    <-0.005685, -0.478282, 5.088076>  <0.474294, -0.474397, 5.088076>  <0.472144, -0.472571, 5.088076>  <0.472144, 0.003823, 5.088076>
    <-0.003265, -0.465189, 5.277845>  <0.361168, -0.463246, 5.277845>  <0.461911, -0.360536, 5.277845>  <0.461911, 0.002080, 5.277845>  }
}
#declare bottle_13 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.461911, 0.002080, 5.277845>  <0.461911, 0.364696, 5.277845>  <0.361168, 0.470361, 5.277845>  <-0.002749, 0.467984, 5.277845>
    <0.451678, 0.000337, 5.467614>  <0.451678, 0.249175, 5.467614>  <0.248042, 0.452769, 5.467614>  <-0.000846, 0.452769, 5.467614>
    <0.451678, 0.000337, 5.595817>  <0.451678, 0.249175, 5.595817>  <0.248042, 0.452769, 5.595817>  <-0.000846, 0.452769, 5.595817>
    <0.451678, 0.000337, 5.934104>  <0.451678, 0.249175, 5.934104>  <0.248042, 0.452769, 5.934104>  <-0.000846, 0.452769, 5.934104>  }
}
#declare bottle_14 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.002749, 0.467984, 5.277845>  <-0.366665, 0.465606, 5.277845>  <-0.466390, 0.366409, 5.277845>  <-0.467394, -0.000188, 5.277845>
    <-0.000846, 0.452769, 5.467614>  <-0.249735, 0.452769, 5.467614>  <-0.453371, 0.249175, 5.467614>  <-0.453371, 0.000337, 5.467614>
    <-0.000846, 0.452769, 5.595817>  <-0.249735, 0.452769, 5.595817>  <-0.453371, 0.249175, 5.595817>  <-0.453371, 0.000337, 5.595817>
    <-0.000846, 0.452769, 5.934104>  <-0.249735, 0.452769, 5.934104>  <-0.453371, 0.249175, 5.934104>  <-0.453371, 0.000337, 5.934104>  }
}
#declare bottle_15 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.467394, -0.000188, 5.277845>  <-0.468398, -0.366785, 5.277845>  <-0.367699, -0.467131, 5.277845>  <-0.003265, -0.465189, 5.277845>
    <-0.453371, 0.000337, 5.467614>  <-0.453371, -0.248501, 5.467614>  <-0.249735, -0.452096, 5.467614>  <-0.000846, -0.452096, 5.467614>
    <-0.453371, 0.000337, 5.595817>  <-0.453371, -0.248501, 5.595817>  <-0.249735, -0.452096, 5.595817>  <-0.000846, -0.452096, 5.595817>
    <-0.453371, 0.000337, 5.934104>  <-0.453371, -0.248501, 5.934104>  <-0.249735, -0.452096, 5.934104>  <-0.000846, -0.452096, 5.934104>  }
}
#declare bottle_16 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.003265, -0.465189, 5.277845>  <0.361168, -0.463246, 5.277845>  <0.461911, -0.360536, 5.277845>  <0.461911, 0.002080, 5.277845>
    <-0.000846, -0.452096, 5.467614>  <0.248042, -0.452096, 5.467614>  <0.451678, -0.248501, 5.467614>  <0.451678, 0.000337, 5.467614>
    <-0.000846, -0.452096, 5.595817>  <0.248042, -0.452096, 5.595817>  <0.451678, -0.248501, 5.595817>  <0.451678, 0.000337, 5.595817>
    <-0.000846, -0.452096, 5.934104>  <0.248042, -0.452096, 5.934104>  <0.451678, -0.248501, 5.934104>  <0.451678, 0.000337, 5.934104>  }
}
#declare bottle_17 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.451678, 0.000337, 5.934104>  <0.451678, 0.249175, 5.934104>  <0.248042, 0.452769, 5.934104>  <-0.000846, 0.452769, 5.934104>
    <0.451678, 0.000337, 6.272390>  <0.451678, 0.249175, 6.272390>  <0.248042, 0.452769, 6.272390>  <-0.000846, 0.452769, 6.272390>
    <0.451678, 0.000337, 6.580043>  <0.451678, 0.249175, 6.580043>  <0.248042, 0.452769, 6.580043>  <-0.000846, 0.452769, 6.580043>
    <0.326092, 0.000337, 6.576951>  <0.326092, 0.180116, 6.576951>  <0.178970, 0.327209, 6.576951>  <-0.000846, 0.327209, 6.576951>  }
}
#declare bottle_18 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.000846, 0.452769, 5.934104>  <-0.249735, 0.452769, 5.934104>  <-0.453371, 0.249175, 5.934104>  <-0.453371, 0.000337, 5.934104>
    <-0.000846, 0.452769, 6.272390>  <-0.249735, 0.452769, 6.272390>  <-0.453371, 0.249175, 6.272390>  <-0.453371, 0.000337, 6.272390>
    <-0.000846, 0.452769, 6.580043>  <-0.249735, 0.452769, 6.580043>  <-0.453371, 0.249175, 6.580043>  <-0.453371, 0.000337, 6.580043>
    <-0.000846, 0.327209, 6.576951>  <-0.180662, 0.327209, 6.576951>  <-0.327784, 0.180116, 6.576951>  <-0.327784, 0.000337, 6.576951>  }
}
#declare bottle_19 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.453371, 0.000337, 5.934104>  <-0.453371, -0.248501, 5.934104>  <-0.249735, -0.452096, 5.934104>  <-0.000846, -0.452096, 5.934104>
    <-0.453371, 0.000337, 6.272390>  <-0.453371, -0.248501, 6.272390>  <-0.249735, -0.452096, 6.272390>  <-0.000846, -0.452096, 6.272390>
    <-0.453371, 0.000337, 6.580043>  <-0.453371, -0.248501, 6.580043>  <-0.249735, -0.452096, 6.580043>  <-0.000846, -0.452096, 6.580043>
    <-0.327784, 0.000337, 6.576951>  <-0.327784, -0.179443, 6.576951>  <-0.180662, -0.326535, 6.576951>  <-0.000846, -0.326535, 6.576951>  }
}
#declare bottle_20 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.000846, -0.452096, 5.934104>  <0.248042, -0.452096, 5.934104>  <0.451678, -0.248501, 5.934104>  <0.451678, 0.000337, 5.934104>
    <-0.000846, -0.452096, 6.272390>  <0.248042, -0.452096, 6.272390>  <0.451678, -0.248501, 6.272390>  <0.451678, 0.000337, 6.272390>
    <-0.000846, -0.452096, 6.580043>  <0.248042, -0.452096, 6.580043>  <0.451678, -0.248501, 6.580043>  <0.451678, 0.000337, 6.580043>
    <-0.000846, -0.326535, 6.576951>  <0.178970, -0.326535, 6.576951>  <0.326092, -0.179443, 6.576951>  <0.326092, 0.000337, 6.576951>  }
}
#declare bottle = union { 
  object { bottle_1 }
  object { bottle_2 }
  object { bottle_3 }
  object { bottle_4 }
  object { bottle_5 }
  object { bottle_6 }
  object { bottle_7 }
  object { bottle_8 }
  object { bottle_9 }
  object { bottle_10 }
  object { bottle_11 }
  object { bottle_12 }
  object { bottle_13 }
  object { bottle_14 }
  object { bottle_15 }
  object { bottle_16 }
  object { bottle_17 }
  object { bottle_18 }
  object { bottle_19 }
  object { bottle_20 }
  bounded_by { Bound00001 }
}

#declare topBottleshft = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.350000, 0.350000, 0.700000>
  translate <0.000000, 0.000000, 6.500000>
}

#declare tophole = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.275000, 0.275000, 0.720000>
  translate <0.000000, 0.000000, 6.490000>
}

#declare maintopshaft = difference {
  object { topBottleshft }
  object { tophole }
}

#declare Bound00002 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <0.463000, 0.463000, 0.088000>
}

#declare bottlering1 = torus { 
  0.375, 0.075  // Major, minor radius
  rotate -x*90
  bounded_by { Bound00002 }
  translate <0.000000, 0.000000, 6.700000>
}

#declare Bound3 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <0.463000, 0.463000, 0.088000>
}

#declare bottlering2 = torus { 
  0.355, 0.045  // Major, minor radius
  rotate -x*90
  bounded_by { Bound3 }
  translate <0.000000, 0.000000, 6.900000>
}

#declare Bound4 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <0.463000, 0.463000, 0.088000>
}

#declare bottlering3 = torus { 
  0.360, 0.030  // Major, minor radius
  rotate -x*90
  bounded_by { Bound4 }
  scale <1.000000, 1.000000, 1.428386>
  translate <0.000000, 0.000000, 7.100000>
}

union {
  object { bottle }
  object { maintopshaft }
  object { bottlering1 }
  object { bottlering2 }
  object { bottlering3 }
  texture {
    a1_tinymap
    scale <1.000000, 1.000000, 7.300000>
    rotate <0.000000, 0.000000, -180.000000>
  }
  rotate <110.000000, 20.000000, 62.915440>
  translate <-2.390339, 2.421020, 3.095127>
}

cylinder {   // dinner_table
  <0,0,1>, <0,0,0>, 1
  texture {
    fabric_texture
    scale <0.009000, 0.009000, 0.009000>
    rotate <0.000000, 0.000000, -60.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <18.000000, 18.000000, 3.000000>
  translate <10.000000, 8.000000, -3.000000>
}

#declare Bound00003 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.065667, 1.065667, 1.040667>
  translate <-0.025000, -0.025000, 0.000000>
}

object {   // steak_top
  height_field {
    gif "steak.gif" 
    water_level 0.003922
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    meaty_map
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  bounded_by { Bound00003 }
  scale <2.284590, 1.642296, 0.450000>
  translate <6.744100, -1.445164, 0.600000>
}

#declare Bound00004 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <0.518809, 0.447364, 0.984302>
  translate <-0.152050, 0.437787, 1.599371>
}

#declare sauce_glob_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.251846, 0.705277, 0.643143>  <-0.251846, 0.490182, 0.638881>  <0.251846, 0.490182, 0.638881>  <0.251846, 0.705277, 0.643143>
    <-0.256457, 0.672622, 0.814363>  <-0.256457, 0.456735, 0.770930>  <0.256457, 0.456735, 0.770930>  <0.256457, 0.672622, 0.814363>
    <-0.245060, 0.580164, 1.001398>  <-0.245060, 0.398133, 0.908372>  <0.245060, 0.398133, 0.908372>  <0.245060, 0.580164, 1.001398>
    <-0.224360, 0.502656, 1.069828>  <-0.224360, 0.356010, 0.956725>  <0.224360, 0.356010, 0.956725>  <0.224360, 0.502656, 1.069828>  }
}
#declare sauce_glob_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.251846, 0.705277, 0.643143>  <0.251846, 0.920371, 0.647404>  <-0.251846, 0.920371, 0.647404>  <-0.251846, 0.705277, 0.643143>
    <0.256457, 0.672622, 0.814363>  <0.256457, 0.888510, 0.857797>  <-0.256457, 0.888510, 0.857797>  <-0.256457, 0.672622, 0.814363>
    <0.245060, 0.580164, 1.001398>  <0.245060, 0.762195, 1.094424>  <-0.245060, 0.762195, 1.094424>  <-0.245060, 0.580164, 1.001398>
    <0.224360, 0.502656, 1.069828>  <0.224360, 0.649303, 1.182930>  <-0.224360, 0.649303, 1.182930>  <-0.224360, 0.502656, 1.069828>  }
}
#declare sauce_glob_3 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.224360, 0.502656, 1.069828>  <-0.224360, 0.356010, 0.956725>  <0.224360, 0.356010, 0.956725>  <0.224360, 0.502656, 1.069828>
    <-0.203661, 0.425149, 1.138257>  <-0.203661, 0.313888, 1.005079>  <0.203661, 0.313888, 1.005079>  <0.203661, 0.425149, 1.138257>
    <-0.182939, 0.317070, 1.222604>  <-0.178982, 0.251236, 1.080621>  <0.178982, 0.251236, 1.080621>  <0.174931, 0.322875, 1.222604>
    <-0.157496, 0.255424, 1.284877>  <-0.157916, 0.194623, 1.180834>  <0.157916, 0.194623, 1.180834>  <0.158078, 0.260124, 1.284877>  }
}
#declare sauce_glob_4 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.224360, 0.502656, 1.069828>  <0.224360, 0.649303, 1.182930>  <-0.224360, 0.649303, 1.182930>  <-0.224360, 0.502656, 1.069828>
    <0.203661, 0.425149, 1.138257>  <0.203661, 0.536410, 1.271436>  <-0.203661, 0.536410, 1.271436>  <-0.203661, 0.425149, 1.138257>
    <0.174931, 0.322875, 1.222604>  <0.170880, 0.394513, 1.364586>  <-0.186895, 0.382904, 1.364586>  <-0.182939, 0.317070, 1.222604>
    <0.158078, 0.260124, 1.284877>  <0.157594, 0.327213, 1.388919>  <-0.157675, 0.316328, 1.388919>  <-0.157496, 0.255424, 1.284877>  }
}
#declare sauce_glob_5 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.157496, 0.255424, 1.284877>  <-0.157916, 0.194623, 1.180834>  <0.157916, 0.194623, 1.180834>  <0.158078, 0.260124, 1.284877>
    <-0.132652, 0.193881, 1.347150>  <-0.136850, 0.138010, 1.281047>  <0.136850, 0.138010, 1.281047>  <0.140579, 0.198962, 1.347150>
    <-0.423655, 0.257991, 1.213071>  <-0.418886, 0.191635, 1.188580>  <0.312984, 0.022313, 1.319336>  <0.310310, 0.128336, 1.339174>
    <-0.514249, 0.196691, 1.387284>  <-0.511718, 0.135969, 1.364953>  <0.333631, 0.010459, 1.574758>  <0.332354, 0.087685, 1.582872>  }
}
#declare sauce_glob_6 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.158078, 0.260124, 1.284877>  <0.157594, 0.327213, 1.388919>  <-0.157675, 0.316328, 1.388919>  <-0.157496, 0.255424, 1.284877>
    <0.140579, 0.198962, 1.347150>  <0.144307, 0.259914, 1.413252>  <-0.128454, 0.249753, 1.413252>  <-0.132652, 0.193881, 1.347150>
    <0.310310, 0.128336, 1.339174>  <0.307636, 0.234358, 1.359012>  <-0.428424, 0.324347, 1.237561>  <-0.423655, 0.257991, 1.213071>
    <0.332354, 0.087685, 1.582872>  <0.332054, 0.170371, 1.590987>  <-0.516708, 0.252428, 1.409615>  <-0.514249, 0.196691, 1.387284>  }
}
#declare sauce_glob_7 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.514249, 0.196691, 1.387284>  <-0.511718, 0.135969, 1.364953>  <0.333631, 0.010459, 1.574758>  <0.332354, 0.087685, 1.582872>
    <-0.604771, 0.130406, 1.561497>  <-0.604549, 0.080304, 1.541326>  <0.354277, -0.001396, 1.830180>  <0.355375, 0.052494, 1.826571>
    <-0.659845, 0.158008, 1.795006>  <-0.660491, 0.109863, 1.791824>  <0.320715, 0.005771, 1.976528>  <0.322548, 0.053866, 1.973137>
    <-0.640379, 0.159779, 1.908084>  <-0.642045, 0.105254, 1.905031>  <0.262223, 0.004377, 2.075291>  <0.264426, 0.054352, 2.072285>  }
}
#declare sauce_glob_8 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.332354, 0.087685, 1.582872>  <0.332054, 0.170371, 1.590987>  <-0.516708, 0.252428, 1.409615>  <-0.514249, 0.196691, 1.387284>
    <0.355375, 0.052494, 1.826571>  <0.356472, 0.106383, 1.822962>  <-0.604992, 0.180509, 1.581669>  <-0.604771, 0.130406, 1.561497>
    <0.322548, 0.053866, 1.973137>  <0.324381, 0.101961, 1.969747>  <-0.659198, 0.206152, 1.798188>  <-0.659845, 0.158008, 1.795006>
    <0.264426, 0.054352, 2.072285>  <0.267530, 0.108175, 2.069280>  <-0.638925, 0.209143, 1.911137>  <-0.640379, 0.159779, 1.908084>  }
}
#declare sauce_glob_9 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.640379, 0.159779, 1.908084>  <-0.642045, 0.105254, 1.905031>  <0.262223, 0.004377, 2.075291>  <0.264426, 0.054352, 2.072285>
    <-0.621125, 0.156390, 2.021162>  <-0.623599, 0.100644, 2.018238>  <0.203730, 0.002983, 2.174054>  <0.207205, 0.058686, 2.171433>
    <-0.587950, 0.155003, 2.247335>  <-0.591905, 0.099920, 2.244633>  <0.092266, 0.008241, 2.373572>  <0.097049, 0.063290, 2.371686>
    <-0.248726, 0.077740, 2.308101>  <-0.248792, 0.076149, 2.308101>  <-0.248632, 0.076143, 2.308131>  <-0.248566, 0.077733, 2.308131>  }
}
#declare sauce_glob_10 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.264426, 0.054352, 2.072285>  <0.267530, 0.108175, 2.069280>  <-0.638925, 0.209143, 1.911137>  <-0.640379, 0.159779, 1.908084>
    <0.207205, 0.058686, 2.171433>  <0.210679, 0.114389, 2.168812>  <-0.618652, 0.212135, 2.024086>  <-0.621125, 0.156390, 2.021162>
    <0.097049, 0.063290, 2.371686>  <0.101832, 0.118338, 2.369800>  <-0.583995, 0.210087, 2.250037>  <-0.587950, 0.155003, 2.247335>
    <-0.248566, 0.077733, 2.308131>  <-0.248499, 0.079324, 2.308131>  <-0.248659, 0.079331, 2.308101>  <-0.248726, 0.077740, 2.308101>  }
}
union {   // sauce_glob
  object { sauce_glob_1 }
  object { sauce_glob_2 }
  object { sauce_glob_3 }
  object { sauce_glob_4 }
  object { sauce_glob_5 }
  object { sauce_glob_6 }
  object { sauce_glob_7 }
  object { sauce_glob_8 }
  object { sauce_glob_9 }
  object { sauce_glob_10 }
  texture {
    SauceColor
  }
  bounded_by { Bound00004 }
  rotate <90.000000, 0.000000, 61.000000>
  translate <2.491322, -0.976329, 0.074412>
}

#declare pea1 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <6.325812, 2.249104, 0.294322>
}

#declare pea2 = object { 
  sphere {<0,0,0>,1}
  scale <0.178976, 0.178976, 0.178976>
  translate <6.683871, 2.336193, 0.294322>
}

#declare pea3 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <6.954842, 2.103956, 0.294322>
}

#declare pea4 = object { 
  sphere {<0,0,0>,1}
  scale <0.121024, 0.121024, 0.121024>
  translate <6.197548, 1.886584, 0.294322>
}

#declare pea5 = object { 
  sphere {<0,0,0>,1}
  scale <0.092048, 0.092048, 0.092048>
  translate <7.308871, 2.074926, 0.294322>
}

#declare pea6 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <8.029020, 2.074926, 0.294322>
}

#declare pea7 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <6.529020, 2.007164, 0.294322>
}

#declare pea8 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <6.829020, 1.774926, 0.294322>
}

#declare pea9 = object { 
  sphere {<0,0,0>,1}
  scale <0.135512, 0.135512, 0.135512>
  translate <7.129020, 1.774926, 0.294322>
}

#declare pea10 = object { 
  sphere {<0,0,0>,1}
  scale <0.135512, 0.135512, 0.135512>
  translate <7.429020, 1.731463, 0.294322>
}

#declare pea11 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <7.656580, 2.021221, 0.294322>
}

#declare pea12 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <8.029020, 1.774926, 0.294322>
}

#declare pea13 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <8.329020, 1.774926, 0.294322>
}

#declare pea14 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <5.572818, 1.330047, 0.294322>
}

#declare pea15 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <6.648359, 1.687757, 0.603360>
}

#declare pea16 = object { 
  sphere {<0,0,0>,1}
  scale <0.178976, 0.178976, 0.178976>
  translate <6.394383, 1.605317, 0.294322>
}

#declare pea17 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <6.723358, 1.416975, 0.294322>
}

#declare pea18 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <7.052334, 1.460438, 0.294322>
}

#declare pea19 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <6.425108, 1.257608, 0.294322>
}

#declare pea20 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <7.072818, 2.373176, 0.294322>
}

#declare pea21 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <7.314866, 1.243120, 0.294322>
}

#declare pea22 = object { 
  sphere {<0,0,0>,1}
  scale <0.178976, 0.178976, 0.178976>
  translate <7.571403, 1.445951, 0.294322>
}

#declare pea23 = object { 
  sphere {<0,0,0>,1}
  scale <0.120970, 0.120970, 0.120970>
  translate <6.976181, 1.716787, 0.559212>
}

#declare pea24 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <6.925812, 1.223282, 0.294322>
}

#declare pea25 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <6.933905, 1.397460, 0.559212>
}

#declare pea26 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <6.742011, 2.065143, 0.559212>
}

#declare pea27 = object { 
  sphere {<0,0,0>,1}
  scale <0.179432, 0.179432, 0.179432>
  translate <7.854842, 1.949024, 0.529779>
}

#declare pea28 = object { 
  sphere {<0,0,0>,1}
  scale <0.135284, 0.135284, 0.135284>
  translate <6.384032, 1.861935, 0.544496>
}

#declare pea29 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <6.538884, 1.861935, 0.818454>
}

#declare pea30 = object { 
  sphere {<0,0,0>,1}
  scale <0.120568, 0.120568, 0.120568>
  translate <4.777777, 1.687757, 0.294322>
}

union {   // pile_o_peas
  object { pea1 }
  object { pea2 }
  object { pea3 }
  object { pea4 }
  object { pea5 }
  object { pea6 }
  object { pea7 }
  object { pea8 }
  object { pea9 }
  object { pea10 }
  object { pea11 }
  object { pea12 }
  object { pea13 }
  object { pea14 }
  object { pea15 }
  object { pea16 }
  object { pea17 }
  object { pea18 }
  object { pea19 }
  object { pea20 }
  object { pea21 }
  object { pea22 }
  object { pea23 }
  object { pea24 }
  object { pea25 }
  object { pea26 }
  object { pea27 }
  object { pea28 }
  object { pea29 }
  object { pea30 }
  texture {
    greenpeacolor
  }
}
#declare Bound00005 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.066958, 2.584342, 0.134590>
  translate <1.246512, -0.845268, 0.086053>
}

#declare napkin_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <1.910225, -3.381074, 0.043796>  <1.346853, -3.381074, 0.108439>  <0.783481, -3.381074, 0.173082>  <0.515563, -3.381074, 0.172106>
    <1.910225, -1.690537, 0.043796>  <1.346853, -1.690537, 0.108439>  <0.783481, -1.690537, 0.173082>  <0.515563, -1.690537, 0.172106>
    <1.910225, 0.000000, 0.043796>  <1.346853, 0.000000, 0.108439>  <0.783481, 0.000000, 0.173082>  <0.515563, 0.000000, 0.172106>
    <1.910225, 1.690537, 0.043796>  <1.346853, 1.690537, 0.108439>  <0.783481, 1.690537, 0.173082>  <0.515563, 1.690537, 0.172106>  }
}
#declare napkin_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.515563, -3.381074, 0.172106>  <0.247645, -3.381074, 0.171129>  <0.000000, -3.381074, 0.000000>  <0.566233, -3.381074, 0.000000>
    <0.515563, -1.690537, 0.172106>  <0.247645, -1.690537, 0.171129>  <0.000000, -1.690537, 0.000000>  <0.566233, -1.690537, 0.000000>
    <0.515563, 0.000000, 0.172106>  <0.247645, 0.000000, 0.171129>  <0.000000, 0.000000, 0.000000>  <0.566233, 0.000000, 0.000000>
    <0.515563, 1.690537, 0.172106>  <0.247645, 1.690537, 0.171129>  <0.000000, 1.690537, 0.000000>  <0.566233, 1.690537, 0.000000>  }
}
#declare napkin_3 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.566233, -3.381074, 0.000000>  <1.132467, -3.381074, 0.000000>  <1.698700, -3.381074, 0.000000>  <2.264933, -3.381074, 0.000000>
    <0.566233, -1.690537, 0.000000>  <1.132467, -1.690537, 0.000000>  <1.698700, -1.690537, 0.000000>  <2.264933, -1.690537, 0.000000>
    <0.566233, 0.000000, 0.000000>  <1.132467, 0.000000, 0.000000>  <1.698700, 0.000000, 0.000000>  <2.264933, 0.000000, 0.000000>
    <0.566233, 1.690537, 0.000000>  <1.132467, 1.690537, 0.000000>  <1.698700, 1.690537, 0.000000>  <2.264933, 1.690537, 0.000000>  }
}
union {   // napkin
  object { napkin_1 }
  object { napkin_2 }
  object { napkin_3 }
  texture {
    napkin_texture
    scale <0.050000, 0.050000, 0.050000>
    rotate <0.000000, 0.000000, -45.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  bounded_by { Bound00005 }
  rotate <0.000000, 0.000000, 11.844083>
  translate <0.184626, -3.692520, 0.010000>
}

