// Persistence Of Vision raytracer version 2.2.

//******** ASTRO-CITY ************************* Vaughn Dettmann '95

#include "colors.inc"
#include "shapes.inc"

#declare Steel = texture { 
 pigment { image_map { gif "hull.gif" }
     scale <5, 7, .05> rotate z*90 }
      finish {
        ambient .8
        diffuse .2
        brilliance 8
        specular 0.8
        roughness 0.01
        crand .09}}

#declare My_Chrome = 
 texture { pigment { color LightGray }
   finish {
     ambient 0.3
     diffuse 0.7
     reflection 0.4
     brilliance 8
     specular 0.8
    roughness 0.01 }}

#declare SHELL =
 sphere { <0, 0, 0>, 10
  texture { Steel }} 

#declare WINDOWS = union {
 box { <-100 , -.3, -.5>, <100, .3, .5> rotate y*0 } 
 box { <-100 , -.3, -.5>, <100, .3, .5> rotate y*10 } 
 box { <-100 , -.3, -.5>, <100, .3, .5> rotate y*20 } 
 box { <-100 , -.3, -.5>, <100, .3, .5> rotate y*30 } 
 box { <-100 , -.3, -.5>, <100, .3, .5> rotate y*40 } 
 box { <-100 , -.3, -.5>, <100, .3, .5> rotate y*50 } 
 box { <-100 , -.3, -.5>, <100, .3, .5> rotate y*60 } 
 box { <-100 , -.3, -.5>, <100, .3, .5> rotate y*70 } 
 box { <-100 , -.3, -.5>, <100, .3, .5> rotate y*80 } 
 box { <-100 , -.3, -.5>, <100, .3, .5> rotate y*90 } 
 box { <-100 , -.3, -.5>, <100, .3, .5> rotate y*100 } 
 box { <-100 , -.3, -.5>, <100, .3, .5> rotate y*110 } 
 box { <-100 , -.3, -.5>, <100, .3, .5> rotate y*120 } 
 box { <-100 , -.3, -.5>, <100, .3, .5> rotate y*130 } 
 box { <-100 , -.3, -.5>, <100, .3, .5> rotate y*140 } 
 box { <-100 , -.3, -.5>, <100, .3, .5> rotate y*150 } 
 box { <-100 , -.3, -.5>, <100, .3, .5> rotate y*160 }
 box { <-100 , -.3, -.5>, <100, .3, .5> rotate y*170 }
  pigment { Black } bounded_by { sphere { <0, 0, 0>,11 }}} 

#declare CAP = difference { 
 object { SHELL }
 object { WINDOWS translate y*6 }
 object { WINDOWS translate y*5 }
 box { <-100 , -100, -100>, <100, 4, 100> }
  pigment { Black } bounded_by { sphere { <0, 0, 0>,11 }}}

#declare LIGHTS = difference {
 sphere { <0, 0, 0>, 9.9
  pigment { White filter .1 }
    finish  { diffuse 0 ambient 1 }}
 box { <-100 , -100, -100>, <100, 4, 100> }
  pigment { Black } bounded_by { sphere { <0, 0, 0>, 11 }}}

#declare STRIP = 
 cylinder { <0, 3.5, 0>, <0, 4, 0>, 9 
  pigment { Cyan }
    finish  { diffuse 0 ambient 1 }}

#declare BOTTOM = difference {
 sphere { <0, 0, 0>, 10 
  texture { Steel }}
 box { <-100 , -100, -100>, <100, 4, 100> }
  pigment { Black } bounded_by { sphere { <0, 0, 0>, 11 }}} 

#declare PILLAR = difference {
  object { Ellipsoid scale <2, 15, 2> }
  box { <-100 , 4, -100>, <100, 25, 100> }
   bounded_by { sphere { <0, 0, 0>, 25 }}} 

#declare BASE = union {
 object { PILLAR }
 object { PILLAR translate <1, 0, -1> rotate z*-10 }
 object { PILLAR translate <2, 0, -2> rotate z*-15 }
 object { PILLAR translate <3, 0, -3> rotate z*-20 }
 object { PILLAR translate <4, 0, -4> rotate z*-25 }
 object { PILLAR translate <-1, 0, -1> rotate z*10 }
 object { PILLAR translate <-2, 0, -2> rotate z*15 }
 object { PILLAR translate <-3, 0, -3> rotate z*20 }
 object { PILLAR translate <-4, 0, -4> rotate z*25 }
  texture { Steel }}

#declare POLES = union {
 cylinder { <0, 2, 0>, <0, 5, 0>, .15 translate x*-6 }
 cylinder { <0, 2, 0>, <0, 5, 0>, .15 translate x*6  }}

#declare RAIL = union {
 torus { 6, .15 translate y*5 }
 object { POLES rotate y*0 }
 object { POLES rotate y*10 }
 object { POLES rotate y*20 }
 object { POLES rotate y*30 }
 object { POLES rotate y*40 }
 object { POLES rotate y*50 }
 object { POLES rotate y*60 }
 object { POLES rotate y*70 }
 object { POLES rotate y*80 }
 object { POLES rotate y*90 }
 object { POLES rotate y*100 }
 object { POLES rotate y*110 }
 object { POLES rotate y*120 }
 object { POLES rotate y*130 }
 object { POLES rotate y*140 }
 object { POLES rotate y*150 }
 object { POLES rotate y*160 }
 object { POLES rotate y*170 }
 texture { My_Chrome }
  bounded_by { cylinder { <0, -10, 0>, <0, 10, 0>, 20 }}}

#declare SPIRE = union {
 object { Ellipsoid scale <.27, 21, .27> }
 object { Ellipsoid scale <.2, 19, .2> translate <-.5, 0, -.5> }
 object { Ellipsoid scale <.2, 18, .2> translate <-1, 0, -1> }
 object { Ellipsoid scale <.2, 17, .2> translate <-1, 0, -1.5> }
 object { Ellipsoid scale <.2, 16, .2> translate <-1.5, 0, -3> }
 object { Ellipsoid scale <.2, 15, .2> translate <-.3, 0, -.3> }
 object { Ellipsoid scale <.2, 14, .2> translate <-1.2, 0, -.2> }
 object { Ellipsoid scale <.2, 13, .2> translate <-1.3, 0, -2> }
 object { Ellipsoid scale <.2, 17.5, .2> translate <-2, 0, -2> }
 object { Ellipsoid scale <.2, 15.6, .2> translate <-3, 0, 3> }
 object { Ellipsoid scale <.2, 14.7, .2> translate <-1, 0, 2> }
 object { Ellipsoid scale <.2, 13.1, .2> translate <-3.2, 0, .4> }
 object { Ellipsoid scale <.2, 19, .2> translate <2, 0, -1> }
 object { Ellipsoid scale <.2, 18, .2> translate <3, 0, -2> }
 object { Ellipsoid scale <.2, 17, .2> translate <.5, 0, -.7> }
 object { Ellipsoid scale <.2, 16, .2> translate <.4, 0, -2> }
 object { Ellipsoid scale <.2, 15, .2> translate <2, 0, 2> }
 object { Ellipsoid scale <.2, 14, .2> translate <1, 0, 3> }
 object { Ellipsoid scale <.2, 13, .2> translate <1, 0, 2.3> }
 object { Ellipsoid scale <.2, 19, .2> translate <.7, 0, .5> }
 object { Ellipsoid scale <.2, 18, .2> translate <.1, 0, .5> }
 object { Ellipsoid scale <.2, 17, .2> translate <2, 0, 3> }
 object { Ellipsoid scale <.2, 16, .2> translate <.1, 0, .5> }
 object { Ellipsoid scale <.2, 15, .2> translate <1.7, 0, 1.5> }
 object { Ellipsoid scale <.2, 14, .2> translate <3, 0, 2.5> }
  texture { My_Chrome }}

#declare SPIRES = difference {
 object { SPIRE }
 box { <-100 , -100, -100>, <100, 4, 100> }
  pigment { Black }
   bounded_by { sphere { <0, 0, 0>, 30 }}} 
  
declare CITY = union {
 object { CAP }
 object { LIGHTS }
 object { STRIP }
 object { BOTTOM rotate z*180 translate y*8.5 }
 object { BASE 
    scale <.9, 1, .9> rotate x*-25 translate <0, 1, 2> }
 object { RAIL translate y*6 }
 object { SPIRES translate <0, 0, 0> }}

#declare CAP2 = difference { 
 object { SHELL }
 object { WINDOWS translate y*6 }
 object { WINDOWS translate y*5 }
  pigment { Black } bounded_by { sphere { <0, 0, 0>,11 }}}

#declare LIGHTS2 =
 sphere { <0, 0, 0>, 9.9
  pigment { White filter .1 }
    finish  { diffuse 0 ambient 1 }}

#declare CITY2 = union {
 object { LIGHTS2 }
 object { CAP2 }
 object { RAIL translate y*6 }}
