//       Scene by Peter Collins
//         started 26-07-1995
//   last modified 13-08-1995

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"

                   

//==========================================================================
#declare Building=
union {
  union {
    sphere { <0 0 0> 6   scale <1 0.5 1> }
    sphere { <0 0 0> 4   scale <1 0.5 1>   translate <  6 0 15> }
    sphere { <0 0 0> 4   scale <1 0.5 1>   translate <-10 0 20> }
    cylinder { <0 0 0> <  6 0 15> 1.1 }
    cylinder { <0 0 0> <-10 0 20> 1.1 }
    texture {
      pigment {
        image_map {
          gif "base1.gif"
          filter 255 1
          once
          interpolate 2
        }
      scale <24 30 1>
      translate <-14 -6 0>
      rotate <90 0 0>
      }
    }
  }
  union {
    sphere { <0 0 0> 5.99   scale <1 0.5 1> }
    sphere { <0 0 0> 3.99   scale <1 0.5 1>   translate <  6 0 15> }
    sphere { <0 0 0> 3.99   scale <1 0.5 1>   translate <-10 0 20> }
    cylinder { <0 0 0> <  6 0 15> 1.09 }
    cylinder { <0 0 0> <-10 0 20> 1.09 }
    texture {
      pigment { color rgb <0.01 0.01 0.01> }
      finish  { reflection 0.4 }
      finish  { specular 0.9 }
    }
  }
  bounded_by { box { <-14.1 -0.1 -6.1> <10 3.1 24.1> } }
  translate <-12 0 -65>
}

//==========================================================================
#declare Aerial=
union {
  cylinder { <0 2.9  0> <0 4.5 0> 0.05 }
  union {
    cylinder { <0 3.8 -1.7> <0 3.8 1.7> 0.05 }
    cylinder { <-1.3 3.8 -1.5> <1.3 3.8 -1.5> 0.05 }
    cylinder { <-1.3 3.8  1.5> <1.3 3.8  1.5> 0.05 }
    cylinder { <-0.8 3.8 -0.4> <0.8 3.8 -0.4> 0.05 }
    cylinder { <-0.8 3.8  0.4> <0.8 3.8  0.4> 0.05 }
  }
  union {
    cylinder { <-1.1 4.5  0>   < 1.1 4.5 0>   0.05 }
    cylinder { < 0.8 4.5 -0.5> < 0.8 4.5 0.5> 0.05 }
    cylinder { <-0.8 4.5 -0.5> <-0.8 4.5 0.5> 0.05 }
  }
  texture {
    pigment { color rgb <0.8 0.8 0.8> }
    finish  { reflection 0.2 }
  }
  bounded_by { box { <-1.4 2.8 -1.8> <1.4 4.6 1.8> } }
  rotate <0 30 0>
  translate <-12 0 -65>
}

//==========================================================================
#declare Little_Dish=
union {
  union {
    difference {
      sphere { <0 0 0> 0.9 }
      sphere { <0 0 0> 0.8 }
      plane  { <0 -1 0> 0 }
      scale <1 0.3333 1>
    }
    cylinder { <0 -0.3 0> <0 0.7 0> 0.06 }
    sphere { <0 0.7 0> 0.12 }
    translate <0 0.40 0>
    rotate <30 100 0>
  }
  cylinder { <0 0 -0.15> <0 0 0.15> 0.12 }
  cylinder { <0 -1 0> <0 0 0> 0.1 }
  texture {
    pigment { color rgb <0.8 0.8 0.8> }
    finish  { reflection 0.2 }
  }
  bounded_by { box { <-1.0 -1.1 -1.0> <1.0 1.0 1.0> } }
}

//==========================================================================
#declare Building2=
union {
  union {
    sphere { <0 0 0> 6   scale <1 0.5 1> }
      texture {
        pigment {
          image_map {
            gif "base1.gif"
            filter 255 1
            once
            interpolate 2
          }
          scale <24 30 1>
          translate <-14 -6 0>
          rotate <90 0 0>
        }
      }
  }
  union {
    sphere { <0 0 0> 5.99   scale <1 0.5 1> }
    cylinder { <0 0 0> <0 17 0> 0.599 }
    sphere { <0 17 0> 0.599 }
    texture {
      pigment { color rgb <0.01 0.01 0.01> }
      finish  { reflection 0.4 }
      finish  { specular 0.9 }
    }
  }
  union {
    cylinder { <0 0 0> <0 17 0> 0.6 }
    sphere { <0 17 0> 0.6 }
    texture {
      pigment {
        image_map {
          gif "base2.gif"
          filter 255 1
          interpolate 2
        }
        translate <-0.5 -0.1 0>
        scale <2 20 1>
      }
    }
  }
  bounded_by { box { <-6.1 -0.1 -6.1> <6.1 17.7 6.1> } }
  scale 0.6
  translate <2 0 8.5>
}

//==========================================================================



#declare Base=
union {
  object { Building }
  object { Aerial }
  object { Little_Dish
    translate <-6 2.6 -50>
  }
  object { Little_Dish
    rotate <0 30 0>
    translate <-22 2.6 -45>
  }
}


#declare Base2=
union {
  object { Building2 }
}


