//       Scene by Peter Collins
//         started 26-07-1995
//   last modified 13-08-1995

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "RADAR.INC"
#include "BASE.INC"
                   
camera {
 location  <0     10 -100>
 direction <0      0   2>
 up        <0      1   0>
 right     <1.3333 0   0>
 look_at   <-5     0   0>
}   

light_source { <0 50 -70> color White }





//==========================================================================
#declare Cliffs =
union {
  height_field {
    gif "cliffs.gif"
    smooth
    water_level 0.01
  }
  texture {
      pigment {
        bozo
        color_map {
          [ 0.0 color rgb<1.0 0.7 0.2> ]
          [ 1.0 color rgb<1.0 0.6 0.1> ]
        }
        scale 0.2
      }
  }
  translate <-0.5 0 -0.5>
  scale <100 10 100>
}

//==========================================================================
#declare Sand=
union {
  plane { <0 1 0> 0 }
  texture {
    pigment { color rgb<1.0 0.7 0.2> }
    normal  { bumps 0.5  scale <0.5 0.5 0.5> }
  }
}

//==========================================================================
#declare Stars=
union {
  plane { <0 1 0> 0
    rotate <-90 0 0>
  }
  texture {
    pigment { image_map {
      gif "stars.gif"
      interpolate 2
    } }
    translate <-0.5 -0.5 0>
    scale <270 65 1>
    translate <-23 -12 0>
  }
  translate <0 50 300>
}

//==========================================================================
#declare Satelites=
union {
  sphere { <-40 23 100> 6
    texture {
      pigment {
        bozo
        color_map {
          [ 0.0 color rgb<0.8 0.4 0.2> ]
          [ 0.4 color rgb<1.3 0.3 0.2> ]
          [ 0.7 color rgb<1.2 0.5 0.3> ]
          [ 1.0 color rgb<1.1 0.6 0.3> ]
        }
        scale 5
      }
      normal  { bumps 0.5  scale 0.9 }
    }
  }
  sphere { <45 30 100> 3
    texture {
      pigment {
        bozo
        color_map {
          [ 0.0 color rgb<0.7 0.3 1.3> ]
          [ 0.4 color rgb<0.6 0.2 1.3> ]
          [ 0.7 color rgb<0.9 0.4 0.8> ]
          [ 1.0 color rgb<0.7 0.5 1.3> ]
        }
        scale 5
      }
      normal  { bumps 0.4  scale 0.7 }
    }
  }
}

//==========================================================================
#declare Tracks =
union {
  height_field {
    gif "tracks.gif"
    water_level 0.01
    scale <35 0.55 45>
    translate <-12 -0.001 -77>
  }
  texture {
    pigment { color rgb<1.0 0.7 0.2> }
  }
}

//==========================================================================
#declare Base_Sand=
union {
  height_field {
    gif "sand.gif"
    water_level 0.01
    scale <25 0.45 31>
    translate <-26 -0.001 -72>
  }
  texture {
    pigment { color rgb<1.0 0.7 0.2> }
    normal  { bumps 0.5  scale <0.5 0.5 0.5> }
  }
}

//==========================================================================



object { Cliffs }
object { Sand }
object { Stars }
object { Satelites }
object { Radar   scale 1.2   translate <12 12.2 40> }
object { Base }
object { Base2 }
object { Tracks }
object { Base_Sand }

