//Rails
#declare rail = object {
  union {
    cylinder { <-6, 0.2, -10>, <-6, 0.2, 50>, 0.2 }
    intersection {
      torus { 6, 0.2 }
      box { <0,0,0>, <9,9,9> }
      translate <-12, 0.1, 50>
    }
  }
}

#declare ring = object {
  difference {
     cylinder { <0, 0.1, -0.5>,  <0, 0.1, 0.5>, 3.1 }
     cylinder { <0, 0.1, -0.51>, <0, 0.1, 0.51>, 2.9 }
  }  // Texture based on Copper_Metal from textures.inc
  texture { pigment { color Copper } finish { Metal } }
}

#declare tube = object {
  union {
    difference {
      union {
        cylinder { <-6, 0.1, -10>, <-6, 0.1, 50>, 3 }
        intersection {
          torus { 6, 3 }
          box { <0,0,0>, <9,9,9> }
          translate <-12, 0.1, 50>
        }
      }
      union {
        cylinder { <-6, 0.1, -11>, <-6, 0.1, 50>, 2.5 }
        intersection {
          torus { 6, 2.5 }
          box { <0,0,0>, <9,9,9> }
          translate <-12, 0.1, 50>
        }
      }
      texture {   // Based on Glass3 from textures.inc
        pigment { color red 0.98 green 0.98 blue 0.98 filter 0.9 quick_color Green }
        finish { ambient 0.1 diffuse 0.1 specular 0.8 reflection 0.2
                refraction 0.9 ior 1.45 roughness 0.0003 phong 1 phong_size 400 }
      }
    }
    object { ring }
    object { ring translate <-6, 0, 10> }
    object { ring translate <-6, 0, 20> }
    object { ring translate <-6, 0, 30> }
    object { ring translate <-6, 0, 40> }
    object { ring translate <-6, 0, 50> }
    object { rail translate <-0.5, 0, -0.5> texture { pigment { Green } finish {ambient 0.5 } } }
    object { rail                           texture { pigment { Red } finish {ambient 0.5 } } }
    object { rail translate < 0.5, 0,  0.5> texture { pigment { Green } finish {ambient 0.5 } } }
  }
}

object { tube }
object { tube rotate y*180 translate <-24, 0, 112> }

// Extra ring at pipe join
object { ring rotate y*90 translate <-12, 0, 56> }

// Vehicle
#declare truck = object {
  union {
    union {
      box { <0, 0, 0>, <1, 0.5, 2> }
      cylinder { <1, 1.3, 0>, <1, 1.3, 2>, 0.8 }
      cone { <1, 1.3, 0>, 0.8, <1, 1.3, -1>, 0 }    
      cone { <1, 1.3, 2>, 0.8, <1, 1.3, 3>, 0 }
      texture { Gold_Metal }
    }
    union {
      cylinder { <1, 1.3, -1>, <1, 1.3, -2>, 0.05}
      cone { <1, 1.3, -2>, 0.05, <1, 1.3, -2.5>, 0 }    
      texture { pigment { White } finish { ambient 2.0 } }
    }
    union {
      cylinder { <1, 1.3, 3>, <1, 1.3, 4>, 0.05}
      cone { <1, 1.3, 4>, 0.05, <1, 1.3, 4.5>, 0 }    
      texture { pigment { Red } finish { ambient 2.0 } }
    }
    union { 
      sphere { <1.6, 1.5, 0.5>, 0.2 texture { New_Brass } }
      sphere { <1.6, 1.5, 1.0>, 0.2 texture { New_Brass } }
      sphere { <1.6, 1.5, 1.5>, 0.2 texture { New_Brass } }
    }
  }
}

#declare train = object {
  union {
    object { truck }
    object { truck translate <0, 0, 4> }
  }
}

object { train translate <-6.5, 0.4, 35> }
object { train translate <-18.5, 0.4, 70> }
