#include "monsters.inc"
#include "balloon.inc"

camera {
	location        <40, 14, 10>
	up              <0, 1, 0>
	right           <4/3, 0, 0 >
	look_at         <38, 4, 20>
}

light_source { <20, 30, -20>  color rgb <1, 1, 1> }

object {
	height_field {
		tga "mountain.tga" smooth
	}
	texture {
		pigment { color rgb <0.5, 0.502, 0.4> }
		finish {
			ambient 0.2
			phong 0.1
		}
	}
	scale <80, 5, 80>
}

plane {
	y, 5.05
	pigment {
		bozo
		turbulence 1
		color_map {
			[0.0 0.1 color rgbf <1, 1, 1, 0> color rgbf <1, 1, 1, 0>]
			[0.1 0.2 color rgbf <1, 1, 1, 0> color rgbf <1, 1, 1, 0.1>]
			[0.2 0.5 color rgbf <1, 1, 1, 0.1> color rgbf <1, 1, 1, 0.85>]
			[0.5 1.0 color rgbf <1, 1, 1, 0.85> color rgbf <1, 1, 1, 0.85>]
		}
		scale <2.5, 1, 1.5>
	}
	finish {ambient 0.25 phong 0}
	translate x*4
}

fog {color rgb <0.7, 0.7, 1> distance 25}

object {
	Monster1
	scale 1.3
	rotate x*40
	rotate z*110
	rotate y*90
	translate <35.2, 8.5, 15>
}

object {
	Monster2
	scale 1.2
	rotate x*40
	rotate -y*45
	translate <41.5, 8, 14>
}

object {
	Monster3
	scale 1.2
	rotate x*20
	rotate -z*45
	rotate y*200
	translate <40, 9, 18>
}

object {
	Balloon
	scale 1.35
	translate <39.9, 13.45, 10.5>
}















