#declare Wall1 = plane {
	-z, 0
	texture {
		pigment {color rgb <0.6, 0.45, 0.9>}
	}
	texture {
		pigment {
			image_map {
			gif "windows1.gif"
				map_type 0
				filter 255, 1
				interpolate 2
			}
		}
		finish {ambient 0.6 phong 0.2 reflection 0.1}
		scale <0.6, 0.4, 1>
	}
}

#declare Bld1 = intersection {
	object {Wall1}
	object {Wall1 rotate y*90 translate z*0.6}
	object {Wall1 rotate y*180 translate <0.6, 0, 0.6>}
	object {Wall1 rotate -y*90 translate x*0.6}
	plane { y, 0 translate y*1.32 }
	plane {-y, 0}
	pigment {color rgb <0, 0.5, 0.5>}
	finish {ambient 0.2 phong 1}

	translate <2.1, 0, 1.1>
}

#declare Bld2 = cylinder {
	<0, 0, 0>, <0, 0.8, 0>, 0.2
	texture {
		pigment {color rgb <0, 0.3, 0.8>}
	}
	texture {
		pigment {
			image_map {
			gif "windows2.gif"
				map_type 2
				filter 255, 1
				interpolate 2
			}
		}
		finish {ambient 1.3 phong 0.2 reflection 0.15}
		scale <1, 0.3, 1>
	}
	translate <2, 0, 0.1>
}

#declare Wall2 = plane {
	x, 0
	texture {
		pigment {color rgb <0.5, 0.4, 0.3>}
	}
	texture {
		pigment {
			image_map {
			gif "windows1.gif"
				map_type 0
				filter 255, 1
				interpolate 2
			}
		}
		finish {ambient 0.5 phong 0.15 reflection 0.1}
		scale <0.8, 0.35, 1>
		rotate y*90
		translate z*0.4
	}
}

#declare Strips = texture {
	pigment {
		gradient z
		color_map {
			[0.00 0.05 color rgb <0.5, 0.4, 0.3> color rgb <0.5, 0.4, 0.3>]
			[0.05 0.95 color rgb <0.7, 0.6, 0.5> color rgb <0.7, 0.6, 0.5>]
			[0.95 1.00 color rgb <0.5, 0.4, 0.3> color rgb <0.5, 0.4, 0.3>]
		}
		frequency 10
	}
	finish {ambient 0.3 phong 0.2 reflection 0.1}
}

#declare Bld3 = union {
	difference {
		merge {
			difference {
				box {<-0.3, 0, -0.5>, <0.2, 1, 0.4>}
				object {Wall2 translate -x*0.2}
			}
			cylinder {<0, 1, -0.5>, <0, 1, 0.4>, 0.2
				texture {Strips scale <1, 1, 0.8> translate -z*0.4}
			}
		}
		plane {
			z, -0.4
			texture {Strips scale 0.4 rotate y*90 translate -x*0.2}
		}
	}

	difference {
		merge {
			difference {
				box {<-0.2, 1, -0.4>, <0.15, 1.7, 0.3>}
				object {Wall2 translate -x*0.15}
			}
			cylinder {<0, 1.7, -0.4>, <0, 1.7, 0.3>, 0.15
				texture {Strips scale <1, 1, 0.6> translate -z*0.3}
			}
		}
		plane {
			z, -0.3
			texture {Strips scale 0.3 rotate y*90 translate -x*0.15}
		}
	}

	difference {
		merge {
			difference {
				box {<-0.2, 1.5, -0.3>, <0.1, 2.2, 0.2>}
				object {Wall2 translate -x*0.1}
			}
			cylinder {<0, 2.2, -0.3>, <0, 2.2, 0.2>, 0.1
				texture {Strips scale <1, 1, 0.4> translate -z*0.2}
			}
		}
		plane {
			z, -0.2
			texture {Strips scale 0.2 rotate y*90 translate -x*0.1}
		}
	}

	union {
		cylinder {<0, 0, -0.4>, <0, 1, -0.4>, 0.025}
		difference {
			sphere {<0, 1, -0.4>, 0.025}
			plane {y, 1}
		}
		cylinder {<0, 1, -0.3>, <0, 1.7, -0.3>, 0.025}
		difference {
			sphere {<0, 1.7, -0.3>, 0.025}
			plane {y, 1.7}
		}
		cylinder {<0, 1.7, -0.2>, <0, 2.2, -0.2>, 0.025}
		difference {
			sphere {<0, 2.2, -0.2>, 0.025}
			plane {y, 2.2}
		}
		texture {
			pigment {
				gradient y
				color_map {
				[0.00 0.05 color rgbf <0.8, 0.8, 0.9, 0.8> color rgbf <0.8, 0.8, 0.9, 0.8>]
				[0.05 0.95 color rgbf <0.9, 0.9, 1, 0.9> color rgbf <0.9, 0.9, 1, 0.9>]
				[0.95 1.00 color rgbf <0.8, 0.8, 0.9, 0.8> color rgbf <0.8, 0.8, 0.9, 0.8>]
				}
				frequency 20
			}
			finish {ambient 0.3 phong 0.5 reflection 0.15}
		}
	}
	texture {
		pigment {color rgb <0.5, 0.4, 0.3>}
		finish {ambient 0.5 phong 0.15 reflection 0.1}
	}
	translate <2.7, 0, 0.4>
}





