// jcalwrld.pov (c) Joel R. Cheves 1995  @ compuserve.com 102366.230
// Requires "alnwrld6.gif" for the height field.

#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"
#include "spship3.inc"
#include "etv.inc"

camera {
   direction <0.0, 0.0, 1.0>
   up <0.0, 1.0, 0.0>
   right <4/3, 0.0, 0.0>
   location <0, 10, -190>
   look_at <0, 70, 200>
}

#declare Sunmap = //for planet zenon 
 pigment 
  {bozo
   color_map 
    {[0.0, 0.4  color red .94 green .86 blue 1.00
                color red .64 green .38 blue 0.3]
     [0.4, 0.6  color red .64 green .38 blue 0.3
                color red .47 green .23  blue 0]
     [0.6, 1.01 color red .47 green .23 blue 0
                color red .15 green .11 blue .2]
    }
  }

object {
   etv
    scale 42
    translate <-20, 75, 60>
    rotate x*-15
}

height_field {
   gif "alnwrld6.gif" 
   water_level .4
    pigment {
      image_map { gif "alnwrld6.gif" }
      quick_color White
      rotate 90*x
      translate <-1.0, 0.0, -1.0>
   }
   scale <320, 256, 200>
    scale <2.0, 0.5, 2.0>
   translate <-160.0, -63.5, -100.0>
    translate <-150.0, 0, -30.0>}

plane { y, -10.0
   pigment { color red .25 green 0 blue .25}
   normal {
      waves 1
      frequency 9
      scale 4000
   }
}

// sky 
sphere { <0.0, 0.0, 0.0>, 1000.0
   pigment {
      onion
      color_map {
         [0.0 0.6  color red 1.0 green 0.6 blue 0.0 filter .8
                   color red 0.3 green 0.6 blue 0.6 filter .8]
         [0.6 1.0  color red 0.3 green 0.6 blue 0.6 filter .8
                   color red 0.1 green 0.4 blue 0.6 filter .8]
      }
      quick_color red 0.7 green 0.7 blue 1.0 filter.4
      scale <6000.0, 1700.0, 4000.0>
   }
   finish {
      ambient 0.8
      diffuse 0.0
   }
  rotate y*-15
}

light_source {
   <-150.0, 250.0, -400.0>
   colour MediumGoldenrod
}

// planet zenon 
light_source {
   <0, 0, 0> color red 1.0 green 0.69 blue .22
   looks_like {
      sphere { <0.0, 0.0, 0.0>, 750
      texture {Sunmap
         scale <600, 135, 600>
         finish { ambient 1.0 diffuse 0.0 }
      }
     rotate z*15
    }
   }
   translate <800, 600, 2500>
}

light_source {
   <0, 0, 0> color Quartz
   translate <-200.0, -5, -100>
}