// Persistence of Vision Raytracer Version 2.0
//Created by James Miller

#include "d:\povray2\include\colors.inc"
//#include "d:\povray2\include\shapes.inc"
#include "d:\povray2\include\textures.inc"
#include "tiefight.inc"
#include "xwing.inc"

camera {              
	//location <1,15,-25>//from front
	location <1,0,-10>
	look_at <0,0,0>
}

// Lights
light_source {<10,12,-15> color White 
	area_light <0,0,0>,<1,5,-10>,5,5
	spotlight
	point_at <0,0,2>
	radius 50
	tightness 3
	falloff 80
	adaptive .5
	jitter
}

object{height_field{gif "planet.gif"}
	scale <75,20,60>
	translate<-30,-10,-10>
	pigment{
		//gradient y
		granite
		color_map{ [0.0 color Tan]
			[0.3 color MediumWood]
			[0.7 color NewTan]
			[1 color DarkTan]
			}
		scale 3
		turbulence .8
		}
	finish {crand .3}
	}

object{sphere{<-50,45,130>,10}
	pigment{
		gradient y
		color_map{[0.0 color BlueViolet]
			[0.3 color NavyBlue]
			[0.5 color DarkSlateBlue]
			[0.7 color RichBlue]
			[0.9 color SlateBlue]
			[1 color White]
			}
		turbulence 1
		scale 2.5
		}
	}

light_source{<0,45,100> color White
	spotlight
	point_at <-50,45,130>
	radius 45
	tightness 3
	falloff 40
	}


object{plane{<0,0,1>,3000}  // stars
	texture{pigment{
		bozo
		scale 4
		turbulence 1 
	color_map{[0.00 0.89 color Clear color Clear]
		  [0.89 1.00 color Clear color rgb <1,1,0.8>]}}
        finish {ambient .4 diffuse 0}}
}


object{xwing
	scale .5
	rotate <10,115,0>
	rotate x*-20
	translate <-2,-2,0>
	}

object{union{
	object{Tie_Laser_Bolt  // from camera, right side
		scale<2,2,3>
		translate<.2,-.61,-8>
		rotate y*-.5
		}
	object{Tie_Laser_Bolt
		scale<2,2,3>
		translate<-.2,-.61,-8>
		rotate y*.5
		}
	object{Tie_Laser_Bolt
		scale<2,2,3>
		translate<.2,-.61,-18>
		rotate y*-.5
		}
	object{Tie_Laser_Bolt
		scale<2,2,3>
		translate <-.2,-.61,-18>
		rotate y*.5
		}
	object{Tie_Laser_Bolt
		scale<2,2,3>
		translate<.2,-.61,-28>
		rotate y*-.5
		}
	object{Tie_Laser_Bolt
		scale<2,2,3>
		translate<-.2,-.61,-28>
		rotate y*.5
		}

	object{TIE_Fighter}
	//object{TA_Fighter}
	scale .5
	rotate <-8,13,-15>
	translate <2,0,13>
	}}

/*
object{TIE_Fighter
	scale .5
	rotate <-8,13,-15>
	translate<.2,1,18>
	}

*/
object{TIE_Fighter // right side
	scale .5
	rotate <-8,13,-15>
	translate <5,.5,18>
	}