      program Panel_Textures
      implicit none
C
C Author       : Kevin B Black
C Date written : 20 August 1995
C Abstract     :
C
C Program to help produce textures for panel of the space craft,
C reduces the effort of having to pick and do every thing by hand.
C
C Initialy used random numbers for the colours, but that didn't
C work out too well. These are picked by hand, and adjusted after
C examining a test rendering.
C
      integer r(0:5),b(0:5),g(0:5)
      integer i
      real rand
      real ambient,diffuse,reflection,brilliance,specular,roughness
C      data r/240, 255, 233, 247, 235, 240/ ! First entry of for Cargo Bay Door (CBD)
      data r/255, 255, 255, 255, 255, 255/ ! First entry of for Cargo Bay Door (CBD)
      data g/246, 246, 225, 240, 230, 238/
      data b/16, 16, 32, 8, 24, 10/
C
C Five sets of panel textures, including one for the Cargo Bay Door
C
      do i=0,5
         if(i.eq.0)then
            write(*,1000)
1000  format(' #declare cc0door =')
         else
            write(*,1010)I-1
1010  format(' #declare cc',I1,' =')
         endif
         ambient=0.3+rand(1.0)/20 ! 0.3
         diffuse=0.6+rand(1.0)/20 ! 0.6
         reflection=0.01
         brilliance=5.0
         specular=0.2+rand(1.0)/100 ! 0.2
         roughness=0.1+rand(1.0)/20 ! 0.1
         write(*,1020)r(i),g(i),b(i),
     *          ambient,diffuse,reflection,brilliance,specular,roughness
1020  format(
     *' texture',/,
     *' {',/,
     *'    pigment { colour red',
     *                     I4,'/255 green',I4,'/255 blue',I4,'/255 }',/,
     *'    finish',/,
     *'    {',/,
     *'       ambient',F8.5,/,
     *'       diffuse',F8.5,/,
     *'       reflection',F8.5,/,
     *'       brilliance',F8.5,/,
     *'       specular',F8.5,/,
     *'       roughness',F8.5,/,
     *'    }',/,
     *' }')
      enddo
      end

      real function rand(x)
      implicit none
      real x,a
      logical init
      data init/.TRUE./
      if(init)then
         call seed(3357)
         init=.FALSE.
      endif
      call random(a)
      rand=a*x
      return
      end
 