/* 
 * @(#)geodomes.inc:v1.0
 *
 * Author       : Kevin B Black
 * Date written : 20 August 1995
 * Abstract     :
 *
 * Defines two types of geodomes for use as radar housings and
 * as habitats.
 *
 * Geodome data models created using geodome V1.1 #, which was written
 * by Andy Wardley <abw@oasis.icl.co.uk>.
 */
#declare geodome2_eighth =
union {
	triangle {
		<0.0000000000, 1.0000000000, 0.0000000000>
		<0.0000000000, 0.9238795325, 0.3826834324>
		<0.3826834324, 0.9238795325, 0.0000000000>
	}
	triangle {
		<0.0000000000, 0.9238795325, 0.3826834324>
		<0.0000000000, 0.7071067812, 0.7071067812>
		<0.4082482905, 0.8164965809, 0.4082482905>
	}
	triangle {
		<0.3826834324, 0.9238795325, 0.0000000000>
		<0.4082482905, 0.8164965809, 0.4082482905>
		<0.7071067812, 0.7071067812, 0.0000000000>
	}
	triangle {
		<0.4082482905, 0.8164965809, 0.4082482905>
		<0.3826834324, 0.9238795325, 0.0000000000>
		<0.0000000000, 0.9238795325, 0.3826834324>
	}
	triangle {
		<0.0000000000, 0.7071067812, 0.7071067812>
		<0.0000000000, 0.3826834324, 0.9238795325>
		<0.4082482905, 0.4082482905, 0.8164965809>
	}
	triangle {
		<0.0000000000, 0.3826834324, 0.9238795325>
		<0.0000000000, 0.0000000000, 1.0000000000>
		<0.3826834324, 0.0000000000, 0.9238795325>
	}
	triangle {
		<0.4082482905, 0.4082482905, 0.8164965809>
		<0.3826834324, 0.0000000000, 0.9238795325>
		<0.7071067812, 0.0000000000, 0.7071067812>
	}
	triangle {
		<0.3826834324, 0.0000000000, 0.9238795325>
		<0.4082482905, 0.4082482905, 0.8164965809>
		<0.0000000000, 0.3826834324, 0.9238795325>
	}
	triangle {
		<0.7071067812, 0.7071067812, 0.0000000000>
		<0.8164965809, 0.4082482905, 0.4082482905>
		<0.9238795325, 0.3826834324, 0.0000000000>
	}
	triangle {
		<0.8164965809, 0.4082482905, 0.4082482905>
		<0.7071067812, 0.0000000000, 0.7071067812>
		<0.9238795325, 0.0000000000, 0.3826834324>
	}
	triangle {
		<0.9238795325, 0.3826834324, 0.0000000000>
		<0.9238795325, 0.0000000000, 0.3826834324>
		<1.0000000000, 0.0000000000, 0.0000000000>
	}
	triangle {
		<0.9238795325, 0.0000000000, 0.3826834324>
		<0.9238795325, 0.3826834324, 0.0000000000>
		<0.8164965809, 0.4082482905, 0.4082482905>
	}
	triangle {
		<0.7071067812, 0.0000000000, 0.7071067812>
		<0.8164965809, 0.4082482905, 0.4082482905>
		<0.4082482905, 0.4082482905, 0.8164965809>
	}
	triangle {
		<0.8164965809, 0.4082482905, 0.4082482905>
		<0.7071067812, 0.7071067812, 0.0000000000>
		<0.4082482905, 0.8164965809, 0.4082482905>
	}
	triangle {
		<0.4082482905, 0.4082482905, 0.8164965809>
		<0.4082482905, 0.8164965809, 0.4082482905>
		<0.0000000000, 0.7071067812, 0.7071067812>
	}
	triangle {
		<0.4082482905, 0.8164965809, 0.4082482905>
		<0.4082482905, 0.4082482905, 0.8164965809>
		<0.8164965809, 0.4082482905, 0.4082482905>
	}
}


#declare geodome2_hemisphere = 
union {
	object { geodome2_eighth }
	object { geodome2_eighth rotate <0, 90, 0> }
	object { geodome2_eighth rotate <0, 180, 0> }
	object { geodome2_eighth rotate <0, 270, 0> }
}


#declare geodome2 = 
union {
	object { geodome2_hemisphere }
	object { geodome2_hemisphere rotate <180, 0, 0> }
}

#declare geodome3_eighth =
union {
	triangle {
		<0.0000000000, 1.0000000000, 0.0000000000>
		<0.0000000000, 0.9807852804, 0.1950903220>
		<0.1950903220, 0.9807852804, 0.0000000000>
	}
	triangle {
		<0.0000000000, 0.9807852804, 0.1950903220>
		<0.0000000000, 0.9238795325, 0.3826834324>
		<0.1987568534, 0.9596829823, 0.1987568534>
	}
	triangle {
		<0.1950903220, 0.9807852804, 0.0000000000>
		<0.1987568534, 0.9596829823, 0.1987568534>
		<0.3826834324, 0.9238795325, 0.0000000000>
	}
	triangle {
		<0.1987568534, 0.9596829823, 0.1987568534>
		<0.1950903220, 0.9807852804, 0.0000000000>
		<0.0000000000, 0.9807852804, 0.1950903220>
	}
	triangle {
		<0.0000000000, 0.9238795325, 0.3826834324>
		<0.0000000000, 0.8314696123, 0.5555702330>
		<0.2088465989, 0.8903200345, 0.4046150446>
	}
	triangle {
		<0.0000000000, 0.8314696123, 0.5555702330>
		<0.0000000000, 0.7071067812, 0.7071067812>
		<0.2113248654, 0.7886751346, 0.5773502692>
	}
	triangle {
		<0.2088465989, 0.8903200345, 0.4046150446>
		<0.2113248654, 0.7886751346, 0.5773502692>
		<0.4082482905, 0.8164965809, 0.4082482905>
	}
	triangle {
		<0.2113248654, 0.7886751346, 0.5773502692>
		<0.2088465989, 0.8903200345, 0.4046150446>
		<0.0000000000, 0.8314696123, 0.5555702330>
	}
	triangle {
		<0.3826834324, 0.9238795325, 0.0000000000>
		<0.4046150446, 0.8903200345, 0.2088465989>
		<0.5555702330, 0.8314696123, 0.0000000000>
	}
	triangle {
		<0.4046150446, 0.8903200345, 0.2088465989>
		<0.4082482905, 0.8164965809, 0.4082482905>
		<0.5773502692, 0.7886751346, 0.2113248654>
	}
	triangle {
		<0.5555702330, 0.8314696123, 0.0000000000>
		<0.5773502692, 0.7886751346, 0.2113248654>
		<0.7071067812, 0.7071067812, 0.0000000000>
	}
	triangle {
		<0.5773502692, 0.7886751346, 0.2113248654>
		<0.5555702330, 0.8314696123, 0.0000000000>
		<0.4046150446, 0.8903200345, 0.2088465989>
	}
	triangle {
		<0.4082482905, 0.8164965809, 0.4082482905>
		<0.4046150446, 0.8903200345, 0.2088465989>
		<0.2088465989, 0.8903200345, 0.4046150446>
	}
	triangle {
		<0.4046150446, 0.8903200345, 0.2088465989>
		<0.3826834324, 0.9238795325, 0.0000000000>
		<0.1987568534, 0.9596829823, 0.1987568534>
	}
	triangle {
		<0.2088465989, 0.8903200345, 0.4046150446>
		<0.1987568534, 0.9596829823, 0.1987568534>
		<0.0000000000, 0.9238795325, 0.3826834324>
	}
	triangle {
		<0.1987568534, 0.9596829823, 0.1987568534>
		<0.2088465989, 0.8903200345, 0.4046150446>
		<0.4046150446, 0.8903200345, 0.2088465989>
	}
	triangle {
		<0.0000000000, 0.7071067812, 0.7071067812>
		<0.0000000000, 0.5555702330, 0.8314696123>
		<0.2113248654, 0.5773502692, 0.7886751346>
	}
	triangle {
		<0.0000000000, 0.5555702330, 0.8314696123>
		<0.0000000000, 0.3826834324, 0.9238795325>
		<0.2088465989, 0.4046150446, 0.8903200345>
	}
	triangle {
		<0.2113248654, 0.5773502692, 0.7886751346>
		<0.2088465989, 0.4046150446, 0.8903200345>
		<0.4082482905, 0.4082482905, 0.8164965809>
	}
	triangle {
		<0.2088465989, 0.4046150446, 0.8903200345>
		<0.2113248654, 0.5773502692, 0.7886751346>
		<0.0000000000, 0.5555702330, 0.8314696123>
	}
	triangle {
		<0.0000000000, 0.3826834324, 0.9238795325>
		<0.0000000000, 0.1950903220, 0.9807852804>
		<0.1987568534, 0.1987568534, 0.9596829823>
	}
	triangle {
		<0.0000000000, 0.1950903220, 0.9807852804>
		<0.0000000000, 0.0000000000, 1.0000000000>
		<0.1950903220, 0.0000000000, 0.9807852804>
	}
	triangle {
		<0.1987568534, 0.1987568534, 0.9596829823>
		<0.1950903220, 0.0000000000, 0.9807852804>
		<0.3826834324, 0.0000000000, 0.9238795325>
	}
	triangle {
		<0.1950903220, 0.0000000000, 0.9807852804>
		<0.1987568534, 0.1987568534, 0.9596829823>
		<0.0000000000, 0.1950903220, 0.9807852804>
	}
	triangle {
		<0.4082482905, 0.4082482905, 0.8164965809>
		<0.4046150446, 0.2088465989, 0.8903200345>
		<0.5773502692, 0.2113248654, 0.7886751346>
	}
	triangle {
		<0.4046150446, 0.2088465989, 0.8903200345>
		<0.3826834324, 0.0000000000, 0.9238795325>
		<0.5555702330, 0.0000000000, 0.8314696123>
	}
	triangle {
		<0.5773502692, 0.2113248654, 0.7886751346>
		<0.5555702330, 0.0000000000, 0.8314696123>
		<0.7071067812, 0.0000000000, 0.7071067812>
	}
	triangle {
		<0.5555702330, 0.0000000000, 0.8314696123>
		<0.5773502692, 0.2113248654, 0.7886751346>
		<0.4046150446, 0.2088465989, 0.8903200345>
	}
	triangle {
		<0.3826834324, 0.0000000000, 0.9238795325>
		<0.4046150446, 0.2088465989, 0.8903200345>
		<0.1987568534, 0.1987568534, 0.9596829823>
	}
	triangle {
		<0.4046150446, 0.2088465989, 0.8903200345>
		<0.4082482905, 0.4082482905, 0.8164965809>
		<0.2088465989, 0.4046150446, 0.8903200345>
	}
	triangle {
		<0.1987568534, 0.1987568534, 0.9596829823>
		<0.2088465989, 0.4046150446, 0.8903200345>
		<0.0000000000, 0.3826834324, 0.9238795325>
	}
	triangle {
		<0.2088465989, 0.4046150446, 0.8903200345>
		<0.1987568534, 0.1987568534, 0.9596829823>
		<0.4046150446, 0.2088465989, 0.8903200345>
	}
	triangle {
		<0.7071067812, 0.7071067812, 0.0000000000>
		<0.7886751346, 0.5773502692, 0.2113248654>
		<0.8314696123, 0.5555702330, 0.0000000000>
	}
	triangle {
		<0.7886751346, 0.5773502692, 0.2113248654>
		<0.8164965809, 0.4082482905, 0.4082482905>
		<0.8903200345, 0.4046150446, 0.2088465989>
	}
	triangle {
		<0.8314696123, 0.5555702330, 0.0000000000>
		<0.8903200345, 0.4046150446, 0.2088465989>
		<0.9238795325, 0.3826834324, 0.0000000000>
	}
	triangle {
		<0.8903200345, 0.4046150446, 0.2088465989>
		<0.8314696123, 0.5555702330, 0.0000000000>
		<0.7886751346, 0.5773502692, 0.2113248654>
	}
	triangle {
		<0.8164965809, 0.4082482905, 0.4082482905>
		<0.7886751346, 0.2113248654, 0.5773502692>
		<0.8903200345, 0.2088465989, 0.4046150446>
	}
	triangle {
		<0.7886751346, 0.2113248654, 0.5773502692>
		<0.7071067812, 0.0000000000, 0.7071067812>
		<0.8314696123, 0.0000000000, 0.5555702330>
	}
	triangle {
		<0.8903200345, 0.2088465989, 0.4046150446>
		<0.8314696123, 0.0000000000, 0.5555702330>
		<0.9238795325, 0.0000000000, 0.3826834324>
	}
	triangle {
		<0.8314696123, 0.0000000000, 0.5555702330>
		<0.8903200345, 0.2088465989, 0.4046150446>
		<0.7886751346, 0.2113248654, 0.5773502692>
	}
	triangle {
		<0.9238795325, 0.3826834324, 0.0000000000>
		<0.9596829823, 0.1987568534, 0.1987568534>
		<0.9807852804, 0.1950903220, 0.0000000000>
	}
	triangle {
		<0.9596829823, 0.1987568534, 0.1987568534>
		<0.9238795325, 0.0000000000, 0.3826834324>
		<0.9807852804, 0.0000000000, 0.1950903220>
	}
	triangle {
		<0.9807852804, 0.1950903220, 0.0000000000>
		<0.9807852804, 0.0000000000, 0.1950903220>
		<1.0000000000, 0.0000000000, 0.0000000000>
	}
	triangle {
		<0.9807852804, 0.0000000000, 0.1950903220>
		<0.9807852804, 0.1950903220, 0.0000000000>
		<0.9596829823, 0.1987568534, 0.1987568534>
	}
	triangle {
		<0.9238795325, 0.0000000000, 0.3826834324>
		<0.9596829823, 0.1987568534, 0.1987568534>
		<0.8903200345, 0.2088465989, 0.4046150446>
	}
	triangle {
		<0.9596829823, 0.1987568534, 0.1987568534>
		<0.9238795325, 0.3826834324, 0.0000000000>
		<0.8903200345, 0.4046150446, 0.2088465989>
	}
	triangle {
		<0.8903200345, 0.2088465989, 0.4046150446>
		<0.8903200345, 0.4046150446, 0.2088465989>
		<0.8164965809, 0.4082482905, 0.4082482905>
	}
	triangle {
		<0.8903200345, 0.4046150446, 0.2088465989>
		<0.8903200345, 0.2088465989, 0.4046150446>
		<0.9596829823, 0.1987568534, 0.1987568534>
	}
	triangle {
		<0.7071067812, 0.0000000000, 0.7071067812>
		<0.7886751346, 0.2113248654, 0.5773502692>
		<0.5773502692, 0.2113248654, 0.7886751346>
	}
	triangle {
		<0.7886751346, 0.2113248654, 0.5773502692>
		<0.8164965809, 0.4082482905, 0.4082482905>
		<0.6396021491, 0.4264014327, 0.6396021491>
	}
	triangle {
		<0.5773502692, 0.2113248654, 0.7886751346>
		<0.6396021491, 0.4264014327, 0.6396021491>
		<0.4082482905, 0.4082482905, 0.8164965809>
	}
	triangle {
		<0.6396021491, 0.4264014327, 0.6396021491>
		<0.5773502692, 0.2113248654, 0.7886751346>
		<0.7886751346, 0.2113248654, 0.5773502692>
	}
	triangle {
		<0.8164965809, 0.4082482905, 0.4082482905>
		<0.7886751346, 0.5773502692, 0.2113248654>
		<0.6396021491, 0.6396021491, 0.4264014327>
	}
	triangle {
		<0.7886751346, 0.5773502692, 0.2113248654>
		<0.7071067812, 0.7071067812, 0.0000000000>
		<0.5773502692, 0.7886751346, 0.2113248654>
	}
	triangle {
		<0.6396021491, 0.6396021491, 0.4264014327>
		<0.5773502692, 0.7886751346, 0.2113248654>
		<0.4082482905, 0.8164965809, 0.4082482905>
	}
	triangle {
		<0.5773502692, 0.7886751346, 0.2113248654>
		<0.6396021491, 0.6396021491, 0.4264014327>
		<0.7886751346, 0.5773502692, 0.2113248654>
	}
	triangle {
		<0.4082482905, 0.4082482905, 0.8164965809>
		<0.4264014327, 0.6396021491, 0.6396021491>
		<0.2113248654, 0.5773502692, 0.7886751346>
	}
	triangle {
		<0.4264014327, 0.6396021491, 0.6396021491>
		<0.4082482905, 0.8164965809, 0.4082482905>
		<0.2113248654, 0.7886751346, 0.5773502692>
	}
	triangle {
		<0.2113248654, 0.5773502692, 0.7886751346>
		<0.2113248654, 0.7886751346, 0.5773502692>
		<0.0000000000, 0.7071067812, 0.7071067812>
	}
	triangle {
		<0.2113248654, 0.7886751346, 0.5773502692>
		<0.2113248654, 0.5773502692, 0.7886751346>
		<0.4264014327, 0.6396021491, 0.6396021491>
	}
	triangle {
		<0.4082482905, 0.8164965809, 0.4082482905>
		<0.4264014327, 0.6396021491, 0.6396021491>
		<0.6396021491, 0.6396021491, 0.4264014327>
	}
	triangle {
		<0.4264014327, 0.6396021491, 0.6396021491>
		<0.4082482905, 0.4082482905, 0.8164965809>
		<0.6396021491, 0.4264014327, 0.6396021491>
	}
	triangle {
		<0.6396021491, 0.6396021491, 0.4264014327>
		<0.6396021491, 0.4264014327, 0.6396021491>
		<0.8164965809, 0.4082482905, 0.4082482905>
	}
	triangle {
		<0.6396021491, 0.4264014327, 0.6396021491>
		<0.6396021491, 0.6396021491, 0.4264014327>
		<0.4264014327, 0.6396021491, 0.6396021491>
	}
}


#declare geodome3_hemisphere = 
union {
	object { geodome3_eighth }
	object { geodome3_eighth rotate <0, 90, 0> }
	object { geodome3_eighth rotate <0, 180, 0> }
	object { geodome3_eighth rotate <0, 270, 0> }
}


#declare geodome3 = 
union {
	object { geodome3_hemisphere }
	object { geodome3_hemisphere rotate <180, 0, 0> }
}
