//
// @(#)ship.inc:v1.0
//
// Author       : Kevin B Black
// Date written : 02 August 1995
// Copyright    :  Kevin B Black, 1995
// Abstract     :
//
// Define Orbit to surface to oribit transport ship. Originaly
// drafted on graph paper.
//
////////////////////////////////////////////////////////////////////////////////
//
// Items required to construct a ship
//
// Include the textures for the panels that make up the spacecraft
//
#include "shipptex.inc"

//
// Rocket nozzels
//
// Rocket nozzels come in two varieties, narrow and scalable, and larger
// for use on main lifting body. A well needs to be cut in where they
// are to be used, for effect.
//
#declare smallnozzel =
   difference
   {
      cone { <0.0, 0.05, 0.0>, 0.03, <0.0, -0.05, 0.0>, 0.05
              texture { pigment { Black } }
           }
      cone { <0.0, 0.03, 0.0>, 0.01, <0.0, -0.06, 0.0>, 0.027
              texture { pigment { Black } }
           }
   }

#declare smallnozzelwell =
   cone { <0.0, 0.049, 0.0>, 0.05, <0.0, -0.01, 0.0>, 0.07
           texture { pigment { Black } }
        }

#declare largenozzel =
   difference
   {
      cone { <0.0, 0.05, 0.0>, 0.06, <0.0, -0.05, 0.0>, 0.12
              texture { pigment { Black } }
           }
      cone { <0.0, 0.03, 0.0>, 0.05, <0.0, -0.06, 0.0>, 0.105
              texture { pigment { Black } }
           }
   }

#declare largenozzelwell =
   cone { <0.0, 0.049, 0.0>, 0.078, <0.0, -0.01, 0.0>, 0.1
           texture { pigment { Black } }
        }

#declare smallflame =
union
{
   difference
   {
      union
      {
         cone
         { <0.0, 0.05, 0.0>, 0.06, <0.0, -0.2, 0.0>, 0.0
            no_shadow
            texture { pigment { colour blue 0.9 } }
            finish { Luminous }
         }
         cone
         { <0.0, 0.05, 0.0>, 0.05, <0.0, -0.4, 0.0>, 0.0
            no_shadow
            texture { pigment { colour red 0.2 green 0.1 blue 0.9 filter 0.9 } }
            finish { Luminous }
         }
      }
      object
      {
         difference
         {
            cylinder { <0.0, 0.5, 0.0>, <0.0, -0.049, 0.0>, 1.0 texture { pigment { Black } } }
            cone { <0.0, 0.03, 0.0>, 0.01, <0.0, -0.06, 0.0>, 0.027
                    texture { pigment { Black } }
             }
         }
      }
   }
  light_source
  { <0, -0.7, 0>
     color White
     spotlight
     point_at <0, 0, 0>
     radius 0.1
     falloff 30
     tightness 100
   }
}

#declare largeflame =
union
{
   difference
   {
      object { union
      {
         sphere
         { <0.0, 0.0, 0.0>, 0.05
            scale <1.0, 3, 1.0>
            translate <0.0, -0.1, 0.0>
            no_shadow
            texture { pigment { colour blue 0.9 } }
            finish { Luminous }
         }
         sphere
         { <0.0, 0.0, 0.0>, 0.1
            scale <1.0, 3, 1.0>
            translate <0.0, -0.155, 0.0>
            no_shadow
            texture { pigment { colour red 0.2 green 0.1 blue 0.9 filter 0.9 } }
            finish { Luminous }
         }
         cone
         { <0.0, -0.7, 0.0>, 0.0, <0.0, -0.06, 0.0>, 0.105
            no_shadow
            texture { pigment { colour red 0.1 green 0.05 blue 1.0 filter 0.9 } }
            finish { Luminous }
         }
      } }
      object
      {
         difference
         {
            cylinder { <0.0, 0.5, 0.0>, <0.0, -0.049, 0.0>, 1.0 texture { pigment { Black } } }
            cone { <0.0, 0.03, 0.0>, 0.05, <0.0, -0.06, 0.0>, 0.105
                    texture { pigment { Black } }
             }
         }
      }
   }
  light_source
  { <0, -0.7, 0>
     color White
     spotlight
     point_at <0, 0, 0>
     radius 0.1
     falloff 30
     tightness 100
   }
}


//
// Landing feet etc
//
// Gear up version (just the door hatches). Door hatches are used for gear
// down version as well
//
#declare geardoorhatch =
union
{
   box
   { <-0.15, -0.003, -0.15>, <0.0, 0.003, 0.15>
      texture
      {
         pigment { Grey }
      }
   }
   box { <-0.15, -0.005, -0.15>, <-0.13, 0.005, 0.15> texture { pigment { colour red 1 green 1 blue 1 } } }
   box { <-0.15, -0.005,  0.15>, < 0.0,  0.005, 0.13> texture { pigment { colour red 1 green 1 blue 1 } } }
   box { < 0.0,  -0.005,  0.15>, < 0.02, 0.005,-0.15> texture { pigment { colour red 1 green 1 blue 1 } } }
   box { < 0.0,  -0.005, -0.15>, <-0.15, 0.005,-0.13> texture { pigment { colour red 1 green 1 blue 1 } } }
   cylinder { <-0.15, 0.0, -0.1>, <-0.15, 0.0, -0.05>, 0.02 texture { pigment { Silver } } }
   cylinder { <-0.15, 0.0,  0.1>, <-0.15, 0.0,  0.05>, 0.02 texture { pigment { Silver } } }
}

#declare geardoorup =
union
{
   object { geardoorhatch scale 0.5 }
   object { geardoorhatch scale 0.5 rotate < 0.0, 180, 0.0> }
}

//
// Gear down bits
//
#declare  geartoe =
union
{
   difference
   {
      box
      { <-0.1, -0.01, 0.0>, <0.1, 0.01, 0.15>
         texture { pigment { Gray } }
      }
      box
      { <0.0, -0.02, 0.0>, <0.3, 0.02, 0.3>
         texture { pigment { Gray } }
         rotate y*-25
         translate <0.1, 0.0, 0.0>
      }
      box
      { <0.0, -0.02, 0.0>, <-0.3, 0.02, 0.3>
         texture { pigment { Gray } }
         rotate y*25
         translate <-0.1, 0.0, 0.0>
      }
   }
   cylinder
   { <-0.08, 0.0, -0.01>, <-0.05, 0.0, -0.01>, 0.02
      texture { pigment { Silver } }
   }
   cylinder
   { <-0.015, 0.0, -0.01>, <0.015, 0.0, -0.01>, 0.02
      texture { pigment { Silver } }
   }
   cylinder
   { <0.05, 0.0, -0.01>, <0.08, 0.0, -0.01>, 0.02
      texture { pigment { Silver } }
   }
}

#declare gearfoot =
union
{
   box
   { <-0.1, -0.01, -0.1>, <0.1, 0.01, 0.1>
      texture { pigment { Gray } }
   }
   difference
   {
      sphere
      { <0.0, 0.0, 0.0>, 0.06
         texture { pigment { Yellow } }
      }
      box
      { <-0.5, 0.0, -0.5>, <0.5, -0.5, 0.5>
         texture { pigment { Yellow } }
      }
   }
   cylinder
   { <0.0, 0.0, 0.0>, <0.0, 0.3, 0.0>, 0.02
      texture { pigment { Silver } }
   }
   cone
   { <0.0, 0.15, 0.0>, 0.05, <0.0, 0.3, 0.0>, 0.06
      texture { pigment { Yellow } }
   }
   object { geartoe rotate <-4, 0.0, 0.0> translate <0.0, 0.0, 0.12> }
   object { geartoe rotate <-4, 0.0, 0.0> translate <0.0, 0.0, 0.12> rotate y*90 }
   object { geartoe rotate <-4, 0.0, 0.0> translate <0.0, 0.0, 0.12> rotate y*180 }
   object { geartoe rotate <-4, 0.0, 0.0> translate <0.0, 0.0, 0.12> rotate y*270 }
}

#declare geardown =
union
{
   object { gearfoot }
   object { geardoorhatch translate <0.15, 0.0, 0.0> rotate z*-160 translate <-0.15, 0.2, 0.0> }
   object { geardoorhatch translate <0.15, 0.0, 0.0> rotate z*-160 rotate y*180 translate <0.15, 0.2, 0.0> }
   scale 0.5
}

#declare gearwell =
box
{ <-0.15,0.1,-0.15>, <0.15,.3,0.15>
   texture { pigment { Black } }
   scale 0.5
}

////////////////////////////////////////////////////////////////////////////////
//
// Main body cones
//
// For test rendering of the ship in a scene, a simple version
// that will render faster is available.
//
// The space craft concists of csg of various shapes, the major
// bulk of the crafts body is made of cones. The cones are
// split into segments, each of which has a slightly different
// colour, to give the appearance that the space craft is
// "boiler plated". The cone segments are merged with a full
// cone for solidity, and by tweeking the size it may improve
// the appearance of the plates.
//
// Declare something to cut the cones with
//
#declare ConeCutter=
intersection
{
//   box { <0.0, -1.0, 0.0>, <1.0, 1.0, -1.0> rotate <0.0, -0.001, 0.0> }
//   box { <0.0, -1.0, 0.0>, <1.0, 1.0, -1.0> rotate <0.0, 45.001, 0.0> }
   box { <0.0, -1.0, 0.0>, <1.0, 1.0, -1.0> rotate <0.0, +0.001, 0.0> }
   box { <0.0, -1.0, 0.0>, <1.0, 1.0, -1.0> rotate <0.0, 45.0-0.001, 0.0> }
}

//
// Declare the first of the body segments, this is the major lower
// cone (two are required for upper and lower "plates").
//
// NOTE : This true cone would be cone { <0.0, 0.1, 0.0>, 0.3, <0.0, -0.5, 0.0>, 0.55 }
#declare body1useg =
intersection
{
   cone { <0.0, 0.1, 0.0>, 0.3, <0.0, -0.5, 0.0>, 0.55 }
   cylinder { <0.0, 0.1, 0.0>, <0.0, -0.201, 0.0>, 0.6 }
   object { ConeCutter }
}
#declare body1lseg =
intersection
{
   cone { <0.0, 0.1, 0.0>, 0.3, <0.0, -0.5, 0.0>, 0.55 }
   cylinder { <0.0, -0.2, 0.0>, <0.0, -0.5, 0.0>, 0.6 }
   object { ConeCutter }
}
#declare doorwaycutter =
intersection
{
   cylinder { <0.0, -0.25, 0.0>, <0.0, -0.5, 0.0>, 0.6 }
   object { ConeCutter rotate <0.0, 22.5, 0.0>
                       translate <0.0, 0.0, -0.2>
                       rotate <0.0, -22.5, 0.0> }
}

#declare body1lsegdoorway =
difference
{
   object { body1lseg }
   object { doorwaycutter }
}
#declare cargobaydoor =
difference
{
   intersection
   {
      object { body1lseg }
      intersection
      {
         cylinder { <0.0, -0.26, 0.0>, <0.0, -0.5, 0.0>, 0.6 }
         object { ConeCutter rotate <0.0, 22.5, 0.0>
                             translate <0.0, 0.0, -0.21>
                             rotate <0.0, -22.5, 0.0> }
      }
   }
   cone { <0.0, 0.09, 0.0>, 0.29, <0.0, -0.51, 0.0>, 0.54 }
}

#declare body1partial =
union
{
   object { body1useg texture { cc0 } }
   object { body1useg texture { cc1 } rotate y*45.0}
   object { body1useg texture { cc2 } rotate y*90.0}
   object { body1useg texture { cc3 } rotate y*135.0}
   object { body1useg texture { cc4 } rotate y*180.0}
   object { body1useg texture { cc0 } rotate y*225.0}
   object { body1useg texture { cc1 } rotate y*270.0}
   object { body1useg texture { cc2 } rotate y*315.0}
// Gets put in, below, contains cargo bay door   object { body1lseg texture { cc4 } }
   object { body1lseg texture { cc0 } rotate y*45.0}
   object { body1lseg texture { cc1 } rotate y*90.0}
   object { body1lseg texture { cc2 } rotate y*135.0}
   object { body1lseg texture { cc3 } rotate y*180.0}
   object { body1lseg texture { cc4 } rotate y*225.0}
   object { body1lseg texture { cc0 } rotate y*270.0}
   object { body1lseg texture { cc1 } rotate y*315.0}
//   cone
//   { <0.0, 0.1, 0.0>, 0.299999, <0.0, -0.5, 0.0>, 0.549999
//      texture { pigment { Gray } }   
//   }
}

#declare body1cargobayclosed =
union
{
   object { body1partial }
   object { body1lseg texture { pigment { Black } } } // Seal! Gap was left for this
   object { body1lsegdoorway texture { cc4 } }
   object { cargobaydoor texture { cc0door } }
   cylinder
   { <0.0, -0.55, 0.0>, <0.0, -0.49, 0.0>, 0.5
      texture { pigment { Gray } }
   }
   rotate <0.0, 22.5, 0.0>
}

#declare body1cargobayopen =
difference
{
   union
   {
      object { body1partial }
      object { body1lsegdoorway texture { cc4 } }
      object { cargobaydoor texture { pigment { colour Gray40 } } 
               rotate <0.0, 22.5, 0.0>
               translate <0.0, 0.5, 0.55>
               rotate <-140.0, 0.0, 0.0>
               translate <0.0, -0.5, -0.55>
               rotate <0.0, -22.5, 0.0>
      }
      cylinder
      { <0.0, -0.55, 0.0>, <0.0, -0.49, 0.0>, 0.5
         texture { pigment { Gray } }
      }
      rotate <0.0, 22.5, 0.0>
   }
   object { doorwaycutter rotate <0.0, 22.5, 0.0> }
   cone
   { <0.0, 0.1, 0.0>, 0.29, <0.0, -0.5, 0.0>, 0.549
      texture { pigment { Red } }   
   }
}

#declare body1simple =
object   
{
   cone { <0.0, 0.1, 0.0>, 0.3, <0.0, -0.5, 0.0>, 0.55
           texture { cc0 }   
        }
}

//
// Declare the second of the body segments, this is the major upper
// cone (only one set of "plates" for the upper major cone).
//
// NOTE : This true cone would be cone { <0.0, 0.3, 0.0>, 0.15, <0.0, 0.1, 0.0>, 0.3 }
#declare body2seg =
intersection
{
   cone { <0.0, 0.3, 0.0>, 0.15, <0.0, 0.1, 0.0>, 0.3 }
   object { ConeCutter }
}

#declare body2 =
object
{
   union
   {
      object { body2seg texture { cc2 } }
      object { body2seg texture { cc4 } rotate y*45.0}
      object { body2seg texture { cc3 } rotate y*90.0}
      object { body2seg texture { cc1 } rotate y*135.0}
      object { body2seg texture { cc0 } rotate y*180.0}
      object { body2seg texture { cc3 } rotate y*225.0}
      object { body2seg texture { cc2 } rotate y*270.0}
      object { body2seg texture { cc4 } rotate y*315.0}
   }
   rotate <0.0, 22.5, 0.0>
}

#declare body2simple =
object
{
   cone 
   { <0.0, 0.3, 0.0>, 0.15, <0.0, 0.1, 0.0>, 0.3
      texture { cc1 }
   }
}

//
// Declare the lifting body of the ship.
//
// Two versions are produced, one with the cargo bay door open,
// and one with it closed.
//
#declare shippodtexture =
texture
{
   pigment { Silver }
   finish
   {
      ambient  0.3
      diffuse  0.6
      reflection  0.1
      brilliance 5.0
      specular 0.2
      roughness 0.06
   }
}
#declare liftingbodypartial =
union
{
   object { body2 }
   torus // Bottom base half torus
   { 0.5, 0.05
      clipped_by { cone { <0.0, 0.6, 0.0>, 0.3, <0.0, 0.0, 0.0>, 0.55 } }
      translate <0.0, -0.55, 0.0>
      texture { pigment { White } }
   }
   torus // Torus between two major body cones
   { 0.3, 0.01
      translate <0.0, 0.1, 0.0>
      texture { pigment { Red } }
   }
   torus // Half torus on top of main cone
   { 0.14, 0.01
      translate <0.0, 0.3, 0.0>
      texture { pigment { Red } }
   }

//
// Docking column for flight module and "fuel" pods
//
   cylinder
   { <0.0, 0.3, 0.0>, <0.0, 0.35, 0.0>, 0.03
      texture { pigment { White } }
   }
   sphere { <0.08, 0.34, 0.0>, 0.04 texture { shippodtexture } }
   sphere { <0.08, 0.34, 0.0>, 0.04 rotate y*60 texture { shippodtexture } }
   sphere { <0.08, 0.34, 0.0>, 0.04 rotate y*120 texture { shippodtexture } }
   sphere { <0.08, 0.34, 0.0>, 0.04 rotate y*180 texture { shippodtexture } }
   sphere { <0.08, 0.34, 0.0>, 0.04 rotate y*240 texture { shippodtexture } }
   sphere { <0.08, 0.34, 0.0>, 0.04 rotate y*300 texture { shippodtexture } }

//
// Large rocket engine in the middle
//
   object { largenozzel translate <0.0, -0.55, 0.0> }

//
// Small rocket engines
//
   object { smallnozzel rotate <0,0,-20> translate <-0.22,-0.55,0> }
   object { smallnozzel rotate <0,0,-20> translate <-0.22,-0.55,0> rotate <0.0, 90, 0.0> }
   object { smallnozzel rotate <0,0,-20>  translate <-0.22,-0.55,0> rotate <0.0, 180, 0.0> }
   object { smallnozzel rotate <0,0,-20>  translate <-0.22,-0.55,0> rotate <0.0, 270, 0.0> }

}

//
// Lifting body, cargo bay door closed
//
#declare liftingbody =
union
{

//
// Cones
//
   difference
   {
      object { body1cargobayclosed }
      object { largenozzelwell translate <0.0, -0.55, 0.0 > }
      object { smallnozzelwell rotate <0,0,-20> translate <-0.22,-0.55,0> }
      object { smallnozzelwell rotate <0,0,-20> translate <-0.22,-0.55,0> rotate <0.0, 90, 0.0> }
      object { smallnozzelwell rotate <0,0,-20>  translate <-0.22,-0.55,0> rotate <0.0, 180, 0.0> }
      object { smallnozzelwell rotate <0,0,-20>  translate <-0.22,-0.55,0> rotate <0.0, 270, 0.0> }
   }
   object { liftingbodypartial }
}

//
// Lifting body, cargo bar door open
//
#declare liftingbodybaydoor =
union
{

//
// Cones
//
   difference
   {
      object { body1cargobayopen }
      object { largenozzelwell translate <0.0, -0.55, 0.0 > }
      object { smallnozzelwell rotate <0,0,-20> translate <-0.22,-0.55,0> }
      object { smallnozzelwell rotate <0,0,-20> translate <-0.22,-0.55,0> rotate <0.0, 90, 0.0> }
      object { smallnozzelwell rotate <0,0,-20>  translate <-0.22,-0.55,0> rotate <0.0, 180, 0.0> }
      object { smallnozzelwell rotate <0,0,-20>  translate <-0.22,-0.55,0> rotate <0.0, 270, 0.0> }
   }
   object { liftingbodypartial }
}

////////////////////////////////////////////////////////////////////////////////
//
// Declare the flight module. Built in location.
//
#declare body3 =
merge
{
   difference
   {
//
// Main body part of flight control module
//
      merge
      {
         intersection
         {
            cone
            { <0.0, 0.5, 0.0>, 0.05, <0.0, 0.4, 0.0>, 0.1
               texture
               {
                  pigment { Gray }
                  finish
                  {
                     ambient  0.3
                     diffuse  0.6
                     reflection  0.01
                     brilliance 4.5
                     specular 0.2
                     roughness 0.08
                  }

               }
               texture 
               {
                  pigment
                  {
                     image_map { gif "decals.gif" filter 80, 0.9 map_type 3 once interpolate 2 }
                     rotate <0.0, -10, 0.0>
                     scale <0.03, 0.02, 0.03>
                     translate <0.0, 0.45-0.03, 0.0>
                  }
               }
            }
            cone { <0.0, 0.5, 0.0>, 0.15, <0.0, 0.4, 0.0>, 0.075
                    texture
                    {
                       pigment { Gray }
                       finish
                       {
                          ambient  0.3
                          diffuse  0.6
                          reflection  0.0
                          brilliance 4.0
                          specular 0.1
                          roughness 0.08
                       }
                    }
                 }
         }
         difference
         {
            sphere { <0.0, 0.475, 0.0>, 0.055
                      texture { pigment { Red } }
                   }
            cylinder { <0.0, 0.49999, 0.0>, <0.0, 0.0, 0.0>, 0.2
                        texture { pigment { Red } }
                     }
         }
      }

//
// Attitude control jets
//
      cylinder { <0.15, 0.47, 0.0>, <0.05, 0.42, 0.0>, 0.006 texture { pigment { Black } } rotate <0.0, 45, 0.0> }
      cylinder { <0.15, 0.47, 0.0>, <0.05, 0.42, 0.0>, 0.006 texture { pigment { Black } } rotate <0.0, 135, 0.0> }
      cylinder { <0.15, 0.47, 0.0>, <0.05, 0.42, 0.0>, 0.006 texture { pigment { Black } } rotate <0.0, 225, 0.0> }
      cylinder { <0.15, 0.47, 0.0>, <0.05, 0.42, 0.0>, 0.006 texture { pigment { Black } } rotate <0.0, 315, 0.0> }

//
// Cut an inside and window
//
      cone { <0.0, 0.48, 0.0>, 0.035, <0.0, 0.44, 0.0>, 0.07
              texture { pigment { Gray } }
           }
//      box { <-0.030, 0.455, 0.0>, <0.030, 0.475, -0.2> pigment { Gray } }
      intersection
      {
         cylinder { <0.0, 0.455, 0.0>, <0.0, 0.475, 0.0>, 0.15
                     texture { pigment { Gray } }
                  }
         object { ConeCutter texture { pigment { Gray } } rotate <0.0, 22.5, 0.0> }
      }

//
// Make counter sunk holes for the rocket nozzles to occupy
//
      object { smallnozzelwell scale 0.1 rotate <0,0,-20> translate <0.06,0.4,0> rotate <0.0, 45, 0.0> }
      object { smallnozzelwell scale 0.1 rotate <0,0,-20> translate <0.06,0.4,0> rotate <0.0, 135, 0.0> }
      object { smallnozzelwell scale 0.1 rotate <0,0,-20>  translate <0.06,0.4,0> rotate <0.0, 225, 0.0> }
      object { smallnozzelwell scale 0.1 rotate <0,0,-20>  translate <0.06,0.4,0> rotate <0.0, 315, 0.0> }

   }

//
// Insert the rocket nozzles
//
   object { smallnozzel scale 0.1 rotate <0,0,-20> translate <0.06,0.4,0> rotate <0.0, 45, 0.0> }
   object { smallnozzel scale 0.1 rotate <0,0,-20> translate <0.06,0.4,0> rotate <0.0, 135, 0.0> }
   object { smallnozzel scale 0.1 rotate <0,0,-20>  translate <0.06,0.4,0> rotate <0.0, 225, 0.0> }
   object { smallnozzel scale 0.1 rotate <0,0,-20>  translate <0.06,0.4,0> rotate <0.0, 315, 0.0> }

//
// Insert glass in the window
//
}

#declare body3simple =
merge
{
   intersection
   {
      cone
      { <0.0, 0.5, 0.0>, 0.05, <0.0, 0.4, 0.0>, 0.1
         texture { pigment { Gray } }
      }
      cone
      { <0.0, 0.5, 0.0>, 0.15, <0.0, 0.4, 0.0>, 0.075
         texture { pigment { Gray } }
      }
   }
   difference
   {
      sphere { <0.0, 0.475, 0.0>, 0.055
                texture { pigment { Red } }
             }
      cylinder { <0.0, 0.49999, 0.0>, <0.0, 0.0, 0.0>, 0.2
                  texture { pigment { Red } }
               }
   }
}

////////////////////////////////////////////////////////////////////////////////
//
// Docking linkage
//
// Declare the docking linkage that joins the flight control module
// to the lifting body
//
#declare docklink =
union
{
   cylinder
   { <0.0, 0.35, 0.0>, <0.0, 0.36, 0.0>, 0.03
      texture { pigment { Yellow } }
   }
   cylinder
   { <0.0, 0.39, 0.0>, <0.0, 0.41, 0.0>, 0.035
      texture { pigment { Yellow } }
   }

// Initiated from p1.for
   cylinder
   { < .026000, .3550, .0000000000>,< .026847, .3950,-.0155000000>, .0040
      texture { pigment { Yellow } }
   }
   cylinder
   { < .026000, .3550, .0000000000>,< .026847, .3950, .0155000000>, .0040
      texture { pigment { Yellow } }
   }
   cylinder
   { < .013000, .3550, .0225166600>,< .026847, .3950, .0155000000>, .0040
      texture { pigment { Yellow } }
   }
   cylinder
   { < .013000, .3550, .0225166600>,< .000000, .3950, .0310000000>, .0040 
      texture { pigment { Yellow } }
   }
   cylinder
   { <-.013000, .3550, .0225166600>,< .000000, .3950, .0310000000>, .0040 
      texture { pigment { Yellow } }
   }
   cylinder
   { <-.013000, .3550, .0225166600>,<-.026847, .3950, .0155000000>, .0040 
      texture { pigment { Yellow } }
   }
   cylinder
   { <-.026000, .3550,-.0000000023>,<-.026847, .3950, .0155000000>, .0040 
      texture { pigment { Yellow } }
   }
   cylinder
   { <-.026000, .3550,-.0000000023>,<-.026847, .3950,-.0155000100>, .0040 
      texture { pigment { Yellow } }
   }
   cylinder
   { <-.013000, .3550,-.0225166600>,<-.026847, .3950,-.0155000100>, .0040 
      texture { pigment { Yellow } }
   }
   cylinder
   { <-.013000, .3550,-.0225166600>,< .000000, .3950,-.0310000000>, .0040
      texture { pigment { Yellow } }
   }
   cylinder
   { < .013000, .3550,-.0225166600>,< .000000, .3950,-.0310000000>, .0040
      texture { pigment { Yellow } }
   }
   cylinder
   { < .013000, .3550,-.0225166600>,< .026847, .3950,-.0155000100>, .0040
      texture { pigment { Yellow } }
   }
}

//
// The crew have lighting...
//
// NOTE : Needs to be inserted in scene file at appropriate place
//
#declare Ship_Lights =
light_source {<0.0, 0.478, 0.0> colour red 0.8 green 0.8 blue 1.0 }

//
// Declate complete ship objects. Rocket engines on the lifting body
// are assumed to be running if gear is up. Cargo bay door is assumed
// to be open if the gear is down. If the door is open, then there
// is a light on in side.
//
#declare Ship_GearUp =
union
{
   object { body3 }
   object { docklink }
   object { liftingbody }
   object { geardoorup translate <-0.35, -0.5501, 0.0 > rotate y*45 }
   object { geardoorup translate <-0.35, -0.5501, 0.0 > rotate y*135 }
   object { geardoorup translate <-0.35, -0.5501, 0.0 > rotate y*225 }
   object { geardoorup translate <-0.35, -0.5501, 0.0 > rotate y*315 }
   object { largeflame translate <0.0, -0.55, 0.0> }
   object { smallflame rotate <0,0,-20> translate <-0.22,-0.55,0> }
   object { smallflame rotate <0,0,-20> translate <-0.22,-0.55,0> rotate <0.0, 90, 0.0> }
   object { smallflame rotate <0,0,-20>  translate <-0.22,-0.55,0> rotate <0.0, 180, 0.0> }
   object { smallflame rotate <0,0,-20>  translate <-0.22,-0.55,0> rotate <0.0, 270, 0.0> }
   bounded_by { box { <-0.6, -1.3, -0.6>, <0.6, 0.55, 0.6> } }
}

#declare Ship_GearDown =
union
{
   object { body3 }
   object { docklink }
   difference
   {
      object { liftingbodybaydoor }
      object { gearwell rotate y*45 translate <-0.35, -0.6501, 0.0 > rotate y*45 }
      object { gearwell rotate y*45 translate <-0.35, -0.6501, 0.0 > rotate y*135 }
      object { gearwell rotate y*45 translate <-0.35, -0.6501, 0.0 > rotate y*225 }
      object { gearwell rotate y*45 translate <-0.35, -0.6501, 0.0 > rotate y*315 }
   }
   object { geardown rotate y*45 translate <-0.35, -0.6501, 0.0 > rotate y*45 }
   object { geardown rotate y*45 translate <-0.35, -0.6501, 0.0 > rotate y*135 }
   object { geardown rotate y*45 translate <-0.35, -0.6501, 0.0 > rotate y*225 }
   object { geardown rotate y*45 translate <-0.35, -0.6501, 0.0 > rotate y*315 }
   light_source { <0.0, 0.0, 0.0> colour red 0.8 green 0.8 blue 0.9 }
   bounded_by { box { <-0.6, -0.7, -0.6>, <0.6, 0.55, 0.7> } }
}

#declare Ship_Simple =
union
{
   object { body1simple }
   object { body2simple }
   object { body3simple }
   bounded_by { box { <-0.6, -0.7, -0.6>, <0.6, 0.55, 0.7> } }
}
