//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 1 lights, 4 textures and 15 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE (c) 1991-1994 SoftTronics by Lutz Kretzschmar + Markus Lutz
//

//  Date : 08/30/1995    (30.08.1995)
//

//
//  This is the standard include file for POV.
//

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "star.inc"

// If you don't like or want the green floor plane and the blue sky, then
// delete the following line. (To permanently delete it, remove it from
// MRYDEFLT.INC in your Moray directory.
//#include "enviro.inc"

camera {  //  Camera Camera01
  location  <1.039, -107.882, 37.389>
  direction <0.0,     0.0,  1.1547>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, -0.056, 27.447> // Following Rocket
}

// *******  L I G H T S *******
light_source {   // Light001
  <-57.585, -53.796, 113.796>
  color rgb <1.000, 1.000, 1.000>
}


//
// ********  T E X T U R E S  *******
//

#include "MOONRCKT.INC"

// ********  O B J E C T S *******
#declare Bound00002 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <4.605636, 2.143104, 9.738227>
  translate <-6.337468, 0.000000, 9.526856>
}

#declare Damper = object { 
  sphere {<0,0,0>,1}
  scale <1.930000, 1.930000, 1.930000>
  translate <-8.800000, 0.000000, 1.930000>
}

#declare StrFoot_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-1.874829, 0.000000, -0.009776>  <-1.874829, -1.031156, -0.009776>  <-1.031156, -1.874829, -0.009776>  <0.000000, -1.874829, -0.009776>
    <-1.922886, 0.000000, 1.161072>  <-1.922886, -1.057587, 1.161072>  <-1.057587, -1.922886, 1.161072>  <0.000000, -1.922886, 1.161072>
    <-2.347238, 0.000000, 4.235698>  <-2.347238, -1.290981, 4.235698>  <-1.290981, -2.347238, 4.235698>  <0.000000, -2.347238, 4.235698>
    <-0.000089, 0.000000, 8.243831>  <-0.000089, -0.000049, 8.243831>  <-0.000049, -0.000089, 8.243831>  <0.000000, -0.000089, 8.243831>  }
}
#declare StrFoot_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.000000, -1.874829, -0.009776>  <1.031156, -1.874829, -0.009776>  <1.874829, -1.031156, -0.009776>  <1.874829, 0.000000, -0.009776>
    <0.000000, -1.922886, 1.161072>  <1.057587, -1.922886, 1.161072>  <1.922886, -1.057587, 1.161072>  <1.922886, 0.000000, 1.161072>
    <0.000000, -2.347238, 4.235698>  <1.290981, -2.347238, 4.235698>  <2.347238, -1.290981, 4.235698>  <2.347238, 0.000000, 4.235698>
    <0.000000, -0.000089, 8.243831>  <0.000049, -0.000089, 8.243831>  <0.000089, -0.000049, 8.243831>  <0.000089, 0.000000, 8.243831>  }
}
#declare StrFoot_3 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <1.874829, 0.000000, -0.009776>  <1.874829, 1.031156, -0.009776>  <1.031156, 1.874829, -0.009776>  <0.000000, 1.874829, -0.009776>
    <1.922886, 0.000000, 1.161072>  <1.922886, 1.057587, 1.161072>  <1.057587, 1.922886, 1.161072>  <0.000000, 1.922886, 1.161072>
    <2.347238, 0.000000, 4.235698>  <2.347238, 1.290981, 4.235698>  <1.290981, 2.347238, 4.235698>  <0.000000, 2.347238, 4.235698>
    <0.000089, 0.000000, 8.243831>  <0.000089, 0.000049, 8.243831>  <0.000049, 0.000089, 8.243831>  <0.000000, 0.000089, 8.243831>  }
}
#declare StrFoot_4 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.000000, 1.874829, -0.009776>  <-1.031156, 1.874829, -0.009776>  <-1.874829, 1.031156, -0.009776>  <-1.874829, 0.000000, -0.009776>
    <0.000000, 1.922886, 1.161072>  <-1.057587, 1.922886, 1.161072>  <-1.922886, 1.057587, 1.161072>  <-1.922886, 0.000000, 1.161072>
    <0.000000, 2.347238, 4.235698>  <-1.290981, 2.347238, 4.235698>  <-2.347238, 1.290981, 4.235698>  <-2.347238, 0.000000, 4.235698>
    <0.000000, 0.000089, 8.243831>  <-0.000049, 0.000089, 8.243831>  <-0.000089, 0.000049, 8.243831>  <-0.000089, 0.000000, 8.243831>  }
}
#declare StrFoot = union { 
  object { StrFoot_1 }
  object { StrFoot_2 }
  object { StrFoot_3 }
  object { StrFoot_4 }
  translate <-8.800000, 0.000000, 1.930000>
}

#declare Connector_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-1.927892, 0.000000, 8.240513>  <-1.927892, -0.183673, 8.240513>  <0.009495, -0.183673, -0.007407>  <0.009495, 0.000000, -0.007407>
    <-0.525319, 0.000000, 11.032006>  <-0.525319, -0.183673, 11.032006>  <1.776264, -0.183673, 2.966184>  <1.776264, 0.000000, 2.966184>
    <1.423548, 0.000000, 13.914549>  <1.423548, -0.183673, 13.914549>  <3.269886, -0.183673, 5.029286>  <3.269886, 0.000000, 5.029286>
    <4.867848, 0.000000, 17.123711>  <4.867848, -0.183673, 17.123711>  <4.926797, -0.183673, 6.529624>  <4.926797, 0.000000, 6.529624>  }
}
#declare Connector_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.009495, 0.000000, -0.007407>  <0.009495, 0.183673, -0.007407>  <-1.927892, 0.183673, 8.240513>  <-1.927892, 0.000000, 8.240513>
    <1.776264, 0.000000, 2.966184>  <1.776264, 0.183673, 2.966184>  <-0.525319, 0.183673, 11.032006>  <-0.525319, 0.000000, 11.032006>
    <3.269886, 0.000000, 5.029286>  <3.269886, 0.183673, 5.029286>  <1.423548, 0.183673, 13.914549>  <1.423548, 0.000000, 13.914549>
    <4.926797, 0.000000, 6.529624>  <4.926797, 0.183673, 6.529624>  <4.867848, 0.183673, 17.123711>  <4.867848, 0.000000, 17.123711>  }
}
#declare Connector = union { 
  object { Connector_1 }
  object { Connector_2 }
  translate <-6.870000, 0.000000, 1.930000>
}

#declare Foot1 = union {
  object { Damper }
  object { StrFoot }
  object { Connector }
  bounded_by { Bound00002 }
}
#declare Bound00001 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <2.564846, 2.564846, 16.619398>
  translate <0.006476, 0.000710, 23.561099>
}

#declare LowerFuselag_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-1.975998, 0.000000, -0.739464>  <-1.975998, -1.086799, -0.739464>  <-1.086799, -1.975998, -0.739464>  <0.000000, -1.975998, -0.739464>
    <-2.035766, 0.000000, 3.689709>  <-2.035766, -1.119671, 3.689709>  <-1.119671, -2.035766, 3.689709>  <0.000000, -2.035766, 3.689709>
    <-2.100737, 0.000000, 7.383689>  <-2.100737, -1.155405, 7.383689>  <-1.155405, -2.100737, 7.383689>  <0.000000, -2.100737, 7.383689>
    <-2.161401, 0.000000, 11.091424>  <-2.161401, -1.188770, 11.091424>  <-1.188770, -2.161401, 11.091424>  <0.000000, -2.161401, 11.091424>  }
}
#declare LowerFuselag_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.000000, -1.975998, -0.739464>  <1.086799, -1.975998, -0.739464>  <1.975998, -1.086799, -0.739464>  <1.975998, 0.000000, -0.739464>
    <0.000000, -2.035766, 3.689709>  <1.119671, -2.035766, 3.689709>  <2.035766, -1.119671, 3.689709>  <2.035766, 0.000000, 3.689709>
    <0.000000, -2.100737, 7.383689>  <1.155405, -2.100737, 7.383689>  <2.100737, -1.155405, 7.383689>  <2.100737, 0.000000, 7.383689>
    <0.000000, -2.161401, 11.091424>  <1.188770, -2.161401, 11.091424>  <2.161401, -1.188770, 11.091424>  <2.161401, 0.000000, 11.091424>  }
}
#declare LowerFuselag_3 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <1.975998, 0.000000, -0.739464>  <1.975998, 1.086799, -0.739464>  <1.086799, 1.975998, -0.739464>  <0.000000, 1.975998, -0.739464>
    <2.035766, 0.000000, 3.689709>  <2.035766, 1.119671, 3.689709>  <1.119671, 2.035766, 3.689709>  <0.000000, 2.035766, 3.689709>
    <2.100737, 0.000000, 7.383689>  <2.100737, 1.155405, 7.383689>  <1.155405, 2.100737, 7.383689>  <0.000000, 2.100737, 7.383689>
    <2.161401, 0.000000, 11.091424>  <2.161401, 1.188770, 11.091424>  <1.188770, 2.161401, 11.091424>  <0.000000, 2.161401, 11.091424>  }
}
#declare LowerFuselag_4 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.000000, 1.975998, -0.739464>  <-1.086799, 1.975998, -0.739464>  <-1.975998, 1.086799, -0.739464>  <-1.975998, 0.000000, -0.739464>
    <0.000000, 2.035766, 3.689709>  <-1.119671, 2.035766, 3.689709>  <-2.035766, 1.119671, 3.689709>  <-2.035766, 0.000000, 3.689709>
    <0.000000, 2.100737, 7.383689>  <-1.155405, 2.100737, 7.383689>  <-2.100737, 1.155405, 7.383689>  <-2.100737, 0.000000, 7.383689>
    <0.000000, 2.161401, 11.091424>  <-1.188770, 2.161401, 11.091424>  <-2.161401, 1.188770, 11.091424>  <-2.161401, 0.000000, 11.091424>  }
}
#declare LowerFuselage = union { 
  object { LowerFuselag_1 }
  object { LowerFuselag_2 }
  object { LowerFuselag_3 }
  object { LowerFuselag_4 }
  translate <0.000000, 0.000000, 7.960000>
}

#declare CentrFuselag_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-2.155989, 0.000000, -0.007693>  <-2.155989, -1.185794, -0.007693>  <-1.185794, -2.155989, -0.007693>  <0.000000, -2.155989, -0.007693>
    <-2.415317, 0.001598, 6.623505>  <-2.415317, -1.330593, 6.623505>  <-1.325343, -2.420568, 6.623505>  <0.006848, -2.420568, 6.623505>
    <-2.248660, 0.000000, 10.145678>  <-2.248660, -1.244045, 10.145678>  <-1.230805, -2.261900, 10.145678>  <0.013240, -2.261900, 10.145678>
    <-1.823768, 0.000000, 14.326598>  <-1.823768, -1.010354, 14.326598>  <-0.997114, -1.837007, 14.326598>  <0.013240, -1.837007, 14.326598>  }
}
#declare CentrFuselag_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.000000, -2.155989, -0.007693>  <1.185794, -2.155989, -0.007693>  <2.155989, -1.185794, -0.007693>  <2.155989, 0.000000, -0.007693>
    <0.006848, -2.420568, 6.623505>  <1.339039, -2.420568, 6.623505>  <2.429013, -1.330593, 6.623505>  <2.429013, 0.001598, 6.623505>
    <0.013240, -2.261900, 10.145678>  <1.257285, -2.261900, 10.145678>  <2.275140, -1.244045, 10.145678>  <2.275140, 0.000000, 10.145678>
    <0.013240, -1.837007, 14.326598>  <1.023594, -1.837007, 14.326598>  <1.850247, -1.010354, 14.326598>  <1.850247, 0.000000, 14.326598>  }
}
#declare CentrFuselag_3 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <2.155989, 0.000000, -0.007693>  <2.155989, 1.185794, -0.007693>  <1.185794, 2.155989, -0.007693>  <0.000000, 2.155989, -0.007693>
    <2.429013, 0.001598, 6.623505>  <2.429013, 1.333789, 6.623505>  <1.339039, 2.423763, 6.623505>  <0.006848, 2.423763, 6.623505>
    <2.275140, 0.000000, 10.145678>  <2.275140, 1.244045, 10.145678>  <1.257285, 2.261900, 10.145678>  <0.013240, 2.261900, 10.145678>
    <1.850247, 0.000000, 14.326598>  <1.850247, 1.010354, 14.326598>  <1.023594, 1.837007, 14.326598>  <0.013240, 1.837007, 14.326598>  }
}
#declare CentrFuselag_4 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.000000, 2.155989, -0.007693>  <-1.185794, 2.155989, -0.007693>  <-2.155989, 1.185794, -0.007693>  <-2.155989, 0.000000, -0.007693>
    <0.006848, 2.423763, 6.623505>  <-1.325343, 2.423763, 6.623505>  <-2.415317, 1.333789, 6.623505>  <-2.415317, 0.001598, 6.623505>
    <0.013240, 2.261900, 10.145678>  <-1.230805, 2.261900, 10.145678>  <-2.248660, 1.244045, 10.145678>  <-2.248660, 0.000000, 10.145678>
    <0.013240, 1.837007, 14.326598>  <-0.997114, 1.837007, 14.326598>  <-1.823768, 1.010354, 14.326598>  <-1.823768, 0.000000, 14.326598>  }
}
#declare CentrFuselage = union { 
  object { CentrFuselag_1 }
  object { CentrFuselag_2 }
  object { CentrFuselag_3 }
  object { CentrFuselag_4 }
  texture {
    CheckeredRed
    scale <1.750000, 3.000000, 3.000000>
    rotate <-90.000000, 0.000000, 0.000000>
    translate <-0.670536, 0.000000, 0.000000>
  }
  translate <0.000000, 0.000000, 19.100000>
}

#declare UpperFuselag_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-1.849468, 0.000000, -0.018602>  <-1.849468, -1.017208, -0.018602>  <-1.017208, -1.849468, -0.018602>  <0.000000, -1.849468, -0.018602>
    <-1.574913, 0.000000, 2.239841>  <-1.574913, -0.866202, 2.239841>  <-0.866202, -1.574913, 2.239841>  <0.000000, -1.574913, 2.239841>
    <-1.081529, 0.000000, 4.368166>  <-1.081529, -0.594841, 4.368166>  <-0.594841, -1.081529, 4.368166>  <0.000000, -1.081529, 4.368166>
    <0.001849, 0.000000, 6.501663>  <0.001849, -0.000003, 6.501663>  <0.001851, -0.000006, 6.501663>  <0.001855, -0.000006, 6.501663>  }
}
#declare UpperFuselag_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.000000, -1.849468, -0.018602>  <1.017208, -1.849468, -0.018602>  <1.849468, -1.017208, -0.018602>  <1.849468, 0.000000, -0.018602>
    <0.000000, -1.574913, 2.239841>  <0.866202, -1.574913, 2.239841>  <1.574913, -0.866202, 2.239841>  <1.574913, 0.000000, 2.239841>
    <0.000000, -1.081529, 4.368166>  <0.594841, -1.081529, 4.368166>  <1.081529, -0.594841, 4.368166>  <1.081529, 0.000000, 4.368166>
    <0.001855, -0.000006, 6.501663>  <0.001858, -0.000006, 6.501663>  <0.001861, -0.000003, 6.501663>  <0.001861, 0.000000, 6.501663>  }
}
#declare UpperFuselag_3 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <1.849468, 0.000000, -0.018602>  <1.849468, 1.017208, -0.018602>  <1.017208, 1.849468, -0.018602>  <0.000000, 1.849468, -0.018602>
    <1.574913, 0.000000, 2.239841>  <1.574913, 0.866202, 2.239841>  <0.866202, 1.574913, 2.239841>  <0.000000, 1.574913, 2.239841>
    <1.081529, 0.000000, 4.368166>  <1.081529, 0.594841, 4.368166>  <0.594841, 1.081529, 4.368166>  <0.000000, 1.081529, 4.368166>
    <0.001861, 0.000000, 6.501663>  <0.001861, 0.000003, 6.501663>  <0.001858, 0.000006, 6.501663>  <0.001855, 0.000006, 6.501663>  }
}
#declare UpperFuselag_4 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.000000, 1.849468, -0.018602>  <-1.017208, 1.849468, -0.018602>  <-1.849468, 1.017208, -0.018602>  <-1.849468, 0.000000, -0.018602>
    <0.000000, 1.574913, 2.239841>  <-0.866202, 1.574913, 2.239841>  <-1.574913, 0.866202, 2.239841>  <-1.574913, 0.000000, 2.239841>
    <0.000000, 1.081529, 4.368166>  <-0.594841, 1.081529, 4.368166>  <-1.081529, 0.594841, 4.368166>  <-1.081529, 0.000000, 4.368166>
    <0.001855, 0.000006, 6.501663>  <0.001851, 0.000006, 6.501663>  <0.001849, 0.000003, 6.501663>  <0.001849, 0.000000, 6.501663>  }
}
#declare UpperFuselage = union { 
  object { UpperFuselag_1 }
  object { UpperFuselag_2 }
  object { UpperFuselag_3 }
  object { UpperFuselag_4 }
  translate <0.000000, 0.000000, 33.400000>
}

#declare Fuselage = union {
  object { LowerFuselage }
  object { CentrFuselage }
  object { UpperFuselage }
  bounded_by { Bound00001 }
  scale <1.200000, 1.200000, 1.000000>
}
#declare Bound3 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <4.605636, 2.143104, 9.738227>
  translate <-6.337468, 0.000000, 9.526856>
}

#declare Damper1 = object { 
  sphere {<0,0,0>,1}
  scale <1.930000, 1.930000, 1.930000>
  translate <-8.800000, 0.000000, 1.930000>
}

#declare StrFoot1_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-1.874829, 0.000000, -0.009776>  <-1.874829, -1.031156, -0.009776>  <-1.031156, -1.874829, -0.009776>  <0.000000, -1.874829, -0.009776>
    <-1.922886, 0.000000, 1.161072>  <-1.922886, -1.057587, 1.161072>  <-1.057587, -1.922886, 1.161072>  <0.000000, -1.922886, 1.161072>
    <-2.347238, 0.000000, 4.235698>  <-2.347238, -1.290981, 4.235698>  <-1.290981, -2.347238, 4.235698>  <0.000000, -2.347238, 4.235698>
    <-0.000089, 0.000000, 8.243831>  <-0.000089, -0.000049, 8.243831>  <-0.000049, -0.000089, 8.243831>  <0.000000, -0.000089, 8.243831>  }
}
#declare StrFoot1_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.000000, -1.874829, -0.009776>  <1.031156, -1.874829, -0.009776>  <1.874829, -1.031156, -0.009776>  <1.874829, 0.000000, -0.009776>
    <0.000000, -1.922886, 1.161072>  <1.057587, -1.922886, 1.161072>  <1.922886, -1.057587, 1.161072>  <1.922886, 0.000000, 1.161072>
    <0.000000, -2.347238, 4.235698>  <1.290981, -2.347238, 4.235698>  <2.347238, -1.290981, 4.235698>  <2.347238, 0.000000, 4.235698>
    <0.000000, -0.000089, 8.243831>  <0.000049, -0.000089, 8.243831>  <0.000089, -0.000049, 8.243831>  <0.000089, 0.000000, 8.243831>  }
}
#declare StrFoot1_3 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <1.874829, 0.000000, -0.009776>  <1.874829, 1.031156, -0.009776>  <1.031156, 1.874829, -0.009776>  <0.000000, 1.874829, -0.009776>
    <1.922886, 0.000000, 1.161072>  <1.922886, 1.057587, 1.161072>  <1.057587, 1.922886, 1.161072>  <0.000000, 1.922886, 1.161072>
    <2.347238, 0.000000, 4.235698>  <2.347238, 1.290981, 4.235698>  <1.290981, 2.347238, 4.235698>  <0.000000, 2.347238, 4.235698>
    <0.000089, 0.000000, 8.243831>  <0.000089, 0.000049, 8.243831>  <0.000049, 0.000089, 8.243831>  <0.000000, 0.000089, 8.243831>  }
}
#declare StrFoot1_4 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.000000, 1.874829, -0.009776>  <-1.031156, 1.874829, -0.009776>  <-1.874829, 1.031156, -0.009776>  <-1.874829, 0.000000, -0.009776>
    <0.000000, 1.922886, 1.161072>  <-1.057587, 1.922886, 1.161072>  <-1.922886, 1.057587, 1.161072>  <-1.922886, 0.000000, 1.161072>
    <0.000000, 2.347238, 4.235698>  <-1.290981, 2.347238, 4.235698>  <-2.347238, 1.290981, 4.235698>  <-2.347238, 0.000000, 4.235698>
    <0.000000, 0.000089, 8.243831>  <-0.000049, 0.000089, 8.243831>  <-0.000089, 0.000049, 8.243831>  <-0.000089, 0.000000, 8.243831>  }
}
#declare StrFoot1 = union { 
  object { StrFoot1_1 }
  object { StrFoot1_2 }
  object { StrFoot1_3 }
  object { StrFoot1_4 }
  translate <-8.800000, 0.000000, 1.930000>
}

#declare Connector1_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-1.927892, 0.000000, 8.240513>  <-1.927892, -0.183673, 8.240513>  <0.009495, -0.183673, -0.007407>  <0.009495, 0.000000, -0.007407>
    <-0.525319, 0.000000, 11.032006>  <-0.525319, -0.183673, 11.032006>  <1.776264, -0.183673, 2.966184>  <1.776264, 0.000000, 2.966184>
    <1.423548, 0.000000, 13.914549>  <1.423548, -0.183673, 13.914549>  <3.269886, -0.183673, 5.029286>  <3.269886, 0.000000, 5.029286>
    <4.867848, 0.000000, 17.123711>  <4.867848, -0.183673, 17.123711>  <4.926797, -0.183673, 6.529624>  <4.926797, 0.000000, 6.529624>  }
}
#declare Connector1_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.009495, 0.000000, -0.007407>  <0.009495, 0.183673, -0.007407>  <-1.927892, 0.183673, 8.240513>  <-1.927892, 0.000000, 8.240513>
    <1.776264, 0.000000, 2.966184>  <1.776264, 0.183673, 2.966184>  <-0.525319, 0.183673, 11.032006>  <-0.525319, 0.000000, 11.032006>
    <3.269886, 0.000000, 5.029286>  <3.269886, 0.183673, 5.029286>  <1.423548, 0.183673, 13.914549>  <1.423548, 0.000000, 13.914549>
    <4.926797, 0.000000, 6.529624>  <4.926797, 0.183673, 6.529624>  <4.867848, 0.183673, 17.123711>  <4.867848, 0.000000, 17.123711>  }
}
#declare Connector1 = union { 
  object { Connector1_1 }
  object { Connector1_2 }
  translate <-6.870000, 0.000000, 1.930000>
}

#declare Foot2 = union {
  object { Damper1 }
  object { StrFoot1 }
  object { Connector1 }
  bounded_by { Bound3 }
  rotate <0.000000, 0.000000, -120.000000>
}
#declare Bound4 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <4.605636, 2.143104, 9.738227>
  translate <-6.337468, 0.000000, 9.526856>
}

#declare Damper2 = object { 
  sphere {<0,0,0>,1}
  scale <1.930000, 1.930000, 1.930000>
  translate <-8.800000, 0.000000, 1.930000>
}

#declare StrFoot2_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-1.874829, 0.000000, -0.009776>  <-1.874829, -1.031156, -0.009776>  <-1.031156, -1.874829, -0.009776>  <0.000000, -1.874829, -0.009776>
    <-1.922886, 0.000000, 1.161072>  <-1.922886, -1.057587, 1.161072>  <-1.057587, -1.922886, 1.161072>  <0.000000, -1.922886, 1.161072>
    <-2.347238, 0.000000, 4.235698>  <-2.347238, -1.290981, 4.235698>  <-1.290981, -2.347238, 4.235698>  <0.000000, -2.347238, 4.235698>
    <-0.000089, 0.000000, 8.243831>  <-0.000089, -0.000049, 8.243831>  <-0.000049, -0.000089, 8.243831>  <0.000000, -0.000089, 8.243831>  }
}
#declare StrFoot2_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.000000, -1.874829, -0.009776>  <1.031156, -1.874829, -0.009776>  <1.874829, -1.031156, -0.009776>  <1.874829, 0.000000, -0.009776>
    <0.000000, -1.922886, 1.161072>  <1.057587, -1.922886, 1.161072>  <1.922886, -1.057587, 1.161072>  <1.922886, 0.000000, 1.161072>
    <0.000000, -2.347238, 4.235698>  <1.290981, -2.347238, 4.235698>  <2.347238, -1.290981, 4.235698>  <2.347238, 0.000000, 4.235698>
    <0.000000, -0.000089, 8.243831>  <0.000049, -0.000089, 8.243831>  <0.000089, -0.000049, 8.243831>  <0.000089, 0.000000, 8.243831>  }
}
#declare StrFoot2_3 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <1.874829, 0.000000, -0.009776>  <1.874829, 1.031156, -0.009776>  <1.031156, 1.874829, -0.009776>  <0.000000, 1.874829, -0.009776>
    <1.922886, 0.000000, 1.161072>  <1.922886, 1.057587, 1.161072>  <1.057587, 1.922886, 1.161072>  <0.000000, 1.922886, 1.161072>
    <2.347238, 0.000000, 4.235698>  <2.347238, 1.290981, 4.235698>  <1.290981, 2.347238, 4.235698>  <0.000000, 2.347238, 4.235698>
    <0.000089, 0.000000, 8.243831>  <0.000089, 0.000049, 8.243831>  <0.000049, 0.000089, 8.243831>  <0.000000, 0.000089, 8.243831>  }
}
#declare StrFoot2_4 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.000000, 1.874829, -0.009776>  <-1.031156, 1.874829, -0.009776>  <-1.874829, 1.031156, -0.009776>  <-1.874829, 0.000000, -0.009776>
    <0.000000, 1.922886, 1.161072>  <-1.057587, 1.922886, 1.161072>  <-1.922886, 1.057587, 1.161072>  <-1.922886, 0.000000, 1.161072>
    <0.000000, 2.347238, 4.235698>  <-1.290981, 2.347238, 4.235698>  <-2.347238, 1.290981, 4.235698>  <-2.347238, 0.000000, 4.235698>
    <0.000000, 0.000089, 8.243831>  <-0.000049, 0.000089, 8.243831>  <-0.000089, 0.000049, 8.243831>  <-0.000089, 0.000000, 8.243831>  }
}
#declare StrFoot2 = union { 
  object { StrFoot2_1 }
  object { StrFoot2_2 }
  object { StrFoot2_3 }
  object { StrFoot2_4 }
  translate <-8.800000, 0.000000, 1.930000>
}

#declare Connector2_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-1.927892, 0.000000, 8.240513>  <-1.927892, -0.183673, 8.240513>  <0.009495, -0.183673, -0.007407>  <0.009495, 0.000000, -0.007407>
    <-0.525319, 0.000000, 11.032006>  <-0.525319, -0.183673, 11.032006>  <1.776264, -0.183673, 2.966184>  <1.776264, 0.000000, 2.966184>
    <1.423548, 0.000000, 13.914549>  <1.423548, -0.183673, 13.914549>  <3.269886, -0.183673, 5.029286>  <3.269886, 0.000000, 5.029286>
    <4.867848, 0.000000, 17.123711>  <4.867848, -0.183673, 17.123711>  <4.926797, -0.183673, 6.529624>  <4.926797, 0.000000, 6.529624>  }
}
#declare Connector2_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.009495, 0.000000, -0.007407>  <0.009495, 0.183673, -0.007407>  <-1.927892, 0.183673, 8.240513>  <-1.927892, 0.000000, 8.240513>
    <1.776264, 0.000000, 2.966184>  <1.776264, 0.183673, 2.966184>  <-0.525319, 0.183673, 11.032006>  <-0.525319, 0.000000, 11.032006>
    <3.269886, 0.000000, 5.029286>  <3.269886, 0.183673, 5.029286>  <1.423548, 0.183673, 13.914549>  <1.423548, 0.000000, 13.914549>
    <4.926797, 0.000000, 6.529624>  <4.926797, 0.183673, 6.529624>  <4.867848, 0.183673, 17.123711>  <4.867848, 0.000000, 17.123711>  }
}
#declare Connector2 = union { 
  object { Connector2_1 }
  object { Connector2_2 }
  translate <-6.870000, 0.000000, 1.930000>
}

#declare Foot3 = union {
  object { Damper2 }
  object { StrFoot2 }
  object { Connector2 }
  bounded_by { Bound4 }
  rotate <0.000000, 0.000000, -240.000000>
}
union {   // Rocket
  object { Foot1 }
  object { Fuselage }
  object { Foot2 }
  object { Foot3 }
  texture {
    RocketRed
  }
  translate <0.000000, 0.000000, 12.000000>
}
object {   // Ground
  height_field {
    tga "moonscpe.tga" 
    water_level 0.000000
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Brown_Agate
  }
  scale <75.000000, 75.000000, 20.000000>
}

#declare Bound00003 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.040000, 1.040000, 1.040000>
  translate <0.000000, 0.000000, 0.000000>
}

#declare EarthPlane = plane {
  z,0
}

#declare EarthSphere = object { 
  sphere {<0,0,0>,1}
}

intersection {
  object { EarthPlane }
  object { EarthSphere }
  texture {
    EarthTexture
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  bounded_by { Bound00003 }
  no_shadow
  scale <30.000000, 30.000000, 30.000000>
  rotate <90.000000, 0.000000, 0.000000>
  translate <120.232001, 351.331561, 89.769484>
}

