//Cube.inc
//Peter McArdle

//I am going to have to use a few naming conventions for my cube.
//The six faces are the T, F, P, L, R, and B.
//They are colored: T-Red F-Blue P-White R-Yellow L-Green and B-Orange.
//Each face has edge and corner pieces plus a center piece.

//"Cube" is the complete cube and "Cube1" is the cube with pieces missing

//---------------------------------Textures-----------------------------------//
#declare Piece_Tex =
texture {  
  pigment { color Gray15 }
  finish { ambient .3 phong 0.8 phong_size 25 }
}

#declare Red_Stick_Tex =
texture {
  pigment { color Red }
  finish { reflection 0.1 }
}

#declare Blue_Stick_Tex =
texture {
  pigment { color Blue }
  finish { reflection 0.1 }
}

#declare Yellow_Stick_Tex =
texture {
  pigment { color Yellow }
  finish { reflection 0.1 }
}

#declare Green_Stick_Tex =
texture {
  pigment { color Green }
  finish { reflection 0.1 }
}

#declare White_Stick_Tex =
texture {
  pigment { color White }
  finish { reflection 0.1 }
}

#declare Orange_Stick_Tex =
texture {
  pigment { color Orange }
  finish { reflection 0.1 }
}
//-------------------------------End Textures---------------------------------//

//-----------------------------------Piece------------------------------------//
#declare Piece =
object { 
  union {
    sphere { <0.03125, 0.03125, - 0.03125> 0.03125 }
    sphere { <0.03125, 0.03125, -0.718175> 0.03125 }
    sphere { <0.03125, 0.718175, -0.03125> 0.03125 }
    sphere { <0.03125, 0.718175, -0.718175> 0.03125 }
    sphere { <0.718175, 0.03125, -0.03125> 0.03125 }
    sphere { <0.718175, 0.03125, -0.718175> 0.03125 } 
    sphere { <0.718175, 0.718175, -0.03125> 0.03125 }
    sphere { <0.718175, 0.718125, -0.718125> 0.03125 }
    cylinder { <0.03125, 0.03125, - 0.03125> <0.03125, 0.03125, -0.718175> 0.03125 }
    cylinder { <0.03125, 0.03125, - 0.03125> <0.03125, 0.718175, -0.03125> 0.03125 } 
    cylinder { <0.03125, 0.03125, - 0.03125> <0.718175, 0.03125, -0.03125> 0.03125 }
    cylinder { <0.03125, 0.03125, -0.718175> <0.718175, 0.03125, -0.718175> 0.03125 }
    cylinder { <0.03125, 0.03125, -0.718175> <0.03125, 0.718175, -0.718175> 0.03125 } 
    cylinder { <0.03125, 0.718175, -0.03125> <0.03125, 0.718175, -0.718175> 0.03125 } 
    cylinder { <0.03125, 0.718175, -0.03125> <0.718175, 0.718175, -0.03125> 0.03125 }  
    cylinder { <0.03125, 0.718175, -0.718175> <0.718175, 0.718125, -0.718125> 0.03125 }  
    cylinder { <0.718175, 0.03125, -0.03125> <0.718175, 0.03125, -0.718175> 0.03125 }
    cylinder { <0.718175, 0.03125, -0.03125> <0.718175, 0.718175, -0.03125> 0.03125 }     
    cylinder { <0.718175, 0.03125, -0.718175> <0.718175, 0.718125, -0.718125> 0.03125 }  
    cylinder { <0.718175, 0.718175, -0.03125> <0.718175, 0.718125, -0.718125> 0.03125 }   
    box { <0.0, 0.03125, -0.718125> <0.0625, 0.718125, -0.03125> }
    box { <0.03125, 0.0, -0.718125> <0.718125, 0.0625, -0.03125> } //comment out for individual pieces on the ground
    box { <0.03125, 0.6875, -0.718125> <0.718125, 0.75, -0.03125> }
    box { <0.6875, 0.03125, -0.718125> <0.75, 0.718125, -0.03125> }  
    box { <0.03125, 0.03125, -0.0625> <0.718125, 0.718125, 0.0> }
    box { <0.03125, 0.03125, -0.75> <0.718125, 0.718125, -0.6875> }
    bounded_by { box { <-0.01, -0.01, -0.76> <0.76, 0.76, 0.01> } }
  } 
  texture { Piece_Tex }
}

//----------------------------------Sticker-----------------------------------//
#declare Sticker =
union {
  cylinder { <0.09375, 0.09375, -0.001> <0.09375, 0.09375, 0.001> 0.03125 }
  cylinder { <0.09375, 0.65625, -0.001> <0.09375, 0.65625, 0.001> 0.03125 } 
  cylinder { <0.65625, 0.09375, -0.001> <0.65625, 0.09375, 0.001> 0.03125 } 
  cylinder { <0.65625, 0.65625, -0.001> <0.65625, 0.65625, 0.001> 0.03125 } 
  box { <0.0625, 0.09375, -0.001> <0.6875, 0.65625, 0.001> }
  box { <0.09375, 0.0625, -0.001> <0.65625, 0.6875, 0.001> }
  bounded_by { box { <0.0, 0.0, -0.01> <0.75, 0.75, 0.01> } }
}

//-----------------------------------Cube-------------------------------------//
//create the cube with base at y*0 and centered on orgin
//the 6 centers
#declare T_C_Sect = 
union {
  object { Piece translate <-0.375, 1.5, 0.375> }
  object { 
    Sticker 
    rotate 90*x 
    translate <-0.375, 2.25, -0.375> 
    texture { Red_Stick_Tex }
  }
}

#declare B_C_Sect =
union {
  object { Piece translate <-0.375, 0.0, 0.375> }
  object { 
    Sticker
    rotate 90*x
    translate <-0.375, 0.0, -0.375>
    texture { Orange_Stick_Tex }
  }
}

#declare F_C_Sect = 
union {
  object { Piece translate <-0.375, 0.75, -0.375> }
  object { 
    Sticker 
    translate <-0.375, 0.75, -1.125> 
    texture { Blue_Stick_Tex }
  }
}

#declare P_C_Sect = 
union {
  object { Piece translate <-0.375 0.75, 1.125> }
  object { 
    Sticker 
    translate <-0.375, 0.75, 1.125> 
    texture { White_Stick_Tex }
  }
}

#declare L_C_Sect =
union {
  object { Piece translate <-1.125, 0.75, 0.375> }
  object {
    Sticker
    rotate 90*y
    translate <-1.125, 0.75, 0.375> 
    texture { Green_Stick_Tex }
  }
}

#declare R_C_Sect =
union {
  object { Piece translate <0.375, 0.75, 0.375> }
  object {
    Sticker
    rotate 90*y
    translate <1.125, 0.75, 0.375> 
    texture { Yellow_Stick_Tex }
  }
}


//the 12 edges
#declare T_F_E_Sect =
union {
  object { Piece translate <-0.375, 1.5, -0.375> }
  object { Sticker translate <-0.375, 1.5, -1.125> texture { Blue_Stick_Tex } }
  object { Sticker rotate 90*x translate <-0.375, 2.25, -1.125> texture { Red_Stick_Tex } }
}

#declare L_F_E_Sect =
union {
  object { Piece translate <-1.125, 0.75, -0.375> }
  object { Sticker translate <-1.125, 0.75, -1.125> texture { Blue_Stick_Tex } }
  object { Sticker rotate 90*y translate <-1.125, 0.75, -0.375> texture { Green_Stick_Tex } }
}

#declare R_F_E_Sect =
union {
  object { Piece translate <0.375, 0.75, -0.375> }
  object { Sticker translate <0.375, 0.75, -1.125> texture { Blue_Stick_Tex } }
  object { Sticker rotate 90*y translate <1.125, 0.75, -0.375> texture { Yellow_Stick_Tex } }
}

#declare B_F_E_Sect =
union {
  object { Piece translate <-0.375, 0.0, -0.375> }
  object { Sticker translate <-0.375, 0.0, -1.125> texture { Blue_Stick_Tex } }
  object { Sticker rotate 90*x translate <-0.375, 0.0, -1.125> texture { Orange_Stick_Tex } }
 }

#declare T_R_E_Sect =
union {
  object { Piece translate <0.375, 1.5, 0.375> }
  object { Sticker rotate 90*x translate <0.375, 2.25, -0.375> texture { Red_Stick_Tex } }
  object { Sticker rotate 90*y translate <1.125, 1.5, 0.375> texture { Yellow_Stick_Tex } }
}

#declare T_L_E_Sect =
union {
  object { Piece translate <-1.125, 1.5, 0.375> }
  object { Sticker rotate 90*x translate <-1.125, 2.25, -0.375> texture { Red_Stick_Tex } }
  object { Sticker rotate 90*y translate <-1.125, 1.5, 0.375> texture { Green_Stick_Tex } }
}

#declare B_R_E_Sect =
union {
  object { Piece translate <0.375, 0.0, 0.375> }
  object { Sticker rotate 90*x translate <0.375, 0.0, -0.375> texture { Orange_Stick_Tex } }
  object { Sticker rotate 90*y translate <1.125, 0.0, 0.375> texture { Yellow_Stick_Tex } }
}

#declare B_L_E_Sect =
union {
  object { Piece translate <-1.125, 0.0, 0.375> }
  object { Sticker rotate 90*x translate <-1.125, 0.0, -0.375> texture { Orange_Stick_Tex } }
  object { Sticker rotate 90*y translate <-1.125 0.0, 0.375> texture { Green_Stick_Tex } }
}

#declare T_P_E_Sect =
union {
  object { Piece translate <-0.375, 1.5, 1.125> } 
  object { Sticker rotate 90*x translate <-0.375, 2.25, 0.375> texture { Red_Stick_Tex } }
  object { Sticker translate <-0.375, 1.5, 1.125> texture { White_Stick_Tex } }
}

#declare B_P_E_Sect =
union {
  object { Piece translate <-0.375, 0.0, 1.125> }
  object { Sticker rotate 90*x translate <-0.375, 0.0, 0.375> texture { Orange_Stick_Tex } }
  object { Sticker translate <-0.375, 0.0, 1.125> texture { White_Stick_Tex } }
}

#declare R_P_E_Sect =
union {
  object { Piece translate <0.375, 0.75, 1.125> }
  object { Sticker rotate 90*y translate <1.125, 0.75, 1.125> texture { Yellow_Stick_Tex } }
  object { Sticker translate <0.375, 0.75, 1.125> texture { White_Stick_Tex } }
}

#declare L_P_E_Sect =
union {
  object { Piece translate <-1.125, 0.75, 1.125> }
  object { Sticker rotate 90*y translate <-1.125, 0.75, 1.125> texture { Green_Stick_Tex } }
  object { Sticker translate <-1.125, 0.75, 1.125> texture { White_Stick_Tex } }
}


//the 8 corners
#declare T_F_R_C_Sect =
union {
  object { Piece translate <0.375, 1.5, -0.375> }
  object { Sticker translate <0.375, 1.5, -1.125> texture { Blue_Stick_Tex } } 
  object { Sticker rotate 90*x translate <0.375, 2.25, -1.125> texture { Red_Stick_Tex } }
  object { Sticker rotate 90*y translate <1.125, 1.5, -0.375> texture { Yellow_Stick_Tex } }
}

#declare T_F_L_C_Sect =
union {
  object { Piece translate <-1.125, 1.5, -0.375> }
  object { Sticker translate <-1.125, 1.5, -1.125> texture { Blue_Stick_Tex } }
  object { Sticker rotate 90*x translate <-1.125, 2.25, -1.125> texture { Red_Stick_Tex } }
  object { Sticker rotate 90*y translate <-1.125, 1.5, -0.375> texture { Green_Stick_Tex } }
}

#declare B_F_R_C_Sect =
union {
  object { Piece translate <0.375, 0.0, -0.375> }
  object { Sticker translate <0.375, 0.0, -1.125> texture { Blue_Stick_Tex } }
  object { Sticker rotate 90*x translate <0.375, 0.0, -1.125> texture { Orange_Stick_Tex } }
  object { Sticker rotate 90*y translate <1.125, 0.0, -0.375> texture { Yellow_Stick_Tex } }
}

#declare B_F_L_C_Sect =
union {
  object { Piece translate <-1.125, 0.0, -0.375> }
  object { Sticker translate <-1.125, 0.0, -1.125> texture { Blue_Stick_Tex } }
  object { Sticker rotate 90*x translate <-1.125, 0.0, -1.125> texture { Orange_Stick_Tex } }
  object { Sticker rotate 90*y translate <-1.125, 0.0, -0.375> texture { Green_Stick_Tex } }
}

#declare T_P_R_C_Sect =
union {
  object { Piece translate <0.375, 1.5, 1.125> }
  object { Sticker translate <0.375, 1.5, 1.125> texture { White_Stick_Tex } }
  object { Sticker rotate 90*x translate <0.375, 2.25, 0.375> texture { Red_Stick_Tex } }
  object { Sticker rotate 90*y translate <1.125, 1.5, 1.125> texture { Yellow_Stick_Tex } }
}

#declare T_P_L_C_Sect =
union {
  object { Piece translate <-1.125, 1.5, 1.125> }
  object { Sticker translate <-1.125, 1.5, 1.125> texture { White_Stick_Tex } }
  object { Sticker rotate 90*x translate <-1.125, 2.25, 0.375> texture { Red_Stick_Tex } }
  object { Sticker rotate 90*y translate <-1.125, 1.5, 1.125> texture { Green_Stick_Tex } }
}

#declare B_P_R_C_Sect =
union {
  object { Piece translate <0.375, 0.0, 1.125> }
  object { Sticker translate <0.375, 0.0, 1.125> texture { White_Stick_Tex } }
  object { Sticker rotate 90*x translate <0.375, 0.0, 0.375> texture { Orange_Stick_Tex } }
  object { Sticker rotate 90*y translate <1.125, 0.0, 1.125> texture { Yellow_Stick_Tex } }
}
 
#declare B_P_L_C_Sect =
union {
  object { Piece translate <-1.125, 0.0, 1.125> }
  object { Sticker translate <-1.125, 0.0, 1.125> texture { White_Stick_Tex } }
  object { Sticker rotate 90*x translate <-1.125, 0.0, 0.375> texture { Orange_Stick_Tex } }
  object { Sticker rotate 90*y translate <-1.125, 0.0, 1.125> texture { Green_Stick_Tex } }
}

//Put them together way 1
#declare Center_Pieces =
union {
  object { T_C_Sect }
  object { B_C_Sect }
  object { F_C_Sect }
  object { P_C_Sect }
  object { L_C_Sect }
  object { R_C_Sect }
  //clipped_by { sphere { <0.0, 1.125, 0.0> 0.71875 inverse } } 
}  

#declare Edge_Pieces = 
union {
  object { T_F_E_Sect }
  object { L_F_E_Sect } 
  object { R_F_E_Sect } 
  object { B_F_E_Sect } 
  object { T_R_E_Sect } 
  object { T_L_E_Sect } 
  object { B_R_E_Sect }
  object { B_L_E_Sect }
  object { T_P_E_Sect }
  object { B_P_E_Sect }
  object { R_P_E_Sect }
  object { L_P_E_Sect }
}

#declare Corner_Pieces =
union {
  object { T_F_R_C_Sect }
  object { T_F_L_C_Sect }
  object { B_F_R_C_Sect }
  object { B_F_L_C_Sect }
  object { T_P_R_C_Sect }
  object { T_P_L_C_Sect }
  object { B_P_R_C_Sect }
  object { B_P_L_C_Sect }
}

#declare Cube =
union {
  object { Center_Pieces }
  object { Edge_Pieces }
  object { Corner_Pieces }
}

//Put them together so that top can be rotated and have cubes missing
//commented out cubes are missing
#declare Top_Cubes =  
union {
  object { T_C_Sect }
  object { T_P_E_Sect }   
  object { T_F_E_Sect }
  //object { T_R_E_Sect } 
  object { T_L_E_Sect } 
  //object { T_F_R_C_Sect }
  object { T_F_L_C_Sect }
  object { T_P_R_C_Sect }
  object { T_P_L_C_Sect }
  clipped_by { sphere { <0.0, 1.125, 0.0> 0.75 inverse } }
}

#declare Other_Cubes =
union {
  object { B_F_R_C_Sect }
  object { B_F_L_C_Sect }
  object { B_P_R_C_Sect }
  object { B_P_L_C_Sect }
  object { B_C_Sect }
  object { F_C_Sect }
  object { P_C_Sect }
  object { L_C_Sect }
  object { R_C_Sect }
  object { L_F_E_Sect } 
  object { R_F_E_Sect } 
  object { B_F_E_Sect } 
  object { B_R_E_Sect }
  object { B_L_E_Sect }
  object { B_P_E_Sect }
  object { R_P_E_Sect }
  object { L_P_E_Sect }
  clipped_by { sphere { <0.0, 1.125, 0.0> 0.75 inverse } }
}

#declare Cube1 = 
union {
  object { 
    Top_Cubes 
    bounded_by { 
      box { <-1.126, 1.49, -1.126> <1.126, 2.26, 1.126> } 
    }
    rotate 45*y 
  }
  object { 
    Other_Cubes 
    bounded_by {
      box { <-1.126, -0.01, -1.126> <1.126, 1.51, 1.126> }
    }
  }
}
