#include "colors.inc"
#include "textures.inc"
#include "paddle3.inc"
#include "paddle4.inc"

#declare China_Label=
   box { <0,0,0> , <1,1,.001>
      pigment { image_map { gif "china.gif" interpolate 2 once filter 255 1.0} }
      finish {ambient .4}
      scale <1.3,.8,1> translate <-.65,-.7,0> rotate x*-90 translate z*-.01 }

//  DECLARATIONS FOR PADDLE
#declare White_Wood = 
 pigment 
  {wood
   turbulence <.05,.2,.05>
   color_map 
    {[0.0, 0.8  color red 0.7 green 0.55 blue 0.35
                color red 0.65 green 0.5 blue 0.45]
     [0.8, 1.01 color red 0.65 green 0.42 blue 0.25
                color red 0.65 green 0.55 blue 0.41]
    }
  }

#declare White_Wood2 = 
 pigment 
  {wood
   turbulence <.05,.2,.05>
   color_map 
    {[0.0, 0.8  color red 0.8 green 0.6 blue 0.4
                color red 0.8 green 0.7 blue 0.5]
     [0.8, 1.01 color red 0.8 green 0.5 blue 0.3
                color red 0.8 green 0.7 blue 0.5]
    }
  }

#declare Paddle_Wood1=
   texture {White_Wood2 rotate x*-90 finish { ambient .2} scale .05 }

#declare Paddle_Wood2=
   texture {White_Wood rotate x*-90 finish { ambient .2} scale .05 }

#declare Handle_Shape=
   difference { 
      cylinder { <0,0,0> , <0,10,0> , 1 texture {Paddle_Wood2} scale <1.44,1,.8>}
      plane { -z, 0 texture {Paddle_Wood2} }
      plane {  z, 0 rotate x*20 translate <0,10,-.2> texture {Paddle_Wood2} }
      }

#declare Handle_Shape2=
   difference { 
      cylinder { <0,-.01,0> , <0,10.01,0> , 1 texture {DMFWood5} scale <1.441,1,.81>}
      plane { -z, 0 texture {DMFWood5} }
      plane {  z, 0 rotate x*20 translate <0,10.01,-.2> texture {DMFWood5} }
      }

#declare Handle_Half=   
union{
   object{ Handle_Shape}
   intersection{
      object {Handle_Shape2 texture {DMFWood5} }
      box { <.5,-5,-5> , <.6,15,5> texture {DMFWood5} }
      }
   intersection{
      object {Handle_Shape2 texture {DMFWood5} }
      box { <-.5,-5,-5> , <-.6,15,5> texture {DMFWood5} }
      }
   }

#declare PP_Paddle=
union{
   //Main Wooden Paddle Shape
   object {Paddle scale <1,1,.3> 
        texture {Paddle_Wood1} 
        texture { pigment {image_map {gif "sticker.gif" interpolate 2 once}
                     scale <9.1,.7,1> rotate y*-90 rotate x*-90 
                     translate <0,10.001,.7>}}
        }
   object {Paddle scale <1,1,.1> translate z*.3
        texture {Paddle_Wood2} 
        texture { pigment {image_map {gif "sticker.gif" interpolate 2 once}
                     scale <9.1,.7,1> rotate y*-90 rotate x*-90 
                     translate <0,10.001,.7>}}
        }
   object {Paddle scale <1,1,.3> translate z*.4
        texture {Paddle_Wood1} 
        texture { pigment {image_map {gif "sticker.gif" interpolate 2 once}
                     scale <9.1,.7,1> rotate y*-90 rotate x*-90 
                     translate <0,10.001,.7>}}
        }
   // Foam Layers
   object {Foam scale <1,1,.15> translate z*-.15   
        pigment {color rgb <1,.75,0>} finish {ambient .1} }
   object {Foam scale <1,1,.2> translate z*-.35
        pigment {color rgb <.81,0,0>} finish {ambient .2}
        normal {bump_map { gif "harvard.gif" interpolate 2 bump_size 3 once}
                scale <11,3,1> translate <-5.5,10,-.35>} }
   object {Foam scale <1,1,.15> translate z*.7
        pigment {color rgb <1,.75,0>} finish {ambient .1} }
   object {Foam scale <1,1,.2> translate z*.85
        pigment {color Black} finish {ambient .2} }
   // Rounded Handle
   object {Handle_Half}
   object {Handle_Half rotate y*180 translate z*.7}
   object {China_Label}
   }  //end of PP union

#declare PP_Ball=
   sphere { <0,0,0> , 1.8 
      texture {pigment {color Gray90} finish {ambient .2 crand .03} }
      texture {pigment {image_map {gif "spalding.gif" interpolate 2 
                        map_type 1 once} } }
      rotate y*-85 rotate x*25 }

#declare PP_Table=
union{
   box { <0,-1.5,0> , <152,0,135> pigment {color SeaGreen} finish {ambient .2}}
   difference { box { <0,0,0> , <152,.001,135> pigment {color Gray80} }
                box { <2,-1,2> , <150,1,133> pigment {color Gray80} }
              }
   }

// NOW PUT THE OBJECTS INTO A SCENE!
object {PP_Paddle rotate x*90 translate y*1.5 rotate y*10 translate <5,0,-1> }
object {PP_Table}
object {PP_Ball translate <12,1.8,5> }

// This was my original camera
// camera { location <-8,10,-8> direction <0,0,2.5> look_at <7,0,7> }
camera { location <-5,10,-5> direction <0,0,1.5> look_at <7,1,7> }

light_source { <0,25,0> color White}
light_source { <0,10,-5> color White}
