//
// buggy.inc - Baby buggy
//
// By Robert S. Creager - December 1994
// robc@bigb.stortek.com
//
// For the December 'Games' Internet ray tracing contest.
//
// This image took 16 hours - 00 minutes on a Sparc 5 with +a0.1 at 800x600.
// This image took 40 hours - ?? minutes on a 486-66  with +a0.1 at 800x600.
//
// The anti-aliasing needed to be that low to give me an acceptable look on
//   the buggy top.
//
// There are four include files - buggy.inc, tstone.inc, tile.inc & chars.inc
// There are eight height field gif maps - plasma1-8.gif  I used 8 so that
//   each tile would look different
//
// The base scale is in inches.
//
// This is my first pov scene, so comments/suggestions are more than welcome
//
// Permissions: Distribute as you wish.  Not for commercial use without
//              prior permission from the artist.
// 
// If you use any thing out of here, please mention me, and I would also
//   appreciate a copy of the final image/and/or the pov files :-)

  
#declare Buggy_Texture = texture { pigment { color SteelBlue quick_color Blue } finish { ambient .1 } }
#declare Rim_Texture = texture { Silver_Metal pigment { color Silver } }
#declare Axle_Width = 28
#declare Spring_Clip = 16
#declare Spring_Radius = 18
#declare Spring_Height = (Spring_Radius-Spring_Clip)*2
#declare Spring_Width = Axle_Width - 6
#declare Buggy_Length = 14
#declare Buggy_Axle_Spacing = Buggy_Length/2+4
#declare Buggy_Curve_Radius = 15
#declare Buggy_Width = Spring_Width/2-1
#declare Buggy_Handle_Radius = 8
#declare Rot_Inc = 360/(Buggy_Curve_Radius*2*Pi/2)

#declare Rim_Side = cone
   { y, 5.5, y*4, 6.5 open
   texture
      { Rim_Texture
      pigment { quick_color Yellow }
      }
   }

#declare Spoke = cylinder
   {
   -x*5.5, x*5.5, .25 open
   texture
      { Rim_Texture
      pigment { quick_color Green }
      }
   }

#declare Rim = difference
   {
   torus
      { 6, 1 scale <1, 2, 1>
      texture
         { Dull
         pigment { color Black quick_color Red }
         }
      }
   cylinder
      { -y y 5.5 open
      texture
         { Rim_Texture
         pigment { quick_color Blue }
         }
      }
   object { Rim_Side }
   object
      { Rim_Side
      rotate x*180
      }
   }

#declare Hub = sphere
   { <0, 0, 0>, 1
   texture
      { Rim_Texture
      pigment { quick_color Magenta }
      }
   }

#declare Wheel = union
   { object { Rim }
   object { Spoke }
   object { Spoke rotate y*45 }
   object { Spoke rotate y*90 }
   object { Spoke rotate -y*45 }
   object { Hub }
   }

#declare Axle_Rod = cylinder
  {
  -x*Axle_Width/2, x*Axle_Width/2, .4
  texture
     { Rim_Texture
     pigment { quick_color Brown }
     }
  }

#declare Single_Spring = intersection
   {
   cylinder
      { -x*.35, x*.35, Spring_Radius
      texture
         { Rim_Texture
         pigment { quick_color Coral }
         }
      }
   cylinder
      { -x*.4, x*.4, Spring_Radius-.2 open inverse
      texture
         { Rim_Texture
         pigment { quick_color Violet }
         }
      }
   clipped_by { plane { -y, Spring_Clip inverse } }
   }

#declare Axle_Spring = union
   {
   object { Single_Spring translate y*Spring_Clip }
   object { Single_Spring rotate z*180 translate -y*Spring_Clip }
   }

#declare Axle = union
   {
   object { Wheel rotate z*90 translate -x*Axle_Width/2 }
   object { Wheel rotate z*90 translate  x*Axle_Width/2 }
   object { Axle_Rod }
   object { Axle_Spring translate < (Spring_Width/2), Spring_Height/2+.4, 0> }
   object { Axle_Spring translate < -(Spring_Width/2), Spring_Height/2+.4, 0> }
   }

#declare Buggy_Curve = merge
   {
   cylinder { <-Buggy_Width, 0, 0>, <Buggy_Width, 0, 0>, Buggy_Curve_Radius
              texture { Buggy_Texture } }
   torus { Buggy_Curve_Radius .25 rotate z*90 translate x*Buggy_Width texture { Gold_Metal } }
   torus { Buggy_Curve_Radius .25 rotate z*90 translate -x*Buggy_Width texture { Gold_Metal } }
   clipped_by { box { <-(Buggy_Width+1), -(Buggy_Curve_Radius+1), -(Buggy_Curve_Radius+1)>
                      <Buggy_Width+1, 0, 0> }
              }
   bounded_by { clipped_by }
   }

#declare Buggy_Rod = cylinder
  { -x*(Spring_Width+.35)/2, x*(Spring_Width+.35)/2, .4
  texture
     { Rim_Texture
     pigment { quick_color NeonPink }
     }
  }

#declare Buggy_Top_Fold = union
   {
   triangle { <Buggy_Width, 0, 0>
              <Buggy_Width-1, Buggy_Curve_Radius-1, 0>
              <Buggy_Width, Buggy_Curve_Radius, 1> }
   triangle { <Buggy_Width, 0, 0>
              <Buggy_Width-1, Buggy_Curve_Radius-1, 0>
              <Buggy_Width, Buggy_Curve_Radius, -1> }

   triangle { <Buggy_Width-1, Buggy_Curve_Radius-1, 0>
              <Buggy_Width, Buggy_Curve_Radius, 1>
              <-(Buggy_Width-1), 14, 0> }
   triangle { <Buggy_Width-1, Buggy_Curve_Radius-1, 0>
              <Buggy_Width, Buggy_Curve_Radius, -1>
              <-(Buggy_Width-1), Buggy_Curve_Radius-1, 0> }

   triangle { <-Buggy_Width, 0, 0>
              <-(Buggy_Width-1), Buggy_Curve_Radius-1, 0>
              <-Buggy_Width, Buggy_Curve_Radius, 1> }
   triangle { <-Buggy_Width, 0, 0>
              <-(Buggy_Width-1), Buggy_Curve_Radius-1, 0>
              <-Buggy_Width, Buggy_Curve_Radius, -1> }

   triangle { <-(Buggy_Width-1), Buggy_Curve_Radius-1, 0>
              <-Buggy_Width, Buggy_Curve_Radius, 1>
              <Buggy_Width, Buggy_Curve_Radius, 1> }
   triangle { <-(Buggy_Width-1), Buggy_Curve_Radius-1, 0>
              <-Buggy_Width, Buggy_Curve_Radius, -1>
              <Buggy_Width, Buggy_Curve_Radius, -1> }

   texture { Buggy_Texture }
   }

#declare Buggy_Top_Frame = union
   {
   cylinder { <-Buggy_Width, Buggy_Curve_Radius, 0>
              <Buggy_Width, Buggy_Curve_Radius, 0> .25
              texture { Gold_Metal } }
   cylinder { <-Buggy_Width, 0, 0>
              <-Buggy_Width, Buggy_Curve_Radius, 0> .25
              texture { Gold_Metal } }
   cylinder { <Buggy_Width, 0, 0>
              <Buggy_Width, Buggy_Curve_Radius, 0> .25
              texture { Gold_Metal } }

   sphere { <Buggy_Width, Buggy_Curve_Radius, 0> .5
              texture { Gold_Metal } }
   sphere { <-Buggy_Width, Buggy_Curve_Radius, 0> .5
              texture { Gold_Metal } }
   sphere { <Buggy_Width, 0, 0> .5
              texture { Gold_Metal } }
   sphere { <-Buggy_Width, 0, 0> .5
              texture { Gold_Metal } }
   }

#declare Buggy_Top = union
   {
   object { Buggy_Top_Fold rotate -x*(90-1*Rot_Inc/2) }
   object { Buggy_Top_Fold rotate -x*(90-3*Rot_Inc/2) }
   object { Buggy_Top_Fold rotate -x*(90-5*Rot_Inc/2) }
   object { Buggy_Top_Fold rotate -x*(90-7*Rot_Inc/2) }
   object { Buggy_Top_Fold rotate -x*(90-9*Rot_Inc/2) }
   object { Buggy_Top_Fold rotate -x*(90-11*Rot_Inc/2) }
   object { Buggy_Top_Fold rotate -x*(90-13*Rot_Inc/2) }
   object { Buggy_Top_Fold rotate -x*(90-15*Rot_Inc/2) }
   object { Buggy_Top_Fold rotate -x*(90-17*Rot_Inc/2) }
   object { Buggy_Top_Fold rotate -x*(90-19*Rot_Inc/2) }
   object { Buggy_Top_Fold rotate -x*(90-21*Rot_Inc/2) }
   object { Buggy_Top_Frame rotate -x*(90-22*Rot_Inc/2) }

   }

#declare Buggy_Bottom = merge
   {
   box
      { <-Buggy_Width, -Buggy_Curve_Radius, -Buggy_Length/(2-Small_Number)>
        <Buggy_Width, 1, Buggy_Length/(2-Small_Number)>
      texture { Buggy_Texture }
      clipped_by { plane { y, 0 } }
      }

   cylinder { <-Buggy_Width, -Buggy_Curve_Radius, -Buggy_Length/2>
              <-Buggy_Width, -Buggy_Curve_Radius, Buggy_Length/2> .25
              texture { Gold_Metal } }
   cylinder { <Buggy_Width, -Buggy_Curve_Radius, -Buggy_Length/2>
              <Buggy_Width, -Buggy_Curve_Radius, Buggy_Length/2> .25
              texture { Gold_Metal } }

   cylinder { <-Buggy_Width, 0, -(Buggy_Length/2+Buggy_Curve_Radius)>
              <-Buggy_Width, 0, Buggy_Length/2+Buggy_Curve_Radius> .25
              texture { Gold_Metal } }
   cylinder { <Buggy_Width, 0, -(Buggy_Length/2+Buggy_Curve_Radius)>
              <Buggy_Width, 0, Buggy_Length/2+Buggy_Curve_Radius> .25
              texture { Gold_Metal } }
   sphere { <Buggy_Width, 0, -(Buggy_Length/2+Buggy_Curve_Radius)> .5
              texture { Gold_Metal } }
   sphere { <-Buggy_Width, 0, -(Buggy_Length/2+Buggy_Curve_Radius)> .5
              texture { Gold_Metal } }

   cylinder { <-Buggy_Width, 0, -(Buggy_Length/2+Buggy_Curve_Radius)>
              <Buggy_Width, 0, -(Buggy_Length/2+Buggy_Curve_Radius)> .25
              texture { Gold_Metal } }
   cylinder { <-Buggy_Width, 0, Buggy_Length/2+Buggy_Curve_Radius>
              <Buggy_Width, 0, Buggy_Length/2+Buggy_Curve_Radius> .25
              texture { Gold_Metal } }
   sphere { <Buggy_Width, 0, Buggy_Length/2+Buggy_Curve_Radius> .5
              texture { Gold_Metal } }
   sphere { <-Buggy_Width, 0, Buggy_Length/2+Buggy_Curve_Radius> .5
              texture { Gold_Metal } }

   object { Buggy_Curve translate -z*Buggy_Length/2 }
   object { Buggy_Curve rotate -x*90 translate z*Buggy_Length/2 }
   object { Buggy_Rod translate <0, -(Buggy_Curve_Radius), Buggy_Axle_Spacing> }
   object { Buggy_Rod translate <0, -(Buggy_Curve_Radius), -Buggy_Axle_Spacing> }
   }

#declare Buggy_Handle = union
   {
   union
      {
      torus { Buggy_Handle_Radius .25 rotate z*90 translate x*Buggy_Width
               texture { Gold_Metal } }
      torus { Buggy_Handle_Radius .25 rotate z*90 translate -x*Buggy_Width
               texture { Gold_Metal } }
      clipped_by { box { <-(Buggy_Width+1), -(Buggy_Handle_Radius+1), -(Buggy_Handle_Radius)>
                         <Buggy_Width+1, 0, 0> } }
      }
   cylinder { <-Buggy_Width, 0, -Buggy_Handle_Radius>
              <Buggy_Width, 0, -Buggy_Handle_Radius> .25
              texture { Gold_Metal } }
   sphere { <Buggy_Width, 0, -Buggy_Handle_Radius> .5
              texture { Gold_Metal } }
   sphere { <-Buggy_Width, 0, -Buggy_Handle_Radius> .5
              texture { Gold_Metal } }
   }

#declare Buggy = union
   {
   object { Buggy_Handle rotate x*90 translate <0, Buggy_Curve_Radius+Spring_Height+.8, Buggy_Length/2+Buggy_Curve_Radius+Buggy_Handle_Radius> }
   object { Buggy_Bottom translate y*(Buggy_Curve_Radius+Spring_Height+.8) }
   object { Buggy_Top translate <0, Buggy_Curve_Radius+Spring_Height+.8, -Buggy_Length/2> }
   object { Axle translate z*Buggy_Axle_Spacing }
   object { Axle translate -z*Buggy_Axle_Spacing }
   }
