//
// chars.inc - Character set used for lettering the tombstone
//
// By Robert S. Creager - December 1994
// robc@bigb.stortek.com
//
// For the December 'Games' Internet ray tracing contest.
//
// This image took 16 hours - 00 minutes on a Sparc 5 with +a0.1 at 800x600.
// This image took 40 hours - ?? minutes on a 486-66  with +a0.1 at 800x600.
//
// The anti-aliasing needed to be that low to give me an acceptable look on
//   the buggy top.
//
// There are four include files - buggy.inc, tstone.inc, tile.inc & chars.inc
// There are eight height field gif maps - plasma1-8.gif  I used 8 so that
//   each tile would look different
//
// The base scale is in inches.
//
// This is my first pov scene, so comments/suggestions are more than welcome
//
// Permissions: Distribute as you wish.  Not for commercial use without
//              prior permission from the artist.
// 
// If you use any thing out of here, please mention me, and I would also
//   appreciate a copy of the final image/and/or the pov files :-)

#declare Small_Number = .0001
#declare Letter_Space = 0.05
#declare Width = 2.5
#declare Height = 4
#declare Size = .25

#declare WS = ((Width-Letter_Space)/2 - Size)
#declare WSH = ((Width-Letter_Space)/3 - Size)
#declare HS = ((Height-Letter_Space)/2 - Size)
#declare HSH = ((Height-Letter_Space)/3 - Size)
#declare Curve_Radius = HS/2
#declare Bound_Box = box { <-(Width+Small_Number), -(Height+Small_Number), -(Size+Small_Number)>
                           < (Width+Small_Number),  (Height+Small_Number),  (Size+Small_Number)> }

#declare Sphere            = sphere   { <0, 0, 0> Size-Small_Number }
#declare Horizontal_Full   = cylinder { -x*WS x*WS Size open }
#declare Horizontal_Half   = cylinder { -x*WSH x*WSH Size open }
#declare Vertical_Full     = cylinder { -y*HS y*HS Size open }
#declare Slant_Full_Full   = cylinder { <-WS, -HS, 0> <WS, HS, 0> Size open }
#declare Slant_Full_Half   = cylinder { <-WS, -HS, 0> <0,  HS, 0> Size open }
#declare Slant_Half_Half   = cylinder { <-WS, -HS, 0> <0,  0,  0> Size open }
#declare Slant_Half_Qtr    = cylinder { <-2*WS/3, -2*HS/3, 0> <0,  0,  0> Size open }
#declare Curve_LVConnector = cylinder { -y*(HS-Curve_Radius+Small_Number) y*(HS+Small_Number) Size open }
#declare Curve_MVConnector = cylinder { -y*(HS-Curve_Radius+Small_Number)  y*(HS-Curve_Radius+Small_Number) Size open }
#declare Curve_SVConnector = cylinder { -y*(Curve_Radius+Small_Number)/2  y*(Curve_Radius+Small_Number)/2 Size open }
#declare Curve_HConnector  = cylinder { -x*(WS-Curve_Radius+Small_Number) x*(WS-Curve_Radius+Small_Number) Size open }
#declare Curve_Quarter     =
difference
   {
   torus { Curve_Radius Size rotate x*90 }
   box { <-(Curve_Radius+Size), -(Curve_Radius+Size), -(Size+Small_Number)>
         <0, 0, (Size+Small_Number)> inverse }
   translate <-(WS-Curve_Radius), -(HS-Curve_Radius), 0>
   }

#declare Char_A =
merge
   {
   object { Slant_Full_Half }
   object { Slant_Full_Half rotate y*180}
   object { Sphere translate y*HS }
   object { Sphere translate <-WS, -HS, 0> }
   object { Sphere translate < WS, -HS, 0> }
   object { Horizontal_Half translate -y*HSH/2 }
   bounded_by { Bound_Box }
   }

#declare Char_C =
merge
   {
   object { Curve_Quarter }
   object { Curve_Quarter rotate y*180 }
   object { Curve_Quarter rotate x*180 }
   object { Curve_Quarter rotate z*180 }
   object { Curve_HConnector translate -y*HS }
   object { Curve_HConnector translate  y*HS }
   object { Curve_MVConnector translate -x*WS }
   object { Sphere translate <WS, -(HS-Curve_Radius), 0> }
   object { Sphere translate <WS,   HS-Curve_Radius, 0> }
   bounded_by { Bound_Box }
   }

#declare Char_E =
merge
   {
   object { Vertical_Full translate -x*WS }
   object { Horizontal_Full translate  y*HS }
   object { Horizontal_Half translate -x*WSH }
   object { Horizontal_Full translate -y*HS }
   object { Sphere translate <-WS, -HS, 0> }
   object { Sphere translate <-WS,  HS, 0> }
   object { Sphere translate <WS, -HS, 0> }
   object { Sphere translate <WS,  HS, 0> }
   object { Sphere }
   bounded_by { Bound_Box }
   }

#declare Char_F =
merge
   {
   object { Vertical_Full translate -x*WS }
   object { Sphere translate <-WS, -HS, 0> }
   object { Sphere translate <-WS,  HS, 0> }
   object { Horizontal_Full translate  y*HS }
   object { Sphere translate <WS,  HS, 0> }
   object { Horizontal_Half translate -x*WSH }
   object { Sphere }
   bounded_by { Bound_Box }
   }

#declare Char_G =
merge
   {
   object { Curve_Quarter }
   object { Curve_Quarter rotate y*180 }
   object { Curve_Quarter rotate x*180 }
   object { Curve_Quarter rotate z*180 }
   object { Curve_HConnector translate -y*HS }
   object { Curve_HConnector translate  y*HS }
   object { Curve_MVConnector translate -x*WS }
   cylinder { <WS, -HS, 0> <WS, -Size, 0> Size open }
   object { Horizontal_Half translate <WSH, -Size, 0> }
   object { Sphere translate <WS, -Size, 0> }
   object { Sphere translate <WS-WSH*2, -Size, 0> }
   object { Sphere translate <WS, -HS, 0> }
   object { Sphere translate <WS,  HS-Curve_Radius, 0> }
   bounded_by { Bound_Box }
   }

#declare Char_H =
merge
   {
   object { Vertical_Full translate -x*WS }
   object { Sphere translate <-WS, -HS, 0> }
   object { Sphere translate <-WS,  HS, 0> }
   object { Vertical_Full translate  x*WS }
   object { Sphere translate <WS, -HS, 0> }
   object { Sphere translate <WS,  HS, 0> }
   object { Horizontal_Full }
   bounded_by { Bound_Box }
   }

#declare Char_I =
merge
   {
   object { Horizontal_Full translate y*HS }
   object { Sphere translate <-WS, HS, 0> }
   object { Sphere translate < WS, HS, 0> }
   object { Vertical_Full }
   object { Horizontal_Full translate -y*HS }
   object { Sphere translate <-WS, -HS, 0> }
   object { Sphere translate < WS, -HS, 0> }
   bounded_by { Bound_Box }
   }

#declare Char_L =
merge
   {
   object { Vertical_Full translate -x*WS }
   object { Sphere translate <-WS, -HS, 0> }
   object { Sphere translate <-WS,  HS, 0> }
   object { Horizontal_Full translate -y*HS }
   object { Sphere translate <WS, -HS, 0> }
   bounded_by { Bound_Box }
   }

#declare Char_M =
merge
   {
   object { Vertical_Full translate -x*WS }
   object { Sphere translate <-WS, -HS, 0> }
   object { Sphere translate <-WS,  HS, 0> }
   object { Vertical_Full translate  x*WS }
   object { Sphere translate <WS, -HS, 0> }
   object { Sphere translate <WS,  HS, 0> }
   object { Slant_Half_Half rotate x*180 }
   object { Slant_Half_Half rotate z*180 }
   object { Sphere }
   bounded_by { Bound_Box }
   }

#declare Char_N =
merge
   {
   object { Vertical_Full translate -x*WS }
   object { Sphere translate <-WS, -HS, 0> }
   object { Sphere translate <-WS,  HS, 0> }
   object { Vertical_Full translate  x*WS }
   object { Sphere translate <WS, -HS, 0> }
   object { Sphere translate <WS,  HS, 0> }
   object { Slant_Full_Full rotate y*180 }
   bounded_by { Bound_Box }
   }

#declare Char_O =
merge
   {
   object { Curve_Quarter }
   object { Curve_Quarter rotate y*180 }
   object { Curve_Quarter rotate x*180 }
   object { Curve_Quarter rotate z*180 }
   object { Curve_HConnector translate -y*HS }
   object { Curve_HConnector translate  y*HS }
   object { Curve_MVConnector translate -x*WS }
   object { Curve_MVConnector translate  x*WS }
   bounded_by { Bound_Box }
   }

#declare Char_P =
merge
   {
   object { Curve_Quarter translate y*(HS-Curve_Radius)*2 }
   object { Curve_Quarter rotate x*180 }
   object { Curve_Quarter rotate z*180 }
   object { Curve_Quarter rotate y*180 translate y*(HS-Curve_Radius)*2 }
   object { Curve_HConnector }
   object { Curve_HConnector translate  y*HS }
   object { Vertical_Full translate -x*WS }
   object { Sphere translate <-WS, -HS, 0> }
   object { Sphere translate <-WS,  HS, 0> }
   }

#declare Char_R =
merge
   {
   object { Curve_Quarter rotate x*180 }
   object { Curve_Quarter rotate z*180 }
   object { Curve_Quarter rotate y*180 translate y*(HS-Curve_Radius)*2 }
   object { Curve_Quarter rotate z*180 translate -y*(HS-Curve_Radius)*2 }
   object { Curve_HConnector translate  y*HS }
   object { Curve_SVConnector translate <WS, -(HS-Curve_Radius/2), 0> }
   object { Horizontal_Half translate -x*(WS-WSH) }
   object { Vertical_Full translate -x*WS }
   object { Sphere translate <-WS, -HS, 0> }
   object { Sphere translate < WS, -HS, 0> }
   object { Sphere translate <-WS,  HS, 0> }
   }

#declare Char_S =
merge
   {
   object { Curve_Quarter }
   object { Curve_Quarter rotate y*180 }
   object { Curve_Quarter rotate z*180 translate -y*(HS-Curve_Radius)*2 }
   object { Curve_Quarter translate y*(HS-Curve_Radius)*2 }
   object { Curve_HConnector translate  y*HS }
   object { Curve_HConnector }
   object { Curve_HConnector translate -y*HS }
   object { Curve_Quarter rotate x*180 }
   object { Curve_Quarter rotate z*180 }
   object { Sphere translate <-WS, -(HS-Curve_Radius), 0> }
   object { Sphere translate < WS,   HS-Curve_Radius, 0> }
   bounded_by { Bound_Box }
   }

#declare Char_T =
merge
   {
   object { Horizontal_Full translate y*HS }
   object { Sphere translate <-WS, HS, 0> }
   object { Sphere translate < WS, HS, 0> }
   object { Vertical_Full }
   object { Sphere translate <0, -HS, 0> }
   bounded_by { Bound_Box }
   }

#declare Char_U =
merge
   {
   object { Curve_Quarter }
   object { Curve_Quarter rotate y*180 }
   object { Curve_HConnector translate -y*HS }
   object { Curve_LVConnector translate -x*WS }
   object { Curve_LVConnector translate  x*WS }
   object { Sphere translate <-WS, HS, 0> }
   object { Sphere translate < WS, HS, 0> }
   bounded_by { Bound_Box }
   }

#declare Char_V =
merge
   {
   object { Slant_Full_Half rotate x*180 }
   object { Slant_Full_Half rotate z*180 }
   object { Sphere translate -y*HS }
   object { Sphere translate <-WS, HS, 0> }
   object { Sphere translate < WS, HS, 0> }
   bounded_by { Bound_Box }
   }

#declare Char_Colon =
union
   {
   object { Sphere translate  y*HSH }
   object { Sphere translate -y*HSH }
   bounded_by { Bound_Box }
   }

#declare Char_1 =
union
   {
   object { Vertical_Full }
   object { Horizontal_Full translate -y*HS }
   object { Slant_Half_Qtr translate y*HS }
   object { Sphere translate <-WS, -HS, 0> }
   object { Sphere translate < WS, -HS, 0> }
   object { Sphere translate < 0, HS, 0> }
   object { Sphere translate < -2*WS/3, HS/3, 0> }
   bounded_by { Bound_Box }
   }

#declare Char_4 =
union
   {
   object { Vertical_Full translate x*WS/2 }
   cylinder { <-WS, 0, 0> <WS/2, HS, 0> Size }
   object { Horizontal_Full }
   object { Sphere translate -x*WS }
   object { Sphere translate  x*WS }
   object { Sphere translate <WS/2, -HS, 0> }
   object { Sphere translate <WS/2,  HS, 0> }
   bounded_by { Bound_Box }
   }

#declare Char_9 =
union
   {
   object { Curve_Quarter translate y*(HS-Curve_Radius)*2 }
   object { Curve_Quarter rotate x*180 }
   object { Curve_Quarter rotate z*180 }
   object { Curve_Quarter rotate y*180 translate y*(HS-Curve_Radius)*2 }
   object { Curve_Quarter rotate y*180 }
   object { Curve_Quarter }
   object { Curve_HConnector }
   object { Curve_HConnector translate -y*HS }
   object { Curve_HConnector translate  y*HS }
   object { Curve_MVConnector translate <WS, 0, 0> }
   object { Sphere translate <-WS, -(HS-Curve_Radius), 0> }
   bounded_by { Bound_Box }
   }
