//
// chars.inc - Character set used for lettering the tombstone
//
// By Robert S. Creager - December 1994
// robc@bigb.stortek.com
//
// For the December 'Games' Internet ray tracing contest.
//
// This image took 16 hours - 00 minutes on a Sparc 5 with +a0.1 at 800x600.
// This image took 40 hours - ?? minutes on a 486-66  with +a0.1 at 800x600.
//
// The anti-aliasing needed to be that low to give me an acceptable look on
//   the buggy top.
//
// There are four include files - buggy.inc, tstone.inc, tile.inc & chars.inc
// There are eight height field gif maps - plasma1-8.gif  I used 8 so that
//   each tile would look different
//
// The base scale is in inches.
//
// This is my first pov scene, so comments/suggestions are more than welcome
//
// Permissions: Distribute as you wish.  Not for commercial use without
//              prior permission from the artist.
// 
// If you use any thing out of here, please mention me, and I would also
//   appreciate a copy of the final image/and/or the pov files :-)

#include "chars.inc"
#include "colors.inc"
#include "textures.inc"

#declare Small_Number = .00000001
#declare Pi = 3.14159265359


// Light blue and black marble with a thin red vein
// Try changing LBlue and Vein below to modify the marble.
#declare LBlue = color red 0.2 green 0.0 blue 0.8
#declare Blood_Marble =
 pigment
  {marble
   turbulence 2.3
   color_map
    {[0.0, 0.8   color Gray20 color LBlue]
     [0.8, 0.9   color LBlue  color Vein]
     [0.9, 1.001 color Vein   color Gray20]
    }
   }
#declare Rob_Marble =
 pigment
  {marble
   turbulence 2.3
   color_map
    {[0.0, 0.8   color LBlue  color Vein]
     [0.8, 0.9   color Vein   color Black]
     [0.9, 1.001 color Black  color LBlue]
    }
   }

#include "buggy.inc"
#include "tile.inc"
#include "tstone.inc"

camera
   {
   location <0, 30, -130>
   look_at <0, 10, 0>
   }

light_source
   {
   <-10, 40, -100>
   color White
   }

light_source
   {
   <-40, 50, -90>
   color White
   spotlight
   point_at <-50, 7, -10>
   radius 9
   falloff 18
   tightness 20
   }

#declare Sphere_Size = 20

union
   {
   sphere { <0, 0, 0> Sphere_Size
            pigment { Apocalypse }
            finish { ambient .4 }
            scale <5000, 5000, 5000>/Sphere_Size
            translate <0, -4000, 0> }
   sphere { <0, 0, 0> 4000 pigment { color Green } translate <0, -4000, 0> }
   object { Buggy rotate <0, 130, 0> translate <-50, 7, -20> }
   object { Hop_Scotch rotate <-20, 30, 0> translate <-35, 0, -80> }
   object { Tomb_Stone rotate <-1, 25.3, 0> translate <40, 40, -40> }
   }


