//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 3 lights, 11 textures and 97 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE (c) 1991-1994 SoftTronics by Lutz Kretzschmar + Markus Lutz
//

//  Date : 12/23/1995    (23.12.1995)
//

//
//  This is the standard include file for POV.
//

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"

// If you don't like or want the green floor plane and the blue sky, then
// delete the following line. (To permanently delete it, remove it from
// MRYDEFLT.INC in your Moray directory.
// #include "enviro.inc"

camera {  //  Camera Camera01
  location  <-134.580, 0.000, 40.000>
  direction <0.0,     0.0,  2.4764>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, 0.000, 23.000>
}

// *******  L I G H T S *******
#declare Light001 = light_source {
  <0.000, 0.000, 33.000>
  color rgb <1.000, 1.000, 1.000>
}

#declare Light002 = light_source {
  <0.000, -0.063, 1.172>
  color rgb <0.682, 0.682, 0.682>
}

light_source {   // Spotlight SpotL001
  <-7.600, 15.300, 36.500>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-7.217, 14.637, 35.857>
    falloff   21.9  // outer radius (in deg)
      radius    17.6  // inner radius
}


//
// ********  T E X T U R E S  *******
//

#include "LAMP_AL2.INC"

// ********  O B J E C T S *******
#declare Cube001 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    PinkAlabaster
  }
  scale <8.000000, 12.000000, 0.300000>
  translate <0.000000, 0.000000, 20.000000>
}

#declare Cube002 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Rosewood
  }
  scale <6.000000, 9.000000, 1.700000>
  translate <0.000000, 0.000000, 18.000000>
}

#declare Cube003 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Rosewood
  }
  scale <2.000000, 2.000000, 2.000000>
  translate <5.500000, 9.000000, 17.750000>
}

#declare BoundLeg1 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.000000, 1.000000, 0.400000>
  translate <-0.017604, -0.005552, 0.610602>
}

#declare Cone5 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  bounded_by { BoundLeg1 }
  scale <1.000000, 1.000000, 20.000000>
  rotate <2.000000, -2.000000, 0.000000>
  translate <7.000000, 10.500000, -4.000000>
}

#declare Sphere24 = object { 
  sphere {<0,0,0>,1}
  scale <0.500000, 0.500000, 0.500000>
  translate <7.000000, 10.500000, 0.500000>
}

#declare Leg_1 = union {
  object { Cube003 }
  object { Cone5 }
  object { Sphere24 }
}

#declare Cube4 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Rosewood
  }
  scale <2.000000, 2.000000, 2.000000>
  translate <5.500000, 9.000000, 17.750000>
}

#declare BoundLeg2 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.000000, 1.000000, 0.400000>
  translate <-0.017604, -0.005552, 0.610602>
}

#declare Cone6 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  bounded_by { BoundLeg2 }
  scale <1.000000, 1.000000, 20.000000>
  rotate <2.000000, 2.000000, 0.000000>
  translate <4.000000, 10.500000, -4.000000>
}

#declare Sphere25 = object { 
  sphere {<0,0,0>,1}
  scale <0.500000, 0.500000, 0.500000>
  translate <4.000000, 10.500000, 0.500000>
}

#declare Leg_2 = union {
  object { Cube4 }
  object { Cone6 }
  object { Sphere25 }
  translate <-11.000000, 0.000000, 0.000000>
}

#declare Cube5 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Rosewood
  }
  scale <2.000000, 2.000000, 2.000000>
  translate <5.500000, 9.000000, 17.750000>
}

#declare BoundLeg3 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.000000, 1.000000, 0.400000>
  translate <-0.017604, -0.005552, 0.610602>
}

#declare Cone7 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  bounded_by { BoundLeg3 }
  scale <1.000000, 1.000000, 20.000000>
  rotate <-2.000000, -2.000000, 0.000000>
  translate <7.000000, 7.500000, -4.000000>
}

#declare Sphere26 = object { 
  sphere {<0,0,0>,1}
  scale <0.500000, 0.500000, 0.500000>
  translate <7.000000, 7.500000, 0.500000>
}

#declare Leg_3 = union {
  object { Cube5 }
  object { Cone7 }
  object { Sphere26 }
  translate <0.000000, -18.000000, 0.000000>
}

#declare Cube6 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Rosewood
  }
  scale <2.000000, 2.000000, 2.000000>
  translate <5.500000, 9.000000, 17.750000>
}

#declare BoundLeg4 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.000000, 1.000000, 0.400000>
  translate <-0.017604, -0.005552, 0.610602>
}

#declare Cone8 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  bounded_by { BoundLeg4 }
  scale <1.000000, 1.000000, 20.000000>
  rotate <-2.000000, 2.000000, 0.000000>
  translate <4.000000, 7.500000, -4.000000>
}

#declare Sphere27 = object { 
  sphere {<0,0,0>,1}
  scale <0.500000, 0.500000, 0.500000>
  translate <4.000000, 7.500000, 0.500000>
}

#declare Leg_4 = union {
  object { Cube6 }
  object { Cone8 }
  object { Sphere27 }
  translate <-11.000000, -18.000000, 0.000000>
}

#declare Bound002 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <16.100000, 0.100000, 8.600000>
  translate <12.500000, 0.000000, -4.500000>
}

#declare Sphere001 = object { 
  sphere {<0,0,0>,1}
  scale <3.500000, 1.000000, 0.500000>
}

#declare Sphere002 = object { 
  sphere {<0,0,0>,1}
  scale <1.200000, 1.000000, 1.500000>
  translate <0.000000, 0.000000, 1.100000>
}

#declare Sphere003 = object { 
  sphere {<0,0,0>,1}
  scale <1.200000, 1.000000, 1.500000>
  translate <0.000000, 0.000000, -1.100000>
}

#declare Sphere004 = object { 
  sphere {<0,0,0>,1}
  scale <0.600000, 1.000000, 0.600000>
  translate <2.200000, 0.000000, 0.400000>
}

#declare Sphere005 = object { 
  sphere {<0,0,0>,1}
  scale <0.600000, 1.000000, 0.600000>
  translate <2.200000, 0.000000, -0.400000>
}

#declare Cone001 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <4.000000, 1.000000, 2.000000>
  rotate <0.000000, 90.000000, 0.000000>
  translate <3.300000, 0.000000, 0.000000>
}

#declare Fleur1 = union {
  object { Sphere001 }
  object { Sphere002 }
  object { Sphere003 }
  object { Sphere004 }
  object { Sphere005 }
  object { Cone001 }
}

#declare Sphere006 = object { 
  sphere {<0,0,0>,1}
  scale <0.800000, 1.000000, 1.000000>
  translate <0.450000, 0.000000, 1.100000>
}

#declare Sphere007 = object { 
  sphere {<0,0,0>,1}
  scale <0.800000, 1.000000, 1.000000>
  translate <0.450000, 0.000000, -1.100000>
}

#declare Sphere008 = object { 
  sphere {<0,0,0>,1}
  scale <0.300000, 1.000000, 0.300000>
  translate <1.800000, 0.000000, 0.500000>
}

#declare Sphere009 = object { 
  sphere {<0,0,0>,1}
  scale <0.300000, 1.000000, 0.300000>
  translate <1.800000, 0.000000, -0.500000>
}

#declare Finial1 = difference {
  object { Fleur1 }
  object { Sphere006 }
  object { Sphere007 }
  object { Sphere008 }
  object { Sphere009 }
}

#declare Sphere2 = object { 
  sphere {<0,0,0>,1}
  scale <3.500000, 1.000000, 0.500000>
}

#declare Sphere3 = object { 
  sphere {<0,0,0>,1}
  scale <1.200000, 1.000000, 1.500000>
  translate <0.000000, 0.000000, 1.100000>
}

#declare Sphere4 = object { 
  sphere {<0,0,0>,1}
  scale <1.200000, 1.000000, 1.500000>
  translate <0.000000, 0.000000, -1.100000>
}

#declare Sphere5 = object { 
  sphere {<0,0,0>,1}
  scale <0.600000, 1.000000, 0.600000>
  translate <2.200000, 0.000000, 0.400000>
}

#declare Sphere6 = object { 
  sphere {<0,0,0>,1}
  scale <0.600000, 1.000000, 0.600000>
  translate <2.200000, 0.000000, -0.400000>
}

#declare Cone2 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <4.000000, 1.000000, 2.000000>
  rotate <0.000000, 90.000000, 0.000000>
  translate <3.300000, 0.000000, 0.000000>
}

#declare Fleur2 = union {
  object { Sphere2 }
  object { Sphere3 }
  object { Sphere4 }
  object { Sphere5 }
  object { Sphere6 }
  object { Cone2 }
}

#declare Sphere7 = object { 
  sphere {<0,0,0>,1}
  scale <0.800000, 1.000000, 1.000000>
  translate <0.450000, 0.000000, 1.100000>
}

#declare Sphere8 = object { 
  sphere {<0,0,0>,1}
  scale <0.800000, 1.000000, 1.000000>
  translate <0.450000, 0.000000, -1.100000>
}

#declare Sphere9 = object { 
  sphere {<0,0,0>,1}
  scale <0.300000, 1.000000, 0.300000>
  translate <1.800000, 0.000000, 0.500000>
}

#declare Sphere10 = object { 
  sphere {<0,0,0>,1}
  scale <0.300000, 1.000000, 0.300000>
  translate <1.800000, 0.000000, -0.500000>
}

#declare Finial2 = difference {
  object { Fleur2 }
  object { Sphere7 }
  object { Sphere8 }
  object { Sphere9 }
  object { Sphere10 }
  rotate <0.000000, 0.000000, -180.000000>
  translate <25.000000, 0.000000, 0.000000>
}

#declare Sphere11 = object { 
  sphere {<0,0,0>,1}
  scale <3.500000, 1.000000, 0.500000>
}

#declare Sphere12 = object { 
  sphere {<0,0,0>,1}
  scale <1.200000, 1.000000, 1.500000>
  translate <0.000000, 0.000000, 1.100000>
}

#declare Sphere13 = object { 
  sphere {<0,0,0>,1}
  scale <1.200000, 1.000000, 1.500000>
  translate <0.000000, 0.000000, -1.100000>
}

#declare Sphere14 = object { 
  sphere {<0,0,0>,1}
  scale <0.600000, 1.000000, 0.600000>
  translate <2.200000, 0.000000, 0.400000>
}

#declare Sphere15 = object { 
  sphere {<0,0,0>,1}
  scale <0.600000, 1.000000, 0.600000>
  translate <2.200000, 0.000000, -0.400000>
}

#declare Cone3 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <7.200000, 1.000000, 2.000000>
  rotate <0.000000, 90.000000, 0.000000>
  translate <3.300000, 0.000000, 0.000000>
}

#declare Fleur3 = union {
  object { Sphere11 }
  object { Sphere12 }
  object { Sphere13 }
  object { Sphere14 }
  object { Sphere15 }
  object { Cone3 }
}

#declare Sphere16 = object { 
  sphere {<0,0,0>,1}
  scale <0.800000, 1.000000, 1.000000>
  translate <0.450000, 0.000000, 1.100000>
}

#declare Sphere17 = object { 
  sphere {<0,0,0>,1}
  scale <0.800000, 1.000000, 1.000000>
  translate <0.450000, 0.000000, -1.100000>
}

#declare Sphere18 = object { 
  sphere {<0,0,0>,1}
  scale <0.300000, 1.000000, 0.300000>
  translate <1.800000, 0.000000, 0.500000>
}

#declare Sphere19 = object { 
  sphere {<0,0,0>,1}
  scale <0.300000, 1.000000, 0.300000>
  translate <1.800000, 0.000000, -0.500000>
}

#declare Finial3 = difference {
  object { Fleur3 }
  object { Sphere16 }
  object { Sphere17 }
  object { Sphere18 }
  object { Sphere19 }
  rotate <0.000000, -90.000000, 0.000000>
  translate <12.500000, 0.000000, -9.500000>
}

#declare Plate = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <7.200000, 1.000000, 4.000000>
  translate <12.500000, 0.000000, 0.000000>
}

#declare DrawerPull = union {
  object { Finial1 }
  object { Finial2 }
  object { Finial3 }
  object { Plate }
  texture {
    Brass_Texture
  }
  bounded_by { Bound002 }
  scale <0.200000, 1.000000, 0.100000>
  rotate <0.000000, 0.000000, -90.000000>
  translate <-6.000000, 2.500000, 18.100000>
}

union {
  object { Cube001 }
  object { Cube002 }
  object { Leg_1 }
  object { Leg_2 }
  object { Leg_3 }
  object { Leg_4 }
  object { DrawerPull }
  texture {
    Rosewood
  }
}

#declare Cylndr3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  scale <0.200000, 0.200000, 30.000000>
}

#declare Cone4 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Rusty_Iron
  }
  scale <2.000000, 2.000000, 0.500000>
  rotate <0.000000, -180.000000, 0.000000>
  translate <0.000000, 0.000000, 1.000000>
}

#declare Cylndr4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Rusty_Iron
  }
  scale <3.000000, 3.000000, 0.500000>
}

#declare Lamp2Cord_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.094165, -0.139440, 0.419023>  <-0.092449, -0.139445, 0.217714>  <-0.095775, 0.261804, 0.217675>  <-0.097491, 0.261809, 0.418984>
    <1.923384, -0.145484, 1.955651>  <1.925080, -0.145744, 1.754342>  <1.981446, 0.251540, 1.754304>  <1.979750, 0.251800, 1.955613>
    <3.919020, 1.436178, 1.972571>  <3.920735, 1.436166, 1.771262>  <3.919146, 1.837425, 1.771224>  <3.917403, 1.844473, 1.972532>
    <5.919105, 1.471993, 1.194649>  <5.927321, 1.437002, 0.993340>  <5.925732, 1.838262, 0.993301>  <5.915731, 1.876755, 1.194610>  }
}
#declare Lamp2Cord_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.097491, 0.261809, 0.418984>  <-0.099206, 0.261814, 0.620293>  <-0.095880, -0.139435, 0.620331>  <-0.094165, -0.139440, 0.419023>
    <1.979750, 0.251800, 1.955613>  <1.978054, 0.252060, 2.156921>  <1.921688, -0.145224, 2.156960>  <1.923384, -0.145484, 1.955651>
    <3.917403, 1.844473, 1.972532>  <3.915659, 1.851521, 2.173840>  <3.917304, 1.436191, 2.173880>  <3.919020, 1.436178, 1.972571>
    <5.915731, 1.876755, 1.194610>  <5.922273, 1.845322, 1.395918>  <5.923890, 1.437027, 1.395957>  <5.919105, 1.471993, 1.194649>  }
}
#declare Lamp2Cord_3 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <5.919105, 1.471993, 1.194649>  <5.927321, 1.437002, 0.993340>  <5.925732, 1.838262, 0.993301>  <5.915731, 1.876755, 1.194610>
    <7.932191, 1.437852, 0.416726>  <7.933906, 1.437839, 0.215417>  <7.932317, 1.839099, 0.215379>  <7.930602, 1.839111, 0.416687>
    <9.937056, 0.165349, 0.447963>  <9.938771, 0.165337, 0.246654>  <9.937182, 0.566596, 0.246616>  <9.935467, 0.566609, 0.447925>
    <11.929309, 0.234765, 1.252940>  <11.932096, 0.173308, 1.051631>  <11.930507, 0.574568, 1.051593>  <11.925949, 0.636010, 1.252901>  }
}
#declare Lamp2Cord_4 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <5.915731, 1.876755, 1.194610>  <5.922273, 1.845322, 1.395918>  <5.923890, 1.437027, 1.395957>  <5.919105, 1.471993, 1.194649>
    <7.930602, 1.839111, 0.416687>  <7.928886, 1.839124, 0.617996>  <7.930475, 1.437864, 0.618035>  <7.932191, 1.437852, 0.416726>
    <9.935467, 0.566609, 0.447925>  <9.933751, 0.566621, 0.649233>  <9.935340, 0.165362, 0.649272>  <9.937056, 0.165349, 0.447963>
    <11.925949, 0.636010, 1.252901>  <11.927075, 0.574593, 1.454210>  <11.928665, 0.173333, 1.454249>  <11.929309, 0.234765, 1.252940>  }
}
#declare Lamp2Cord_5 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <11.929309, 0.234765, 1.252940>  <11.932096, 0.173308, 1.051631>  <11.930507, 0.574568, 1.051593>  <11.925949, 0.636010, 1.252901>
    <13.923705, 0.181292, 2.057917>  <13.925420, 0.181280, 1.856608>  <13.923831, 0.582539, 1.856569>  <13.922116, 0.582552, 2.057878>
    <15.893985, 3.453719, 4.072620>  <15.895701, 3.453707, 3.871311>  <15.894112, 3.854966, 3.871273>  <15.892368, 3.862014, 4.072581>
    <17.893841, 3.475712, 4.089663>  <17.895557, 3.475700, 3.888354>  <17.893968, 3.876959, 3.888315>  <17.892252, 3.876971, 4.089624>  }
}
#declare Lamp2Cord_6 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <11.925949, 0.636010, 1.252901>  <11.927075, 0.574593, 1.454210>  <11.928665, 0.173333, 1.454249>  <11.929309, 0.234765, 1.252940>
    <13.922116, 0.582552, 2.057878>  <13.920400, 0.582564, 2.259187>  <13.921989, 0.181305, 2.259225>  <13.923705, 0.181292, 2.057917>
    <15.892368, 3.862014, 4.072581>  <15.890625, 3.869062, 4.273889>  <15.892270, 3.453732, 4.273929>  <15.893985, 3.453719, 4.072620>
    <17.892252, 3.876971, 4.089624>  <17.890536, 3.876984, 4.290933>  <17.892126, 3.475724, 4.290971>  <17.893841, 3.475712, 4.089663>  }
}
#declare Lamp2Cord = union { 
  object { Lamp2Cord_1 }
  object { Lamp2Cord_2 }
  object { Lamp2Cord_3 }
  object { Lamp2Cord_4 }
  object { Lamp2Cord_5 }
  object { Lamp2Cord_6 }
  texture {
    Blue_Agate
  }
  scale <2.700000, 1.000000, 1.000000>
  translate <3.000000, 0.000000, -0.200000>
}

#declare Lamp2Stand = union {
  object { Cylndr3 }
  object { Cone4 }
  object { Cylndr4 }
  object { Lamp2Cord }
  texture {
    Brass_Texture
  }
  rotate <0.000000, 0.000000, -42.000000>
}

#declare Sphere20 = object { 
  sphere {<0,0,0>,1}
}

#declare Cone004 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <1.000000, 1.000000, 2.500000>
  translate <0.000000, 0.000000, -2.500000>
}

#declare Cylndr008 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.450000, 0.450000, 1.000000>
  rotate <0.000000, -180.000000, 0.000000>
  translate <0.000000, 0.000000, -1.400000>
}

#declare Bulb = merge {
  object { Sphere20 }
  object { Cone004 }
  object { Cylndr008 }
  texture {
    Silver_Texture
  }
  no_shadow
  translate <0.000000, 0.000000, 32.600000>
}

#declare Cylndr009 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.500000, 0.500000, 1.000000>
  rotate <0.000000, -180.000000, 0.000000>
  translate <0.000000, 0.000000, -1.600000>
}

#declare Sphere21 = object { 
  sphere {<0,0,0>,1}
  scale <0.500000, 0.500000, 0.500000>
  translate <0.000000, 0.000000, -2.600000>
}

#declare Socket = union {
  object { Cylndr009 }
  object { Sphere21 }
  texture {
    Brass_Texture
  }
  translate <0.000000, 0.000000, 32.600000>
}

#declare L2Bound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  no_shadow
  scale <5.233333, 5.233333, 3.000000>
  translate <0.000000, 0.000000, 33.000000>
}

#declare Outer_Shade = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Jade
  }
  no_shadow
  scale <5.000000, 5.000000, 15.000000>
  rotate <-180.000000, 0.000000, 0.000000>
  translate <0.000000, 0.000000, 45.000000>
}

#declare Inner_Shade = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Jade
  }
  no_shadow
  scale <4.900000, 4.900000, 15.000000>
  rotate <-180.000000, 0.000000, 0.000000>
  translate <0.000000, 0.000000, 45.000000>
}

#declare Lamp2Shade = difference {
  object { Outer_Shade }
  object { Inner_Shade }
  bounded_by { L2Bound }
  no_shadow
}

union {   // Lamp_2
  object { Lamp2Stand }
  object { Light001 }
  object { Bulb }
  object { Socket }
  object { Lamp2Shade }
  translate <-15.000000, -15.000000, 0.000000>
}
#declare Lamp1Bound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <2.100000, 9.500000, 2.400000>
  translate <0.000000, 0.500000, 0.800000>
}

#declare Cone002 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <1.000000, 3.000000, 1.000000>
  rotate <-180.000000, 0.000000, 0.000000>
  translate <0.000000, 0.000000, -0.500000>
}

#declare Cone003 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <1.000000, 3.000000, 1.000000>
  rotate <0.000000, -180.000000, 0.000000>
  translate <0.000000, 0.000000, 1.900000>
}

#declare Sphere22 = object { 
  sphere {<0,0,0>,1}
  scale <0.300000, 0.300000, 0.600000>
  translate <0.000000, 0.000000, 2.500000>
}

#declare BzPtch001_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-1.794601, 0.243450, 0.182230>  <-1.794601, 0.499849, -1.555206>  <1.801928, 0.507177, -1.555191>  <1.801928, 0.250777, 0.182246>
    <-0.309909, -2.509845, 1.480131>  <-0.309909, -3.017731, 0.966726>  <0.302475, -3.017731, 0.966726>  <0.302475, -2.509845, 1.480131>
    <-0.514076, -3.510421, 2.252274>  <-0.505840, -3.734537, 1.448331>  <0.505840, -3.734537, 1.448331>  <0.505840, -3.510421, 2.252274>
    <-0.179008, -4.141807, 3.954679>  <-0.110677, -4.988121, 4.437722>  <0.088790, -4.988121, 4.437722>  <0.160513, -4.141176, 3.951066>  }
}
#declare BzPtch001_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <1.801928, 0.250777, 0.182246>  <1.801928, -0.005622, 1.919683>  <-1.794601, -0.012950, 1.919667>  <-1.794601, 0.243450, 0.182230>
    <0.302475, -2.509845, 1.480131>  <0.302475, -2.001959, 1.993536>  <-0.309909, -2.001959, 1.993536>  <-0.309909, -2.509845, 1.480131>
    <0.505840, -3.510421, 2.252274>  <0.505840, -3.286305, 3.056218>  <-0.522312, -3.286305, 3.056218>  <-0.514076, -3.510421, 2.252274>
    <0.160513, -4.141176, 3.951066>  <0.232235, -3.294231, 3.464409>  <-0.247339, -3.295494, 3.471637>  <-0.179008, -4.141807, 3.954679>  }
}
#declare BzPtch001 = union { 
  object { BzPtch001_1 }
  object { BzPtch001_2 }
  scale <0.650000, 0.700000, 0.450000>
  rotate <12.000000, 0.000000, 0.000000>
  translate <0.000000, -5.100000, -0.150000>
}

#declare Sphere23 = object { 
  sphere {<0,0,0>,1}
  scale <2.000000, 6.000000, 1.000000>
}

#declare BzPtch002_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-1.503817, -8.706658, 0.280406>  <-1.503817, -7.929630, 0.909871>  <1.490898, -7.929630, 0.909871>  <1.490898, -8.706658, 0.280406>
    <0.035306, 14.438990, 0.102857>  <1.035031, 14.462467, 0.103068>  <0.964721, 18.348428, -0.861288>  <-0.035003, 18.324951, -0.861500>
    <1.471898, 8.617876, 4.011850>  <1.451800, 9.617633, 4.020883>  <-1.542216, 9.557665, 3.996700>  <-1.522119, 8.557908, 3.987667>
    <0.688579, 6.202709, 5.539481>  <0.178657, 6.692117, 5.539956>  <-1.286885, 5.165167, 5.514351>  <-0.776963, 4.675759, 5.513876>  }
}
#declare BzPtch002_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <1.490898, -8.706658, 0.280406>  <1.490898, -9.483687, -0.349059>  <-1.503817, -9.483687, -0.349059>  <-1.503817, -8.706658, 0.280406>
    <-0.035003, 18.324951, -0.861500>  <-1.034727, 18.301474, -0.861711>  <-0.964418, 14.415513, 0.102645>  <0.035306, 14.438990, 0.102857>
    <-1.522119, 8.557908, 3.987667>  <-1.502022, 7.558151, 3.978634>  <1.491995, 7.618119, 4.002817>  <1.471898, 8.617876, 4.011850>
    <-0.776963, 4.675759, 5.513876>  <-0.267040, 4.186351, 5.513401>  <1.198502, 5.713301, 5.539007>  <0.688579, 6.202709, 5.539481>  }
}
#declare BzPtch002_3 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.688579, 6.202709, 5.539481>  <0.178657, 6.692117, 5.539956>  <-1.286885, 5.165167, 5.514351>  <-0.776963, 4.675759, 5.513876>
    <-0.094739, 3.787542, 7.067113>  <-1.094487, 3.766600, 7.059030>  <-1.031554, 0.772669, 7.032001>  <-0.031806, 0.793610, 7.040084>
    <-1.582278, 2.537456, 16.115405>  <-1.558859, 1.537771, 16.106399>  <1.434941, 1.607685, 16.130671>  <1.411522, 2.607371, 16.139677>
    <-0.060519, -8.855775, 4.039301>  <0.939191, -8.879827, 4.040073>  <0.871113, -11.675137, 5.112417>  <-0.128597, -11.651086, 5.111645>  }
}
#declare BzPtch002_4 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.776963, 4.675759, 5.513876>  <-0.267040, 4.186351, 5.513401>  <1.198502, 5.713301, 5.539007>  <0.688579, 6.202709, 5.539481>
    <-0.031806, 0.793610, 7.040084>  <0.967942, 0.814552, 7.048167>  <0.905009, 3.808483, 7.075196>  <-0.094739, 3.787542, 7.067113>
    <1.411522, 2.607371, 16.139677>  <1.388103, 3.607056, 16.148683>  <-1.605697, 3.537141, 16.124411>  <-1.582278, 2.537456, 16.115405>
    <-0.128597, -11.651086, 5.111645>  <-1.128308, -11.627034, 5.110874>  <-1.060230, -8.831724, 4.038530>  <-0.060519, -8.855775, 4.039301>  }
}
#declare BzPtch002 = union { 
  object { BzPtch002_1 }
  object { BzPtch002_2 }
  object { BzPtch002_3 }
  object { BzPtch002_4 }
  scale <0.300000, 0.300000, 0.250000>
  translate <0.000000, 7.000000, -0.500000>
}

#declare FlameBody_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.000047, 0.000000, 0.000000>  <-0.000047, -0.000606, 0.000000>  <0.000047, -0.000606, 0.000000>  <0.000047, 0.000000, 0.000000>
    <-1.547945, 0.000000, 0.542081>  <-1.547945, -2.010526, 0.542081>  <1.547945, -2.010526, 0.542081>  <1.547945, 0.000000, 0.542081>
    <-3.092308, 0.000000, 2.106435>  <-3.092308, -4.021946, 2.106435>  <3.092308, -4.021946, 2.106435>  <3.092308, 0.000000, 2.106435>
    <-1.897455, -0.545229, 4.408855>  <-1.897455, -3.293137, 4.408855>  <2.194853, -3.293137, 4.408855>  <2.194853, -0.545229, 4.408855>  }
}
#declare FlameBody_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.000047, 0.000000, 0.000000>  <0.000047, 0.000606, 0.000000>  <-0.000047, 0.000606, 0.000000>  <-0.000047, 0.000000, 0.000000>
    <1.547945, 0.000000, 0.542081>  <1.547945, 2.010526, 0.542081>  <-1.547945, 2.010526, 0.542081>  <-1.547945, 0.000000, 0.542081>
    <3.092308, 0.000000, 2.106435>  <3.092308, 4.021946, 2.106435>  <-3.092308, 4.021946, 2.106435>  <-3.092308, 0.000000, 2.106435>
    <2.194853, -0.545229, 4.408855>  <2.194853, 2.202679, 4.408855>  <-1.897455, 2.202679, 4.408855>  <-1.897455, -0.545229, 4.408855>  }
}
#declare FlameBody_3 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-1.897455, -0.545229, 4.408855>  <-1.897455, -3.293137, 4.408855>  <2.194853, -3.293137, 4.408855>  <2.194853, -0.545229, 4.408855>
    <-0.702602, -1.090458, 6.711276>  <-0.702602, -2.564328, 6.711276>  <1.297398, -2.564328, 6.711276>  <1.297398, -1.090458, 6.711276>
    <-2.434707, -0.495663, 8.413879>  <-2.434707, -1.087382, 8.413879>  <-1.530597, -1.087382, 8.413879>  <-1.530597, -0.495663, 8.413879>
    <-0.000080, 0.297398, 10.018113>  <-0.000080, 0.297346, 10.018113>  <0.000005, 0.297346, 10.018113>  <0.000005, 0.297398, 10.018113>  }
}
#declare FlameBody_4 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <2.194853, -0.545229, 4.408855>  <2.194853, 2.202679, 4.408855>  <-1.897455, 2.202679, 4.408855>  <-1.897455, -0.545229, 4.408855>
    <1.297398, -1.090458, 6.711276>  <1.297398, 0.383411, 6.711276>  <-0.702602, 0.383411, 6.711276>  <-0.702602, -1.090458, 6.711276>
    <-1.530597, -0.495663, 8.413879>  <-1.530597, 0.096056, 8.413879>  <-2.434707, 0.096056, 8.413879>  <-2.434707, -0.495663, 8.413879>
    <0.000005, 0.297398, 10.018113>  <0.000005, 0.297450, 10.018113>  <-0.000080, 0.297450, 10.018113>  <-0.000080, 0.297398, 10.018113>  }
}
#declare FlameBody = union { 
  object { FlameBody_1 }
  object { FlameBody_2 }
  object { FlameBody_3 }
  object { FlameBody_4 }
  texture {
    Texture02
  }
  no_shadow
  scale <0.100000, 0.100000, 0.200000>
}

#declare Wick = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Rusty_Iron
  }
  scale <0.050000, 0.050000, 0.800000>
  translate <0.000000, 0.000000, -0.250000>
}

#declare Flame_Core = object { 
  sphere {<0,0,0>,1}
  texture {
    Texture01
  }
  scale <0.150000, 0.150000, 0.400000>
  rotate <5.000000, 0.000000, 0.000000>
  translate <0.000000, 0.000000, 0.600000>
}

#declare Flame4 = union {
  object { FlameBody }
  object { Wick }
  object { Flame_Core }
  object { Light002 }
  translate <0.000000, -8.300000, 1.000000>
}
union {   // Lamp_1
  object { Cone002 }
  object { Cone003 }
  object { Sphere22 }
  object { BzPtch001 }
  object { Sphere23 }
  object { BzPtch002 }
  object { Flame4 }
  texture {
    Brass_Texture
  }
  bounded_by { Lamp1Bound }
  scale <0.800000, 0.800000, 1.000000>
  translate <0.000000, 0.000000, 22.000000>
}
#declare WallBound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <0.100000, 50.000000, 25.000000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <5.000000, 5.000000, 0.000000>
}

plane {   // Plane001
  z,0
  texture {
    DMFDarkOak
  }
  bounded_by { WallBound }
  rotate <0.000000, -90.000000, 0.000000>
  translate <26.000000, 0.000000, 20.000000>
}

#declare Cube004 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Silver_Texture
  }
  scale <0.100000, 11.000000, 0.100000>
  translate <-5.500000, 0.000000, 18.500000>
}

#declare Cube7 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Silver_Texture
  }
  scale <0.100000, 11.000000, 0.100000>
  translate <-5.500000, 0.000000, 27.500000>
}

#declare Cube8 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Silver_Texture
  }
  scale <0.100000, 11.000000, 0.100000>
  translate <5.500000, 0.000000, 18.500000>
}

#declare Cube9 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Silver_Texture
  }
  scale <0.100000, 11.000000, 0.100000>
  translate <5.500000, 0.000000, 27.500000>
}

#declare Cube005 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Silver_Texture
  }
  scale <5.500000, 0.100000, 0.100000>
  translate <0.000000, -11.000000, 18.500000>
}

#declare Cube10 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Silver_Texture
  }
  scale <5.500000, 0.100000, 0.100000>
  translate <0.000000, 11.000000, 18.500000>
}

#declare Cube11 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Silver_Texture
  }
  scale <5.500000, 0.100000, 0.100000>
  translate <0.000000, -11.000000, 27.500000>
}

#declare Cube12 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Silver_Texture
  }
  scale <5.500000, 0.100000, 0.100000>
  translate <0.000000, 11.000000, 27.500000>
}

#declare Cube006 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Silver_Texture
  }
  scale <0.100000, 0.100000, 4.500000>
  translate <-5.500000, -11.000000, 23.000000>
}

#declare Cube13 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Silver_Texture
  }
  scale <0.100000, 0.100000, 4.500000>
  translate <5.500000, -11.000000, 23.000000>
}

#declare Cube14 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Silver_Texture
  }
  scale <0.100000, 0.100000, 4.500000>
  translate <-5.500000, 11.000000, 23.000000>
}

#declare Cube15 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Silver_Texture
  }
  scale <0.100000, 0.100000, 4.500000>
  translate <5.500000, 11.000000, 23.000000>
}

union {
  object { Cube004 }
  object { Cube7 }
  object { Cube8 }
  object { Cube9 }
  object { Cube005 }
  object { Cube10 }
  object { Cube11 }
  object { Cube12 }
  object { Cube006 }
  object { Cube13 }
  object { Cube14 }
  object { Cube15 }
  translate <0.000000, 0.000000, 2.000000>
}

#declare Boom_Arm = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  scale <0.200000, 0.200000, 25.000000>
}

#declare BoomHeadBrkt = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Rusty_Iron
  }
  rotate <-90.000000, 90.000000, 0.000000>
  translate <0.000000, -0.500000, 24.000000>
}

#declare Boom_Ctrwt = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Rusty_Iron
  }
  scale <0.300000, 0.300000, 4.000000>
}

#declare Pivot = object { 
  sphere {<0,0,0>,1}
  texture {
    Chrome_Texture
  }
  scale <0.400000, 0.660000, 0.400000>
  translate <0.000000, 0.000000, 24.000000>
}

#declare Boom = union {
  object { Boom_Arm }
  object { BoomHeadBrkt }
  object { Boom_Ctrwt }
  object { Pivot }
  rotate <0.000000, 24.000000, -60.000000>
  translate <-1.850000, 3.000000, 14.000000>
}

#declare Sphere28 = object { 
  sphere {<0,0,0>,1}
}

#declare Cone9 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <1.000000, 1.000000, 2.500000>
  translate <0.000000, 0.000000, -2.500000>
}

#declare Cylndr9 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.450000, 0.450000, 1.000000>
  rotate <0.000000, -180.000000, 0.000000>
  translate <0.000000, 0.000000, -1.400000>
}

#declare Bulb1 = merge {
  object { Sphere28 }
  object { Cone9 }
  object { Cylndr9 }
  texture {
    Silver_Texture
  }
  rotate <0.000000, -180.000000, 0.000000>
  translate <0.000000, 0.000000, 1.500000>
}

#declare Cylndr10 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.500000, 0.500000, 1.000000>
  rotate <0.000000, -180.000000, 0.000000>
  translate <0.000000, 0.000000, -1.600000>
}

#declare Sphere29 = object { 
  sphere {<0,0,0>,1}
  scale <0.500000, 0.500000, 0.500000>
  translate <0.000000, 0.000000, -2.600000>
}

#declare Socket1 = union {
  object { Cylndr10 }
  object { Sphere29 }
  texture {
    Brass_Texture
  }
  rotate <0.000000, 180.000000, 0.000000>
  translate <0.000000, 0.000000, 1.500000>
}

#declare Cylndr001 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Rusty_Iron
  }
  scale <1.500000, 1.500000, 7.000000>
  translate <0.000000, 0.000000, -2.000000>
}

#declare Cylndr010 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver_Texture
  }
  scale <1.300000, 1.300000, 6.700000>
  translate <0.000000, 0.000000, -2.000000>
}

#declare CSG3 = difference {
  object { Cylndr001 }
  object { Cylndr010 }
}

#declare Spot_Head = union {
  object { Bulb1 }
  object { Socket1 }
  object { CSG3 }
  rotate <0.000000, -50.000000, -60.000000>
  translate <4.400000, -7.700000, 36.500000>
}
#declare Cone10 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Rusty_Iron
  }
  scale <2.000000, 2.000000, 0.500000>
  rotate <0.000000, -180.000000, 0.000000>
  translate <0.000000, 0.000000, 1.000000>
}

#declare WallCord_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.002299, -0.200618, 0.281414>  <0.002332, -0.200618, 0.080098>  <-0.002266, 0.200618, 0.080098>  <-0.002299, 0.200618, 0.281414>
    <2.002168, -0.177702, 1.801377>  <2.002200, -0.177701, 1.600061>  <1.997603, 0.223535, 1.600061>  <1.997570, 0.223534, 1.801377>
    <3.987204, 1.139635, 1.801702>  <3.987236, 1.139636, 1.600386>  <3.982639, 1.540872, 1.600386>  <3.982525, 1.547906, 1.801702>
    <5.992354, 1.118887, 1.007032>  <5.987186, 1.155517, 0.805716>  <5.982588, 1.556753, 0.805716>  <5.989555, 1.523654, 1.007032>  }
}
#declare WallCord_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.002299, 0.200618, 0.281414>  <-0.002332, 0.200618, 0.482730>  <0.002266, -0.200618, 0.482730>  <0.002299, -0.200618, 0.281414>
    <1.997570, 0.223534, 1.801377>  <1.997537, 0.223534, 2.002693>  <2.002135, -0.177702, 2.002693>  <2.002168, -0.177702, 1.801377>
    <3.982525, 1.547906, 1.801702>  <3.982412, 1.554941, 2.003018>  <3.987171, 1.139635, 2.003018>  <3.987204, 1.139635, 1.801702>
    <5.989555, 1.523654, 1.007032>  <5.982442, 1.563788, 1.208348>  <5.987120, 1.155516, 1.208348>  <5.992354, 1.118887, 1.007032>  }
}
#declare WallCord_3 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <5.992354, 1.118887, 1.007032>  <5.987186, 1.155517, 0.805716>  <5.982588, 1.556753, 0.805716>  <5.989555, 1.523654, 1.007032>
    <7.987102, 1.171398, 0.212362>  <7.987135, 1.171399, 0.011046>  <7.982537, 1.572635, 0.011046>  <7.982504, 1.572634, 0.212362>
    <10.001642, -0.086036, 0.226758>  <10.001675, -0.086036, 0.025442>  <9.997077, 0.315200, 0.025442>  <9.997045, 0.315200, 0.226758>
    <12.001033, -0.127288, 1.015044>  <12.001544, -0.063120, 0.813728>  <11.996946, 0.338117, 0.813728>  <11.998274, 0.273961, 1.015044>  }
}
#declare WallCord_4 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <5.989555, 1.523654, 1.007032>  <5.982442, 1.563788, 1.208348>  <5.987120, 1.155516, 1.208348>  <5.992354, 1.118887, 1.007032>
    <7.982504, 1.572634, 0.212362>  <7.982472, 1.572634, 0.413678>  <7.987069, 1.171398, 0.413678>  <7.987102, 1.171398, 0.212362>
    <9.997045, 0.315200, 0.226758>  <9.997012, 0.315199, 0.428074>  <10.001610, -0.086037, 0.428074>  <10.001642, -0.086036, 0.226758>
    <11.998274, 0.273961, 1.015044>  <11.996880, 0.338116, 1.216360>  <12.001478, -0.063120, 1.216360>  <12.001033, -0.127288, 1.015044>  }
}
#declare WallCord_5 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <12.001033, -0.127288, 1.015044>  <12.001544, -0.063120, 0.813728>  <11.996946, 0.338117, 0.813728>  <11.998274, 0.273961, 1.015044>
    <14.001380, -0.040204, 1.803329>  <14.001412, -0.040203, 1.602013>  <13.996815, 0.361033, 1.602013>  <13.996782, 0.361033, 1.803329>
    <15.963844, 3.246904, 3.801696>  <15.963877, 3.246905, 3.600380>  <15.959279, 3.648141, 3.600380>  <15.959166, 3.655175, 3.801696>
    <17.963552, 3.283890, 3.802021>  <17.963584, 3.283891, 3.600705>  <17.958987, 3.685127, 3.600705>  <17.958954, 3.685127, 3.802021>  }
}
#declare WallCord_6 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <11.998274, 0.273961, 1.015044>  <11.996880, 0.338116, 1.216360>  <12.001478, -0.063120, 1.216360>  <12.001033, -0.127288, 1.015044>
    <13.996782, 0.361033, 1.803329>  <13.996749, 0.361032, 2.004645>  <14.001347, -0.040204, 2.004645>  <14.001380, -0.040204, 1.803329>
    <15.959166, 3.655175, 3.801696>  <15.959052, 3.662210, 4.003012>  <15.963811, 3.246904, 4.003012>  <15.963844, 3.246904, 3.801696>
    <17.958954, 3.685127, 3.802021>  <17.958921, 3.685126, 4.003337>  <17.963519, 3.283890, 4.003337>  <17.963552, 3.283890, 3.802021>  }
}
#declare WallCord = union { 
  object { WallCord_1 }
  object { WallCord_2 }
  object { WallCord_3 }
  object { WallCord_4 }
  object { WallCord_5 }
  object { WallCord_6 }
  texture {
    Blue_Agate
  }
  scale <2.500000, 1.000000, 1.000000>
  translate <2.900000, 0.000000, 0.000000>
}

#declare Cylndr002 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  scale <0.200000, 0.200000, 20.000000>
}

#declare Cylndr003 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Rusty_Iron
  }
  scale <3.000000, 3.000000, 0.500000>
}

#declare SpotBase = union {
  object { Cone10 }
  object { WallCord }
  object { Cylndr002 }
  object { Cylndr003 }
  rotate <0.000000, 0.000000, 45.000000>
}

#declare Cylndr004 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Rusty_Iron
  }
  scale <1.500000, 1.500000, 1.000000>
  rotate <0.000000, 90.000000, 0.000000>
}

#declare Sphere30 = object { 
  sphere {<0,0,0>,1}
  texture {
    Rusty_Iron
  }
  scale <0.250000, 0.250000, 0.250000>
  translate <-0.100000, 0.000000, 0.000000>
}

#declare Spot_Bracket = union {
  object { Cylndr004 }
  object { Sphere30 }
  rotate <0.000000, 0.000000, 30.000000>
  translate <-0.500000, -0.300000, 20.000000>
}

#declare Cord_1_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-1.655131, -0.573757, 0.410551>  <-1.655131, -0.672846, 0.410551>  <-1.453164, -0.672846, 0.410551>  <-1.453164, -0.573757, 0.410551>
    <0.119533, 1.187509, 4.305846>  <0.166036, 1.104777, 4.334335>  <0.344380, 1.194395, 4.303475>  <0.297877, 1.277127, 4.274985>
    <0.838440, 0.109841, 8.378677>  <0.842709, 0.038099, 8.446893>  <1.072702, 0.051786, 8.446893>  <1.068432, 0.123528, 8.378677>
    <0.076787, -0.399592, 10.407919>  <0.099236, -0.473738, 10.466048>  <0.296272, -0.460057, 10.407564>  <0.273823, -0.385910, 10.349435>  }
}
#declare Cord_1_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-1.453164, -0.573757, 0.410551>  <-1.453164, -0.474668, 0.410551>  <-1.655131, -0.474668, 0.410551>  <-1.655131, -0.573757, 0.410551>
    <0.297877, 1.277127, 4.274985>  <0.251375, 1.359859, 4.246496>  <0.073030, 1.270240, 4.277357>  <0.119533, 1.187509, 4.305846>
    <1.068432, 0.123528, 8.378677>  <1.064163, 0.195271, 8.310461>  <0.834170, 0.181584, 8.310461>  <0.838440, 0.109841, 8.378677>
    <0.273823, -0.385910, 10.349435>  <0.251374, -0.311763, 10.291306>  <0.054338, -0.325445, 10.349790>  <0.076787, -0.399592, 10.407919>  }
}
#declare Cord_1_3 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.076787, -0.399592, 10.407919>  <0.099236, -0.473738, 10.466048>  <0.296272, -0.460057, 10.407564>  <0.273823, -0.385910, 10.349435>
    <-0.684865, -0.909025, 12.437160>  <-0.644237, -0.985575, 12.485202>  <-0.480158, -0.971899, 12.368235>  <-0.520786, -0.895348, 12.320193>
    <-0.734618, 1.222799, 17.832816>  <-0.698412, 1.138318, 17.795794>  <-0.554019, 1.138318, 17.937008>  <-0.590226, 1.222799, 17.974029>
    <-0.186122, 1.921009, 17.789287>  <-0.160162, 1.847048, 17.733537>  <0.010843, 1.847048, 17.824991>  <-0.015118, 1.921009, 17.880741>  }
}
#declare Cord_1_4 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.273823, -0.385910, 10.349435>  <0.251374, -0.311763, 10.291306>  <0.054338, -0.325445, 10.349790>  <0.076787, -0.399592, 10.407919>
    <-0.520786, -0.895348, 12.320193>  <-0.561414, -0.818798, 12.272151>  <-0.725494, -0.832474, 12.389119>  <-0.684865, -0.909025, 12.437160>
    <-0.590226, 1.222799, 17.974029>  <-0.626432, 1.307281, 18.011051>  <-0.770825, 1.307281, 17.869837>  <-0.734618, 1.222799, 17.832816>
    <-0.015118, 1.921009, 17.880741>  <-0.041078, 1.994971, 17.936491>  <-0.212082, 1.994971, 17.845037>  <-0.186122, 1.921009, 17.789287>  }
}
#declare Cord_1_5 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.186122, 1.921009, 17.789287>  <-0.160162, 1.847048, 17.733537>  <0.010843, 1.847048, 17.824991>  <-0.015118, 1.921009, 17.880741>
    <0.362374, 2.619220, 17.745759>  <0.378088, 2.555779, 17.671281>  <0.575704, 2.555779, 17.712975>  <0.559990, 2.619220, 17.787453>
    <-3.497277, -2.395026, 23.668439>  <-3.497277, -2.494115, 23.668439>  <-3.295310, -2.494115, 23.668439>  <-3.295310, -2.395026, 23.668439>
    <-2.598717, -3.554121, 24.982633>  <-2.632357, -3.585835, 24.950930>  <-2.461329, -3.525239, 24.910686>  <-2.427689, -3.493525, 24.942389>  }
}
#declare Cord_1_6 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-0.015118, 1.921009, 17.880741>  <-0.041078, 1.994971, 17.936491>  <-0.212082, 1.994971, 17.845037>  <-0.186122, 1.921009, 17.789287>
    <0.559990, 2.619220, 17.787453>  <0.544276, 2.682661, 17.861931>  <0.346660, 2.682661, 17.820237>  <0.362374, 2.619220, 17.745759>
    <-3.295310, -2.395026, 23.668439>  <-3.295310, -2.295937, 23.668439>  <-3.497277, -2.295937, 23.668439>  <-3.497277, -2.395026, 23.668439>
    <-2.427689, -3.493525, 24.942389>  <-2.394049, -3.461811, 24.974093>  <-2.565077, -3.522407, 25.014336>  <-2.598717, -3.554121, 24.982633>  }
}
#declare Cord_1_7 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-2.598717, -3.554121, 24.982633>  <-2.632357, -3.585835, 24.950930>  <-2.461329, -3.525239, 24.910686>  <-2.427689, -3.493525, 24.942389>
    <-1.700158, -4.713216, 26.296827>  <-1.767438, -4.677554, 26.233421>  <-1.627348, -4.556363, 26.152933>  <-1.560068, -4.592025, 26.216340>
    <2.664526, -4.837450, 32.696834>  <2.731055, -4.906176, 32.670964>  <2.871943, -4.810738, 32.779741>  <2.805414, -4.742012, 32.805611>
    <2.927345, -2.695515, 32.190170>  <2.956303, -2.738566, 32.163435>  <3.108887, -2.714030, 32.271799>  <3.079929, -2.670979, 32.298534>  }
}
#declare Cord_1_8 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <-2.427689, -3.493525, 24.942389>  <-2.394049, -3.461811, 24.974093>  <-2.565077, -3.522407, 25.014336>  <-2.598717, -3.554121, 24.982633>
    <-1.560068, -4.592025, 26.216340>  <-1.492788, -4.627686, 26.279746>  <-1.632878, -4.748877, 26.360233>  <-1.700158, -4.713216, 26.296827>
    <2.805414, -4.742012, 32.805611>  <2.738885, -4.673286, 32.831481>  <2.597997, -4.768724, 32.722704>  <2.664526, -4.837450, 32.696834>
    <3.079929, -2.670979, 32.298534>  <3.050970, -2.550527, 32.325269>  <2.898387, -2.575063, 32.216905>  <2.927345, -2.695515, 32.190170>  }
}
#declare Cord_1_9 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <2.927345, -2.695515, 32.190170>  <2.956303, -2.738566, 32.163435>  <3.108887, -2.714030, 32.271799>  <3.079929, -2.670979, 32.298534>
    <3.190165, -0.476180, 31.683506>  <3.181552, -0.570957, 31.655905>  <3.345830, -0.617322, 31.763856>  <3.354443, -0.522545, 31.791456>
    <1.550878, -4.434220, 26.165890>  <1.620804, -4.431825, 26.236057>  <1.724866, -4.573914, 26.137202>  <1.654940, -4.576309, 26.067036>
    <0.544970, -5.734593, 28.854269>  <0.580165, -5.726517, 28.840288>  <0.733178, -5.797627, 28.791329>  <0.697983, -5.805704, 28.805310>  }
}
#declare Cord_1_10 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <3.079929, -2.670979, 32.298534>  <3.050970, -2.550527, 32.325269>  <2.898387, -2.575063, 32.216905>  <2.927345, -2.695515, 32.190170>
    <3.354443, -0.522545, 31.791456>  <3.363056, -0.427768, 31.819057>  <3.198777, -0.381402, 31.711106>  <3.190165, -0.476180, 31.683506>
    <1.654940, -4.576309, 26.067036>  <1.585014, -4.578704, 25.996869>  <1.480953, -4.436615, 26.095724>  <1.550878, -4.434220, 26.165890>
    <0.697983, -5.805704, 28.805310>  <0.662789, -5.813780, 28.819291>  <0.509776, -5.742670, 28.868250>  <0.544970, -5.734593, 28.854269>  }
}
#declare Cord_1_11 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.544970, -5.734593, 28.854269>  <0.580165, -5.726517, 28.840288>  <0.733178, -5.797627, 28.791329>  <0.697983, -5.805704, 28.805310>
    <-0.460938, -7.034967, 31.542648>  <-0.460474, -7.021209, 31.444520>  <-0.258510, -7.021340, 31.445456>  <-0.258973, -7.035098, 31.543584>
    <1.286841, 0.193753, 42.550162>  <1.224476, 0.222055, 42.621774>  <1.341009, 0.130927, 42.759275>  <1.403374, 0.102625, 42.687663>
    <2.428458, -4.430760, 38.918297>  <2.346768, -4.459828, 38.966260>  <2.435783, -4.418665, 39.142817>  <2.517474, -4.389598, 39.094854>  }
}
#declare Cord_1_12 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <0.697983, -5.805704, 28.805310>  <0.662789, -5.813780, 28.819291>  <0.509776, -5.742670, 28.868250>  <0.544970, -5.734593, 28.854269>
    <-0.258973, -7.035098, 31.543584>  <-0.259437, -7.048856, 31.641712>  <-0.461401, -7.048725, 31.640776>  <-0.460938, -7.034967, 31.542648>
    <1.403374, 0.102625, 42.687663>  <1.465739, 0.074324, 42.616051>  <1.349207, 0.165452, 42.478551>  <1.286841, 0.193753, 42.550162>
    <2.517474, -4.389598, 39.094854>  <2.599164, -4.360530, 39.046891>  <2.510148, -4.401692, 38.870334>  <2.428458, -4.430760, 38.918297>  }
}
#declare Cord_1 = union { 
  object { Cord_1_1 }
  object { Cord_1_2 }
  object { Cord_1_3 }
  object { Cord_1_4 }
  object { Cord_1_5 }
  object { Cord_1_6 }
  object { Cord_1_7 }
  object { Cord_1_8 }
  object { Cord_1_9 }
  object { Cord_1_10 }
  object { Cord_1_11 }
  object { Cord_1_12 }
  texture {
    Blue_Agate
  }
}

#declare Spot_Stand = union {
  object { SpotBase }
  object { Spot_Bracket }
  object { Cord_1 }
  rotate <0.000000, 0.000000, -15.000000>
}

union {   // Spot_Lamp
  object { Boom }
  object { Spot_Head }
  object { Spot_Stand }
  translate <-12.000000, 23.000000, 0.000000>
}
plane {   // Wall2
  z,0
  texture {
    DMFDarkOak
  }
  rotate <-90.000000, 0.000000, 0.000000>
  translate <0.000000, -30.000000, 20.000000>
}

