// MIC.INC
//
// Microphone Object - For PIANO.POV
//
// Neil Clark - 2/95
//
// For the 2/95 'Sound/Music' Ray Tracing Contest
//

#declare Ring = object {
    torus { 1.0, 0.03
    }
   texture { pigment { color Silver }}
  }

// Ball on mic made up of rings...
#declare Set = union
  {
   object { Ring rotate <0,0,0> }
   object { Ring rotate <10,0,0> }
   object { Ring rotate <20,0,0> }
   object { Ring rotate <30,0,0> }
   object { Ring rotate <40,0,0> }
   object { Ring rotate <50,0,0> }
   object { Ring rotate <60,0,0> }
   object { Ring rotate <70,0,0> }
   object { Ring rotate <80,0,0> }
   object { Ring rotate <90,0,0> }
   object { Ring rotate <100,0,0> }
   object { Ring rotate <110,0,0> }
   object { Ring rotate <120,0,0> }
   object { Ring rotate <130,0,0> }
   object { Ring rotate <140,0,0> }
   object { Ring rotate <150,0,0> }
   object { Ring rotate <160,0,0> }
   object { Ring rotate <170,0,0> }
  }

#declare Mic_Ball = union
  {
   object { Set } // about the X
   object { Set rotate <0,0,90> } // about the Z
   object { sphere { <0,0,0>, 0.9
    texture { pigment { color DarkSlateGray }}
    }
   }
  }

#declare Mic_Handle = object
  {
   cone { < 0, 0, 0 >, 0.75 < 5, 0, 0 >, 0.5
      texture { pigment { color Gray15 }}
     }
  }

#declare Mic_Antenae = object
  {
   cone { < 0, 0, 0 >, 0.05 < 1, 0, 0 >, 0.03
      texture {  Silver_Texture }
     }
  }

#declare Mic_Antenae_Ball = object
  {
   sphere { < 0, 0, 0 >, 0.1
      texture {  Silver_Texture }
     }
  }

#declare Mic_Clip = difference
  {
    object { cone { < 0, 0, 0 >, 0.7 < 1, 0, 0 >, 0.65
      texture {  pigment { color Gray25 }}
      }
    }
    object { cone { < 0, 0, 0 >, 0.7 < 1, 0, 0 >, 0.65
      texture {  pigment { color Gray25 }}
      }
    }
   clipped_by { plane { y,0 }}
  }

#declare Mic = union
  {
    object { Mic_Ball translate <0,1,0> }
    object { Mic_Handle translate <0.2,1,0> }
    object { Mic_Antenae translate <5.3,1,0> }
    object { Mic_Antenae_Ball translate <6.22,1,0> }
    object { Mic_Clip translate <2.5,1,0> }
  }


