// CHARLIE.INC - Charlie the Can in TOYS.POV
//
// By Neil Clark
//
#declare Body = object
 {
  cylinder { <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>, 1
  scale < 0.76, 1.3, 0.8>
  translate < 0, 0, 0 >
  texture { pigment { color NeonBlue } finish { Shiny }}
  }
 }

#declare Hat = object
  {
   quartic {
   < 1.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 2.0, 0.0,
   -1.23683,  0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
   0.0, 0.0, 1.0, 0.0, 0.0, 2.0, 0.0, 1.19683,  0.0,
   0.0, 0.0, 0.0, 1.0, 0.0, -1.23683, 0.0, 0.35810  >
   translate < 0, 0.9, 0 >
   texture { pigment { color NeonBlue } finish { Shiny }}
  }
 }

#declare Left_Eye = object
  {
   sphere { <0.0, 0.0, 0.0> , 1.0
   scale < 0.1798, 0.176, 0.1798>
   translate < -0.3402, 0.444, -0.7598>
   texture { pigment { color White } finish { Shiny }}
  }
 }

#declare Right_Eye = object
  {
   sphere { <0.0, 0.0, 0.0> , 1.0
   scale < 0.17980, 0.17600, 0.17980>
   translate < 0.35980, 0.44400, -0.75980>
   texture { pigment { color White } finish { Shiny }}
   }
  }

#declare Nose = object
  {
   sphere { <0.0, 0.0, 0.0> , 1.0
   scale < 0.18, 0.18, 0.18>
   translate < 0, -0.04, -0.9>
   texture { pigment { color Orange } finish { Shiny }}
  }
  }

#declare Left_Pupil = object
  {
   sphere { <0.0, 0.0, 0.0> , 1.0
   scale < 0.1, 0.1, 0.1 >
   translate < -0.36, 0.44, -0.85 >
   texture { pigment { color Black } finish { Shiny }}
   }
  }

#declare Right_Pupil = object
  {
   sphere { <0.0, 0.0, 0.0> , 1.0
   scale < 0.1, 0.1, 0.1>
   translate < 0.36, 0.44, -0.85 >
   texture { pigment { color Black } finish { Shiny }}
  }}

#declare Upper_Lip = object
  {
   quartic {
   < 1.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 2.0, 0.0,
   -0.43604,  0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
   0.0, 0.0, 1.0, 0.0, 0.0, 2.0, 0.0, 0.41044,  0.0,
   0.0, 0.0, 0.0, 1.0, 0.0, -0.43604, 0.0, 0.04212  >
   rotate < 340, 0, 0>
   translate < 0.00000, -0.49, -0.5>
   texture { pigment { color Red } finish { Shiny }}
  }}

#declare Lower_Lip = object
  {
   quartic {
   < 1.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 2.0, 0.0,
   -0.43604,  0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
   0.0, 0.0, 1.0, 0.0, 0.0, 2.0, 0.0, 0.41044,  0.0,
   0.0, 0.0, 0.0, 1.0, 0.0, -0.43604, 0.0, 0.04212  >
   rotate < 320, 0, 0>
   translate < 0.00000, -0.60229, -0.5>
   texture { pigment { color Red } finish { Shiny }}
  }}

#declare Left_Elbow = object
  {
   sphere { <0.0, 0.0, 0.0> , 1.0
   scale < 0.17980, 0.17600, 0.17980>
   translate < -1.88020, -0.11600, -0.01980>
   texture { pigment { color Silver } finish { Shiny }}
  }}

#declare Left_Upper_Arm = object
  {
   cylinder { <-1.0, 0.0, 0.0>,<1.0, 0.0, 0.0>,1
   scale < 0.667, 0.15, 0.15 >
   translate < -1.25330, -0.11890, 0.00000>
   texture { pigment { color Silver } finish { Shiny }}
  }}

#declare Left_Lower_Arm = object
  {
   cylinder { <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,1
   scale < 0.15, 0.66670, 0.15 >
   translate < -1.88110, -0.82670, 0.00000>
   texture { pigment { color Silver } finish { Shiny }}
  }}

#declare Left_Foot = object
  {
   cylinder { <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,1
   scale < 0.31890, 0.06670, 0.30000>
   translate < -1.86110, -1.54670, 0.00000>
   texture { pigment { color Silver } finish { Shiny }}
  }}

#declare Right_Elbow = object
  {
   sphere { <0.0, 0.0, 0.0> , 1.0
   scale < 0.17980, 0.17600, 0.17980>
   translate < -1.88020, -0.11600, -0.01980>
   texture { pigment { color Silver } finish { Shiny }}
   rotate <0, 180, 0> }
  }

#declare Right_Upper_Arm = object
  {
   cylinder { <-1.0, 0.0, 0.0>,<1.0, 0.0, 0.0>,1
   scale < 0.667, 0.15, 0.15 >
   translate < -1.25330, -0.11890, 0.00000>
   rotate <0, 180, 0>
   texture { pigment { color Silver } finish { Shiny }}
  }
  }

#declare Right_Lower_Arm = object
  {
   cylinder { <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,1
   scale < 0.15, 0.66670, 0.15 >
   translate < -1.88110, -0.82670, 0.00000>
   rotate <0, 180, 0>
   texture { pigment { color Silver } finish { Shiny }}
  }}

#declare Right_Foot = object
  {
   cylinder { <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,1
   scale < 0.31890, 0.06670, 0.30000>
   translate < -1.86110, -1.54670, 0.00000>
   rotate <0, 180, 0>
   texture { pigment { color Silver } finish { Shiny }}
  }}

#declare Hub = object {  // inside wheel cone
    cone {
      < 0, 0, 0.15 >, 1.0
      < 0, 0, -0.4 >, 0
      scale <2, 2, 2>
      rotate <0, 0, 0>
      translate <0, 0, 0>
      texture { pigment { checker color Red color White }
      rotate <0, 0, 15>
      scale <2, 2, 2>
      finish { Shiny phong .8 }
     }
   }
}

#declare Tire = union { // wheel object
  object {
    torus {1.0, 0.3
    rotate <  90, 0, 0 >
    scale <  1.8, 1.8, 1.8 >
    }
  }
  Hub
  texture { pigment { color NeonBlue } finish { Shiny phong .8 }}
}

#declare Wheel = object
   {
     Tire
     scale <0.4, 0.4, 0.4>
     rotate <0, -90, 0>
     translate <1, -1.2, 0>
   }

#declare Left_Arm = union
  {
   object { Left_Upper_Arm }
   object { Left_Elbow }
   object { Left_Lower_Arm }
   object { Left_Foot }
  }

#declare Right_Arm = union
  {
   object { Right_Upper_Arm }
   object { Right_Elbow }
   object { Right_Lower_Arm }
   object { Right_Foot }
  }

#declare Charlie = union
  {
   object { Body }
   object { Hat }
   object { Left_Eye }
   object { Right_Eye }
   object { Left_Pupil }
   object { Right_Pupil }
   object { Nose }
   object { Upper_Lip }
   object { Lower_Lip }
   object { Left_Arm rotate < 15, 0, 0> }
   object { Right_Arm rotate < -15, 0, 0> }
   object { Wheel scale <0.8, 0.8, 0.8> }
   object { Wheel scale <0.8,0.8,0.8>
       // Flip the left wheel as mirror object
       rotate <0,180,0> translate <0, 0, 0> }
  }
