// DUNLOP.INC - Tire object declarations for the red indy race car.
//
// By Neil Clark
//
#declare tire = object
    {
     intersection
       {
        plane  { <-1, 0, 0>, 1.0 }
        plane  { <1, 0, 0>, 1.0 }
        object { Cylinder_X scale <1, 1, 1> }
        object { Cylinder_X scale <.6, .6, .6> inverse }
       }
     pigment { color Black }
     bounded_by { box { < -1, -1, -1>, <1, 1, 1> } }
     scale <.4, 1, 1>
    }

#declare rim = object
    {
     intersection
       {
        plane { <-1, 0, 0>, 1.0 }
        plane { <1, 0, 0>, 1.0 }
        object { Cylinder_X scale <.6, .6, .6> }
        object { Cylinder_X scale <.57, .57, .57> inverse }
       }
     texture { Chrome_Texture }
     bounded_by { box { < -1, -1, -1>, <1, 1, 1> } }
     scale <.4, 1, 1>
    }

#declare spoke = object
   {
    intersection
      {
       object { QCone_Y }
       plane   { <0.0, 1.0, 0.0>, 0.0 }
       plane   { <0.0, -1.0, 0.0>, 1.0 }
       scale < 0.16, .90, 0.34 >
      }
    texture { Chrome_Texture }
    bounded_by { box { < -1, -1, -1>, <1, 1, 1> }}
    translate <0, 0, 0>
   }

#declare csg_wheel = union
  {
   object { tire  scale <.6, .6, .6> rotate <0, 90, 0> }
   object { rim   scale <.6, .6, .6> rotate <0, 90, 0> }
   object { spoke scale <.6, .6, .6> rotate <0, 90, 0> }
   object { spoke scale <.6, .6, .6> rotate <0, 90, 72>}
   object { spoke scale <.6, .6, .6> rotate <0, 90, 144>}
   object { spoke scale <.6, .6, .6> rotate <0, 90, 216>}
   object { spoke scale <.6, .6, .6> rotate <0, 90, 288>}
}

#declare rr_wheel = union
  {
   object { csg_wheel }
   object
    {
     sphere { <0, 0, 0>, .15}
     texture { Chrome_Texture }
    }
  }

#declare rf_wheel = union
  {
   object { csg_wheel }
   object
    {
     sphere { <0, 0, 0>, .15}
     texture { Chrome_Texture }
    }
  }

#declare lr_wheel = union
  {
   object { csg_wheel }
   object
    {
     sphere { <0, 0, 0>, .15}
     texture { Chrome_Texture }
    }
  }

#declare lf_wheel = union
  {
   object { csg_wheel }
   object
    {
     sphere { <0, 0, 0>, .15}
     texture { Chrome_Texture }
    }
  }

#declare axle = object
    {
     intersection
       {
        plane { <-1, 0, 0>, 1.0 }
        plane { <1, 0, 0>, 1.0 }
        object { Cylinder_X scale <.1, .1, .1> }
        }
     texture { Chrome_Texture }
     bounded_by { box { < -1, -1, -1>, <1, 1, 1> } }
     scale <.5, .5, .5>
     rotate <0, 90, 0>
    }

