// TTOY.INC - TinkerToy Library
//
// By Neil Clark

#declare TToyWood = texture
  {
   White_Wood                // Use what you want that looks good...
  }

//
// 4 Wooden colored sticks
//

//
// ---------------------------   Yellow Stick   -----------------------
//

#declare Yellow_Ttoy = difference
 {
  object
   {
    Disk_X
    texture { pigment { color Yellow }}
    scale < 2, 0.125, 0.125>
    translate <0, 0, 0>
   }
  object
   {
    box
     {
      <0,-0.2,-0.015>, <0.2,0.2,0.015>
      pigment { color rgbf <1.0,1.0,1.0,1.0> }
      translate <-1.875, 0, 0>
     }
   }
  object
   {
    box
     {
      <0,-0.2,-0.015>, <0.2,0.2,0.015>
      pigment { color rgbf <1.0,1.0,1.0,1.0> }
      translate <1.875, 0, 0>
     }
   }
  bounded_by { object { Disk_X }
    scale < 2.1, 0.128, 0.128>
    translate <0, 0, 0>
   }
 }

//
// ---------------------------   Blue Stick   -----------------------
//

#declare Blue_Ttoy = difference
 {
  object
   {
    Disk_X
    texture { pigment { color Blue }}
    scale < 3.25, 0.125, 0.125>
    translate <0, 0, 0>
   }
  object
   {
    box
     {
      <0,-0.2,-0.015>, <0.2,0.2,0.015>
      pigment { color rgbf <1.0,1.0,1.0,1.0> }
      translate <-3.25, 0, 0>
     }
   }
  object
   {
    box
     {
      <0,-0.2,-0.015>, <0.2,0.2,0.015>
      pigment { color rgbf <1.0,1.0,1.0,1.0> }
      translate <3.06, 0, 0>
     }
   }
  bounded_by { object { Disk_X }
    scale < 3.5, 0.128, 0.128>
    translate <0, 0, 0>
   }
 }

//
// ---------------------------   Red Stick   -----------------------
//

#declare Red_Ttoy = difference
 {
  object
   {
    Disk_X
    texture { pigment { color Red }}
    scale < 4, 0.125, 0.125>
    translate <0, 0, 0>
   }
  object
   {
    box
     {
      <0,-0.2,-0.015>, <0.2,0.2,0.015>
      pigment { color rgbf <1.0,1.0,1.0,1.0> }
      translate <-4, 0, 0>
     }
   }
  object
   {
    box
     {
      <0,-0.2,-0.015>, <0.2,0.2,0.015>
      pigment { color rgbf <1.0,1.0,1.0,1.0> }
      translate <3.81, 0, 0>
     }
   }
  bounded_by { object { Disk_X }
    scale < 4.5, 0.128, 0.128>
    translate <0, 0, 0>
   }
 }

//
// ---------------------------   Green Stick   -----------------------
//

#declare Green_Ttoy = difference
 {
  object
   {
    Disk_X
    texture { pigment { color Green }}
    scale < 6.25, 0.125, 0.125>
    translate <0, 0, 0>
   }
  object
   {
    box
     {
      <0,-0.2,-0.015>, <0.2,0.2,0.015>
      pigment { color rgbf <1.0,1.0,1.0,1.0> }
      translate <-6.26, 0, 0>
     }
   }
  object
   {
    box
     {
      <0,-0.2,-0.015>, <0.2,0.2,0.015>
      pigment { color rgbf <1.0,1.0,1.0,1.0> }
      translate <6.26, 0, 0>
     }
   }
  bounded_by { object { Disk_X }
    scale < 6.3, 0.128, 0.128>
    translate <0, 0, 0>
   }
 }

//
// ---------------------------   Rounded Wheel   -----------------------
//

#declare Round_Wheel = difference
 {
  object  // Main Disk
   {
    Disk_X
    texture { White_Wood scale < 0.55, 0.22, .73 > }
    scale < 0.4, 0.65, 0.65>
    translate <0, 0, 0>
   }
  object  // Center Hole
   {
    Disk_X
    scale < 0.55, 0.125, 0.125>
    texture { White_Wood scale < 0.17, 0.22, 0.13 > }
    translate <0, 0, 0>
   }
  object // Radial Hole #1
   {
    Disk_Y
    scale <0.125, 0.2, 0.125 >
    translate <0, 0.84, 0>
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object // Radial Hole #2
   {
    Disk_Y
    scale <0.125, 0.2, 0.125 >
    translate <0, 0.84, 0>
    rotate x*-45
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object // Radial Hole #3
   {
    Disk_Y
    scale <0.125, 0.2, 0.125 >
    translate <0, 0.84, 0>
    rotate x*-90
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object // Radial Hole #4
   {
    Disk_Y
    scale <0.125, 0.2, 0.125 >
    translate <0, 0.84, 0>
    rotate x*-135
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object // Radial Hole #5
   {
    Disk_Y
    scale <0.125, 0.2, 0.125 >
    translate <0, 0.84, 0>
    rotate x*-180
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object // Radial Hole #6
   {
    Disk_Y
    scale <0.125, 0.2, 0.125 >
    translate <0, 0.84, 0>
    rotate x*-225
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object // Radial Hole #7
   {
    Disk_Y
    scale <0.125, 0.2, 0.125 >
    translate <0, 0.84, 0>
    rotate x*-270
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object // Radial Hole #8
   {
    Disk_Y
    scale <0.125, 0.2, 0.125 >
    translate <0, 0.84, 0>
    rotate x*-315
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object {
    torus {0.68, 0.03
    rotate <  90, 0, 0 >
    translate <  0, 0, 0 >
    scale <  1, 1, 1 >
    rotate <  0, 90, 0 >
    texture { White_Wood scale < 0.17, 0.22, 0.13 > }
    }
    texture { White_Wood scale < 0.17, 0.22, 0.13 > }
    //pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
    bounded_by { object { sphere { <0,0,0>, 0.68 } }
    translate <0, 0, 0>
   }
 }

//
// ---------------------------   5 Hole - Flat Wheel   -----------------------
//

#declare Flat_Wheel = difference
 {
  object  // Main Disk
   {
    Disk_X
    texture { TToyWood scale < 0.77, 0.53, 0.83 > }
    scale < 0.4, 0.65, 0.65>
    translate <0, 0, 0>
   }
  object  // Center Hole
   {
    Disk_X
    scale < 0.55, 0.13, 0.13>
    texture { DMFLightOak scale < 0.17, 0.22, 0.13 > }
    translate <0, 0, 0>
   }
  object // Radial Hole #1
   {
    Disk_Y
    scale <0.125, 0.2, 0.125 >
    translate <0, 0.8, 0>
    rotate x*-45
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object // Radial Hole #2
   {
    Disk_Y
    scale <0.125, 0.2, 0.125 >
    translate <0, 0.8, 0>
    rotate x*-135
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object // Radial Hole #3
   {
    Disk_Y
    scale <0.125, 0.2, 0.125 >
    translate <0, 0.8, 0>
    rotate x*-225
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object // Radial Hole #4

   {
    Disk_Y
    scale <0.125, 0.2, 0.125 >
    translate <0, 0.8, 0>
    rotate x*315
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object // Face Hole #1 - Front
   {
    Disk_X
    scale <0.125, 0.125, 0.125 >
    translate <0.52, 0.47, 0>
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object // Face Hole #2 - Front
   {
    Disk_X
    scale <0.125, 0.125, 0.125 >
    translate <0.52, -0.47, 0>
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object // Face Hole #3 - Front
   {
    Disk_X
    scale <0.125, 0.125, 0.125 >
    translate <0.52, 0, 0.47>
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object // Face Hole #4 - Front
   {
    Disk_X
    scale <0.125, 0.125, 0.125 >
    translate <0.52, 0, -0.47>
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object // Face Hole #1 - Back
   {
    Disk_X
    scale <0.125, 0.125, 0.125 >
    translate <-0.52, 0.47, 0>
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object // Face Hole #2 - Back
   {
    Disk_X
    scale <0.125, 0.125, 0.125 >
    translate <-0.52, -0.47, 0>
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object // Face Hole #3 - Back
   {
    Disk_X
    scale <0.125, 0.125, 0.125 >
    translate <-0.52, 0, 0.47>
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  object // Face Hole #4 - Back
   {
    Disk_X
    scale <0.125, 0.125, 0.125 >
    translate <-0.52, 0, -0.47>
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
  bounded_by { object { sphere { <0,0,0>, 1.7 } }
    translate <0, 0, 0>
   }
 }

//
// ---------------------------   Orange Bushing   -----------------------
// inner bushing ring

#declare irim = difference
    {
     object
      {
       Disk_X
       scale <0.1,0.3,0.3>
       texture { pigment { color Orange } finish { ambient 0.2 }}
      }
    object
      {
       Disk_X
       texture { pigment { color rgbf <1.0,1.0,1.0,1.0> }}
       scale <0.11,0.25,0.25>
      }
    }

// bushing center disk

#declare BCenter = difference
 {
  object  // Main Disk
    {
     Disk_X
     scale <0.2, 0.25, 0.25>
     texture { pigment { color Orange }
     finish { ambient 0.2 }}
     translate <0, 0, 0>
    }
  object  // Center Hole
    {
     box { <-0.3, -0.125, -0.125> <0.3, 0.125, 0.125> }
     texture { pigment { color Orange } finish { reflection 0.1 }}
     translate <0, 0, 0>
    }
 }

// put parts together into 1 bushing object

#declare Orange_Bushing = union
 {
  object  // Main Disk
    {
     BCenter
    }
  object  // inner ring cut-out
    {
     irim
    }
  object  // outer ring
    {
     irim
     scale <1.8,1.3,1.3>
    }
 }

//
// ---------------------------   Orange Connector   -----------------------
//

#declare Orange_Connector = difference
 {
  object  // Main Disk
    {
     Disk_X
     scale <0.8, 0.25, 0.25>
     texture { pigment { color Orange }
     finish { ambient 0.2 }}
     translate <0, 0, 0>
    }
  object  // Center Hole
    {
     Disk_X
     scale <1.1, 0.125, 0.125>
     texture { pigment { color Orange }
     finish { ambient 0.2 }}
     translate <0, 0, 0>
    }
  object // Radial Hole #1
   {
    Disk_Y
    scale <0.13, 1, 0.13 >
    translate <0, 0, 0>
    rotate x*-90
    pigment { color rgbf <1.0,1.0,1.0,1.0> }
   }
 }

