//       Scene by Peter Collins
//         started 18-07-1995
//   last modified 19-07-1995

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
                   

//===========================================================================
#declare The_Metal = texture {
                               Chrome_Metal
                             }
//===========================================================================

#declare Pin =
union {
  cone { <0 0 0> 0.2 <0 -0.7 0> 0.5 }
  cylinder { <0 -0.7 0> <0 -5 0> 0.5 }
  cone { <0 -5 0> 0.5 <0 -5.5 0> 0.7 }
  cylinder { <0 -5.5 0> <0 -6 0> 0.7}
  texture {
    pigment { color rgb<1.0 0.7 0.25> }
    finish  { Metal }
  }
  bounded_by { box { <-0.8 -6.1 -0.8> <0.8 0.1 0.8> } }
}

//===========================================================================

#declare White_Thing =
union {
  difference {
    cylinder { <0 -0.1 0> <0 -7 0> 3.5 }
    cylinder { <0  0.1 0> <0 -6 0> 2.5 }
  }
  texture {
    pigment { color White }
    finish  { reflection 0.1 }
    finish  { specular 0.1 }
  }
  bounded_by { box { <-3.3 -7.1 -3.3> <3.3 0.1 3.3> } }
}

//===========================================================================

#declare Metal_Around_White_Thing =
union {
  difference {
    union {
      cylinder { <0 -0.375 0> <0 -8.5 0> 4 }
      torus { 3.625 0.375  translate <0 -0.375 0> }
    }
    cylinder { <0 0.1 0> <0 -8 0> 3.25   }
    box { <-6 -4 -0.2> <6 0.1 0.2> }
    box { <-6 -4 -0.2> <6 0.1 0.2>  rotate <0  60 0> }
    box { <-6 -4 -0.2> <6 0.1 0.2>  rotate <0 -60 0> }
  }
  texture { The_Metal }
  bounded_by { box { <-4.1 -8.6 -4.1> <4.1 0.1 4.1> } }
}

//===========================================================================

#declare Rubber =
union {
  cylinder { <0 -8 0> <0 -8.6 0> 4.75 }
  texture {
    pigment { color rgb<1 0 0> }
  }
  bounded_by { box { <-4.8 -8.7 -4.8> <4.8 -7.9 4.8> } }
}

//===========================================================================

#declare Metal_Case =
union {
  difference {
    cylinder { <0 0.2 0> <0 -10   0> 5.75 }
    cylinder { <0 0.3 0> <0 -10.1 0> 4.75 }
    cone { <0 -0.3 0> 4.749 <0 0.21 0> 5.05 }
    box { <-12 0.3 -1.25> <12 -6 1.25> }
    cylinder { <0 -6.25 -12> <0 -6.25 12> 1.75 }
    intersection {
      box { <-8 -1.25 -6> <8 1.25 0>
        rotate<0 0 16>  rotate<0 -45 0>  translate<0 -5.55 0>
      }
      box { <0 0 -6> <6 -10 1.249> }
    }
    intersection {
      box { <-8 -1.25 -6> <8 1.25 0>
        rotate<0 0 16>  rotate<0 -45 0>  translate<0 -5.55 0>  rotate<0 180 0>
      }
      box { <-6 0 -1.249> <0 -10 6> }
    }
  }
  difference {
    union {
      cone { <0  0.2 0> 6.525 <0 -0.3  0> 6.875 }
      cylinder { <0 -0.3 0> <0 -1.8 0> 6.875 }
      cone { <0 -2.3 0> 6.525 <0 -1.8 0> 6.875 }
    }
    cylinder { <0 0.3 0> <0 -3 0> 5.749 }
  }
  texture { The_Metal }
  bounded_by { box { <-6.9 -10.1 -6.9> <6.9 0.3 6.9> } }
}

//===========================================================================

#declare Twist =
union {
  cylinder { <0 -8.01 0> <0 -13 0> 6.675 }
  torus { 6.675 0.2  translate <0 -8.21 0> }
  cylinder { <0 -8.21 0> <0 -13.7 0> 6.875 }
  difference {
    torus { 5.875 1  translate<0 -13.7 0> }
    cylinder { <0 -12 0> <0 -15 0> 6.475 }
  }
  cylinder { <0 -13 0> <0 -16 0> 4 }
  union {
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0   0 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0   5 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0  10 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0  15 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0  20 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0  25 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0  30 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0  35 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0  40 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0  45 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0  50 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0  55 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0  60 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0  65 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0  70 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0  75 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0  80 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0  85 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0  90 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0  95 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 100 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 105 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 110 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 115 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 120 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 125 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 130 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 135 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 140 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 145 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 150 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 155 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 160 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 165 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 170 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 175 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 180 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 185 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 190 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 195 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 200 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 205 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 210 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 215 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 220 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 225 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 230 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 235 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 240 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 245 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 250 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 255 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 260 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 265 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 270 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 275 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 280 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 285 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 290 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 295 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 300 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 305 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 310 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 315 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 320 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 325 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 330 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 335 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 340 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 345 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 350 0 >}
    box{<0 -9 0><0.265 -13.25 0.265> translate<4.861 0 4.861> rotate<0 355 0 >}
  }
  texture { The_Metal }
  bounded_by { box { <-7.5 -7.9 -7.5> <7.5 -16.1 7.5> } }
}

//===========================================================================

#declare End_Cap =
union {
  cylinder { <0 -15 0> <0 -25 0> 4.25 }
  texture {
    pigment { color rgb<0.1 1 0.1> }
    finish  { reflection 0.1 }
    finish  { specular 0.1 }
  }
  bounded_by { box { <-4.3 -14.9 -4.3> <4.3 -25.1 4.3> } }
}

//===========================================================================

