//
// This is POV data file to picture oddjunk.jpg by Timo Ettanen.
//

#include "colors.inc"                //Standard include files
#include "shapes.inc"
#include "textures.inc"
#include "stones.inc"

#include "wheel.inc"                 //Includes for this scene
#include "cup.inc"
#include "holder.inc"
#include "room.inc"

      camera {
        location  <55, 42, -85>
        direction <0,0,1.5>
        look_at   <15, 24, 10>
      }

#declare Woodpiece =                     //Smoothed woodpiece
   union{

     box{<0,0.25,0.25><10,19.75,2.75>}
     box{<0.25,0.25,0><9.75,19.75,3> }
     box{<0.25,0,0.25><9.75,20,2.75> }

     cylinder{<0.25,0.25,0.25><0.25,19.75,0.25>,0.25}
     cylinder{<9.75,0.25,0.25><9.75,19.75,0.25>,0.25}
     cylinder{<9.75,0.25,2.75><9.75,19.75,2.75>,0.25}
     cylinder{<0.25,0.25,2.75><0.25,19.75,2.75>,0.25}

     cylinder{<0.25,0.25,0.25><9.75,0.25,0.25>,0.25}
     cylinder{<0.25,0.25,2.75><9.75,0.25,2.75>,0.25}
     cylinder{<0.25,0.25,0.25><0.25,0.25,2.75>,0.25}
     cylinder{<9.75,0.25,0.25><9.75,0.25,2.75>,0.25}

     cylinder{<0.25,19.75,0.25><9.75,19.75,0.25>,0.25}
     cylinder{<0.25,19.75,2.75><9.75,19.75,2.75>,0.25}
     cylinder{<0.25,19.75,0.25><0.25,19.75,2.75>,0.25}
     cylinder{<9.75,19.75,0.25><9.75,19.75,2.75>,0.25}

     sphere{<0.25,0.25,0.25>,0.25}
     sphere{<9.75,0.25,0.25>,0.25}
     sphere{<0.25,0.25,2.75>,0.25}
     sphere{<9.75,0.25,2.75>,0.25}

     sphere{<0.25,19.75,0.25>,0.25}
     sphere{<9.75,19.75,0.25>,0.25}
     sphere{<0.25,19.75,2.75>,0.25}
     sphere{<9.75,19.75,2.75>,0.25}

   bounded_by {box{<-.001,-.001,-.001>,<10.001,20.001,3.001>}}
   }

#declare Boxwood1 =
     object {Woodpiece texture{DMFWood1
                        scale 12
                        rotate<100,0,2>
                        translate<2,1,0.5>}
             }
#declare Boxwood2 =
     object {Woodpiece texture{DMFWood1
                        scale 10
                        rotate<91,0,-3>
                        translate<5,0,1>}
             }
#declare Boxwood3 =
     object {Woodpiece texture{DMFWood1
                        scale 11
                        rotate<80,0,2>
                        translate<7,0,0>}
             }
#declare Woodhole=
     difference{
         cylinder{<0,0,-0.1><0,0,3.1>,4}
         union{
             torus{4,1 rotate<90,0,0> translate<0,0,1>}
             difference{
                 cylinder{<0,0,1><0,0,3.1>,4}
                 cylinder{<0,0,0.999><0,0,3.101>,3.001}
             }
         }
     bounded_by{cylinder{<0,0,-0.11><0,0,3.11>,4}}
       texture{DMFWood1
           scale 10
           rotate<91,0,-3>
           translate<5,0,1>
           translate<-5,-8.5,0>
       }
     }

object {Boxwood1}
difference{
    object {Boxwood2 translate<10,0,0>}
    object {Woodhole translate<15,8.5,0>}
}
cylinder{<0,0,2><0,0,20>,2.9 open translate<15,8.5,0>
      texture{Brass_Metal
      }
}
object {Boxwood3 translate<20,0,0>}

object {Boxwood1 rotate<0,-90,0> translate<30,0,3>}
object {Boxwood2 rotate<0,-90,0> translate<30,0,13>}

object {Boxwood1 rotate<0,-90,0> translate<3,0,3>}
object {Boxwood2 rotate<0,-90,0> translate<3,0,13>}

object {Boxwood3 translate<0,0,23>}
object {Boxwood1 translate<10,0,23>}
object {Boxwood2 translate<20,0,23>}

object {Boxwood3                          //Top of the box
         scale<1,1.3,1>
         rotate<90,0,0>
         translate<0,23,0>}
object {Boxwood1
         scale<1,1.3,1>
         rotate<90,0,0>
         translate<10,23,0>}
object {Boxwood2
         scale<1,1.3,1>
         rotate<90,0,0>
         translate<20,23,0>}

object{Cup
        translate<15,10,0>
}

#declare Cornerpart =
   union{
     object{ Footpart
     }
     object{ Foot
       translate<1,-1.25,1>
     }
   }

object{Cornerpart}

object{Cornerpart
     rotate<0,90,0>
     translate<0,0,26>
}
object{Cornerpart
     rotate<0,180,0>
     translate<30,0,26>
}
object{Cornerpart
     rotate<0,270,0>
     translate<30,0,0>
}

object{Holder
       scale .4
       rotate<0,90,0>
       translate<14,43,13>
}

object{Screw
       rotate<90,0,0>
       rotate<0,90,0>
       translate<22,23.5,11>
}

object{Screw
       rotate<90,0,0>
       rotate<0,30,0>
       translate<22,23.5,15.2>
}

object{Screw
       rotate<90,0,0>
       rotate<0,-30,0>
       translate<17,23.5,13>
}

object{Wheel
      scale 0.3
      translate<33,19,13>
}

cylinder{<30,19,13><35,19,13>,0.55        //axle of wheel
         texture{New_Brass}
}

object{Room}

plane{y,-2.999
    texture{
        pigment{
           bozo
           color_map{
               [0.0  color rgbf<0.9,0.8,0.8,0.9>]
               [0.95  color rgbf<0.9,0.8,0.8,0.9>]
               [0.951  color rgbf<0.7,0.4,0.3,0.5>]
               [1.0  color rgbf<0.7,0.4,0.3,0.5>]
           }
        scale<1.5,2.5,2.5>
        }
    }
}


light_source{<850,300,-1000> color White
      area_light <25, 0, 0>, <0, 23, 0>, 10, 10
      adaptive 1
}
light_source{<80,60,-80> color Gray60
      area_light <5, 0, 0>, <0, 5, 0>, 10, 10
      adaptive 1
}

