// Persistence of Vision Raytracer
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "myshapes.inc"
#include "constants.inc"

#declare Shiny_Rosewood = texture {
 pigment {
   bozo
   turbulence 0.04
   color_map {
      [0.000, 0.256   color red  0.204  green  0.110  blue  0.078  filter  0.000
                      color red  0.231  green  0.125  blue  0.090  filter  0.000]
      [0.256, 0.393   color red  0.231  green  0.125  blue  0.090  filter  0.000
                      color red  0.247  green  0.133  blue  0.090  filter  0.000]
      [0.393, 0.581   color red  0.247  green  0.133  blue  0.090  filter  0.000
                      color red  0.204  green  0.110  blue  0.075  filter  0.000]
      [0.581, 0.726   color red  0.204  green  0.110  blue  0.075  filter  0.000
                      color red  0.259  green  0.122  blue  0.102  filter  0.000]
      [0.726, 0.983   color red  0.259  green  0.122  blue  0.102  filter  0.000
                      color red  0.231  green  0.125  blue  0.086  filter  0.000]
      [0.983, 1       color red  0.231  green  0.125  blue  0.086  filter  0.000
                      color red  0.204  green  0.110  blue  0.078  filter  0.000]
   }
   scale <0.5, 0.5, 1>
   translate <10, 0, 0>
 }
 finish {
   ambient 0.5
   diffuse 0.8
 }
}
// Rosewood layer 2
texture {
 pigment {
   wood
   turbulence 0.04
   color_map {
      [0.000, 0.139   color red  0.545  green  0.349  blue  0.247  filter  1.000
                      color red  0.000  green  0.000  blue  0.000  filter  0.004]
      [0.139, 0.148   color red  0.000  green  0.000  blue  0.000  filter  0.004
                      color red  0.000  green  0.000  blue  0.000  filter  0.004]
      [0.148, 0.287   color red  0.000  green  0.000  blue  0.000  filter  0.004
                      color red  0.545  green  0.349  blue  0.247  filter  1.000]
      [0.287, 0.443   color red  0.545  green  0.349  blue  0.247  filter  1.000
                      color red  0.545  green  0.349  blue  0.247  filter  1.000]
      [0.443, 0.626   color red  0.545  green  0.349  blue  0.247  filter  1.000
                      color red  0.000  green  0.000  blue  0.000  filter  0.004]
      [0.626, 0.635   color red  0.000  green  0.000  blue  0.000  filter  0.004
                      color red  0.000  green  0.000  blue  0.000  filter  0.004]
      [0.635, 0.843   color red  0.000  green  0.000  blue  0.000  filter  0.004
                      color red  0.545  green  0.349  blue  0.247  filter  1.000]
      [0.843, 1       color red  0.545  green  0.349  blue  0.247  filter  1.000
                      color red  0.545  green  0.349  blue  0.247  filter  1.000]
   }
   scale <0.5, 0.5, 1>
   translate <10, 0, 0>
 }
 finish {Shiny}
}

#declare SpnwhlTexture = texture{ 
  Shiny_Rosewood
}

object { // the sun
  //light_source { <240.0,  2400.0,  2400.0> color White }
  light_source { <17633,  176336.0,  176336.0> color White }
}

object { // room lighting
  light_source { <60.0,  120.0,  -100.0> color Gray95 
  area_light <8, 0, 0>, <0, 8, 0>, 5, 5
  adaptive 1
  }
}

object {  // room lighting
  light_source { <-50.0,  120.0,  -50.0> color Gray85 
  area_light <8, 0, 0>, <0, 0, 8>, 5, 5
  adaptive 1
  }
}


object { // outside ground
   height_field { gif "surf001.gif" smooth
     texture {
       pigment 
        {gradient y
         color_map 
          {[0.00, 1.001 color ForestGreen  
                        color Green]
          }
        }
     }
     translate <-0.5,-1.0,-0.5>
   }
   scale <500000.0, 2000.0, 500000.0>
 }

object { //The Sky
   sphere { <0.0, 0.0, 0.0>, 250010.0  }
   texture {
     pigment { 
        Blue_Sky3
        scale <25000.0, 25000.0, 25000.0>
        rotate <40.0,10,15>
     }
     finish {
        ambient 0.7
        diffuse 0.0
     }
   }
 }

object { // wood floor
   intersection {
     plane { 1.0*y 0.0}
     plane { 1.0*z 0.0}
   }
   texture {
     pigment {
       image_map {
         gif "hardoak.gif" 
         map_type 0
         interpolate 2
       }
     }
     scale <2*44.297, 2*30.0, 1.0>
     rotate 90*x
   }
   translate 18*z
 }

#include "windowa.inc"
object { 
  union {
    object { Window 
      texture {
        pigment {Gray95}
        finish {Shiny}
      } 
    }
    object { WindowWall1
      texture {
        pigment {
          image_map {
            gif "txtur001.gif" 
            map_type 0
            //interpolate 2
          }
          scale <10.0 10.0 1.0>
        }
        //pigment {LightBlue}
        //finish {crand 0.05}
      } 
    }
  }
  scale<1.0,1.0,1.0> 
  rotate<0.0, 0.0, 0.0>
  translate<36.0, 44.0, 18.0> 
}

object { WindowWall1
  texture {
    pigment {White}
    finish {Dull}
  } 
  scale<1.0,1.0,1.0> 
  rotate<0.0, 90.0, 0.0>
  translate<136.0, 44.0, -82.0> 
}

object { WindowWall1
  texture {
    pigment {White}
    finish {Dull}
  } 
  scale<1.0,1.0,1.0> 
  rotate<0.0, -90.0, 0.0>
  translate<-64.0, 44.0, -82.0> 
}

object { WindowWall1
  texture {
    pigment {White}
    finish {Dull}
  } 
  scale<1.0,1.0,1.0> 
  rotate<0.0, 180.0, 0.0>
  translate<36.0, 44.0, -182.0> 
}

#include "picture.inc"
#declare PictureAndFrame = object {
  union {
    object { PictureFrame
      scale <1.0,1.0,1.0>
    }
    object { // picture in the frame
      box { <-9.0, -6.75, -.0625 > < 9.0, 6.75, 0.0625 > }
      texture {
        pigment {
          image_map {
            gif "house004.gif"  
            once
            map_type 0
            interpolate 2
          }
          quick_color Blue
        }
        scale <18.0, 13.5, 1.0>
        translate <-9.0, -6.75, 0.0>
      }
    }
  }
  bounded_by {box {<-11.3, -9.0, -.30> <11.3, 9.0, .30>}}
}

object { PictureAndFrame
  translate <1.0,35.0,13.75> 
}


#include "spnwhl.inc"
object { SpinningWheel
  scale<1.0,1.0,1.0> 
  rotate<0.0, 22.5, 0.0>
  translate<2.0, 0.0, 0.0> 
}                       

camera {                                                               
   location <10.0, 40.0, -100.0>                                          
   direction <0.0, 0.0,  2.0>
   up  <0.0,  1.0,  0.0>
   right <4/3, 0.0, 0.0>
   look_at <20.0, 20.0, 0.0>
}
