//George W. Hart                June 1995             File: ARTIFRAD.POV
#include "colors.inc"
#include "textures.inc"

object{light_source { <3.7, 3.7, -0.8> color White}}  //near camera for flat look

camera{  
   location  <4.4, 4.2, -2>
   direction <0.0, 2.4, 0.0>
   sky       <0.0, 0.0, 1.0>
   up        <0.0, 0.0, 1.0>
   right     <1.3333, 0.0, 0.0>
   look_at   <0, 0, 0>
   }

fog{
   color Black     // the fog color --- to make far side slightly darker
   distance 5.0    // distance for 67% fog color
   }

#declare Rtexture=texture{           //"bony" texture
      pigment {White}
      finish {Dull ambient .5}
      normal {bumps 0.7  scale 0.01} 
      }

//object is really a complex geodesic polyhedron.
//edges of polyhedron made of "struts".  3 parts per strut and six struts
//around each hole combine to make 18-sided hole.  Looks round.
#declare strut=union{                    //squished "hourglass". 
   cylinder{<0,0,-0.3> <0,0,0.3> .05} 
   cone{<0,0,-1> 0.08 <0,0,-.3> 0.05}
   cone{<0,0, 1> 0.08 <0,0, .3> 0.05}
   scale <1,5,0.98>
   }            


// "Prong" sticks out from most vertices of polyhedron.  Each the same:
//    3 curved fingers (produced with lsystem) on a 4-part pedastal.

declare c=1.1   //width factor for tendrils
#declare l_start1 = object { cone { <0,0.0,0> c*.5  <0, 0.3, 0> c*.25} }
#declare l_start2 = object { cone { <0,0.3,0> c*.25 <0, 0.7, 0> c*.15} }
#declare l_start3 = object { cone { <0,0.7,0> c*.15 <0, 2.0, 0> c*.20} }
#declare l_start4 = object { cone { <0,2.0,0> c*.20 <0, 2.5, 0> c*.35} }
#declare l_base = object { cone { <0,0,0> c*.75/2 <0, 1.6, 0> c*.35/2} }  //base obj.

#declare prong=union{
object{l_start1   scale<21, 14, 21>rotate<0, -90, 0>}
object{l_start2   scale<21, 14, 21>rotate<0, -90, 0>}
object{l_start3   scale<21, 14, 21>rotate<0, -90, 0>}
object{l_start3   scale<21, 14, 21>rotate<0, -90, 0>}
union{     //next 15 lines are output of lparser when given artifrad.ls as input.
  object{l_base scale<14, 11.6667, 14>rotate<0, 0, -44.7669>rotate<0, 0, 0>translate<0, 0, 0>}
  object{l_base scale<8.96, 9.33333, 8.96>rotate<0, 0, -32.2744>rotate<0, -342.082, 0>translate<11.785, 11.7853, 0>}
  object{l_base scale<5.7344, 7.46667, 5.7344>rotate<0, 0, -15.1934>rotate<0, -328.244, 0>translate<18.6555, 23.0377, -1.98865>}
  object{l_base scale<3.67002, 5.97333, 3.67002>rotate<0, 0, -12.1879>rotate<0, -227.014, 0>translate<21.0875, 33.3277, -3.39572>}
  object{l_base scale<2.34881, 4.77867, 2.34881>rotate<0, 0, -29.2266>rotate<0, -218.756, 0>translate<19.8804, 41.6667, -4.74543>}
  object{l_base scale<14, 11.6667, 14>rotate<0, 0, -44.7669>rotate<0, -238.763, 0>translate<0, 0, 0>}
  object{l_base scale<8.96, 9.33333, 8.96>rotate<0, 0, -63.3632>rotate<0, -246.035, 0>translate<-5.89212, 11.7853, -10.2063>}
  object{l_base scale<5.7344, 7.46667, 5.7344>rotate<0, 0, -81.6663>rotate<0, -252.715, 0>translate<-10.5023, 17.6945, -21.2337>}
  object{l_base scale<3.67002, 5.97333, 3.67002>rotate<0, 0, -87.6166>rotate<0, -258.094, 0>translate<-13.4097, 19.1625, -31.391>}
  object{l_base scale<2.34881, 4.77867, 2.34881>rotate<0, 0, -104.712>rotate<0, -269.494, 0>translate<-14.9736, 19.4497, -39.7749>}
  object{l_base scale<14, 11.6667, 14>rotate<0, 0, -44.7669>rotate<0, -119.384, 0>translate<0, 0, 0>}
  object{l_base scale<8.96, 9.33333, 8.96>rotate<0, 0, -33.6856>rotate<0, -94.229, 0>translate<-5.8932, 11.7853, 10.2057>}
  object{l_base scale<5.7344, 7.46667, 5.7344>rotate<0, 0, -39.5742>rotate<0, -57.0403, 0>translate<-6.50424, 22.8572, 17.6094>}
  object{l_base scale<3.67002, 5.97333, 3.67002>rotate<0, 0, -57.3185>rotate<0, -33.5681, 0>translate<-2.82078, 31.0547, 23.355>}
  object{l_base scale<2.34881, 4.77867, 2.34881>rotate<0, 0, -65.4118>rotate<0, -20.0703, 0>translate<3.17149, 35.6251, 27.3578>}
  translate <0,30,0>
  }
   scale .001
   rotate <0,0,-90>
   scale <3.3, 3, 3>
   }

//set of prongs and struts is output of GeoMaker with the following parameters: 
//        freq=6, twist=1, check hex pat, .25 random perturb, 
//        edge obj=strut (check only vary length), non-5-vertexobj=prong
union{                    
   #include "geomaker.out"   
   texture {Rtexture}
   no_shadow           //for photomicrograph appearance, want no shadows
   }
