#include "piano.inc"
#include "painting.inc"
#include "room.inc"
#include "desktop.inc"
#include "micrscop.inc"

camera {
  location <0,20,-84>
  direction <0,0,2.5>
  up <0,1,0>
  right <1.25,0,0>
  look_at <0,0,0>
}

light_source { <10,40,-10> color rgb<1,1,1> 
  area_light <6,0,0>,<0,0,6>,3,3
  jitter
}

#declare DESK =
union {
  object { Desk }
  object { Keyboard rotate -90*y translate <0,-2.46,4.25> }
  object { ComputerMonitor rotate -6*y translate -z }
  rotate 90*y
  translate <7.5,12,-48>
}

#declare PIANO =
object { GrandPiano scale 2.5 rotate 20*y translate <-10,2.25,-5> }

object { DESK }
object { PIANO }
object { PAINTING }
object { ROOM }
object { MICROSCOPE scale .3 rotate -42*y translate <-5,10.5,-54> }
box { <-100,-6,-100>,<4,-3,4> rotate 6*y translate <-5,10.5,-54> 
  texture { POLISHED_METAL2 }
}
