#declare CHROME =
texture {
  pigment {
    rgb<.9,.91,.98>
  }
  finish {
    metallic
    reflection .35
    brilliance 20
    phong .6
    ambient 0
    specular .3
  }
}

#declare SHINY_BLACK =
texture {
  pigment {
    rgb<0,0,0>
  }
  finish {
    reflection .15
    phong .8
    specular .4
  }
}

#declare GLASS =
texture {
  pigment {
    rgbf<1,1,1,1>
  }
  finish {
    reflection .1
    refraction .25
    ior 2
    specular .2
  }
}

#declare subtract_curve =
union {
  box { <-20,-50,-100>,<20,100,-4.99> rotate -24*x translate 14.5*y }
  box { <-20,8,-5>,<20,14.5,6> }
  box { <-20,14.5,-1.5>,<20,18,2.5> }
  cylinder { <-20,14.5,-1.5>,<20,14.5,-1.5>,3.5 }
  cylinder { <-20,14.5,2.5>,<20,14.5,2.5>,3.5 }
  rotate 48*x
  translate <0,-10,-10>
}

#declare body_sillhouette =
intersection {
  difference {
    box { <-10,-10,-10>,<10,10,10> }
    object { subtract_curve }
    box { <-20,-9.1,-20>,<20,2,-.1> }
    box { <-20,-12,-20>,<20,2,-6.25> }
  }
  cylinder { <-10,-10,-10>,<10,-10,-10>,20 }
}

#declare Sillhouette2 =
union {
  intersection {
    box { <0,-100,-100>,<100,100,100> rotate -3.5*z translate -x }
    box { <-100,-100,-100>,<0,100,100> rotate 3.5*z translate x }
  }
  sphere { <0,-10,5>,7 scale <.6,1.8,1.08> }
}

#declare Body =
union {
  difference {
    intersection {
      union {
        object { body_sillhouette }
        box { <-20,-4.7,-4.1>,<20,-4.2,8> }
      }
      object { Sillhouette2 }
    }
    box { <-100,-12,-.1>,<-.55,5,-10> }
    box { <.55,-12,-.1>,<100,5,-10> }
  }
  difference {
    sphere { <0,-10,-6.25>,1.5 }
    box { <-2,-12,-4>,<2,-10,-8.5> }
  }
}

#declare Shaft =
union {
  cylinder { <0,6.7,0>,<0,-.7,0>,1.225 }
  cylinder { <0,-1,0>,<0,-4,0>,1.225 }
  cylinder { <0,6.7,0>,<0,10.2,0>,.75 }
  scale <1.15,1.2,1.15>
  translate <0,1.75,-5.8>
  rotate -24*x 
  translate 14.5*y
  rotate 48*x
  translate <0,-10,-10>
}

#declare ChromeShaft =
union {
  cylinder { <0,-4.25,0>,<0,0,0>,1 }
  cylinder { <0,6.65,0>,<0,6.8,0>,1.32 }
  cylinder { <0,10.15,0>,<0,10.45,0>,1.05 }
  cylinder { <-2,3,1.2>,<-1.65,3,1.2>,1.25 }
  cylinder { <-1.65,3,1.2>,<0,3,1.2>,.675 }
  scale <1.15,1.2,1.15>
  translate <0,1.75,-5.8>
  rotate -24*x 
  translate 14.5*y
  rotate 48*x
  translate <0,-10,-10>
}

#declare Lenses =
union { 
  sphere { <0,0,0>,.95 }
  cylinder { <0,0,0>,<0,-1.45,0>,.25 rotate 24*z rotate -30*y translate <.0707106781187,0,.0707106781187> }
  cylinder { <0,0,0>,<0,-1.45,0>,.25 rotate 24*z rotate 90*y translate -.1*z }
  cylinder { <0,0,0>,<0,-1.45,0>,.25 rotate -24*z rotate 30*y translate <-.0707106781187,0,.0707106781187> }
  translate -4*y
  scale <1.15,1.2,1.15>
  translate <0,1.75,-5.8>
  rotate -24*x 
  translate 14.5*y
  rotate 48*x
  translate <0,-10,-10>
}

#declare Light =
cylinder { <0,-10,-6.25>,<0,-8.1,-6.25>,.85 }

#declare Leg =
difference {
  union {
    cylinder { <-.9,-10,0>,<.9,-10,0>,1.25  scale <1,1,1.3> translate -5*z }
    cylinder { <-.9,-10,0>,<.9,-10,0>,1.25  scale <1,1,1.3> translate 4.5*z }
    box { <-.9,-10,4.5>,<.9,-8.75,-5> }
  }
  box { <-20,-20,-20>,<20,-10,20> }
}

#declare Legs =
union { 
  object { Leg translate 3.6*x }
  object { Leg translate -3.6*x }
}

#declare GlassPlate =
box { <-1.85,-4.65,-7>,<1.85,-4.35,-4.1> }

#declare Slide =
box { <-1.6,-4.35,-6.5>,<1.6,-4.15,-5.5> }

#declare SlidePins =
union {
  cylinder { <-1.4,-4.7,-4.3>,<-1.4,-3.95,-4.3>,.25 }
  cylinder { <1.4,-4.7,-4.3>,<1.4,-3.95,-4.3>,.25 }
  box { <-1.7,-4.15,-6.7>,<-1.1,-4.05,-4.3> }
  box { <1.1,-4.15,-6.7>,<1.7,-4.05,-4.3> }
}

#declare PLASTIC_STUFF =
union {
  object { Body }
  object { Shaft }
  object { Legs }
  texture { SHINY_BLACK }
}

#declare CHROME_STUFF =
union {
  object { ChromeShaft }
  object { Lenses }
  object { Light }
  object { SlidePins }
  texture { CHROME }
}

#declare GLASS_STUFF =
union {
  object { GlassPlate }
  object { Slide }
  texture { GLASS }
}

#declare MICROSCOPE =
union {
  object { PLASTIC_STUFF }
  object { GLASS_STUFF }
  object { CHROME_STUFF } 
}

