//Object file to be included with science.pov
//Pen and spectacles objects borrowed from another user
//




//begin stool**********************************
#declare stoolbound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <3.405049, 3.656579, 7.625800>
  translate <-0.115042, -0.131722, -0.937500>
}

#declare chairback = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    chairtex
  }
  scale <2.000000, 2.000000, 0.600000>
  rotate <-90.000000, 0.000000, 0.000000>
}

#declare back_clip = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    chairtex
  }
  scale <2.000000, 0.700000, 1.000000>
  translate <0.000000, 0.300000, 2.500000>
}

#declare back_clip1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    chairtex
  }
  scale <2.000000, 0.700000, 1.000000>
  translate <0.000000, 0.300000, -2.500000>
}

#declare back = difference {
  object { chairback }
  object { back_clip }
  object { back_clip1 }
  scale <1.300000, 1.000000, 1.000000>
  translate <0.000000, -3.200000, 3.000000>
}

#declare chairseat = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    chairtex
  }
  scale <2.700000, 2.300000, 0.600000>
  translate <0.000000, 0.000000, -1.000000>
}

#declare shaft = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver1
  }
  scale <0.300000, 0.300000, 6.000000>
  translate <0.000000, 0.000000, -6.800000>
}

#declare footring = torus { 
  2.400, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    Silver1
  }
}

#declare footsup = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver1
  }
  scale <0.150000, 0.150000, 4.600000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-0.022204, -2.292586, 0.000000>
}

#declare footsup1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver1
  }
  scale <0.150000, 0.150000, 4.600000>
  rotate <-90.000000, 0.000000, -90.000000>
  translate <-2.324525, 0.009735, 0.000000>
}

#declare footrest = union {
  object { footring }
  object { footsup }
  object { footsup1 }
  translate <0.000000, 0.000000, -5.000000>
}
#declare footring1 = torus { 
  2.400, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    Silver1
  }
  scale <1.000000, 1.000000, 1.300000>
}

#declare footsup2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver1
  }
  scale <0.150000, 0.150000, 4.600000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-0.022204, -2.292586, 0.000000>
}

#declare footsup3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver1
  }
  scale <0.150000, 0.150000, 4.600000>
  rotate <-90.000000, 0.000000, -90.000000>
  translate <-2.324525, 0.009735, 0.000000>
}

#declare wheel = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    wheeltex
  }
  scale <0.500000, 0.500000, 0.300000>
  rotate <-90.000000, 0.000000, -45.000000>
  translate <-0.195897, 2.171832, -0.600000>
}

#declare wheel1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    wheeltex
  }
  scale <0.500000, 0.500000, 0.300000>
  rotate <-90.000000, 0.000000, 27.000000>
  translate <2.317885, -0.116123, -0.600000>
}

#declare wheel2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    wheeltex
  }
  scale <0.500000, 0.500000, 0.300000>
  rotate <-90.000000, 0.000000, -67.000000>
  translate <-0.130598, -2.462860, -0.600000>
}

#declare wheel3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    wheeltex
  }
  scale <0.500000, 0.500000, 0.300000>
  rotate <-90.000000, 0.000000, -15.000000>
  translate <-2.379661, -0.148773, -0.600000>
}

#declare wheelbase = union {
  object { footring1 }
  object { footsup2 }
  object { footsup3 }
  object { wheel }
  object { wheel1 }
  object { wheel2 }
  object { wheel3 }
  scale <1.250000, 1.250000, 1.250000>
  rotate <0.000000, 0.000000, -67.000000>
  translate <0.000000, 0.000000, -7.000000>
}
#declare backsupport = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Silver1
  }
  scale <0.500000, 1.000000, 0.100000>
}

#declare backsupport1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Silver1
  }
  scale <0.500000, 2.000000, 0.100000>
  rotate <90.000000, 0.000000, 0.000000>
  translate <0.000000, -1.000000, 1.900000>
}

#declare support = union {
  object { backsupport }
  object { backsupport1 }
  translate <0.000000, -2.300000, -1.100000>
}
#declare stool =
union {   // labstool
  object { back }
  object { chairseat }
  object { shaft }
  object { footrest }
  object { wheelbase }
  object { support }
  bounded_by { stoolbound }
}
//end stool

//begin microscope*******************************
#declare basefeet = torus { 
  3.250, 0.750  // Major, minor radius
  rotate -x*90
  texture {
    feet_tex
  }
}

#declare feet_clip = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    feet_tex
  }
  scale <4.200000, 2.200000, 1.000000>
  translate <0.000000, 2.000000, 0.000000>
}

#declare feet = difference {
  object { basefeet }
  object { feet_clip }
}

#declare base_ends = object { 
  sphere {<0,0,0>,1}
  texture {
    feet_tex
  }
  scale <0.750000, 0.750000, 0.750000>
  translate <3.246787, 0.005546, 0.000000>
}

#declare base_ends1 = object { 
  sphere {<0,0,0>,1}
  texture {
    feet_tex
  }
  scale <0.750000, 0.750000, 0.750000>
  translate <-3.247000, 0.005546, 0.000000>
}

#declare base = union {
  object { feet }
  object { base_ends }
  object { base_ends1 }
  scale <1.000000, 1.500000, 1.000000>
  translate <0.000000, 3.000000, -9.000000>
}

#declare condenser = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Gold_Texture
  }
  scale <1.250000, 1.250000, 1.750000>
  translate <0.000000, 0.413690, -8.894338>
}

#declare upperbase = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    feet_tex
  }
  scale <2.000000, 0.750000, 4.500000>
  translate <0.000000, -1.654761, -4.757436>
}

#declare stage = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    stage_tex
  }
  scale <3.000000, 3.000000, 0.300000>
  translate <0.000000, 1.000000, -4.000000>
}

#declare knob = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    stage_tex
  }
  scale <1.200000, 1.200000, 0.700000>
  rotate <-90.000000, 0.000000, -90.000000>
  translate <3.000000, -1.500000, -4.000000>
}

#declare knob1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    stage_tex
  }
  scale <1.200000, 1.200000, 0.700000>
  rotate <-90.000000, 0.000000, -90.000000>
  translate <-3.700000, -1.500000, -4.000000>
}

#declare turretdisc = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver1
  }
  scale <1.750000, 1.750000, 0.750000>
}

#declare lens = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver_Texture
  }
  scale <0.500000, 0.500000, 1.750000>
  rotate <30.000000, 0.000000, 0.000000>
  translate <0.000000, 1.837416, -1.336303>
}

#declare lens1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver_Texture
  }
  scale <0.500000, 0.500000, 1.750000>
  rotate <30.000000, 0.000000, -120.000000>
  translate <1.837416, -1.002227, -1.336303>
}

#declare lens2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver_Texture
  }
  scale <0.500000, 0.500000, 1.750000>
  rotate <30.000000, 0.000000, -240.000000>
  translate <-1.781737, -1.113586, -1.336303>
}

#declare turret = union {
  object { turretdisc }
  object { lens }
  object { lens1 }
  object { lens2 }
  rotate <-30.000000, 0.000000, -180.000000>
  translate <0.000000, 1.164059, -0.851061>
}
#declare main_tube = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Gold_Texture
  }
  scale <1.250000, 1.250000, 7.000000>
}

#declare eyepiece = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    eye_tex
  }
  scale <0.750000, 0.750000, 2.000000>
  translate <0.000000, 0.000000, 7.000000>
}

#declare turretball = object { 
  sphere {<0,0,0>,1}
  texture {
    Gold_Texture
  }
  scale <1.700000, 1.700000, 1.000000>
}

#declare tubebody = union {
  object { main_tube }
  object { eyepiece }
  object { turretball }
  rotate <45.000000, 0.000000, 0.000000>
}
#declare microscope =
union {   // microscope
  object { base }
  object { condenser }
  object { upperbase }
  object { stage }
  object { knob }
  object { knob1 }
  object { turret }
  object { tubebody }
}
//end microscope

//begin cancer manuscript*************************
#declare canmssbound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <9.339431, 0.435384, 11.705165>
  translate <0.000000, 0.130000, 0.000000>
}

#declare cancersheet = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    CANCERTex
    scale <2.000000, 2.000000, 1.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-1.000000, -0.456707, -1.026220>
  }
  scale <8.500000, 0.010000, 11.000000>
  translate <0.000000, -0.020000, 0.000000>
}

#declare aidssheet = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    AIDSTex
    scale <2.000000, 2.000000, 1.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-1.000000, -0.456707, -1.026220>
  }
  scale <8.500000, 0.010000, 11.000000>
  translate <0.000000, -0.020000, 0.000000>
}


#declare undersheet = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  translate <0.000000, -0.020000, 0.000000>
}

#declare undersheet1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -0.300000, 0.000000>
  translate <0.000000, 0.010000, 0.000000>
}

#declare undersheet2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -0.600000, 0.000000>
  translate <0.000000, 0.040000, 0.000000>
}

#declare undersheet3 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -0.900000, 0.000000>
  translate <0.000000, 0.070000, 0.000000>
}

#declare undersheet4 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -1.200000, 0.000000>
  translate <0.000000, 0.100000, 0.000000>
}

#declare undersheet5 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -1.500000, 0.000000>
  translate <0.000000, 0.130000, 0.000000>
}

#declare undersheet6 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -1.800000, 0.000000>
  translate <0.000000, 0.160000, 0.000000>
}

#declare undersheet7 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -2.100000, 0.000000>
  translate <0.000000, 0.190000, 0.000000>
}

#declare undersheet8 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -2.400000, 0.000000>
  translate <0.000000, 0.220000, 0.000000>
}

#declare undersheet9 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -2.700000, 0.000000>
  translate <0.000000, 0.250000, 0.000000>
}

#declare undersheet10 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -3.000000, 0.000000>
  translate <0.000000, 0.280000, 0.000000>
}
#declare cancermss =
union {   // canmss
  object { cancersheet }
  object { undersheet }
  object { undersheet1 }
  object { undersheet2 }
  object { undersheet3 }
  object { undersheet4 }
  object { undersheet5 }
  object { undersheet6 }
  object { undersheet7 }
  object { undersheet8 }
  object { undersheet9 }
  object { undersheet10 }
  bounded_by { canmssbound }
}
#declare aidsmss =
union {   // canmss
  object { aidssheet }
  object { undersheet }
  object { undersheet1 }
  object { undersheet2 }
  object { undersheet3 }
  object { undersheet4 }
  object { undersheet5 }
  object { undersheet6 }
  object { undersheet7 }
  object { undersheet8 }
  object { undersheet9 }
  object { undersheet10 }
  bounded_by { canmssbound }
}

//end cancer manuscript

//begin grant************************************
#declare grantbound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <12.084455, 0.454845, 13.578635>
  translate <0.000000, 0.090000, 0.000000>
}

#declare coversheet1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    GRANTTex
    scale <2.000000, 2.000000, 1.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-1.000000, -0.456707, -1.026220>
  }
  scale <8.500000, 0.010000, 11.000000>
  translate <0.000000, -0.020000, 0.000000>
}

#declare undersheets = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
}

#declare undersheets1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -1.000000, 0.000000>
  translate <0.000000, 0.010000, 0.000000>
}

#declare undersheets2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -2.000000, 0.000000>
  translate <0.000000, 0.020000, 0.000000>
}

#declare undersheets3 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -3.000000, 0.000000>
  translate <0.000000, 0.030000, 0.000000>
}

#declare undersheets4 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -4.000000, 0.000000>
  translate <0.000000, 0.040000, 0.000000>
}

#declare undersheets5 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -5.000000, 0.000000>
  translate <0.000000, 0.050000, 0.000000>
}

#declare undersheets6 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -6.000000, 0.000000>
  translate <0.000000, 0.060000, 0.000000>
}

#declare undersheets7 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -7.000000, 0.000000>
  translate <0.000000, 0.070000, 0.000000>
}

#declare undersheets8 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -8.000000, 0.000000>
  translate <0.000000, 0.080000, 0.000000>
}

#declare undersheets9 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -9.000000, 0.000000>
  translate <0.000000, 0.090000, 0.000000>
}

#declare undersheets10 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.000000, 0.100000, 0.000000>
}

#declare undersheets11 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -11.000000, 0.000000>
  translate <0.000000, 0.110000, 0.000000>
}

#declare undersheets12 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -12.000000, 0.000000>
  translate <0.000000, 0.120000, 0.000000>
}

#declare undersheets13 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -13.000000, 0.000000>
  translate <0.000000, 0.130000, 0.000000>
}

#declare undersheets14 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -14.000000, 0.000000>
  translate <0.000000, 0.140000, 0.000000>
}

#declare undersheets15 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -15.000000, 0.000000>
  translate <0.000000, 0.150000, 0.000000>
}

#declare undersheets16 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -16.000000, 0.000000>
  translate <0.000000, 0.160000, 0.000000>
}

#declare undersheets17 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -17.000000, 0.000000>
  translate <0.000000, 0.170000, 0.000000>
}

#declare undersheets18 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -18.000000, 0.000000>
  translate <0.000000, 0.180000, 0.000000>
}

#declare undersheets19 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -19.000000, 0.000000>
  translate <0.000000, 0.190000, 0.000000>
}

#declare undersheets20 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    under_tex
  }
  scale <8.500000, 0.010000, 11.000000>
  rotate <0.000000, -20.000000, 0.000000>
  translate <0.000000, 0.200000, 0.000000>
}
#declare grant =
union {
  object { coversheet1 }
  object { undersheets }
  object { undersheets1 }
  object { undersheets2 }
  object { undersheets3 }
  object { undersheets4 }
  object { undersheets5 }
  object { undersheets6 }
  object { undersheets7 }
  object { undersheets8 }
  object { undersheets9 }
  object { undersheets10 }
  object { undersheets11 }
  object { undersheets12 }
  object { undersheets13 }
  object { undersheets14 }
  object { undersheets15 }
  object { undersheets16 }
  object { undersheets17 }
  object { undersheets18 }
  object { undersheets19 }
  object { undersheets20 }
  bounded_by { grantbound }
}
//end grant

//begin pen**************************************
#declare penbound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <0.600000, 0.600000, 9.000000>
  translate <0.192113, 0.108057, 4.869744>
}

#declare pencylinder = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    pentex
  }
  scale <0.500000, 0.500000, 5.000000>
}

#declare pensphere = object { 
  sphere {<0,0,0>,1}
  scale <0.500000, 0.500000, 3.000000>
}

#declare pentip = object { 
  sphere {<0,0,0>,1}
  texture {
    Gold_Texture
  }
  scale <0.100000, 0.100000, 1.000000>
  translate <0.000000, 0.000000, -2.615658>
}

#declare pencylinder1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    pentex
  }
  scale <0.500000, 0.500000, 5.000000>
  translate <0.000000, 0.000000, 5.298993>
}

#declare penband = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver_Texture
  }
  scale <0.500000, 0.500000, 0.300000>
  translate <0.000000, 0.000000, 5.005853>
}

#declare penend = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    pentex
  }
  scale <0.500000, 0.500000, 3.000000>
  rotate <-180.000000, 0.000000, 0.000000>
  translate <0.000000, 0.000000, 13.325949>
}

#declare penclip = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.500000, 0.500000, 1.000000>
  translate <0.000000, 0.000000, 12.480613>
}

#declare pendiff = difference {
  object { penend }
  object { penclip }
}

#declare penbutton = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver_Texture
  }
  scale <0.150000, 0.150000, 1.000000>
  translate <0.000000, 0.000000, 11.463962>
}

#declare pocketbox = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.182959, 0.183000, 0.346367>
  translate <0.653633, -0.426498, 9.199953>
}

#declare pocketbox1 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.065373, 0.183000, 1.686316>
  translate <0.761058, -0.426498, 7.239053>
}

#declare pocketball = object { 
  sphere {<0,0,0>,1}
  scale <0.250000, 0.250000, 0.415071>
  translate <0.731161, -0.424229, 5.966479>
}

#declare ballclip = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.268839, 0.337517, 0.597862>
  translate <1.096741, -0.433162, 6.007807>
}

#declare balldiff = difference {
  object { pocketball }
  object { ballclip }
}

#declare pocketclip = union {
  object { pocketbox }
  object { pocketbox1 }
  object { balldiff }
  texture {
    Silver_Texture
  }
  translate <0.000000, 0.407682, -0.050960>
}
#declare pen =
union {   // pen
  object { pencylinder }
  object { pensphere }
  object { pentip }
  object { pencylinder1 }
  object { penband }
  object { pendiff }
  object { penbutton }
  object { pocketclip }
  texture {
    pentex
  }
  bounded_by { penbound }
}
//end pen

//begin spectacles********************************
#declare specbound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <6.000000, 7.000000, 2.200000>
  rotate <355.863220, -359.739197, 0.000000>
  translate <-17.782187, -2.965798, -18.319700>
}

#declare Torus001 = torus { 
  1.900, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    Gold_Texture
  }
  rotate <90.000000, 0.000000, 0.000000>
  translate <-20.790936, -9.128205, -17.876788>
}

#declare Torus2 = torus { 
  1.900, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    Gold_Texture
  }
  rotate <90.000000, 0.000000, 0.000000>
  translate <-15.059753, -9.128205, -17.876788>
}

#declare Torus002 = torus { 
  1.925, 0.075  // Major, minor radius
  rotate -x*90
  scale <0.800000, 0.800000, 0.800000>
  rotate <90.000000, 0.000000, 0.000000>
  translate <-17.936610, -8.802197, -17.876788>
}

#declare clip1 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.701615, 1.000000, 1.308711>
  translate <-17.981147, -8.802197, -18.339690>
}

#declare bridge = difference {
  object { Torus002 }
  object { clip1 }
}

#declare Cone2 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.200000, 0.500000, 12.000000>
  rotate <90.000000, 0.000000, 0.000000>
  translate <-12.800517, 3.423077, -18.043271>
}

#declare clip3 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.489492, 2.172019, 0.906238>
  translate <-12.756831, 1.521017, -18.026072>
}

#declare brace1 = difference {
  object { Cone2 }
  object { clip3 }
}

#declare Torus003 = torus { 
  1.850, 0.150  // Major, minor radius
  rotate -x*90
  rotate <90.000000, 0.000000, -90.000000>
  translate <-12.821503, -0.691260, -19.736404>
}

#declare clip2 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.380097, 2.593945, 1.937615>
  rotate <311.500977, 0.000000, 0.000000>
  translate <-12.862288, -1.781469, -20.395909>
}

#declare earpiece = difference {
  object { Torus003 }
  object { clip2 }
  texture {
    earpiecetex
  }
}

#declare earbrace1 = union {
  object { brace1 }
  object { earpiece }
}

#declare Cone3 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.200000, 0.500000, 12.000000>
  rotate <90.000000, 0.000000, 0.000000>
  translate <-12.800517, 3.423077, -18.043271>
}

#declare clip4 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.489492, 2.172019, 0.906238>
  translate <-12.756831, 1.521017, -18.026072>
}

#declare brace2 = difference {
  object { Cone3 }
  object { clip4 }
}

#declare Torus4 = torus { 
  1.850, 0.150  // Major, minor radius
  rotate -x*90
  rotate <90.000000, 0.000000, -90.000000>
  translate <-12.821503, -0.691260, -19.736404>
}

#declare clip5 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.380097, 2.593945, 1.937615>
  rotate <311.500977, 0.000000, 0.000000>
  translate <-12.862288, -1.781469, -20.395909>
}

#declare earpiece1 = difference {
  object { Torus4 }
  object { clip5 }
  texture {
    earpiecetex
  }
}

#declare earbrace2 = union {
  object { brace2 }
  object { earpiece1 }
  translate <-10.217390, 0.000000, 0.000000>
}

#declare hinge1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver_Texture
  }
  scale <0.250000, 0.250000, 0.750000>
  translate <-12.750705, -8.890858, -18.393351>
}

#declare hinge2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver_Texture
  }
  scale <0.250000, 0.250000, 0.750000>
  translate <-23.104742, -8.890858, -18.393351>
}

#declare lens3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Glass2
  }
  scale <1.800000, 1.800000, 0.350000>
  rotate <90.000000, 0.000000, 0.000000>
  translate <-20.741493, -8.924853, -17.905878>
}

#declare lens4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Glass2
  }
  scale <1.800000, 1.800000, 0.350000>
  rotate <90.000000, 0.000000, 0.000000>
  translate <-15.015310, -8.968953, -17.894967>
}
#declare spectacles =
union {   // spectacles
  object { Torus001 }
  object { Torus2 }
  object { bridge }
  object { earbrace1 }
  object { earbrace2 }
  object { hinge1 }
  object { hinge2 }
  object { lens3 }
  object { lens4 }
  texture {
    Gold_Texture
  }
  bounded_by { specbound }
}
//end spectacles

//begin zappa picture****************************
#declare pictbound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <12.398655, 1.297740, 17.398655>
  translate <0.000000, 9.499086, 7.243903>
}

#declare picture_frame = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    frame_tex
  }
  scale <12.000000, 0.800000, 17.000000>
  translate <0.000000, 9.598171, 7.243903>
}

#declare frame_clip = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    frame_tex
  }
  scale <10.000000, 0.800000, 15.000000>
  translate <0.000000, 9.400000, 7.244000>
}

#declare frame = difference {
  object { picture_frame }
  object { frame_clip }
}

#declare zappa = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    ZappaTex
    scale <2.000000, 2.000000, 1.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-1.000000, -0.456707, -1.026220>
  }
  scale <10.000000, 0.200000, 15.000000>
  translate <0.000000, 9.800000, 7.243903>
}
#declare feynman = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FeynmanTex
    scale <2.000000, 2.000000, 1.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-1.000000, -0.456707, -1.026220>
  }
  scale <10.000000, 0.200000, 15.000000>
  translate <0.000000, 9.800000, 7.243903>
}

#declare zappaphoto =
union {   // framed_photo
  object { frame }
  object { feynman }
  bounded_by { pictbound }
}
//end zappa picture


#declare feynmanphoto =
union {   // framed_photo
  object { frame }
  object { zappa }
  bounded_by { pictbound }
}
//end Feynman

//begin spectrophotometer**************************
#declare spectrobound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <9.279840, 5.601740, 6.945899>
  translate <0.000000, -0.646251, 4.266060>
}

#declare spec_base = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    spec_tex
  }
  scale <7.901224, 5.300000, 2.400000>
  translate <0.000000, -0.668151, 0.000000>
}

#declare spec_ext = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    spec_tex
  }
  scale <7.787793, 2.300000, 3.500000>
  translate <0.000000, 2.375650, 4.231626>
}

#declare spec_clip = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    spec_tex
  }
  scale <9.000000, 2.300000, 3.500000>
  rotate <-37.596680, 0.000000, 0.000000>
  translate <0.000000, -0.074239, 6.755754>
}

#declare spec_display = difference {
  object { spec_ext }
  object { spec_clip }
}

#declare meter = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    meter_face_tex
    scale <2.000000, 2.000000, 2.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-0.996926, -1.103025, -1.027087>
  }
  scale <4.000000, 0.200000, 2.500000>
  rotate <-38.000000, 0.000000, 0.000000>
  translate <0.000000, 1.662045, 5.423694>
}

#declare knob2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    knob_tex
  }
  rotate <52.000000, 0.000000, 0.000000>
  translate <-6.000000, 1.595728, 5.051335>
}

#declare knob3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    knob_tex
  }
  rotate <52.000000, 0.000000, 0.000000>
  translate <6.000000, 1.595728, 5.051335>
}

#declare tube_in = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    knob_tex
  }
  scale <1.000000, 1.000000, 0.600000>
  translate <-5.069364, -3.019264, 2.798024>
}
#declare spectrophotometer =
union {
  object { spec_base }
  object { spec_display }
  object { meter }
  object { knob2 }
  object { knob3 }
  object { tube_in }
  bounded_by { spectrobound }
}
//end spectrophotometer

//begin ttrack1*******************************************
#declare rrack1bound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <7.204400, 3.204400, 5.534400>
  translate <0.000000, 0.000000, 4.580000>
}

#declare rack_bottom = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  scale <7.000000, 3.000000, 0.750000>
}

#declare rack_bot_indent = object { 
  sphere {<0,0,0>,1}
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  translate <0.000000, -1.400000, 0.750000>
}

#declare rack_bot_ind1 = object { 
  sphere {<0,0,0>,1}
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  translate <0.000000, 1.400000, 0.750000>
}

#declare rack_bot_ind2 = object { 
  sphere {<0,0,0>,1}
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  translate <-2.500000, 1.400000, 0.750000>
}

#declare rack_bot_ind3 = object { 
  sphere {<0,0,0>,1}
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  translate <-5.000000, 1.400000, 0.750000>
}

#declare rack_bot_ind4 = object { 
  sphere {<0,0,0>,1}
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  translate <-5.000000, -1.400000, 0.750000>
}

#declare rack_bot_ind5 = object { 
  sphere {<0,0,0>,1}
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  translate <-2.500000, -1.400000, 0.750000>
}

#declare rack_bot_ind6 = object { 
  sphere {<0,0,0>,1}
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  translate <2.500000, -1.400000, 0.750000>
}

#declare rack_bot_ind7 = object { 
  sphere {<0,0,0>,1}
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  translate <5.000000, -1.400000, 0.750000>
}

#declare rack_bot_ind8 = object { 
  sphere {<0,0,0>,1}
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  translate <2.500000, 1.400000, 0.750000>
}

#declare rack_bot_ind9 = object { 
  sphere {<0,0,0>,1}
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  translate <5.000000, 1.400000, 0.750000>
}

#declare rack_base = difference {
  object { rack_bottom }
  object { rack_bot_indent }
  object { rack_bot_ind1 }
  object { rack_bot_ind2 }
  object { rack_bot_ind3 }
  object { rack_bot_ind4 }
  object { rack_bot_ind5 }
  object { rack_bot_ind6 }
  object { rack_bot_ind7 }
  object { rack_bot_ind8 }
  object { rack_bot_ind9 }
}

#declare top = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  scale <7.000000, 3.000000, 0.750000>
}

#declare rack_hole = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  scale <1.000000, 1.000000, 2.000000>
  translate <-5.000000, 1.400000, -1.000000>
}

#declare rack_hole1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  scale <1.000000, 1.000000, 2.000000>
  translate <-2.500000, 1.400000, -1.000000>
}

#declare rack_hole2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  scale <1.000000, 1.000000, 2.000000>
  translate <0.000000, 1.400000, -1.000000>
}

#declare rack_hole3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  scale <1.000000, 1.000000, 2.000000>
  translate <2.500000, 1.400000, -1.000000>
}

#declare rack_hole4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  scale <1.000000, 1.000000, 2.000000>
  translate <5.000000, 1.400000, -1.000000>
}

#declare rack_hole5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  scale <1.000000, 1.000000, 2.000000>
  translate <-5.000000, -1.400000, -1.000000>
}

#declare rack_hole6 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  scale <1.000000, 1.000000, 2.000000>
  translate <-2.500000, -1.400000, -1.000000>
}

#declare rack_hole7 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  scale <1.000000, 1.000000, 2.000000>
  translate <0.000000, -1.400000, -1.000000>
}

#declare rack_hole8 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  scale <1.000000, 1.000000, 2.000000>
  translate <2.500000, -1.400000, -1.000000>
}

#declare rack_hole9 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  scale <1.000000, 1.000000, 2.000000>
  translate <5.000000, -1.400000, -1.000000>
}

#declare rack_top = difference {
  object { top }
  object { rack_hole }
  object { rack_hole1 }
  object { rack_hole2 }
  object { rack_hole3 }
  object { rack_hole4 }
  object { rack_hole5 }
  object { rack_hole6 }
  object { rack_hole7 }
  object { rack_hole8 }
  object { rack_hole9 }
  translate <0.000000, 0.000000, 5.000000>
}

#declare post = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  scale <0.500000, 0.500000, 5.000000>
  translate <-6.500000, 2.000000, 0.000000>
}

#declare post1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  scale <0.500000, 0.500000, 5.000000>
  translate <-6.500000, -2.000000, 0.000000>
}

#declare post2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  scale <0.500000, 0.500000, 5.000000>
  translate <6.500000, -2.000000, 0.000000>
}

#declare post3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    rack_tex
    rotate <0.000000, -90.000000, 0.000000>
  }
  scale <0.500000, 0.500000, 5.000000>
  translate <6.500000, 2.000000, 0.000000>
}

#declare rack = union {
  object { rack_base }
  object { rack_top }
  object { post }
  object { post1 }
  object { post2 }
  object { post3 }
}

#declare tt_base = object { 
  sphere {<0,0,0>,1}
  texture {
    Glass2
  }
}

#declare base_clip = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Glass2
  }
  translate <0.000000, 0.000000, 1.000000>
}

#declare testt_base = difference {
  object { tt_base }
  object { base_clip }
}

#declare tt_wall = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Glass2
  }
  scale <1.000000, 1.000000, 8.000000>
}

#declare tt_lip = torus { 
  1.100, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    Glass2
  }
  translate <0.000000, 0.000000, 8.000000>
}

#declare test_tube = union {
  object { testt_base }
  object { tt_wall }
  object { tt_lip }
  scale <0.900000, 0.900000, 1.100000>
  translate <0.000000, -1.400000, 1.000000>
}

#declare tt_base1 = object { 
  sphere {<0,0,0>,1}
  texture {
    Glass2
  }
}

#declare base_clip1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Glass2
  }
  translate <0.000000, 0.000000, 1.000000>
}

#declare testt_base1 = difference {
  object { tt_base1 }
  object { base_clip1 }
}

#declare tt_wall1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Glass2
  }
  scale <1.000000, 1.000000, 8.000000>
}

#declare tt_lip1 = torus { 
  1.100, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    Glass2
  }
  translate <0.000000, 0.000000, 8.000000>
}

#declare test_tube1 = union {
  object { testt_base1 }
  object { tt_wall1 }
  object { tt_lip1 }
  scale <0.900000, 0.900000, 1.100000>
  translate <-5.000000, -1.400000, 1.000000>
}

#declare tt_base2 = object { 
  sphere {<0,0,0>,1}
  texture {
    Glass2
  }
}

#declare base_clip2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Glass2
  }
  translate <0.000000, 0.000000, 1.000000>
}

#declare testt_base2 = difference {
  object { tt_base2 }
  object { base_clip2 }
}

#declare tt_wall2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Glass2
  }
  scale <1.000000, 1.000000, 8.000000>
}

#declare tt_lip2 = torus { 
  1.100, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    Glass2
  }
  translate <0.000000, 0.000000, 8.000000>
}

#declare test_tube2 = union {
  object { testt_base2 }
  object { tt_wall2 }
  object { tt_lip2 }
  scale <0.900000, 0.900000, 1.100000>
  translate <2.500000, -1.400000, 1.000000>
}

#declare tt_base3 = object { 
  sphere {<0,0,0>,1}
  texture {
    Glass2
  }
}

#declare base_clip3 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Glass2
  }
  translate <0.000000, 0.000000, 1.000000>
}

#declare testt_base3 = difference {
  object { tt_base3 }
  object { base_clip3 }
}

#declare tt_wall3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Glass2
  }
  scale <1.000000, 1.000000, 8.000000>
}

#declare tt_lip3 = torus { 
  1.100, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    Glass2
  }
  translate <0.000000, 0.000000, 8.000000>
}

#declare test_tube3 = union {
  object { testt_base3 }
  object { tt_wall3 }
  object { tt_lip3 }
  scale <0.900000, 0.900000, 1.100000>
  translate <5.000000, -1.400000, 1.000000>
}

#declare tt_base4 = object { 
  sphere {<0,0,0>,1}
  texture {
    Glass2
  }
}

#declare base_clip4 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Glass2
  }
  translate <0.000000, 0.000000, 1.000000>
}

#declare testt_base4 = difference {
  object { tt_base4 }
  object { base_clip4 }
}

#declare tt_wall4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Glass2
  }
  scale <1.000000, 1.000000, 8.000000>
}

#declare tt_lip4 = torus { 
  1.100, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    Glass2
  }
  translate <0.000000, 0.000000, 8.000000>
}

#declare test_tube4 = union {
  object { testt_base4 }
  object { tt_wall4 }
  object { tt_lip4 }
  scale <0.900000, 0.900000, 1.100000>
  translate <-5.000000, 1.400000, 1.000000>
}

#declare tt_base5 = object { 
  sphere {<0,0,0>,1}
  texture {
    Glass2
  }
}

#declare base_clip5 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Glass2
  }
  translate <0.000000, 0.000000, 1.000000>
}

#declare testt_base5 = difference {
  object { tt_base5 }
  object { base_clip5 }
}

#declare tt_wall5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Glass2
  }
  scale <1.000000, 1.000000, 8.000000>
}

#declare tt_lip5 = torus { 
  1.100, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    Glass2
  }
  translate <0.000000, 0.000000, 8.000000>
}

#declare test_tube5 = union {
  object { testt_base5 }
  object { tt_wall5 }
  object { tt_lip5 }
  scale <0.900000, 0.900000, 1.100000>
  translate <-2.500000, 1.400000, 1.000000>
}

#declare tt_base6 = object { 
  sphere {<0,0,0>,1}
  texture {
    Glass2
  }
}

#declare base_clip6 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Glass2
  }
  translate <0.000000, 0.000000, 1.000000>
}

#declare testt_base6 = difference {
  object { tt_base6 }
  object { base_clip6 }
}

#declare tt_wall6 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Glass2
  }
  scale <1.000000, 1.000000, 8.000000>
}

#declare tt_lip6 = torus { 
  1.100, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    Glass2
  }
  translate <0.000000, 0.000000, 8.000000>
}

#declare test_tube6 = union {
  object { testt_base6 }
  object { tt_wall6 }
  object { tt_lip6 }
  scale <0.900000, 0.900000, 1.100000>
  translate <0.000000, 1.400000, 1.000000>
}

#declare tt_base7 = object { 
  sphere {<0,0,0>,1}
  texture {
    Glass2
  }
}

#declare base_clip7 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Glass2
  }
  translate <0.000000, 0.000000, 1.000000>
}

#declare testt_base7 = difference {
  object { tt_base7 }
  object { base_clip7 }
}

#declare tt_wall7 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Glass2
  }
  scale <1.000000, 1.000000, 8.000000>
}

#declare tt_lip7 = torus { 
  1.100, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    Glass2
  }
  translate <0.000000, 0.000000, 8.000000>
}

#declare test_tube7 = union {
  object { testt_base7 }
  object { tt_wall7 }
  object { tt_lip7 }
  scale <0.900000, 0.900000, 1.100000>
  translate <2.500000, 1.400000, 1.000000>
}

#declare tt_base8 = object { 
  sphere {<0,0,0>,1}
  texture {
    Glass2
  }
}

#declare base_clip8 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Glass2
  }
  translate <0.000000, 0.000000, 1.000000>
}

#declare testt_base8 = difference {
  object { tt_base8 }
  object { base_clip8 }
}

#declare tt_wall8 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Glass2
  }
  scale <1.000000, 1.000000, 8.000000>
}

#declare tt_lip8 = torus { 
  1.100, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    Glass2
  }
  translate <0.000000, 0.000000, 8.000000>
}

#declare test_tube8 = union {
  object { testt_base8 }
  object { tt_wall8 }
  object { tt_lip8 }
  scale <0.900000, 0.900000, 1.100000>
  translate <5.000000, 1.400000, 1.000000>
}
#declare rack1 =
union {   // rack1
  object { rack }
  object { test_tube }
  object { test_tube1 }
  //object { test_tube2 }
  //object { test_tube3 }
  //object { test_tube4 }
  //object { test_tube5 }
  //object { test_tube6 }
  //object { test_tube7 }
  //object { test_tube8 }
  bounded_by { rrack1bound }
}
#declare rack2 =
union {   // right_rack1
  object { rack }
  //object { test_tube }
  //object { test_tube1 }
  //object { test_tube2 }
  //object { test_tube3 }
  //object { test_tube4 }
  //object { test_tube5 }
  object { test_tube6 }
  //object { test_tube7 }
  object { test_tube8 }
  bounded_by { rrack1bound }
}
#declare rack3 =
union {   // right_rack1
  object { rack }
  object { test_tube }
  object { test_tube1 }
  object { test_tube2 }
  object { test_tube3 }
  object { test_tube4 }
  object { test_tube5 }
  object { test_tube6 }
  object { test_tube7 }
  object { test_tube8 }
  bounded_by { rrack1bound }
}
//end ttrack1

//begin power tower console**************************
#declare consolebound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <6.356418, 8.421478, 13.022687>
  translate <0.000000, -3.020565, 3.486111>
}

#declare base1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    spec_tex
  }
  scale <5.380093, 4.405718, 9.180158>
}

#declare console_clip = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    spec_tex
  }
  scale <6.000000, 4.405718, 7.000000>
  rotate <-45.000000, 0.000000, 0.000000>
  translate <0.000000, -3.020565, 8.087320>
}

#declare main_console = difference {
  object { base1 }
  object { console_clip }
}

#declare dial_face = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    dial_img0
    scale <2.000000, 2.000000, 1.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-1.000000, -1.000000, -0.927122>
  }
  scale <1.500000, 0.100000, 1.000000>
  translate <-3.000000, -4.621022, -2.383861>
}

#declare dial_face1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    dial_img1
    scale <2.000000, 2.000000, 1.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-1.000000, -1.000000, -0.927122>
  }
  scale <1.500000, 0.100000, 1.000000>
  translate <3.000000, -4.621022, -2.383861>
}

#declare lights = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    light_tex
  }
  scale <0.200000, 0.200000, 0.200000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-4.200000, -4.600000, -4.500000>
}

#declare lights1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    light_tex
  }
  scale <0.200000, 0.200000, 0.200000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-4.200000, -4.600000, -5.500000>
}

#declare lights2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    light_tex2
  }
  scale <0.200000, 0.200000, 0.200000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-4.200000, -4.600000, -6.500000>
}

#declare lights3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    light_tex
  }
  scale <0.200000, 0.200000, 0.200000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-4.200000, -4.600000, -7.500000>
}

#declare lights4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    light_tex
  }
  scale <0.200000, 0.200000, 0.200000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-2.000000, -4.600000, -4.500000>
}

#declare lights5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    light_tex
  }
  scale <0.200000, 0.200000, 0.200000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-2.000000, -4.600000, -5.500000>
}

#declare lights6 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    light_tex2
  }
  scale <0.200000, 0.200000, 0.200000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-2.000000, -4.600000, -6.500000>
}

#declare lights7 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    light_tex
  }
  scale <0.200000, 0.200000, 0.200000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-2.000000, -4.600000, -7.500000>
}

#declare light_clus1 = union {
  object { lights }
  object { lights1 }
  object { lights2 }
  object { lights3 }
  object { lights4 }
  object { lights5 }
  object { lights6 }
  object { lights7 }
}
#declare lights8 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    light_tex
  }
  scale <0.200000, 0.200000, 0.200000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-4.200000, -4.600000, -4.500000>
}

#declare lights9 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    light_tex2
  }
  scale <0.200000, 0.200000, 0.200000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-4.200000, -4.600000, -5.500000>
}

#declare lights10 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    light_tex2
  }
  scale <0.200000, 0.200000, 0.200000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-4.200000, -4.600000, -6.500000>
}

#declare lights11 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    light_tex2
  }
  scale <0.200000, 0.200000, 0.200000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-4.200000, -4.600000, -7.500000>
}

#declare lights12 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    light_tex
  }
  scale <0.200000, 0.200000, 0.200000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-2.000000, -4.600000, -4.500000>
}

#declare lights13 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    light_tex
  }
  scale <0.200000, 0.200000, 0.200000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-2.000000, -4.600000, -5.500000>
}

#declare lights14 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    light_tex
  }
  scale <0.200000, 0.200000, 0.200000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-2.000000, -4.600000, -6.500000>
}

#declare lights15 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    light_tex
  }
  scale <0.200000, 0.200000, 0.200000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-2.000000, -4.600000, -7.500000>
}

#declare light_clus2 = union {
  object { lights8 }
  object { lights9 }
  object { lights10 }
  object { lights11 }
  object { lights12 }
  object { lights13 }
  object { lights14 }
  object { lights15 }
  translate <6.072649, 0.000000, 0.000000>
}
#declare dial_face8 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    dial_img8
    scale <2.000000, 2.000000, 1.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-1.000000, -1.000000, -0.927122>
  }
  scale <0.750000, 0.100000, 0.500000>
  translate <3.000000, 0.220049, 5.097794>
}

#declare dial_face9 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    dial_img9
    scale <2.000000, 2.000000, 1.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-1.000000, -1.000000, -0.927122>
  }
  scale <0.750000, 0.100000, 0.500000>
  translate <3.000000, 0.220049, 3.847794>
}

#declare dial_face10 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    dial_img10
    scale <2.000000, 2.000000, 1.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-1.000000, -1.000000, -0.927122>
  }
  scale <0.750000, 0.100000, 0.500000>
  translate <3.000000, 0.220049, 2.597794>
}

#declare dial_face11 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    dial_img11
    scale <2.000000, 2.000000, 1.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-1.000000, -1.000000, -0.927122>
  }
  scale <0.750000, 0.100000, 0.500000>
  translate <3.000000, 0.220049, 1.347794>
}

#declare right_meters = union {
  object { dial_face8 }
  object { dial_face9 }
  object { dial_face10 }
  object { dial_face11 }
  rotate <-45.000000, 0.000000, 0.000000>
  translate <0.000000, -3.285574, 1.914041>
}

#declare dial_face12 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    dial_img12
    scale <2.000000, 2.000000, 1.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-1.000000, -1.000000, -0.927122>
  }
  scale <0.750000, 0.100000, 0.500000>
  translate <3.000000, 0.220049, 5.097794>
}

#declare dial_face13 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    dial_img13
    scale <2.000000, 2.000000, 1.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-1.000000, -1.000000, -0.927122>
  }
  scale <0.750000, 0.100000, 0.500000>
  translate <3.000000, 0.220049, 3.847794>
}

#declare dial_face14 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    dial_img14
    scale <2.000000, 2.000000, 1.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-1.000000, -1.000000, -0.927122>
  }
  scale <0.750000, 0.100000, 0.500000>
  translate <3.000000, 0.220049, 2.597794>
}

#declare dial_face15 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    dial_img15
    scale <2.000000, 2.000000, 1.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-1.000000, -1.000000, -0.927122>
  }
  scale <0.750000, 0.100000, 0.500000>
  translate <3.000000, 0.220049, 1.347794>
}

#declare right_meters1 = union {
  object { dial_face12 }
  object { dial_face13 }
  object { dial_face14 }
  object { dial_face15 }
  rotate <-45.000000, 0.000000, 0.000000>
  translate <-6.000000, -3.285574, 1.914041>
}

#declare dial_face2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    dial_img2
    scale <2.000000, 2.000000, 1.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-1.000000, -1.000000, -0.927122>
  }
  scale <1.500000, 0.100000, 1.000000>
  rotate <-45.000000, 0.000000, 0.000000>
  translate <3.000000, 2.640584, 7.628354>
}

#declare dial_face16 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    dial_img16
    scale <2.000000, 2.000000, 1.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-1.000000, -1.000000, -0.927122>
  }
  scale <1.500000, 0.100000, 1.000000>
  rotate <-45.000000, 0.000000, 0.000000>
  translate <-3.000000, 2.640584, 7.628354>
}
#declare console =
union {   // console
  object { main_console }
  object { dial_face }
  object { dial_face1 }
  object { light_clus1 }
  object { light_clus2 }
  object { right_meters }
  object { right_meters1 }
  object { dial_face2 }
  object { dial_face16 }
  bounded_by { consolebound }
}
//end power tower console

//begin power tower********************************
#declare towerbound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <108.456169, 33.456173, 127.669090>
  translate <0.000000, 0.000000, 124.875224>
}

#declare shaft1 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Copper_Texture
  }
  scale <2.000000, 2.000000, 100.000000>
  rotate <0.000000, -180.000000, 0.000000>
}

#declare ring = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Copper_Texture
  }
  translate <0.000000, 0.000000, -10.000000>
}

#declare ring1 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Copper_Texture
  }
  scale <2.100000, 2.100000, 2.100000>
  translate <0.000000, 0.000000, -20.000000>
}

#declare ring2 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Copper_Texture
  }
  scale <3.200000, 3.200000, 3.200000>
  translate <0.000000, 0.000000, -30.000000>
}

#declare ring3 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Copper_Texture
  }
  scale <4.300000, 4.300000, 4.300000>
  translate <0.000000, 0.000000, -40.000000>
}

#declare ring4 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Copper_Texture
  }
  scale <5.400000, 5.400000, 5.400000>
  translate <0.000000, 0.000000, -50.000000>
}

#declare ring5 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Copper_Texture
  }
  scale <6.500000, 6.500000, 6.500000>
  translate <0.000000, 0.000000, -60.000000>
}

#declare ring6 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Copper_Texture
  }
  scale <7.599999, 7.599999, 7.599999>
  translate <0.000000, 0.000000, -70.000000>
}

#declare ring7 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Copper_Texture
  }
  scale <8.700000, 8.700000, 8.700000>
  translate <0.000000, 0.000000, -80.000000>
}

#declare ring8 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Copper_Texture
  }
  scale <9.800000, 9.800000, 9.800000>
  translate <0.000000, 0.000000, -90.000000>
}

#declare base2 = cylinder { //++++++
  <0,0,1>, <0,0,0>, 1
  texture {
    Base_Tex
  }
  scale <20.000000, 20.000000, 100.000000>
  translate <0.000000, 0.000000, -199.337697>
}

#declare Ball = object { 
  sphere {<0,0,0>,1}
  texture {
    Ball_Texture
  }
  scale <25.942287, 25.942287, 25.942287>
  translate <0.000000, 0.000000, 18.351194>
}

#declare glow_ball = object { 
  sphere {<0,0,0>,1}
  texture {
    Sparking_Effect
    rotate y*45 //***********************************************************
  }
  no_shadow
  scale <30.000000, 30.000000, 30.000000>
  translate <0.000000, 0.000000, 18.000000>
}

#declare ring18 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Sparking_Effect2
  }
  scale <6.500000, 6.500000, 6.500000>
  translate <0.000000, 0.000000, -50.000000>
}

#declare Shock_tower = union {
  object { shaft1 }
  object { ring }
  object { ring1 }
  object { ring2 }
  object { ring3 }
  object { ring4 }
  object { ring5 }
  object { ring6 }
  object { ring7 }
  object { ring8 }
  object { base2 }
  object { Ball }
  object { glow_ball }
  object { ring18 }
  translate <-75.000000, 0.000000, 200.000000>
}
#declare shaft2 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Copper_Texture
  }
  scale <2.000000, 2.000000, 100.000000>
  rotate <0.000000, -180.000000, 0.000000>
}

#declare ring9 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Copper_Texture
  }
  translate <0.000000, 0.000000, -10.000000>
}

#declare ring10 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Copper_Texture
  }
  scale <2.100000, 2.100000, 2.100000>
  translate <0.000000, 0.000000, -20.000000>
}

#declare ring11 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Copper_Texture
  }
  scale <3.200000, 3.200000, 3.200000>
  translate <0.000000, 0.000000, -30.000000>
}

#declare ring12 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Copper_Texture
  }
  scale <4.300000, 4.300000, 4.300000>
  translate <0.000000, 0.000000, -40.000000>
}

#declare ring13 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Copper_Texture
  }
  scale <5.400000, 5.400000, 5.400000>
  translate <0.000000, 0.000000, -50.000000>
}

#declare ring14 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Copper_Texture
  }
  scale <6.500000, 6.500000, 6.500000>
  translate <0.000000, 0.000000, -60.000000>
}

#declare ring15 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Copper_Texture
  }
  scale <7.599999, 7.599999, 7.599999>
  translate <0.000000, 0.000000, -70.000000>
}

#declare ring16 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Copper_Texture
  }
  scale <8.700000, 8.700000, 8.700000>
  translate <0.000000, 0.000000, -80.000000>
}

#declare ring17 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Copper_Texture
  }
  scale <9.800000, 9.800000, 9.800000>
  translate <0.000000, 0.000000, -90.000000>
}

#declare base3 = cylinder { //++++++
  <0,0,1>, <0,0,0>, 1
  texture {
    Base_Tex
  }
  scale <20.000000, 20.000000, 100.000000>
  translate <0.000000, 0.000000, -199.337697>
}

#declare Ball1 = object { 
  sphere {<0,0,0>,1}
  texture {
    Ball_Texture
  }
  scale <25.942287, 25.942287, 25.942287>
  translate <0.000000, 0.000000, 18.351194>
}

#declare glow_ball1 = object { 
  sphere {<0,0,0>,1}
  texture {
    Sparking_Effect
  }
  no_shadow
  scale <30.000000, 30.000000, 30.000000>
  translate <0.000000, 0.000000, 18.000000>
}

#declare ring19 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Sparking_Effect2
  }
  scale <9.800000, 9.800000, 9.800000>
  translate <0.000000, 0.000000, -80.000000>
}

#declare ring20 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Sparking_Effect2
  }
  scale <4.300000, 4.300000, 4.300000>
  translate <0.000000, 0.000000, -30.000000>
}

#declare Shock_tower1 = union {
  object { shaft2 }
  object { ring9 }
  object { ring10 }
  object { ring11 }
  object { ring12 }
  object { ring13 }
  object { ring14 }
  object { ring15 }
  object { ring16 }
  object { ring17 }
  object { base3 }
  object { Ball1 }
  object { glow_ball1 }
  object { ring19 }
  object { ring20 }
  translate <75.000000, 0.000000, 200.000000>
}
#declare glow_flash = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Sparking_Effect
  }
  no_shadow
  scale <30.000000, 15.000000, 125.000000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <60.645894, 0.000000, 219.088144>
}
#declare power_tower =
union {   // Tower_assembly
  object { Shock_tower }
  object { Shock_tower1 }
  object { glow_flash }
  bounded_by { towerbound }
}
//end power tower

//begin lbench1***********************************
#declare lbenchbound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <20.542210, 11.007874, 10.742208>
  translate <0.000000, 0.000000, -9.800000>
}

#declare table_top = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    table_top_tex
  }
  scale <20.000000, 10.465666, 0.400000>
}

#declare table_top1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    LightOak
  }
  scale <19.000000, 10.000000, 0.900000>
  translate <0.000000, 0.000000, -1.250000>
}

#declare Leg = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    LightOak
  }
  scale <0.500000, 1.000000, 10.000000>
  translate <-18.000000, 9.000000, -10.000000>
}

#declare Leg1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    LightOak
  }
  scale <0.500000, 1.000000, 10.000000>
  translate <18.000000, 9.000000, -10.000000>
}

#declare Leg2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    LightOak
  }
  scale <0.500000, 1.000000, 10.000000>
  translate <-18.000000, -9.000000, -10.000000>
}

#declare Leg3 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    LightOak
  }
  scale <0.500000, 1.000000, 10.000000>
  translate <18.000000, -9.000000, -10.000000>
}
#declare labbench =
union {   // left_bench
  object { table_top }
  object { table_top1 }
  object { Leg }
  object { Leg1 }
  object { Leg2 }
  object { Leg3 }
  bounded_by { lbenchbound }
}
//end lbench1

//begin table**************************************
#declare tablebound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <20.542210, 11.007874, 10.742208>
  translate <0.000000, 0.000000, -9.800000>
}

#declare table_top2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    table_top_tex
  }
  scale <20.000000, 10.465666, 0.400000>
}

#declare table_top3 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    LightOak
  }
  scale <19.000000, 10.000000, 0.900000>
  translate <0.000000, 0.000000, -1.250000>
}

#declare Leg4 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    LightOak
  }
  scale <1.000000, 1.000000, 10.000000>
  translate <-18.000000, 9.000000, -10.000000>
}

#declare Leg5 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    LightOak
  }
  scale <1.000000, 1.000000, 10.000000>
  translate <18.000000, 9.000000, -10.000000>
}

#declare Leg6 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    LightOak
  }
  scale <1.000000, 1.000000, 10.000000>
  translate <-18.000000, -9.000000, -10.000000>
}

#declare Leg7 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    LightOak
  }
  scale <1.000000, 1.000000, 10.000000>
  translate <18.000000, -9.000000, -10.000000>
}
#declare table =
union {   // Table
  object { table_top2 }
  object { table_top3 }
  object { Leg4 }
  object { Leg5 }
  object { Leg6 }
  object { Leg7 }
  bounded_by { tablebound }
}
//end table

