#include "head.inc"

#declare Inst_metal = texture {
	pigment { color rgb <0.8, 0.5, 0.1> }
	finish {
		metallic
		ambient 0.2
		phong 1
		reflection 0.45
   }
}

#declare Bld = texture {
	pigment {color rgb <0.7, 0, 0>}
	finish {ambient 0.2 phong 1}
}

#declare Part = union {
	cylinder {<-0.6, -0.1, 0>, <0.6, -0.1, 0>, 0.01
		texture {My_glass}
	}
	cylinder {<-0.6, -0.1, 0>, <0.6, -0.1, 0>, 0.006
		texture {Bld}
	}
}

#declare Oxygen = union {
	merge {
		sphere {<0, 0.5, 0>, 0.5}
		cylinder {<0, -0.5, 0>, <0, 0.5, 0>, 0.5}
		sphere {<0, -0.5, 0>, 0.5}
		cylinder {<0, -1.05, 0>, <0, -0.8, 0>, 0.2}
		texture {
			pigment {color rgb <0.3, 0.3, 0.3>}
		}
		texture {
			pigment {
				image_map {
					gif "o2.gif"
					once
					filter 255, 1
					filter 32, 0.05
					map_type 2
					interpolate 2
				}
				translate <-0.5, -0.5, 0>
				rotate <0, -90, 180>
			}
			finish {ambient 0.2 phong 0.6}
			normal {bumps 0.2 scale 0.01}
			scale <0.3, 1, 0.3>
		}
	}
	merge {							// pipes
		cylinder {<0, -1.45, 0>, <0, -1.05, 0>, 0.05}
		cylinder {<0, -1.3, 0>, <0, -1.15, 0>, 0.1}
		cylinder {<-0.3, -1.2, 0>, <0.6, -1.2, 0>, 0.025}
		cylinder {<-0.4, -1.2, 0>, <-0.2, -1.2, 0>, 0.1}
	}
	difference {					//device
		cylinder {<-0.6, -1.2, -0.15>, <-0.6, -1.2, 0.15>, 0.3
			texture {
				pigment {color rgb <0.3, 0.3, 0.3>}
				finish {ambient 0.2 phong 0.5}
			}
		}
		cylinder {<-0.6, -1.2, -0.2>, <-0.6, -1.2, -0.1>, 0.26
			texture {
				pigment {
					image_map {
						gif "grad.gif"
						once
						map_type 0
						interpolate 2
					}
				}
				finish {ambient 0.2 phong 0.6 reflection 0.2}
				rotate z*180
				translate <1, 1, 0>
				scale 0.52
				translate <-0.86, -1.46, 0>
			}
		}
	}
	union {
		difference {					//bondage high
			cylinder {<0, 0.45, 0>, <0, 0.55, 0>, 0.51}
			cylinder {<0, 0.4, 0>, <0, 0.6, 0>, 0.5}
		}
		difference {					//bondage low
			cylinder {<0, -0.45, 0>, <0, -0.55, 0>, 0.51}
			cylinder {<0, -0.4, 0>, <0, -0.6, 0>, 0.5}
		}
		cylinder {<0.48, 0.5, 0>, <0.75, 0.5, 0>, 0.02}
		cylinder {<0.48, -0.5, 0>, <0.75, -0.5, 0>, 0.02}
		texture {Inst_metal}
	}

	blob {								//tap
		threshold 0.6
		component 1.0, 0.20, <0, 0, 0>
		component 1.0, 0.12, <0.17, 0, 0>
		component 1.0, 0.12, <-0.17, 0, 0>
		component 1.0, 0.12, <0, 0, 0.17>
		component 1.0, 0.12, <0, 0, -0.17>

		pigment {color rgb <1, 1, 1>}
		finish {ambient 0.2 phong 1 reflection 0.2}

		rotate y*30
		translate -y*1.45
	}
	rotate z*180
	translate <0.75, 1.2, 0>
	scale 0.4
	translate <0.7, 0, 0>

	texture {Inst_metal}
}

#declare Blood = union {
	difference {
		merge {
			sphere {<0, 0.5, 0>, 0.5}
			cylinder {<0, -0.5, 0>, <0, 0.5, 0>, 0.5}
			sphere {<0, -0.5, 0>, 0.5}
			cylinder {<0, 0.8, 0>, <0, 1.05, 0>, 0.2}
		}
		union {
			sphere {<0, 0.5, 0>, 0.48}
			cylinder {<0, -0.5, 0>, <0, 0.5, 0>, 0.48}
			cylinder {<0, 0.7, 0>, <0, 1.1, 0>, 0.18}
		}
	}
	union {				// bondage
		torus {0.52, 0.02}
		cylinder {<0.52, 0, 0>, <1, 0, 0>, 0.02}
		texture {Inst_metal}
	}
	merge {
		cylinder {<0, 1, 0>, <0, 1.1, 0>, 0.1}
		cylinder {<0, 1.1, 0>, <0, 1.15, 0>, 0.24}
	}
	difference {
		sphere {<0, -0.5, 0>, 0.48}
		plane {-y, 0.5}
		pigment {color rgbf <0.7, 0, 0, 0>}
		finish {ambient 0.2 phong 1}
	}
	texture { My_glass }

	translate -x*1
	scale <0.3, 0.4, 0.3>
	rotate y*15
	translate <-0.7, 0.85, 0>
}

#declare Installation = union {
	object { Head }
	object { Blood }
	object { Oxygen }
	difference {
		cylinder {<0, 0.8, 0>, <0, 0.9, 0>, 0.6}
		cylinder {<0, 0.7, 0>, <0, 0.95, 0>, 0.58}
		translate z*0.1
	}
	difference {
		cylinder {<-0.7, 0.85, 0>, <0.7, 0.85, 0>, 0.02}
		cylinder {<0, 0.7, 0>, <0, 0.95, 0>, 0.59}
	}
	sphere {<-0.7, 0.85, 0>, 0.05}
	sphere {<0.7, 0.85, 0>, 0.05}

	intersection {
		torus {0.4, 0.02 rotate x*90}
		box {<-0.5, 0, -0.1>, <0, 0.5, 0.1>}
		translate <-0.3, 0.95, 0>
	}
	intersection {
		torus {0.4, 0.02 rotate x*90}
		box {<-0.5, 0, -0.1>, <0, 0.5, 0.1>}
		translate <-0.3, 0.95, 0>
		rotate y*180
	}
	sphere {<-0.3, 1.35, 0>, 0.08}
	sphere {<0.3, 1.35, 0>, 0.08}
	union {
		smooth_triangle {
		<0, 0, 0>, <0, 0, -1>,
		<0, 1, 0>, <0, 0, -1>,
		<1, 0, 0>, <0, 0, -1>
		}
		smooth_triangle {
		<0, 1, 0>, <0, 0, -1>,
		<1, 1, 0>, <0, 0, -1>,
		<1, 0, 0>, <0, 0, -1>
		}
		texture {
		pigment {
			gradient y
			turbulence 0.4
			color_map {
			[0 0.3 color rgbf <1, 1, 1, 1> color rgbf <1, 1, 1, 1>]
			[0.3 0.48 color rgbf <1, 1, 1, 1> color rgbf <0.3, 0.3, 1, 0.2>]
			[0.48 0.52 color rgb <1, 1, 1> color rgb <1, 1, 1>]
			[0.52 0.7 color rgbf <0.3, 0.3, 1, 0.2> color rgbf <1, 1, 1, 1>]
			[0.7 1 color rgbf <1, 1, 1, 1> color rgbf <1, 1, 1, 1>]
			}
		}
		finish { ambient 1 }
		}
		translate <-0.5, -0.5, 0>
		scale <0.6, 0.3, 1>
		translate y*1.33
		no_shadow
	}
	cylinder {<-0.7, -0.18, 0>, <-0.7, 0.95, 0>, 0.02}
	cylinder {<0.7, -0.18, 0>, <0.7, 0.95, 0>, 0.02}
	torus {0.7, 0.02 translate -y*0.18}
	cylinder {<-0.7, -0.18, 0>, <0.7, -0.18, 0>, 0.02}
	cylinder {<0, -0.2, 0>, <0, 0, 0>, 0.3}

	//	pipe network
	merge {
		union {
			torus {0.6, 0.02 translate -y*0.1 texture {My_glass}}
			torus {0.6, 0.01 translate -y*0.1 texture {Bld}}
		}
		torus {0.8, 0.01 translate y*0.96}
		cylinder {<0.6, -0.1, 0>, <0.8, 0.96, 0>, 0.01 rotate y*60}   //O2 pipe
		union {												// blood pipe
			cylinder {<-0.6, -0.1, 0>, <-1, -0.1, 0>, 0.01
				texture {My_glass}
			}
			cylinder {<-0.6, -0.1, 0>, <-1, -0.1, 0>, 0.006
				texture {Bld}
			}
			cylinder {<-1, -0.1, 0>, <-1, 0.48, 0>, 0.01
				texture {My_glass}
			}
			cylinder {<-1, -0.1, 0>, <-1, 0.48, 0>, 0.006
				texture {Bld}
			}
			sphere {<-1, -0.1, 0>, 0.01}
			rotate y*15
		}
		object {Part}
		object {Part rotate y*20}
		object {Part rotate y*40}
		object {Part rotate y*60}
		object {Part rotate y*80}
		object {Part rotate y*100}
		object {Part rotate y*120}
		object {Part rotate y*140}
		object {Part rotate y*160}
	}
	texture {Inst_metal}

	translate y*0.2
}

