#declare Flask = object {
	union {
		union {
			difference {
				sphere {<0, 0, 0>, 0.30}
				sphere {<0, 0, 0>, 0.29}
				cylinder {<0, 0, 0>, <0, 0.8, 0>, 0.09}
			}
			difference {
				cylinder {<0, 0, 0>, <0, 0.8, 0>, 0.1}
				cylinder {<0, -0.1, 0>, <0, 0.9, 0>, 0.09}
				sphere {<0, 0, 0>, 0.30}
			}
			torus {0.1, 0.01 translate y*0.8 }
		}
		difference {
			sphere {<0, 0, 0>, 0.29
				texture {
					pigment {color rgbf <0.9, 0.9, 0.7, 0.5>}
					finish {ambient 0.2 phong 1}
				}
			}
			plane {x, 0 rotate z*14 translate x*0.2
				texture {
					pigment {color rgbf <0.9, 0.9, 0.7, 0.5>}
					finish {ambient 0.2 phong 1}
				}
			}
		}
	}
	texture { My_glass }
	rotate -z*104
	translate y*0.3
	scale 0.7
}

#declare Ring = union {			// pad
	torus {0.236, 0.01 translate -y*0.2}
	cylinder {<0, -0.135, 0>, <0, 0, 0>, 0.01
		translate <0, -0.2, -0.236>
	}
	cylinder {<0, -0.135, 0>, <0, 0, 0>, 0.01
		translate <0, -0.2, -0.236> rotate y*120
	}
	cylinder {<0, -0.135, 0>, <0, 0, 0>, 0.01
		translate <0, -0.2, -0.236> rotate -y*120
	}
	sphere {<0, -0.335, -0.236>, 0.015 }
	sphere {<0, -0.335, -0.236>, 0.015 rotate y*120}
	sphere {<0, -0.335, -0.236>, 0.015 rotate -y*120}
	texture { Inst_metal }
}

#declare Flask1 = object {
	union {
		union {
			difference {
				sphere {<0, 0, 0>, 0.30}
				sphere {<0, 0, 0>, 0.29}
				cylinder {<0, 0, 0>, <0, 0.8, 0>, 0.09}
			}
			difference {
				cylinder {<0, 0, 0>, <0, 0.8, 0>, 0.1}
				cylinder {<0, -0.1, 0>, <0, 0.9, 0>, 0.09}
				sphere {<0, 0, 0>, 0.30}
			}
			torus {0.1, 0.01 translate y*0.8 }
		}
		object {Ring}
	}
	texture { My_glass }
	translate y*0.35
}

#declare Sheet = object {
	union {
		smooth_triangle {
		<0, 0, 0>, <0, 0, -1>,
		<0, 1, 0>, <0, 0, -1>,
		<1, 0, 0>, <0, 0, -1>
		}
		smooth_triangle {
		<0, 1, 0>, <0, 0, -1>,
		<1, 1, 0>, <0, 0, -1>,
		<1, 0, 0>, <0, 0, -1>
		}
	}
	texture {
		pigment {
			image_map {
				gif "lorem.gif"
				once
				map_type 0
				filter 255, 1
				interpolate 2
			}
		}
		finish { ambient 0.4 phong 0 }
	}
	scale <4, 6, 1>
	scale 0.2
	rotate <90, 0, 0>
	translate <0, 0.002, 0>
}

#declare Note = object {
	union {
		smooth_triangle {
		<0, 0, 0>, <0, 0, -1>,
		<0, 1, 0>, <0, 0, -1>,
		<1, 0, 0>, <0, 0, -1>
		}
		smooth_triangle {
		<0, 1, 0>, <0, 0, -1>,
		<1, 1, 0>, <0, 0, -1>,
		<1, 0, 0>, <0, 0, -1>
		}
	}
	texture {
		pigment {
			image_map {
				gif "note.gif"
				once
				map_type 0
				interpolate 2
			}
		}
		finish { ambient 0.4 phong 1 }
	}
	scale <4, 3, 1>
	scale 0.2
	rotate <90, 0, 0>
	translate <0, 0.002, 0>
}

#declare Inkpot = union {
	difference {
		merge {
			difference {
				merge {
					object { torus {0.8, 0.2} rotate <90, 0, 0> rotate <0, 0, 0> }
					cylinder {
						<0, -0.2, 0>, <0, 0.2, 0>, 0.8
						rotate <90, 0, 0> rotate <0, 0, 0>
					}
					object { torus {0.8, 0.2} rotate <90, 0, 0> rotate <0, 22.5, 0> }
					cylinder {
						<0, -0.2, 0>, <0, 0.2, 0>, 0.8
						rotate <90, 0, 0> rotate <0, 22.5, 0>
					}
					object { torus {0.8, 0.2} rotate <90, 0, 0> rotate <0, 45, 0> }
					cylinder {
						<0, -0.2, 0>, <0, 0.2, 0>, 0.8
						rotate <90, 0, 0> rotate <0, 45, 0>
					}
					object { torus {0.8, 0.2} rotate <90, 0, 0> rotate <0, 67.5, 0> }
					cylinder {
						<0, -0.2, 0>, <0, 0.2, 0>, 0.8
						rotate <90, 0, 0> rotate <0, 67.5, 0>
					}
					object { torus {0.8, 0.2} rotate <90, 0, 0> rotate <0, 90, 0> }
					cylinder {
						<0, -0.2, 0>, <0, 0.2, 0>, 0.8
						rotate <90, 0, 0> rotate <0, 90, 0>
					}
					object { torus {0.8, 0.2} rotate <90, 0, 0> rotate <0, 112.5, 0> }
					cylinder {
						<0, -0.2, 0>, <0, 0.2, 0>, 0.8
						rotate <90, 0, 0> rotate <0, 112.5, 0>
					}
					object { torus {0.8, 0.2} rotate <90, 0, 0> rotate <0, 135, 0> }
					cylinder {
						<0, -0.2, 0>, <0, 0.2, 0>, 0.8
						rotate <90, 0, 0> rotate <0, 135, 0>
					}
					object { torus {0.8, 0.2} rotate <90, 0, 0> rotate <0, 157.5, 0> }
					cylinder {
						<0, -0.2, 0>, <0, 0.2, 0>, 0.8
						rotate <90, 0, 0> rotate <0, 157.5, 0>
					}
				}
				plane {y, -0.8}
				plane {y, 0.8 inverse}
			}
			cylinder { <0, 0.4, 0>, <0, 0.9, 0>, 0.6 }
			bounded_by {sphere {<0, 0, 0>, 1.1}}
			scale <0.2, 0.1, 0.2>
		}
		cylinder { <0, -0.4, 0>, <0, 1.1, 0>, 0.5    		// ink
			texture {
				pigment {color rgbf <0.1, 0, 0.4, 0.2> }
				finish {ambient 0.2 phong 1}
			}
			scale <0.2, 0.1, 0.2>
		}
		texture {
			pigment { color rgbf <1, 0.9, 1, 0.8> }
			finish {
				ambient 0.15
				phong 1.0 phong_size 80
				specular 0.8
				roughness 0.01
				reflection 0.4
				refraction 1
				ior 1.3
			}
		}
	}
	difference {
		cylinder { <0, 0.9, 0>, <0, 0.95, 0>, 0.55 }
		cylinder { <0, 0.8, 0>, <0, 1, 0>, 0.5 }
		scale <0.2, 0.1, 0.2>
	}
	merge {
		difference {
			cylinder { <0, 0, 0>, <0, 0.05, 0>, 0.55 }
			cylinder { <0, -0.5, 0>, <0, 0.1, 0>, 0.5 }
		}
		difference {
			sphere {<0, 0, 0>, 0.53}
			sphere {<0, 0, 0>, 0.50}
			plane {y, 0}
			scale <1, 0.5, 1>
			translate y*0.05
		}
		scale <0.2, 0.1, 0.2>
		translate -z*0.11
		rotate x*135
		translate <0, 0.095, 0.11>
	}
	cylinder { <-0.02, 0.95, 0.55>, <0.02, 0.95, 0.55>, 0.05
		scale <0.2, 0.1, 0.2>
	}
	texture {
		pigment { color rgb <1, 0.6, 0.2> }
		finish {
			metallic
			ambient 0.2
			phong 1
			reflection 0.5
	   }
	}
	translate y*0.08
}

#declare Pen = union {
	merge {
		cylinder {<0, 0, 0>, <0, 1.4, 0>, 0.05}
		sphere {<0, 0, 0>, 0.05 scale <1, 0.5, 1> translate y*1.4}
		pigment {color rgb <0.7, 0, 0>}
		finish {ambient 0.2 phong 1}
		translate y*0.3
	}
	difference {
		cylinder {<0, 0, 0>, <0, 0.4, 0>, 0.051}
		cylinder {<0, -0.1, 0>, <0, 0.5, 0>, 0.05}
		texture {
			pigment { color rgb <0.9, 0.6, 0.1> }
			finish {
				metallic
				ambient 0.2
				phong 1
				reflection 0.6
		   }
		}
	}
	difference {
		cylinder {<0, 0, 0>, <0, 0.3, 0>, 0.05 }
		cylinder {<0, -0.1, 0>, <0, 0.4, 0>, 0.049 }
		plane {-z, 0 rotate y*30}
		plane {-z, 0 rotate -y*30}
		sphere {<0, 0, 0>, 0.1
			scale <0.45, 1, 0.45> translate -z*0.05 rotate y*60
		}
		sphere {<0, 0, 0>, 0.1
			scale <0.45, 1, 0.45> translate -z*0.05 rotate -y*60
		}
		box {<-0.002, -0.15, -0.06>, <0.002, 0.15, 0>}
		cylinder {<0, 0.15, -0.06>, <0, 0.15, 0>, 0.02 }
		texture {
			pigment { color rgb <0.75, 0.85, 0.85> }
			finish {
				metallic
				ambient 0.2
				phong 1
				reflection 0.6
		   }
		}
		translate -y*0.2
	}
	difference {
		blob {
			threshold 0.8
			component 1, 1.654240, <0, -0.950570, 0>
			component 1, 1.654240, <0, 1.041825, 0>
		}
		plane {-y, 0}
		texture {
			pigment { color rgbf <0.1, 0, 0.4, 0.2> }
			finish { ambient 0.2 phong 1 phong_size 90 }
		}
		scale <0.012, 0.03, 0.012>
		rotate <-90, 45, 0>
		translate <0, -0.198, -0.0495>
	}
	translate y*0.2
	rotate <90, 0, -45>
	translate <0, 0.05, -1>
	scale 0.45
}
