#declare Stick = merge {
	difference {
		sphere {<-0.7, 0, 0>, 0.09}
		plane {y, 0}
	}
	sphere {<-0.7, 0.15, 0>, 0.07}
	sphere {<-0.7, 0.26, 0>, 0.05}
	cylinder { <-0.7, 0.26, 0>, <-0.7, 1.55, 0>, 0.05}
}

#declare Half= object {
	union {
		merge {
			difference {
				cone {<0, 0, 0>, 0.2, <0, 0.565685, 0>, 0}
				sphere {<0, 0.565685, 0>, 0.5}
				torus {0.2, 0.1}
			}
			difference {
				sphere {<0, 0.565685, 0>, 0.5}
				sphere {<0, 0.565685, 0>, 0.48}
				plane {y, 0.565685 inverse}
			}
			difference {
				cylinder { <0, 0.565685, 0>, <0, 1.065685, 0>, 0.5}
				cylinder { <0, 0.4, 0>, <0, 1.1, 0>, 0.48}
			}
			difference {
				sphere {<0, 1.065685, 0>, 0.5}
				sphere {<0, 1.065685, 0>, 0.48}
				plane {y, 1.065685}
			}
			texture {My_glass}
		}
		difference {
			merge {
				cylinder { <0, 1.065685, 0>, <0, 1.3, 0>, 0.55}
				difference {
					cylinder { <0, 1.3, 0>, <0, 1.5, 0>, 0.8}
					torus {0.8, 0.2 translate y*1.3}
				}
				cylinder { <0, 1.5, 0>, <0, 1.6, 0>, 0.8}
				object { Stick }
				object { Stick rotate y*180 }
			}
			sphere {<0, 1.065685, 0>, 0.52}
			cylinder { <0, 1, 0>, <0, 1.7, 0>, 0.4}
			cylinder { <0, 1.5, 0>, <0, 1.7, 0>, 0.6}
			texture {
				DMFDarkOak
				finish {
					ambient 0.25
					phong 0.5 phong_size 30
				}
				scale 0.07
			}
		}
	}
}

#declare Sand = object {
	union {
		difference {
			torus {0.48, 0.68 translate -y*0.114315}
			sphere {<0, 0.565685, 0>, 0.48 inverse}
		}
		merge {
			cylinder { <0, -0.565685, 0>, <0, -1.065685, 0>, 0.48}
			sphere {<0, -1.065685, 0>, 0.48}
			cone {<0, -0.565685, 0>, 0.48, <0, -0.3, 0>, 0}
		}
	}
	texture {
		pigment {
			granite
			turbulence 0.8
			color_map {
			[0.00, 0.33	color rgb <1.0, 0.8, 0> color rgb <1.0, 0.8, 0>]
			[0.33, 0.40 color rgb <0.8, 0.6, 0> color rgb <0.8, 0.6, 0>]
			[0.40, 1.00 color rgb <0.9, 0.7, 0> color rgb <0.9, 0.7, 0>]
			}
		}
		finish {ambient 0.2 phong 0.4}
		normal {bumps 0.4 scale 0.05}
		scale 0.04
	}
}

#declare Watch = union {
	object {Half}
	object {Half rotate x*180}
	object {Sand}
	translate y*1.6
	scale 0.5
}
