
#declare BaseGrey =texture{pigment{color rgb<.5,.5,.5>}
                        finish{specular .6 roughness .07}
                        }
#declare HiGrey =texture{pigment{color rgb<.7,.7,.8>}
                        finish{phong 1 phong_size 30}
                        }

#declare Chrome = texture{pigment{color rgb<.45,.45,.45>}
                        finish{specular .95 roughness .001 reflection .95}
                        }
#declare Perspex = texture{pigment{colour rgbf<.9,.9,.65,1>}
                        finish{phong .2 phong_size 40 refraction 1 ior 1.2}
                        }

#declare Knob= union{
        cylinder{<0,0,0> <0,.5,0> .4 texture{BaseGrey}}
        intersection{
        cylinder{<0,.5,0> <0,.6,0> .45 texture{Chrome}}
        cone{<0,.5,0> .6 <0,.61,0> .4 texture{HiGrey}}
        }
        }


#declare Spike=union{
        cylinder{<0,0,0>, <0,3,0>.1} //change to 2.5y for alternative
        //cone{<0,2.5,0>.1 <0,3.2,0> 0} //Alternative
        
        sphere{<0,3,0>, .25} 
        cylinder{<0,3,0>, <-1.4,3,0> .1}
        sphere{<-1.4,3,0> .25}
                
                
                union{
                cone{<0,1,0> .1 <0,1.4,0> 0}
                cylinder{<0,0,0>, <0,1,0> .1}
                //cone{<0,0,0>,.1 <0,-.5,0>,.5}
                rotate z*-24
                translate<-1.4,3,0>
                }
      
      texture{Chrome}
      }


#declare SliderShape=difference{
                        box{<0,.7,0>, <1,1.7,9> texture{HiGrey}}
box{<-1,1.2,-1>, <.2,1.45,10> texture{BaseGrey}}  //These boxes make grooves in
box{<.8,1.2,-1>, <2,1.45,10> texture{BaseGrey}}  //The side of the first
                        }

#declare CrossSlider=union{
                        cylinder{<-3.4,.2,0> <2.4,.2,0> .15}
                        cylinder{<2,.2,0> <2,.2,.5> .15}
                        cylinder{<2.4,.2,.5> <-3.4,.2,.5> .15}
                        cylinder{<-3,.2,.5> <-3,.2,0> .15}
                                union{
                                cone{<0,0,.25> .75 <0,.3,.25> .6}
                                box{<-.7,0,-.3> <-.5,.3,.55>}
                                box{<.7,0,-.3> <.5,.3,.55>}
                                }
                        union{
                        cylinder{<1.4,0,.25> <1.4,.5,.25> .25}
                        object{Spike rotate y*180 translate <1.4,0,.25>}
                        }                        
                        
                        texture {HiGrey}

                        }
//object {CrossSlider scale<2,2,2> rotate x*-80}

#declare Slider=union{
                        difference{
                        box{<0,.7,0>, <1,1.51,9> 
                        texture{HiGrey}
                        texture{pigment{
                        image_map{gif "scale2.gif" filter 0,1  }
                                rotate x*90        
                               
                                scale<1,1,3>
                                translate x*-.1
                               }
                        }
                        }
                        
box{<-1,1.2,-1>, <.2,1.45,10> texture{BaseGrey}}  //These boxes make grooves in
box{<.8,1.2,-1>, <2,1.45,10> texture{BaseGrey}}  //The side of the first
                        }
object{CrossSlider translate <0,1.5,8.5>}                        
}//end union

//object {Slider rotate x*-45}
                        
#declare CircularMount= union{
                        difference{
                        cylinder{<0,0,0>, <0,1.5,0>,4.5 texture{BaseGrey}}
                        object{SliderShape translate<-.5,0,-4.5> scale<.95,1,1>}
                                }
                        object{Slider translate<-.5,0,-5.5>}//-4.5 is centered
                        object {Knob translate<.9,1.5,-3.8>}
                        }
//object{CircularMount rotate y*10}

#declare HalfRing=difference{
                cone{<0,0,0>4.8 <0,.3,0> 4.55}
                cylinder{<0,-1,0> <0,1,0> 4.55}
                plane{x,0 rotate y*20}
                texture {Perspex}
                }

#declare Base=  union{  object{
                        difference{
                        box{<0,0,0>, <10,1.5,10> texture{BaseGrey}}
                        cylinder{<1,2,1>, <1,-1,1>,.4 texture{BaseGrey}}
                        cylinder{<9,2,1>, <9,-1,1>,.4 texture{BaseGrey}}
                        cylinder{<1,2,9>, <1,-1,9>,.4 texture{BaseGrey}}
                        cylinder{<9,2,9>, <9,-1,9>,.4 texture{BaseGrey}}
                        //four bolt holes                
                
                        cylinder{<5,0,5>, <5,1.6,5>,4.55 texture{BaseGrey}}
                        // for the mount

                                }               // end difference
                        translate <-5,0,-5>
                        } // end object

                object{CircularMount rotate y*210 translate<0,.805,0>}
                object{HalfRing translate y*1.5}
                object{Knob translate<2.5,1.5,-5>}
                }              //end union

//object {Base  scale <.25,.25,.25> translate <-.6,0,-1.5>}


