//  Persistance of Vision Raytracer V2.0
//  World definition file.
//

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"

// If you don't like or want the green floor plane and the blue sky, then
// delete the following line. (To permanently delete it, remove it from
// MRYDEFLT.INC in your Moray directory.

camera {  //  Camera Camera01
  location  <-11.515, 10.092, 5.000>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, 0.000, 1.000>
}

// *******  L I G H T S *******
//light_source {   // Light001
//  <3.457, 5.357, 4.362>
//  color rgb <1.000, 1.000, 1.000>
//}

light_source {   // Light002
  <-4.509, 8.296, 7.629>
  color rgb <1.000, 1.000, 1.000>
}

//light_source {   // Light003
//  <-3.621, -6.261, 3.303>
//  color rgb <1.000, 1.000, 1.000>
//}


//
// ********  T E X T U R E S  *******
//

#include "LABTY.INC"

// ********  O B J E C T S *******
plane { y , -6.5
        pigment { color LightBlue }
        }

plane { x , 6.5
        pigment { color LightBlue }
        }
        
#declare base = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Brass_Texture
  }
  normal { waves 0.1 scale 0.04 }
  scale <1.000000, 1.000000, 0.500000>
  rotate <-0.000000, -180.000000, -0.000000>
  translate <0.000000, 0.000000, 0.150000>
}

#declare pipe = cylinder {
  <0,0,1>, <0,0,0>, 1
  open
  texture {
    Chrome_Texture
  }
  scale <0.200000, 0.200000, 2.000000>
  translate <0.000000, 0.000000, 0.500000>
}

#declare valve = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  normal { bumps 0.2 scale 0.08 }
  scale <0.300000, 0.300000, 1.000000>
}

#declare valvehole = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  scale <0.100000, 0.100000, 0.700000>
  rotate <-270.000000, -0.000000, -0.000000>
  translate <0.000000, 0.366375, 0.302658>
}

#declare valveUnit = difference {
  object { valve }
  object { valvehole }
}

#declare gas = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  scale <0.100000, 0.100000, 0.300000>
  rotate <-270.000000, -0.000000, -90.000000>
  translate <-0.228664, 0.000000, 0.143364>
}

union {   // Bunsen
  object { base }
  object { pipe }
  object { valveUnit }
  object { gas }
  rotate <-0.000000, -0.000000, -186.000000>
  translate <2.754427, -2.319426, 0.000000>
   
}
#declare holdertop = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    DMFWood1
  }
  scale <1.700000, 0.553618, 0.100000>
  translate <0.976916, 0.000000, 0.169636>
}

#declare holdhole = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    DMFWood1
  }
  scale <0.400000, 0.400000, 0.400000>
}

#declare holdhole1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    DMFWood1
  }
  scale <0.400000, 0.400000, 0.400000>
  translate <1.000000, 0.000000, 0.000000>
}

#declare holdhole2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    DMFWood1
  }
  scale <0.400000, 0.400000, 0.400000>
  translate <2.000000, 0.000000, 0.000000>
}

#declare ttMholder = difference {
  object { holdertop }
  object { holdhole }
  object { holdhole1 }
  object { holdhole2 }
  translate <0.000000, 0.000000, 1.102505>
}

#declare leg = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  scale <0.050000, 0.050000, 2.200000>
  translate <-0.549830, 2.705045, -0.345834>
}

#declare foot = disc { 
  <0.0, 0.0, 0.0>,
  <0.0, 0.0, 1.0>,
  1.0000
  texture {
    Chrome_Texture
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <-0.524375, 2.718753, -0.317504>
}

#declare leg1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  scale <0.050000, 0.050000, 2.200000>
  translate <2.509102, 2.705045, -0.366198>
}

#declare foot1 = disc { 
  <0.0, 0.0, 0.0>,
  <0.0, 0.0, 1.0>,
  1.0000
  texture {
    Chrome_Texture
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <2.495458, 2.712754, -0.317504>
}

#declare legMholder = union {
  object { leg }
  object { foot }
  object { leg1 }
  object { foot1 }
  translate <0.000000, -2.719609, -0.515114>
}
#declare testMholder = union {
  object { ttMholder }
  object { legMholder }
}
#declare ttube1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  open
  texture {
    Glass
  }
  scale <1.000000, 1.000000, 6.000000>
}

#declare ttend1 = object { 
  sphere {<0,0,0>,1}
  texture {
    Glass
  }
}

#declare ttop1 = torus { 
  1.050, 0.050  // Major, minor radius
  rotate -x*90
  texture {
    Glass
  }
  translate <0.000000, 0.000000, 6.000000>
}

#declare testMtube1 = merge {
  object { ttube1 }
  object { ttend1 }
  object { ttop1 }
  scale <0.300000, 0.300000, 0.300000>
  translate <1.000000, 0.000000, 0.000000>
}

#declare testMtube = merge {
  object { ttube1 }
  object { ttend1 }
  object { ttop1 }
  scale <0.300000, 0.300000, 0.300000>
}

#declare testMtube2 = merge {
  object { ttube1 }
  object { ttend1 }
  object { ttop1 }
  scale <0.300000, 0.300000, 0.300000>
  translate <2.000000, 0.000000, 0.000000>
}

union {   // the_testt
  object { testMholder }
  object { testMtube1 }
  object { testMtube }
  object { testMtube2 }
  translate <-0.018722, 2.676571, 0.534387>
}

box {   // desktop
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Rosewood
  }
  scale <5.000000, 5.000000, 0.500000>
  translate <-0.919114, 0.000000, -0.825420>
   
}

#declare flask = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Glass
  }
  scale <1.000000, 1.000000, 2.000000>
  rotate <-180.000000, -0.000000, -0.000000>
  translate <0.000000, 0.000000, 2.003246>
}

#declare flaskb = torus { 
  0.500, 0.500  // Major, minor radius
  rotate -x*90
  texture {
    Glass
  }
  scale <1.000000, 1.000000, 0.200000>
}

#declare flaskt = cylinder {
  <0,0,1>, <0,0,0>, 1
  open
  texture {
    Glass
  }
  scale <0.300000, 0.300000, 1.000000>
  translate <0.000000, 0.000000, 1.385423>
}

#declare ftop = torus { 
  0.350, 0.050  // Major, minor radius
  rotate -x*90
  texture {
    Glass
  }
  translate <0.000000, 0.000000, 2.387046>
}

merge {   // The_Flask
  object { flask }
  object { flaskb }
  object { flaskt }
  object { ftop }
  translate <-2.230483, -2.753557, -0.256267>
}

#declare rubber_1 = object { 
  bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3
    <-1.000000, -14.950712, 3.185547>  <-1.000000, -14.957980, 3.735499>  <-0.550000, -14.963926, 4.185459>  <0.000000, -14.963926, 4.185459>
    <-1.000000, 0.408745, 0.287971>  <-1.000000, 0.091977, 0.737591>  <-0.550000, -0.315620, 1.204410>  <0.000000, -0.315620, 1.204410>
    <-1.000000, -8.164442, 22.946169>  <-1.000000, -8.714442, 22.946169>  <-0.550000, -9.164442, 22.946169>  <0.000000, -9.164442, 22.946169>
    <-12.253660, -1.492023, 24.282157>  <-12.253660, -2.042023, 24.282157>  <-11.803660, -2.492023, 24.282157>  <-11.253660, -2.492023, 24.282157>  }
}
#declare rubber_2 = object { 
  bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3
    <0.000000, -14.963926, 4.185459>  <0.550000, -14.963926, 4.185459>  <1.000000, -14.957980, 3.735499>  <1.000000, -14.950712, 3.185547>
    <0.000000, -0.315620, 1.204410>  <0.550000, -0.315620, 1.204410>  <1.000000, 0.091977, 0.737591>  <1.000000, 0.408745, 0.287971>
    <0.000000, -9.164442, 22.946169>  <0.550000, -9.164442, 22.946169>  <1.000000, -8.714442, 22.946169>  <1.000000, -8.164442, 22.946169>
    <-11.253660, -2.492023, 24.282157>  <-10.703660, -2.492023, 24.282157>  <-10.253660, -2.042023, 24.282157>  <-10.253660, -1.492023, 24.282157>  }
}
#declare rubber_3 = object { 
  bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3
    <1.000000, -14.950712, 3.185547>  <1.000000, -14.943444, 2.635595>  <0.550000, -14.937498, 2.185634>  <0.000000, -14.937498, 2.185634>
    <1.000000, 0.408745, 0.287971>  <1.000000, 0.725513, -0.161648>  <0.550000, 0.984688, -0.529519>  <0.000000, 0.984688, -0.529519>
    <1.000000, -8.164442, 22.946169>  <1.000000, -7.614442, 22.946169>  <0.550000, -7.164442, 22.946169>  <0.000000, -7.164442, 22.946169>
    <-10.253660, -1.492023, 24.282157>  <-10.253660, -0.942023, 24.282157>  <-10.703660, -0.492023, 24.282157>  <-11.253660, -0.492023, 24.282157>  }
}
#declare rubber_4 = object { 
  bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3
    <0.000000, -14.937498, 2.185634>  <-0.550000, -14.937498, 2.185634>  <-1.000000, -14.943444, 2.635595>  <-1.000000, -14.950712, 3.185547>
    <0.000000, 0.984688, -0.529519>  <-0.550000, 0.984688, -0.529519>  <-1.000000, 0.725513, -0.161648>  <-1.000000, 0.408745, 0.287971>
    <0.000000, -7.164442, 22.946169>  <-0.550000, -7.164442, 22.946169>  <-1.000000, -7.614442, 22.946169>  <-1.000000, -8.164442, 22.946169>
    <-11.253660, -0.492023, 24.282157>  <-11.803660, -0.492023, 24.282157>  <-12.253660, -0.942023, 24.282157>  <-12.253660, -1.492023, 24.282157>  }
}
union {   // rubber
  object { rubber_1 }
  object { rubber_2 }
  object { rubber_3 }
  object { rubber_4 }
  texture {
    rubbertube
  }
  normal { bumps 0.1 scale 0.04 }
  scale <0.150000, 0.150000, 0.150000>
  rotate <263.645630, 268.136200, -0.000000>
  translate <5.338346, -3.084205, 0.214810>
   
}

cylinder {   // stirrer
  <0,0,1>, <0,0,0>, 1
  texture {
    Glass
  }
  scale <0.050000, 0.050000, 4.000000>
  rotate <-6.209671, -0.000000, -0.000000>
  translate <-2.203408, -2.818836, -0.260082>
}

#declare glassMbase = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  scale <1.000000, 1.000000, 0.300000>
}

#declare glassMrod = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  scale <0.100000, 0.100000, 5.000000>
}

#declare glassMclamp = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  normal { bumps 0.1 scale 0.04 }
  scale <0.300000, 0.300000, 0.300000>
  translate <0.000000, 0.000000, 2.500000>
}

#declare glassMrod2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  scale <0.050000, 0.050000, 2.000000>
  rotate <-90.000000, -0.000000, -0.000000>
  translate <0.000000, -0.511919, 2.658871>
}
#declare glassmhole = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  normal { bumps 0.1 scale 0.04 }
  scale <0.100000, 0.100000, 0.500000>
  translate <0.000000, 1.412784, 2.600000>
}

#declare glassMhder = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  normal { bumps 0.1 scale 0.04 }
  scale <0.300000, 0.300000, 0.300000>
  translate <0.000000, 1.412784, 2.500000>
}

#declare glassMholder = difference {
        object {glassMhder}
        object {glassmhole}
        }

union {   // pipMholder
  object { glassMbase }
  object { glassMrod }
  object { glassMclamp }
  object { glassMrod2 }
  object { glassMholder }
  rotate <-0.000000, -0.000000, -45.297096>
  translate <-3.731750, 0.263093, -0.353704>
   
}
#declare flask1 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Green_Glass
  }
  scale <1.000000, 1.000000, 2.000000>
  rotate <-180.000000, -0.000000, -0.000000>
  translate <0.000000, 0.000000, 2.003246>
}

#declare flaskb1 = torus { 
  0.500, 0.500  // Major, minor radius
  rotate -x*90
  texture {
    Glass
  }
  scale <1.000000, 1.000000, 0.200000>
}

#declare flaskt1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  open
  texture {
    Glass
  }
  scale <0.300000, 0.300000, 1.000000>
  translate <0.000000, 0.000000, 1.385423>
}

#declare ftop1 = torus { 
  0.350, 0.050  // Major, minor radius
  rotate -x*90
  texture {
    Glass
  }
  translate <0.000000, 0.000000, 2.387046>
}

merge {   // The_Flask1
  object { flask1 }
  object { flaskb1 }
  object { flaskt1 }
  object { ftop1 }
  translate <-5.859055, 1.835715, -0.185527>
}
