// Scene file for Internet Blues
// by Marty Rabens (mrabens@herbie.unl.edu)
// Copyrights, lefts, and centers:
//     If you find something useful in here, go ahead and use it/derive from
//     it in your own stuff.  Just give me credit and include my eMail
//     address if you do.

#include "colors.inc"
#include "textures.inc"
#include "human.inc"
#include "human1.inc"
#include "human2.inc"
#include "human3.inc"
#include "human4.inc"
#include "pod.inc"

#declare Human1_Small = object {
  Human1
  pigment {color red 2 green 2}
  no_shadow
  scale 0.75
  translate <Holo_Dis, Holo_Height, 0>
}

#declare Human2_Small = object {
  Human2
  pigment {color red 2}
  no_shadow
  scale 0.75
  translate <Holo_Dis, Holo_Height, 0>
}

#declare Human3_Small = object {
  Human3
  pigment {color green 2}
  no_shadow
  scale 0.75
  translate <Holo_Dis, Holo_Height, 0>
}
  
#declare Human4_Small = object {
  Human4
  pigment {color red 2 blue 2}
  no_shadow
  scale 0.75
  translate <Holo_Dis, Holo_Height, 0>
}

declare Pod1 = union {
  object {
    Pod
    pigment {color White}
  }

  object {
    Human1
    scale 2
    rotate y*60
    translate y*1
  }
  
  object {
    Human2_Small
  }

  object {
    Human3_Small
    rotate y*120
  }
  
  object {
    Human4_Small
    rotate y*240
  }
}

declare Pod2 = union {
  object {
    Pod
    pigment {color White}
  }

  object {
    Human2
    scale 2
    rotate y*190
    translate y*1
  }
  
  object {
    Human1_Small
  }

  object {
    Human3_Small
    rotate y*120
  }
  
  object {
    Human4_Small
    rotate y*240
  }
}

declare Pod3 = union {
  object {
    Pod
    pigment {color White}
  }

  object {
    Human3
    scale 2
    rotate y*(-20)
    translate y*1
  }
  
  object {
    Human1_Small
  }

  object {
    Human2_Small
    rotate y*120
  }
  
  object {
    Human4_Small
    rotate y*240
  }
}

declare Pod4 = union {
  object {
    Pod
    pigment {color White}
  }

  object {
    Human4
    scale 2
    rotate y*220
    translate y*1
  }
  
  object {
    Human1_Small
  }

  object {
    Human2_Small
    rotate y*120
  }
  
  object {
    Human3_Small
    rotate y*240
  }
}

object {       // Yellow
  Pod1
  rotate y*(-23)
  translate <-7.5, 0, -28>
}

object {       // Red
  Pod2
  rotate y*25
  translate <10, 0, -13>
}

object {       // Green
  Pod3
  rotate y*(-20)
  translate <9, 0, 30>
}

object{        // Purple
  Pod4
  rotate y*(-110)
  translate <-4, 0, 6>
}

plane {
  <0, 1, 0>, 0
  texture {
    Polished_Chrome
    finish {
      reflection 0.1
      diffuse 0.2
    }
  }
}

camera {
  direction <0, 0, 2>
  location <0, 7, -60>
  look_at <0, 5, 0>
}

light_source {<22, 17, -80> color White}

