#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "hammer.inc"

/* Camera: Camera01 */
camera {
   location <15.4070, 20.6244, 1.5298>
   direction <0, 1.414, 0>
   up <0, 0, 1>
   sky  <0, 0, 1>
   right <1.333, 0, 0>
   look_at <5.5841, -0.9825, -10.4028>
}


/* just to clear the room */
/* Light: Light01 */
light_source {
    <-1.4093, -10.9794, 5.2636> color rgb <0.35, 0.35, 0.35>
}


/* This light gives an interesting shadow */
/* Spotlight: Light02 */
light_source {
    <-8.1799, 13.6931, 0.0000> color rgb <0.45, 0.45, 0.45>
    spotlight
    point_at <9.6156, -4.6120, -9.0144>
    tightness 0
    radius 17.13
    falloff 43.38
}



/* Texture of the Wall */
#declare WALL = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.40
        phong_size 11.9
    }
    pigment { rgb <0.729, 0.718, 0.627> }
    normal {bumps 0.05 scale 0.05}
}


/* That broken piece of metal :-) */
#declare PREGO = texture {
    finish {
	ambient 0.10
	diffuse 0.90
	phong 1.00
	phong_size 58.8
	metallic
	reflection 0.6000
	crand 0.05
    }
    pigment { rgb <0.425, 0.425, 0.435> }
}


/* Table wood - reflective */
#declare REFLECT_WOOD = texture {
 pigment 
  {
  image_map {
	gif "teak.gif" /* From 3D Studio */
	interpolate 2
	map_type 0
	}
	scale <33.33,33.33,1>
	translate <-15.41,-19.18,0>
   }
finish {
	ambient 0.20
	diffuse 0.9
	phong 0.54
	phong_size 16.1
	reflection 0.1
	}
}


/* The hammer cable - basically the tan wood texture, with some 
modifications */
#declare HAMMER_CABLE = texture {
    finish {
	ambient 0.10
	diffuse 0.90
	phong 0.63
	phong_size 18.9
    }
 pigment 
  {wood
   turbulence 0.04
   octaves 3
   scale <0.05, .05, 1>
   color_map 
    {[0.00, 0.10 color red 0.60 green 0.30 blue 0.18
		 color red 0.60 green 0.30 blue 0.18]
     [0.10, 0.90 color red 0.60 green 0.30 blue 0.18
		 color red 0.30 green 0.15 blue 0.09]
     [0.90, 1.0  color red 0.30 green 0.15 blue 0.09
		 color red 0.30 green 0.15 blue 0.09]
    }  
   rotate 90*y
   }
}



/* The metalic hammer head - reflective, and there is a layered
map texture in order to give a more metalic apearance */
#declare HAMMER_HEAD = texture {
    finish {
	ambient 0.10
	diffuse 0.70
	phong 1.00
	phong_size 58.8
	metallic
	reflection 0.20
	crand 0.05
    }
    pigment { rgb <0.369, 0.369, 0.369> }
}
texture {
	pigment{ image_map {
		   gif "refmap.gif"  /* From 3D Studio */
		   map_type 1
		   filter all 0.6
		   }
		translate <11.2,-7.86, -10.34>
		scale <8,8,8>
		}
	}
			



#include "hammer.inc"  //a VERY large file with lots of smooth_triangles
