#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"


/* Colors of the sun ray */
#declare ray_medium_color= color rgb<0.6,0.3,0.07>
#declare ray_dark_color= color rgb<0.4,0.2,0.02>
#declare ray_brite_color= color rgb<0.8,0,0>



/* Light: Light01 */
light_source {
    <6.1081, 0.0000, 19.1413> color rgb <0.22, 0.22, 0.22>
}

/* Camera: Camera02 */
camera {
   location <29.7571, 6.0613, -6.8879>
   direction <0, 0.953, 0>
   up <0, 0, 1>
   sky  <0, 0, 1>
   right <1.333, 0, 0>
   look_at <2.8151, 6.3509, 3.5393>
}

/* Spotlight: Light03 */
light_source {
    <-61.5005, 54.9862, 48.8647> color rgb <0.25, 0.25, 0.25>
    spotlight
    point_at <10.4069, 0.0000, 0.3054>
    tightness 0
    radius 41.25
    falloff 43.00
}

/* Spotlight: Light02 */
light_source {
    <97.5261, -1.2267, 69.6171> color rgb <0.40, 0.40, 0.40>
    spotlight
    point_at <35.3848, -2.8945, -38.5299>
    tightness 0
    radius 0.50
    falloff 63.75
}



/* Red part of the cable of the hammer */
#declare RED_CABLE = texture {
    finish {
	ambient 0.10
	diffuse 0.90
	phong 0.96
	phong_size 28.7
    }
    pigment { rgb <0.725, 0.000, 0.000> }
}


/* Black part of the cable of the hammer */
#declare BLACK_CABLE = texture {
    finish {
	ambient 0.10
	diffuse 0.90
	phong 0.96
	phong_size 28.7
    }
    pigment { rgb <0.082, 0.082, 0.082> }
}



/* Metalic Hammer head */
#declare HAMMER_HEAD = texture {
    finish {
	ambient 0.10
	diffuse 0.90
	phong 1.00
	phong_size 50.4
	metallic
	reflection 0.100
    }
    pigment { rgb <0.459, 0.459, 0.459> }
}


/* The psycodelic layered Sky */
#declare MY_SKY = texture {
  pigment {
   gradient y   /* The sun rays */
   
color_map {
	[0.0 0.3 color raio_escur
		 color raio_medio]
	[0.3 0.5 color raio_medio
		 color raio_claro]
	[0.5 0.7 color raio_claro
		 color raio_medio]
	[0.7 1.0 color raio_medio
		 color raio_escur]
	      }
  scale 10.0
 }
finish {
	ambient 0.3
	}
}

texture {
  pigment {
   bozo         /* The clouds */
   turbulence 0.6
   colour_map {
      [0.0 0.3   colour red 0.8 green 0.5  blue 0.3 filter 0.0
		 colour red 0.6 green 0.4  blue 0.0 filter 0.0]  
      [0.3 0.8   colour red 0.6 green 0.4  blue 0.0 filter 0.0
		 colour red 0.4 green 0.4  blue 0.0 filter 0.8]  
      [0.8 0.9   colour red 0.4 green 0.4  blue 0.0 filter 0.8
		 colour rgbf <0.9,0.8,0.7,1>]  
      [0.9 1.001 colour rgbf <0.9,0.8,0.7,1>
		 colour rgbf <0.9,0.8,0.7,1>]
     }
   scale <6,8,6>
   }
finish {
	ambient 0.3
	}
}


/* The floor - modified from Grnt27 */
//------ Dark Green & Browns
#declare FLOORTEX = 
texture {
pigment
 {granite
  color_map
   {[0.000, 0.043   color rgbf <0.773, 0.647, 0.569, 0.000>
		    color rgbf <0.431, 0.322, 0.227, 0.000>]
    [0.043, 0.113   color rgbf <0.431, 0.322, 0.227, 0.000>
		    color rgbf <0.278, 0.282, 0.216, 0.000>]
    [0.113, 0.304   color rgbf <0.278, 0.282, 0.216, 0.000>
		    color rgbf <0.278, 0.282, 0.216, 0.000>]
    [0.304, 0.426   color rgbf <0.278, 0.282, 0.216, 0.000>
		    color rgbf <0.459, 0.341, 0.243, 0.000>]
    [0.426, 0.843   color rgbf <0.459, 0.341, 0.243, 0.000>
		    color rgbf <0.459, 0.341, 0.243, 0.000>]
    [0.843, 0.878   color rgbf <0.459, 0.341, 0.243, 0.000>
		    color rgbf <0.459, 0.341, 0.243, 0.000>]
    [0.878, 0.983   color rgbf <0.459, 0.341, 0.243, 0.000>
		    color rgbf <0.278, 0.282, 0.216, 0.000>]
    [0.983, 1.001   color rgbf <0.278, 0.282, 0.216, 0.000>
		    color rgbf <0.773, 0.647, 0.569, 0.000>]
   }
 }
finish {
	ambient 0.4
	}
scale <10,10,10>

}



/* There is a mirror to duplicate the marching hammers       */
/* so I don't have to model them all (It's a time-saver too) */
#declare MIRROR = texture {
    finish {
	ambient 0.10
	diffuse 0.90
	phong 0.03
	phong_size 1.0
	reflection 1.000
    }
    pigment { rgb <0.000, 0.000, 0.000> }
}



#include "wall02.inc" // A VERY large (10MB) file of smooth_triangles
