// Persistence of Vision RayTracer version 2 Scene description file
// File: msknife.pov
// Description: A pocket knife - my contribution for the
//              comp.graphics.raytracing November-competition
//              (Topic: "Tools")
// Scale: 1 unit = 1 mm
// Created: 22-Nov-94
// Updated: 30-Nov-94
// Author: Martin Schwarz <ujc4@rz.uni-karlsruhe.de>

/* To do: (a lot!)
 - model tools (blades, screw driver, corkscrew, ...)
 - optimize camera, light_source
 - optimize textures
 - swiss cross logo on Plastic_Plate?
*/

camera {
  location <-25, 10, -150>
  look_at <-35, 0, 0>
}

light_source {
  <-10, 20, -200>
  color rgb <1, 1, 1>
}

#declare Plastic_Plate = union {
  torus { 9.5, 3 /* sturm */ translate -32.5*x }
  torus { 9.5, 3 /* sturm */ translate  32.5*x }
  cylinder { < 32.5, 0, 9.5>, <-32.5, 0, 9.5>, 3 }
  cylinder { < 32.5, 0,-9.5>, <-32.5, 0,-9.5>, 3 }
  cylinder { < 32.5, 0, 0>, < 32.5, 3, 0>, 9.5 }
  cylinder { <-32.5, 0, 0>, <-32.5, 3, 0>, 9.5 }
  box { <-32.5, 0, -9.5>, <32.5, 3, 9.5> }
  clipped_by { plane { -y, 0 } }
  bounded_by { box { <-45, 0, -12.5>, <45, 3, 12.5> } }
  texture {
    pigment { color rgb <0.7, 0.05, 0.05> }
    finish { specular 0.9  roughness 0.1 }
  }
}

#declare Metal_Texture = texture {
  pigment { color rgb <0.6, 0.65, 0.8> }
  finish { reflection 0.4  brilliance 8  specular 0.9  roughness 0.01 }

}

#declare Metal_Plate = union {
  cylinder { <-32.5, 0, 0>, <-32.5, 0.5, 0>, 12.5 }
  cylinder { < 32.5, 0, 0>, < 32.5, 0.5, 0>, 12.5 }
  box { <-32.5, 0, -12.5>, <32.5, 0.5, 12.5> }
  bounded_by { box { <-45, 0, -12.5>, <45, 0.5, 12.5> } }
  texture { Metal_Texture }
}

#declare Metal_Plate_B = box{
  <-40, 0, -7.5>, <40, 2, -3.75>
  texture { Metal_Texture }
}

#declare Connecting_Piece = union {
  box { <-17.5, 0, -7.5>, <-10, 2, 7.5> }
  box { <-10, 0, -3.75>, <0, 2, 3.75> }
  cylinder { <0, 0, 0>, <0, 2, 0>, 3.75 }
  bounded_by { box { <-17.5, 0, -7.5>, <3.75, 2, 17.5> } }
}

#declare Saw_bit = difference {
  box { <-1.25, 0, 0>, <1.25, 2, 2.5> }
  box { <-3.75, 0, -1.25>, <0, 2, 0>  rotate 63.435*y }
  box { <0, 0, -1.25>, <3.75, 2, 0>  rotate -63.435*y }
  bounded_by { box { <-1.25, 0, 0>, <1.25, 2, 2.5> } }
}

#declare Saw = union {
  object { Connecting_Piece }
  difference {
    box { <-102.5, 0.5, -7.5>, <-17.5, 1.5, 7.5> }
    box { <0, 0, 0>, <80, 2, 5>  rotate 5.528*y  translate -95*x }
    box { <0, 0, 0>, <10, 2, -5>  rotate 33.69*y  translate <-102.5, 0, 5> }
    object { Saw_bit  translate < -21.25, 0, 0.5> }
    object { Saw_bit  translate < -23.75, 0, 0.5> }
    object { Saw_bit  translate < -26.25, 0, 0.5> }
    object { Saw_bit  translate < -28.75, 0, 0.5> }
    object { Saw_bit  translate < -31.25, 0, 0.5> }
    object { Saw_bit  translate < -33.75, 0, 0.5> }
    object { Saw_bit  translate < -36.25, 0, 0.5> }
    object { Saw_bit  translate < -38.75, 0, 0.5> }
    object { Saw_bit  translate < -41.25, 0, 0.5> }
    object { Saw_bit  translate < -43.75, 0, 0.5> }
    object { Saw_bit  translate < -46.25, 0, 0.5> }
    object { Saw_bit  translate < -48.75, 0, 0.5> }
    object { Saw_bit  translate < -51.25, 0, 0.5> }
    object { Saw_bit  translate < -53.75, 0, 0.5> }
    object { Saw_bit  translate < -56.25, 0, 0.5> }
    object { Saw_bit  translate < -58.75, 0, 0.5> }
    object { Saw_bit  translate < -61.25, 0, 0.5> }
    object { Saw_bit  translate < -63.75, 0, 0.5> }
    object { Saw_bit  translate < -66.25, 0, 0.5> }
    object { Saw_bit  translate < -68.75, 0, 0.5> }
    object { Saw_bit  translate < -71.25, 0, 0.5> }
    object { Saw_bit  translate < -73.75, 0, 0.5> }
    object { Saw_bit  translate < -76.25, 0, 0.5> }
    object { Saw_bit  translate < -78.75, 0, 0.5> }
    object { Saw_bit  translate < -81.25, 0, 0.5> }
    object { Saw_bit  translate < -83.75, 0, 0.5> }
    object { Saw_bit  translate < -86.25, 0, 0.5> }
    object { Saw_bit  translate < -88.75, 0, 0.5> }
    object { Saw_bit  translate < -91.25, 0, 0.5> }
    object { Saw_bit  translate < -93.75, 0, 0.5> }
  }
  texture { Metal_Texture }
}

#declare Pocket_Knife = union {
  object { Plastic_Plate  translate 4*y }
  object { Plastic_Plate  rotate 180*x  translate -4*y }
  object { Metal_Plate  translate  3.5*y }
  object { Metal_Plate  rotate 180*x  translate -3.5*y }
  object { Metal_Plate  translate 1*y }
  object { Metal_Plate  rotate 180*x  translate -1*y }
  object { Metal_Plate_B  translate 1.5*y }
  object { Metal_Plate_B  translate -0.5*y }
  object { Metal_Plate_B  translate -1.75*y }
  object { Saw  translate -32.5*x }
}

object { Pocket_Knife  rotate -45*x }

