//
//   WRENCH.POV
//
//   November 13, 1994
//   For the Internet 'Tools' Contest for 11/94
//
//     SysOp - The Tackle Box BBS
//   Oklahoma's BEST Ray Tracing BBS
//    2 GIG Online - (405) 359-3301
//
//   This file and the ray traced images
//   are Copyright (C) 1994 by Neil Clark
//

#include "colors.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "textures.inc"

// Camera
camera{
  location < 10, 19, -12 >
  look_at < 10, 1, 1  >
}

// Light Sources
light_source { < -8, 70, -30 > color White }

// Floor Plane
plane { y, -1 texture { DMFLightOak } scale <19, 13, 15> }

// Wrench Metal Texture
#declare wrench_texture = texture
{
    Silver_Texture
    finish {
        ambient 0.2
        diffuse 0.6
        reflection 0.6
        brilliance 10
        specular 0.35
        roughness 0.05
        metallic
    }
}

// Box End
#declare box_end = difference
 {
  object
   {
    Disk_Y
    scale <2.7, 0.8, 2.7>
    texture { wrench_texture }
   }
  object
   {
    Hexagon
    scale <1.1, 1.9, 1.9>
    rotate <0, 0, 90>
    translate <0, 0, 0>
    pigment { color Silver }
  }
  object
   {
    Hexagon
    scale <1.1, 1.9, 1.9>
    rotate <30, 0, 90>
    translate <0, 0, 0>
    pigment { color Silver }
  }
  object
   {
    Cone_Y
    scale <2.5, 1.1, 2.5>
    rotate <0, 0, 180>
    translate <0, -0.1, 0>
    texture { wrench_texture }
  }
  bounded_by { sphere { <0, 0, 0>, 3 }}
}

// Handle
#declare handle = union
 {
  object
   {
    box { <2, 0, -0.75>, <20, 0.5, 0.75> }
    texture { wrench_texture }
   }
  object
   {
    Disk_X
    scale <9, 0.5, 0.5>
    translate <11, 0, -0.75>
    texture { wrench_texture }
  }
  object
   {
    Disk_X
    scale <9, 0.5, 0.5>
    translate <11, 0, 0.75>
    texture { wrench_texture }
  }
}

// Graver image map for wrench letters
#declare lb_three_quarters = object {  //box with engraved letters
  intersection{
    box {
      <-13, 0,-1>, <12, 6, 2>
      texture { wrench_texture }
    }
    height_field { 
      gif "wr_let.gif"
      translate <-.5, 0, 0>
      scale <23.1, .2, 2.7>
      rotate <-90, 0, 0>
      translate <0, 0, -.817>
      pigment { Silver }
      finish {diffuse 0.8 specular .7 roughness .1}
      smooth
    }
  }
}

// Open End
#declare open_box_end = intersection
 {
  object
   {
    Disk_Y
    scale <3.7, 1, 3.0>
    translate <1.1, 0, 0>
    texture { wrench_texture }
   }
  object
   {
    Disk_Y
    scale <2.5, 1, 3.2>
    texture { wrench_texture }
  }
}

// Build up the Open End
#declare open_end = difference {
  object { open_box_end } // main part
  object { box { <-3, -2, -1.3>, <0.5, 2, 1.3> }
           pigment { color Silver }} // 3/4 cut-out
  object { Disk_Y scale <1.0, 1.5, 1.3>
           translate <0.4, 0, 0> } // rounded cut-out
  object { box { <-3, -2, -1.3>, <0.5, 2, 1.3> }
           rotate <0, 45, 0> translate <-2.3, 0, 0> } // upper_clip
  object { box { <-3, -2, -1.3>, <0.5, 2, 1.3> }
           rotate <0, -45, 0> translate <-2.3, 0, 0> } // lower_clip
  texture { wrench_texture }
  scale <1, 0.75, 1>
  rotate <0, 165, 0>
  translate <21.5, 0, 0.4>
  }

// Build tool from parts
#declare wrench = union {
  object { box_end rotate <0, 0, -15> translate <-0.29, 0.4, 0> }
  object { handle }
  object
    {
      lb_three_quarters
      scale <0.4, 0.4, 0.1>
      rotate <90, 0, 0>
      translate <11, 0.7, -0.5>
    }
  object { open_end }
}

// Place the Object
object { wrench rotate <-10, 0, 0> }

