/*
#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

camera{
    location <0, 0, -75>
    look_at <0, 0, 0>
    rotate y*-30
}

light_source{ <200, 200, -500> color Gray75 }
*/

/////////////////////////////////////////////////////////////////////

#declare CabinetFrame =
union{

    // Left side
    box{
        <-24, 34.375, -7.5> <-23.5, -34.375, 7.5>
        texture{ CabinetTex }
        finish{ CabinetFin }
    }

    // Right side
    box{
        <24, 34.375, -7.5> <23.5, -34.375, 7.5>
        texture{ CabinetTex }
        finish{ CabinetFin }
    }

    // First shelf
    box{
        <-23.5, 34.125, 7.5> <23.5, 32.125, -7.5>
        texture{ CabinetTex rotate x*90 }
        finish{ CabinetFin }
    }

    // Second shelf
    union{
        difference{
            box{ <-23.5, 12.5, -7.5> <23.5, 14, 7.5> }
            union{
                box{ <-23.51, 12.75, -7.25> <23.51, 12.49, -7.501> }
                box{ <-23.51, 13.75, -7.25> <23.51, 14.01, -7.501> }

            }
        }
        union{
            cylinder{ <-23.5, 12.75, -7.25> <23.5, 12.75, -7.25> .25 }
            cylinder{ <-23.5, 13.75, -7.25> <23.5, 13.75, -7.25> .25 }
        }
        texture{ CabinetTex rotate x*90 }
        finish{ CabinetFin }
    }

    // Third shelf
    union{
        difference{
            box{ <-23.5, -10.375, -7.5> <23.5, -8.875, 7.5> }
            union{
                box{ <-23.51, -10.125, -7.25> <23.51, -11, -7.501> }
                box{ <-23.51, -9.125, -7.25> <23.51, -7, -7.501> }
            }
        }
        union{
            cylinder{ <-23.5, -10.125, -7.25> <23.5, -10.125, -7.25> .25 }
            cylinder{ <-23.5, -9.125, -7.25> <23.5, -9.125, -7.25> .25 }
        }
        texture{ CabinetTex rotate x*90 }
        finish{ CabinetFin }
    }

    // Bottom shelf
    box{
        <-23.5, -34.375, 7.5> <23.5, -32.375, -7.45>
        texture{ CabinetTex rotate x*90 }
        finish{ CabinetFin }
    }

    // Top middle partition
    box{
        <-.25, 33.125, 7.5> <.25, 13, -7.25>
        texture{ CabinetTex }
        finish{ CabinetFin }
    }

    // Right partition
    box{
        <2.5, 13, 7.5> <3, -34.375, -7.25>
        texture{ CabinetTex }
        finish{ CabinetFin }
    }
}

#declare DoorPartH =
box{ <-4.5, -.6, -6.5> <4.5, .6, -6.75> }

#declare DoorPartV =
box{ <-1, -11, -7> <1, 11, -6.75> }

#declare CabinetDoors =
union{
    union{
        object{ DoorPartV translate <-12, 0, 0> }
        object{ DoorPartV translate <-1.1, 0, 0> }
        object{ DoorPartV translate <1.1, 0, 0> }
        object{ DoorPartV translate <12, 0, 0> }
        texture{ CabinetTex }
        finish{ CabinetFin }
    }
    union{
        object{ DoorPartH translate <-6.5, (1.35*7.5), 0> }
        object{ DoorPartH translate <-6.5, (1.35*6.5), 0> }
        object{ DoorPartH translate <-6.5, (1.35*5.5), 0> }
        object{ DoorPartH translate <-6.5, (1.35*4.5), 0> }
        object{ DoorPartH translate <-6.5, (1.35*3.5), 0> }
        object{ DoorPartH translate <-6.5, (1.35*2.5), 0> }
        object{ DoorPartH translate <-6.5, (1.35*1.5), 0> }
        object{ DoorPartH translate <-6.5, (1.35*.5), 0> }
        object{ DoorPartH translate <-6.5, (1.35*-.5), 0> }
        object{ DoorPartH translate <-6.5, (1.35*-1.5), 0> }
        object{ DoorPartH translate <-6.5, (1.35*-2.5), 0> }
        object{ DoorPartH translate <-6.5, (1.35*-3.5), 0> }
        object{ DoorPartH translate <-6.5, (1.35*-4.5), 0> }
        object{ DoorPartH translate <-6.5, (1.35*-5.5), 0> }
        object{ DoorPartH translate <-6.5, (1.35*-6.5), 0> }
        object{ DoorPartH translate <-6.5, (1.35*-7.5), 0> }
        texture{ CabinetTex rotate x*90 }
        finish{ CabinetFin }
    }
    union{
        object{ DoorPartH translate <6.5, (1.35*7.5), 0> }
        object{ DoorPartH translate <6.5, (1.35*6.5), 0> }
        object{ DoorPartH translate <6.5, (1.35*5.5), 0> }
        object{ DoorPartH translate <6.5, (1.35*4.5), 0> }
        object{ DoorPartH translate <6.5, (1.35*3.5), 0> }
        object{ DoorPartH translate <6.5, (1.35*2.5), 0> }
        object{ DoorPartH translate <6.5, (1.35*1.5), 0> }
        object{ DoorPartH translate <6.5, (1.35*.5), 0> }
        object{ DoorPartH translate <6.5, (1.35*-.5), 0> }
        object{ DoorPartH translate <6.5, (1.35*-1.5), 0> }
        object{ DoorPartH translate <6.5, (1.35*-2.5), 0> }
        object{ DoorPartH translate <6.5, (1.35*-3.5), 0> }
        object{ DoorPartH translate <6.5, (1.35*-4.5), 0> }
        object{ DoorPartH translate <6.5, (1.35*-5.5), 0> }
        object{ DoorPartH translate <6.5, (1.35*-6.5), 0> }
        object{ DoorPartH translate <6.5, (1.35*-7.5), 0> }
        texture{ CabinetTex rotate x*90 }
        finish{ CabinetFin }
    }
    box{
        <-13, -11, -6.5> <13, 11, -6.7>
        pigment{ color Black }
    }
}

#declare CabinetDrawer =
union{
    box{ <-9.95, -2.7, -7> <9.95, 2.7, 5> }
    texture{ CabinetTex rotate x*90 }
    finish{ CabinetFin }
}

#declare Cabinet=
union{
    object{ CabinetFrame }
    object{ CabinetDoors translate <-10.25, -21.375, 0> }
    object{ CabinetDrawer translate <13.5, -13.5, 0> }
}

/*
object{
    Cabinet
}
*/
