#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

camera {
	location <15, 35, -50>       
	direction <0, 0, 3.3>
	look_at <10, 0, -1.5>
	}

light_source { <35, 75, -15> color White }

difference {
plane { y,0
	texture {
		pigment {
			image_map { gif "comics2.gif" }       
			rotate <90, 0, 0>
			}
		finish { ambient -0.05 }
		}
	scale <35, 1, 35>
	translate <-7, 0, 3>
	}
box { <-1, 0.1, -1>, <6, -0.1, 4> }
box { <6.5, 0.1, -1>, <13.5, -0.1, 4> }
box { <14, 0.1, -1>, <21, -0.1, 4> }
} //difference

plane { y,0
	texture { 
		pigment{
			granite
			turbulence 0.1
			color_map {
				[ 0, 0.6  color Gray05 color Gray05  ]
				[ 0.6, 1  color Gray05 color White   ]
				}
			}
		finish { ambient 0.4 }
		scale 4
		}
clipped_by { box { <-1, 0.1, -1>, <6, -0.1, 4> } }
	}

#declare frame =
union {
	sphere { <-1, 0, -1>, 0.1
		}
	sphere { <-1, 0, 4>, 0.1
		}
	sphere { <6, 0, -1>, 0.1
		}
	sphere { <6, 0, 4>, 0.1
		}
	cylinder { <-1, 0, -1>, <6, 0, -1>, 0.1
		}
	cylinder { <-1, 0, -1>, <-1, 0, 4>, 0.1
		}
	cylinder { <-1, 0, 4>, <6, 0, 4>, 0.1
		}
	cylinder { <6, 0, 4>, <6, 0, -1>, 0.1
		}
	texture {
		pigment { color Black }
		finish { phong 0.6
			phong_size 20
			diffuse 0
			}
		}
}

object { frame }


height_field { tga "fabric03.tga"
		scale <5, 1, 3>
		texture {
			pigment {
				image_map {
					tga "usflag.tga" 
					}       
					rotate <90, 0, 0>
					scale <5, 1, 3>
				}
			finish { ambient 0.4 }
			}
		no_shadow
		}

cylinder { <-0.025, 0.4, 3.3>, <-0.025, 0.4, -1>, 0.1
	texture { Silver1 }
	}

sphere { <-0.025, 0.4, 3.4>, 0.15
	texture { New_Brass }
	}

height_field { gif "caption7.gif"
		texture {
			pigment { gradient y 
				color_map {
					[ 0 color Gray30 ]
					[ 1 color White ] }
				}
			finish { ambient 0.4 }
			}
		no_shadow
		scale <7, 0.3, 2>
		translate <-1, -0.00001, -3.5>
		}

height_field { gif "caption8.gif"
		texture {
			pigment { gradient y 
				color_map {
					[ 0 color Gray30 ]
					[ 1 color White ] }
				}
			finish { ambient 0.4 }
			}
		no_shadow
		scale <7, 0.3, 2>
		translate <6.5, -0.00001, -3.5>
		}

height_field { gif "caption9.gif"
		texture {
			pigment { gradient y 
				color_map {
					[ 0 color Gray30 ]
					[ 1 color White ] }
				}
			finish { ambient 0.4 }
			}
		no_shadow
		scale <7, 0.3, 2>
		translate <14, -0.00001, -3.5>
		}

plane { y,0
	texture { 
		pigment{
			DMFLightOak
			scale <0.75, 1, 1.5> 
			rotate <2, -14, 0>
			}
		finish { ambient 0.4 }
		}
clipped_by { box { <6.5, 0.1, -1>, <13.5, -0.1, 4> } }
	}

object { frame
	translate <7.5, 0, 0>
	}

height_field { gif "wrnkppr1.gif"
	texture {
		pigment {
			image_map { tga "scfrt.tga" }
			rotate <90, 0, 0>
			}
		finish { ambient 0.3 }
		}
	scale <4.665, 0.1, 1.98>
	rotate <0, -25, 0>
	translate <7.75, 0.1, 0>
	}

height_field { gif "wrnkppr2.gif"
	texture {
		pigment {
			image_map { tga "scbck.tga" }
			rotate <90, 0, 0>
			}
		finish { ambient 0.3 }
		}
	scale <4.665, 0.1, 1.98>
	rotate <0, 10, 0>
	translate <8, 0, 0.4>
	}

plane { y,0
	texture { DMFDarkOak
		scale <0.5, 1, 5> 
		rotate <7, 35, 0>
		finish { ambient 0.4 }
		}
clipped_by { box { <14, 0.1, -1>, <21, -0.1, 4> } }
	}

object { frame
	translate <15, 0, 0>
	}


// Cartridge
#include "cartridg.pov"

object { cartridge
	scale 0.6
	rotate <0, -120, 0>
	translate <19, 0.6, 2.25>
	}

object { cartridge
	scale 0.6
	rotate <-90, 0, 0>
	translate <16, 0, 2.25>
	}

object { cartridge
	scale 0.6
	rotate <0, -150, 0>
	translate <20, 0.6, 1.75>
	}
