//  Persistance of Vision Raytracer V2.0
//  World definition file.
//
//  Contains 1 lights, 9 textures and 166 primitives.
//
//  This file was generated for POV-Ray V2.0 by
//  MORAY.EXE (c) '91 '92 '93 SoftTronics by Lutz Kretzschmar + Markus Lutz
//

//  Date : 11/25/1995    (25.11.1995)
//

//
//  This is MORAY's default standard include file for POV 2.0.
//  called MRYDFLT2.INC
//
//  It defines a standard scene environment of a grass plane on the 'floor'
//  and a blue sky that gets hazy towards the horizon.
//

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"

#include "landscap.pov"
plane {
  <0.0, 0.0, 1.0>, -0.01
  texture {
    pigment {
      rgb <0.0, 1.0, 0.0>
    }
    finish {
      ambient 0.1
      diffuse 0.3
      phong 0.2
      phong_size 5
      crand 0.075
    }
  }
}
sphere {
  <0, 0, 0>, 1
  texture {
    pigment {/*
    image_map {
      gif "fract002.gif"
      map_type 1
    }*/
    granite
    color_map{[0.0 color Clear]
                [0.2 color Clear]
                [0.2001 color White]
                [0.2002 color White]
                [0.2003 color Clear]
                [0.6 color Clear]
                [0.6001 color Gray75]
                [0.6002 color Clear]
                [1.0 color Clear]}
    }
    finish {
      ambient .5
      diffuse 0.0
    }
    scale 1
  }
  no_shadow
  scale <1000,1000,1000>
}
sphere{<0,0,0>,1000.1
        texture{pigment{color Black}
                finish{Luminous}}}
#declare BezFlatness = 0.01
#declare BezUStep    = 3
#declare BezVStep    = 3

camera {  //  Camera Camera01
  location  <275.000, 65.000, 50.000>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, 65.000, 20.000>
}

// *******  L I G H T S *******
object {   // Light source FireBall_Light2
  light_source {
    <0.000, 80.000, 20.000>
    color  red 0.900 green 0.900 blue 3.000
  }
}
// light_source{<0,-30,40> color White}

//
// ********  T E X T U R E S  *******
//

#include "insects.INC"

// ********  O B J E C T S *******
#declare Bound017 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <8.521955, 19.734875, 17.184984>
  translate <0.697779, 7.323014, 16.647604>
}

#declare Bound11 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <3.217985, 5.565061, 5.726809>
  translate <5.605185, 5.411335, 5.585992>
}

#declare Leg_Par1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Carapace_T
  }
  scale <0.500000, 0.500000, 10.000000>
  rotate <-135.000000, -45.000000, -0.000000>
  translate <3.000000, 3.125000, 10.700000>
}

#declare Leg_Par2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Carapace_T
  }
  scale <0.500000, 0.500000, 10.000000>
  rotate <-247.500000, 15.000000, -0.000000>
  translate <8.004326, 10.167478, 5.623820>
}

#declare Leg_J1 = object { 
  sphere {<0,0,0>,1}
  texture {
    Carapace_T
  }
  scale <0.750000, 0.750000, 0.750000>
  translate <7.887146, 10.040373, 5.687687>
}

#declare Bound012 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.052334, 0.552334, 2.477365>
  translate <0.000000, 0.000000, 1.425031>
}

#declare Palm2 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 0.500000, 1.000000>
}

#declare Fing_P5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.125000, 0.125000, 2.000000>
  translate <-0.500000, 0.000000, 0.875000>
}

#declare Fing_Tip5 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.125000, 0.125000, 1.000000>
  rotate <-195.000000, -0.000000, -0.000000>
  translate <-0.500000, 0.236905, 3.850063>
}

#declare Fing_J7 = object { 
  sphere {<0,0,0>,1}
  scale <0.200000, 0.200000, 0.200000>
  translate <-0.500000, 0.000000, 2.875000>
}

#declare Fing7 = union {
  object { Fing_P5 }
  object { Fing_Tip5 }
  object { Fing_J7 }
  translate <0.000000, 0.000000, -0.250000>
}

#declare Fing_P5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.125000, 0.125000, 2.000000>
  translate <-0.500000, 0.000000, 0.875000>
}

#declare Fing_Tip5 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.125000, 0.125000, 1.000000>
  rotate <-195.000000, -0.000000, -0.000000>
  translate <-0.500000, 0.236905, 3.850063>
}

#declare Fing_J7 = object { 
  sphere {<0,0,0>,1}
  scale <0.200000, 0.200000, 0.200000>
  translate <-0.500000, 0.000000, 2.875000>
}

#declare Fing8 = union {
  object { Fing_P5 }
  object { Fing_Tip5 }
  object { Fing_J7 }
  translate <0.500000, 0.000000, 0.000000>
}

#declare Fing_P5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.125000, 0.125000, 2.000000>
  translate <-0.500000, 0.000000, 0.875000>
}

#declare Fing_Tip5 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.125000, 0.125000, 1.000000>
  rotate <-195.000000, -0.000000, -0.000000>
  translate <-0.500000, 0.236905, 3.850063>
}

#declare Fing_J7 = object { 
  sphere {<0,0,0>,1}
  scale <0.200000, 0.200000, 0.200000>
  translate <-0.500000, 0.000000, 2.875000>
}

#declare Fing9 = union {
  object { Fing_P5 }
  object { Fing_Tip5 }
  object { Fing_J7 }
  translate <1.000000, 0.000000, -0.250000>
}

#declare Foot1 = union {
  object { Palm2 }
  object { Fing7 }
  object { Fing8 }
  object { Fing9 }
  texture {
    Carapace_T
  }
  bounded_by { Bound012 }
  rotate <-115.000000, -0.000000, -0.000000>
  translate <6.937877, 0.938606, 1.887023>
}

#declare Leg3 = union {
  object { Leg_Par1 }
  object { Leg_Par2 }
  object { Leg_J1 }
  object { Foot1 }
  texture {
    Carapace_T
  }
  bounded_by { Bound11 }
}

#declare Body_Seg1 = object { 
  sphere {<0,0,0>,1}
  texture {
    Carapace_T
  }
  scale <5.000000, 5.000000, 7.500000>
  translate <0.000000, 6.500000, 20.000000>
}

#declare Body_Seg2 = object { 
  sphere {<0,0,0>,1}
  texture {
    Carapace_T
  }
  scale <5.000000, 5.000000, 7.500000>
  rotate <-15.000000, -0.000000, -0.000000>
  translate <0.000000, 3.250000, 10.625000>
}

#declare Bound8 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <4.678676, 5.309381, 3.948676>
  translate <0.000000, 7.373705, 29.480000>
}

#declare Bound4 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <4.161743, 5.292448, 3.161743>
  translate <0.000000, 7.373705, 28.710000>
}

#declare Skullpar1 = object { 
  sphere {<0,0,0>,1}
  texture {
    Carapace_T
  }
  scale <4.000000, 5.000000, 3.000000>
  translate <0.000000, 7.243000, 28.710000>
}

#declare Nostril1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.500000, 0.500000, 2.000000>
  rotate <75.000000, -0.000000, -0.000000>
  translate <1.750000, 12.375000, 27.375000>
}

#declare Nostril2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.500000, 0.500000, 2.000000>
  rotate <75.000000, -0.000000, -0.000000>
  translate <-1.750000, 12.375000, 27.375000>
}

#declare Skull = difference {
  object { Skullpar1 }
  object { Nostril1 }
  object { Nostril2 }
  texture {
    Carapace_T
  }
  bounded_by { Bound4 }
}

#declare Eye3 = object { 
  sphere {<0,0,0>,1}
  texture {
    Eye_T
  }
  translate <3.500000, 8.000000, 29.750000>
}

#declare Eye4 = object { 
  sphere {<0,0,0>,1}
  texture {
    Eye_T
  }
  translate <-3.500000, 8.000000, 29.750000>
}

#declare Bound7 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <2.154882, 0.448632, 1.189808>
  translate <0.093750, 4.950000, 32.108824>
}

#declare Bound6 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <0.278928, 0.326153, 1.163792>
  translate <-1.756250, 5.046525, 32.108885>
}

#declare Antenpar7 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Anten_T
  }
  scale <0.125000, 0.125000, 1.000000>
  rotate <15.000000, -5.000000, -0.000000>
  translate <-1.750000, 5.125000, 31.000000>
}

#declare Antenpar8 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Anten_T
  }
  scale <0.125000, 0.125000, 1.000000>
  rotate <-5.000000, 2.500000, -0.000000>
  translate <-1.825000, 4.867574, 31.935163>
}

#declare Anten_Tip1 = object { 
  sphere {<0,0,0>,1}
  texture {
    Anten_Tip_T
  }
  scale <0.250000, 0.250000, 0.250000>
  translate <-1.750000, 5.000000, 33.000000>
}

#declare AntenJoint2 = object { 
  sphere {<0,0,0>,1}
  texture {
    Anten_T
  }
  scale <0.200000, 0.200000, 0.200000>
  translate <-1.812500, 5.150000, 31.950000>
}

#declare Antenna1 = union {
  object { Antenpar7 }
  object { Antenpar8 }
  object { Anten_Tip1 }
  object { AntenJoint2 }
  texture {
    Anten_T
  }
  bounded_by { Bound6 }
}

#declare Bound6 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <0.374517, 0.397139, 1.140694>
  translate <1.850000, 4.922622, 32.083824>
}

#declare Antenpar7 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Anten_T
  }
  scale <0.125000, 0.125000, 1.000000>
  rotate <-2.500000, 15.000000, -0.000000>
  translate <1.750000, 5.125000, 31.000000>
}

#declare AntenJoint1 = object { 
  sphere {<0,0,0>,1}
  texture {
    Anten_T
  }
  scale <0.200000, 0.200000, 0.200000>
  translate <2.000000, 4.875000, 31.950000>
}

#declare Antenpar8 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Anten_T
  }
  scale <0.125000, 0.125000, 1.000000>
  rotate <20.000000, -10.000000, -0.000000>
  translate <2.000344, 5.177782, 31.888736>
}

#declare Anten_Tip2 = object { 
  sphere {<0,0,0>,1}
  texture {
    Anten_Tip_T
  }
  scale <0.250000, 0.250000, 0.250000>
  translate <1.750000, 4.800000, 32.950000>
}

#declare Antenna3 = union {
  object { Antenpar7 }
  object { AntenJoint1 }
  object { Antenpar8 }
  object { Anten_Tip2 }
  texture {
    Anten_T
  }
  bounded_by { Bound6 }
}

#declare Antennae1 = union {
  object { Antenna1 }
  object { Antenna3 }
  texture {
    Anten_T
  }
  bounded_by { Bound7 }
}

#declare Head1 = union {
  object { Skull }
  object { Eye3 }
  object { Eye4 }
  object { Antennae1 }
  texture {
    Carapace_T
  }
  bounded_by { Bound8 }
}

#declare Bound9 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <2.773551, 10.497821, 1.974882>
  translate <2.612160, 16.172946, 19.187089>
}

#declare Arm_Par1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Carapace_T
  }
  scale <0.500000, 0.500000, 10.000000>
  rotate <-105.000000, -15.000000, -0.000000>
  translate <3.875000, 6.000000, 20.500000>
}

#declare Arm_Par4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Carapace_T
  }
  scale <0.500000, 0.500000, 10.000000>
  rotate <-75.000000, 75.000000, 35.000000>
  translate <4.529988, 15.570280, 18.011257>
}

#declare Arm_J2 = object { 
  sphere {<0,0,0>,1}
  texture {
    Carapace_T
  }
  scale <0.625000, 0.625000, 0.625000>
  translate <4.565247, 15.655379, 18.032672>
}

#declare Bound016 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.052334, 0.552334, 2.477365>
  translate <0.000000, 0.000000, 1.425031>
}

#declare Palm2 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 0.500000, 1.000000>
}

#declare Fing_P4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.125000, 0.125000, 2.000000>
  translate <-0.500000, 0.000000, 0.875000>
}

#declare Fing_Tip4 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.125000, 0.125000, 1.000000>
  rotate <-195.000000, -0.000000, -0.000000>
  translate <-0.500000, 0.236905, 3.850063>
}

#declare Fing_J6 = object { 
  sphere {<0,0,0>,1}
  scale <0.200000, 0.200000, 0.200000>
  translate <-0.500000, 0.000000, 2.875000>
}

#declare Fing4 = union {
  object { Fing_P4 }
  object { Fing_Tip4 }
  object { Fing_J6 }
  translate <0.000000, 0.000000, -0.250000>
}

#declare Fing_P4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.125000, 0.125000, 2.000000>
  translate <-0.500000, 0.000000, 0.875000>
}

#declare Fing_Tip4 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.125000, 0.125000, 1.000000>
  rotate <-195.000000, -0.000000, -0.000000>
  translate <-0.500000, 0.236905, 3.850063>
}

#declare Fing_J6 = object { 
  sphere {<0,0,0>,1}
  scale <0.200000, 0.200000, 0.200000>
  translate <-0.500000, 0.000000, 2.875000>
}

#declare Fing5 = union {
  object { Fing_P4 }
  object { Fing_Tip4 }
  object { Fing_J6 }
  translate <0.500000, 0.000000, 0.000000>
}

#declare Fing_P4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.125000, 0.125000, 2.000000>
  translate <-0.500000, 0.000000, 0.875000>
}

#declare Fing_Tip4 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.125000, 0.125000, 1.000000>
  rotate <-195.000000, -0.000000, -0.000000>
  translate <-0.500000, 0.236905, 3.850063>
}

#declare Fing_J6 = object { 
  sphere {<0,0,0>,1}
  scale <0.200000, 0.200000, 0.200000>
  translate <-0.500000, 0.000000, 2.875000>
}

#declare Fing6 = union {
  object { Fing_P4 }
  object { Fing_Tip4 }
  object { Fing_J6 }
  translate <1.000000, 0.000000, -0.250000>
}

#declare Hand3 = union {
  object { Palm2 }
  object { Fing4 }
  object { Fing5 }
  object { Fing6 }
  texture {
    Carapace_T
  }
  bounded_by { Bound016 }
  rotate <-15.000000, 90.000000, -0.000000>
  translate <1.000000, 25.250000, 18.648000>
}

#declare Arm3 = union {
  object { Arm_Par1 }
  object { Arm_Par4 }
  object { Arm_J2 }
  object { Hand3 }
  texture {
    Carapace_T
  }
  bounded_by { Bound9 }
  translate <0.000000, 0.000000, 1.000000>
}

#declare Bound10 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <2.773551, 10.497821, 1.974882>
  translate <-2.612160, 16.172946, 19.187089>
}

#declare Arm_Par2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Carapace_T
  }
  scale <0.500000, 0.500000, 10.000000>
  rotate <-105.000000, 15.000000, -0.000000>
  translate <-3.875000, 6.000000, 20.500000>
}

#declare Arm_Par3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Carapace_T
  }
  scale <0.500000, 0.500000, 10.000000>
  rotate <-75.000000, 75.000000, -5.000000>
  translate <-4.529988, 15.570280, 18.011257>
}

#declare Arm_J1 = object { 
  sphere {<0,0,0>,1}
  texture {
    Carapace_T
  }
  scale <0.625000, 0.625000, 0.625000>
  translate <-4.565247, 15.655379, 18.032672>
}

#declare Bound3 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.052334, 0.552334, 2.477365>
  translate <0.000000, 0.000000, 1.425031>
}

#declare Palm2 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 0.500000, 1.000000>
}

#declare Bound2 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <0.225413, 0.243866, 1.512944>
  translate <-0.500000, 0.018453, 2.362531>
}

#declare Fing_P1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.125000, 0.125000, 2.000000>
  translate <-0.500000, 0.000000, 0.875000>
}

#declare Fing_Tip1 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.125000, 0.125000, 1.000000>
  rotate <-195.000000, -0.000000, -0.000000>
  translate <-0.500000, 0.236905, 3.850063>
}

#declare Fing_J3 = object { 
  sphere {<0,0,0>,1}
  scale <0.200000, 0.200000, 0.200000>
  translate <-0.500000, 0.000000, 2.875000>
}

#declare Fing1 = union {
  object { Fing_P1 }
  object { Fing_Tip1 }
  object { Fing_J3 }
  bounded_by { Bound2 }
  translate <0.000000, 0.000000, -0.250000>
}

#declare Bound015 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <0.225413, 0.243866, 1.512944>
  translate <-0.500000, 0.018453, 2.362531>
}

#declare Fing_P2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.125000, 0.125000, 2.000000>
  translate <-0.500000, 0.000000, 0.875000>
}

#declare Fing_Tip2 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.125000, 0.125000, 1.000000>
  rotate <-195.000000, -0.000000, -0.000000>
  translate <-0.500000, 0.236905, 3.850063>
}

#declare Fing_J4 = object { 
  sphere {<0,0,0>,1}
  scale <0.200000, 0.200000, 0.200000>
  translate <-0.500000, 0.000000, 2.875000>
}

#declare Fing2 = union {
  object { Fing_P2 }
  object { Fing_Tip2 }
  object { Fing_J4 }
  bounded_by { Bound015 }
  translate <0.500000, 0.000000, 0.000000>
}

#declare Bound014 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <0.225413, 0.243866, 1.512944>
  translate <-0.500000, 0.018453, 2.362531>
}

#declare Fing_P3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.125000, 0.125000, 2.000000>
  translate <-0.500000, 0.000000, 0.875000>
}

#declare Fing_Tip3 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.125000, 0.125000, 1.000000>
  rotate <-195.000000, -0.000000, -0.000000>
  translate <-0.500000, 0.236905, 3.850063>
}

#declare Fing_J5 = object { 
  sphere {<0,0,0>,1}
  scale <0.200000, 0.200000, 0.200000>
  translate <-0.500000, 0.000000, 2.875000>
}

#declare Fing3 = union {
  object { Fing_P3 }
  object { Fing_Tip3 }
  object { Fing_J5 }
  bounded_by { Bound014 }
  translate <1.000000, 0.000000, -0.250000>
}

#declare Hand = union {
  object { Palm2 }
  object { Fing1 }
  object { Fing2 }
  object { Fing3 }
  texture {
    Carapace_T
  }
  bounded_by { Bound3 }
  rotate <-15.000000, -90.000000, -0.000000>
  translate <-1.000000, 25.250000, 18.648000>
}

#declare Arm4 = union {
  object { Arm_Par2 }
  object { Arm_Par3 }
  object { Arm_J1 }
  object { Hand }
  texture {
    Carapace_T
  }
  bounded_by { Bound10 }
  translate <0.000000, 0.000000, 1.000000>
}

#declare Bound011 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <2.580387, 7.828477, 7.245640>
  translate <-4.887541, -4.227137, 17.252794>
}

#declare Leg_Par3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Carapace_T
  }
  scale <0.500000, 0.500000, 10.000000>
  rotate <60.000000, -45.000000, -0.000000>
  translate <-3.000000, 3.125000, 10.700000>
}

#declare Leg_Par4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Carapace_T
  }
  scale <0.500000, 0.500000, 10.000000>
  rotate <15.000000, 5.000000, -0.000000>
  translate <-6.550584, -5.414169, 14.092149>
}

#declare Leg_J2 = object { 
  sphere {<0,0,0>,1}
  texture {
    Carapace_T
  }
  scale <0.750000, 0.750000, 0.750000>
  translate <-6.491589, -5.418596, 14.276323>
}

#declare Bound013 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.052334, 0.552334, 2.477365>
  translate <0.000000, 0.000000, 1.425031>
}

#declare Palm3 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 0.500000, 1.000000>
}

#declare Fing_P6 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.125000, 0.125000, 2.000000>
  translate <-0.500000, 0.000000, 0.875000>
}

#declare Fing_Tip6 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.125000, 0.125000, 1.000000>
  rotate <-195.000000, -0.000000, -0.000000>
  translate <-0.500000, 0.236905, 3.850063>
}

#declare Fing_J8 = object { 
  sphere {<0,0,0>,1}
  scale <0.200000, 0.200000, 0.200000>
  translate <-0.500000, 0.000000, 2.875000>
}

#declare Fing10 = union {
  object { Fing_P6 }
  object { Fing_Tip6 }
  object { Fing_J8 }
  translate <0.000000, 0.000000, -0.250000>
}

#declare Fing_P6 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.125000, 0.125000, 2.000000>
  translate <-0.500000, 0.000000, 0.875000>
}

#declare Fing_Tip6 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.125000, 0.125000, 1.000000>
  rotate <-195.000000, -0.000000, -0.000000>
  translate <-0.500000, 0.236905, 3.850063>
}

#declare Fing_J8 = object { 
  sphere {<0,0,0>,1}
  scale <0.200000, 0.200000, 0.200000>
  translate <-0.500000, 0.000000, 2.875000>
}

#declare Fing11 = union {
  object { Fing_P6 }
  object { Fing_Tip6 }
  object { Fing_J8 }
  translate <0.500000, 0.000000, 0.000000>
}

#declare Fing_P6 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.125000, 0.125000, 2.000000>
  translate <-0.500000, 0.000000, 0.875000>
}

#declare Fing_Tip6 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.125000, 0.125000, 1.000000>
  rotate <-195.000000, -0.000000, -0.000000>
  translate <-0.500000, 0.236905, 3.850063>
}

#declare Fing_J8 = object { 
  sphere {<0,0,0>,1}
  scale <0.200000, 0.200000, 0.200000>
  translate <-0.500000, 0.000000, 2.875000>
}

#declare Fing12 = union {
  object { Fing_P6 }
  object { Fing_Tip6 }
  object { Fing_J8 }
  translate <1.000000, 0.000000, -0.250000>
}

#declare Foot2 = union {
  object { Palm3 }
  object { Fing10 }
  object { Fing11 }
  object { Fing12 }
  texture {
    Carapace_T
  }
  bounded_by { Bound013 }
  rotate <105.000000, -0.000000, -0.000000>
  translate <-5.716942, -8.049083, 23.747575>
}

#declare Leg4 = union {
  object { Leg_Par3 }
  object { Leg_Par4 }
  object { Leg_J2 }
  object { Foot2 }
  texture {
    Carapace_T
  }
  bounded_by { Bound011 }
}

union {
  object { Leg3 }
  object { Body_Seg1 }
  object { Body_Seg2 }
  object { Head1 }
  object { Arm3 }
  object { Arm4 }
  object { Leg4 }
  texture {
    Carapace_T
  }
  bounded_by { Bound017 }
}

#declare Bound13 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <6.310186, 10.976938, 13.142169>
  translate <-0.256310, -1.340069, 12.747950>
}

#declare BodySeg = object { 
  sphere {<0,0,0>,1}
  texture {
    Carapace
  }
  scale <2.500000, 2.000000, 5.000000>
  rotate <-85.000000, -0.000000, -0.000000>
  translate <0.000000, -4.559650, 7.159834>
}

#declare BodySeg1 = object { 
  sphere {<0,0,0>,1}
  texture {
    Carapace
  }
  scale <2.500000, 2.000000, 3.000000>
  rotate <-5.000000, -0.000000, -0.000000>
  translate <0.000000, 0.187500, 10.000000>
}

#declare Bound003 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <2.443250, 3.099500, 2.218250>
  translate <-0.331250, 0.250000, 14.431250>
}

#declare Head = object { 
  sphere {<0,0,0>,1}
  texture {
    Carapace
  }
  scale <2.000000, 3.000000, 1.000000>
  translate <0.000000, 0.250000, 13.312500>
}

#declare Eye1 = object { 
  sphere {<0,0,0>,1}
  texture {
    Eye_T
  }
  scale <0.750000, 0.750000, 0.750000>
  translate <0.937500, 0.750000, 14.125000>
}

#declare Eye2 = object { 
  sphere {<0,0,0>,1}
  texture {
    Eye_T
  }
  scale <0.750000, 0.750000, 0.750000>
  translate <-0.937500, 0.750000, 14.125000>
}

#declare Antenpar1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Anten_T
  }
  scale <0.100000, 0.100000, 1.000000>
  rotate <5.000000, -45.000000, -0.000000>
  translate <-1.562500, -0.937500, 13.562500>
}

#declare Antenpar2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Anten_T
  }
  scale <0.100000, 0.100000, 1.000000>
  rotate <-0.000000, -10.000000, -0.000000>
  translate <-2.250000, -1.062500, 14.250000>
}

#declare Antenpar3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Anten_T
  }
  scale <0.100000, 0.100000, 1.000000>
  rotate <-10.000000, 5.000000, -0.000000>
  translate <-2.437500, -1.062500, 15.187500>
}

#declare Anten_Joint1 = object { 
  sphere {<0,0,0>,1}
  texture {
    Anten_T
  }
  scale <0.200000, 0.200000, 0.200000>
  translate <-2.250000, -1.062500, 14.312500>
}

#declare Anten_Joint2 = object { 
  sphere {<0,0,0>,1}
  texture {
    Anten_T
  }
  scale <0.200000, 0.200000, 0.200000>
  translate <-2.437500, -1.062500, 15.187500>
}

#declare Anten_Joint3 = object { 
  sphere {<0,0,0>,1}
  texture {
    Anten_T
  }
  scale <0.300000, 0.300000, 0.300000>
  translate <-2.375000, -0.937500, 16.250000>
}

#declare Anten1 = union {
  object { Antenpar1 }
  object { Antenpar2 }
  object { Antenpar3 }
  object { Anten_Joint1 }
  object { Anten_Joint2 }
  object { Anten_Joint3 }
}

#declare Antenpar5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Anten_T
  }
  scale <0.100000, 0.100000, 1.000000>
  rotate <-15.000000, -5.000000, -0.000000>
  translate <1.812500, -0.876250, 14.500000>
}

#declare Antenpar4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Anten_T
  }
  scale <0.100000, 0.100000, 1.000000>
  rotate <-5.000000, 15.000000, -0.000000>
  translate <1.562500, -0.938750, 13.562500>
}

#declare Antenpar6 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Anten_T
  }
  scale <0.100000, 0.100000, 1.000000>
  rotate <-30.000000, -20.000000, -0.000000>
  translate <1.750000, -0.626250, 15.437500>
}

#declare Anten_Joint4 = object { 
  sphere {<0,0,0>,1}
  texture {
    Anten_T
  }
  scale <0.200000, 0.200000, 0.200000>
  translate <1.812500, -0.875000, 14.500000>
}

#declare Anten_Joint5 = object { 
  sphere {<0,0,0>,1}
  texture {
    Anten_T
  }
  scale <0.200000, 0.200000, 0.200000>
  translate <1.750000, -0.625000, 15.437500>
}

#declare Anten_Joint6 = object { 
  sphere {<0,0,0>,1}
  texture {
    Anten_T
  }
  scale <0.300000, 0.300000, 0.300000>
  translate <1.437500, -0.125000, 16.250000>
}

#declare Antenna2 = union {
  object { Antenpar5 }
  object { Antenpar4 }
  object { Antenpar6 }
  object { Anten_Joint4 }
  object { Anten_Joint5 }
  object { Anten_Joint6 }
}

#declare Head_T = union {
  object { Head }
  object { Eye1 }
  object { Eye2 }
  object { Anten1 }
  object { Antenna2 }
  texture {
    Carapace
  }
  bounded_by { Bound003 }
}

#declare Bound001 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <2.169590, 2.618930, 4.901895>
  translate <-2.892146, -1.932194, 4.472342>
}

#declare Legpar1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Carapace
  }
  scale <0.200000, 0.200000, 5.000000>
  rotate <-2.500000, -40.000000, -0.000000>
  translate <-1.000000, -0.062500, 5.062500>
}

#declare Legpar2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Carapace
  }
  scale <0.200000, 0.200000, 5.000000>
  rotate <-1.250000, 5.000000, -0.000000>
  translate <-4.500000, -0.062500, 3.937500>
}

#declare Leg_Joint1 = object { 
  sphere {<0,0,0>,1}
  texture {
    Carapace
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <-4.125000, 0.062500, 8.750000>
}

#declare Legpar3 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Carapace
  }
  scale <0.200000, 0.200000, 6.250000>
  rotate <-45.000000, -5.000000, -0.000000>
  translate <-4.135362, -4.426888, -0.305317>
}

#declare Leg_Joint2 = object { 
  sphere {<0,0,0>,1}
  texture {
    Carapace
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <-4.437500, 0.000000, 4.062500>
}

#declare Leg1 = union {
  object { Legpar1 }
  object { Legpar2 }
  object { Leg_Joint1 }
  object { Legpar3 }
  object { Leg_Joint2 }
  texture {
    Carapace
  }
  bounded_by { Bound001 }
  translate <-0.500000, -7.500000, 1.750000>
}

#declare Bound002 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <2.282915, 1.858865, 5.563904>
  translate <3.005274, -1.535194, 3.964913>
}

#declare Legpar4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Carapace
  }
  scale <0.200000, 0.200000, 5.000000>
  rotate <5.000000, 40.000000, -0.000000>
  translate <1.000000, 0.000000, 5.250000>
}

#declare Legpar5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Carapace
  }
  scale <0.200000, 0.200000, 5.000000>
  rotate <-15.000000, -5.000000, -0.000000>
  translate <4.625000, -1.687500, 4.246271>
}

#declare Leg_Joint3 = object { 
  sphere {<0,0,0>,1}
  texture {
    Carapace
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <4.224826, -0.336803, 8.904386>
}

#declare Legpar6 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Carapace
  }
  scale <0.200000, 0.200000, 6.250000>
  rotate <-15.000000, 15.000000, -0.000000>
  translate <3.105798, -3.269627, -1.474559>
}

#declare Leg_Joint4 = object { 
  sphere {<0,0,0>,1}
  texture {
    Carapace
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <4.663757, -1.730313, 4.294078>
}

#declare Leg2 = union {
  object { Legpar4 }
  object { Legpar5 }
  object { Leg_Joint3 }
  object { Legpar6 }
  object { Leg_Joint4 }
  texture {
    Carapace
  }
  bounded_by { Bound002 }
  translate <0.500000, -7.500000, 1.750000>
}

#declare Bound007 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <2.156638, 0.785154, 5.738334>
  translate <2.892146, -0.111370, 3.622950>
}

#declare Legpar7 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Carapace
  }
  scale <0.200000, 0.200000, 5.000000>
  rotate <-2.500000, 40.000000, -0.000000>
  translate <1.000000, -0.062500, 5.062500>
}

#declare Legpar8 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Carapace
  }
  scale <0.200000, 0.200000, 5.000000>
  rotate <-1.250000, -5.000000, -0.000000>
  translate <4.500000, -0.062500, 3.937500>
}

#declare Leg_Joint5 = object { 
  sphere {<0,0,0>,1}
  texture {
    Carapace
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <4.125000, 0.062500, 8.750000>
}

#declare Legpar9 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Carapace
  }
  scale <0.200000, 0.200000, 6.250000>
  rotate <-6.250000, 12.500000, -0.000000>
  translate <3.078331, -0.785240, -2.004100>
}

#declare Leg_Joint6 = object { 
  sphere {<0,0,0>,1}
  texture {
    Carapace
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <4.437500, 0.000000, 4.062500>
}

#declare Leg5 = union {
  object { Legpar7 }
  object { Legpar8 }
  object { Leg_Joint5 }
  object { Legpar9 }
  object { Leg_Joint6 }
  texture {
    Carapace
  }
  bounded_by { Bound007 }
  translate <0.500000, -1.250000, 2.000000>
}

#declare Bound010 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <2.548023, 2.253592, 5.590324>
  translate <-3.261584, 1.869923, 3.547229>
}

#declare Legpar10 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Carapace
  }
  scale <0.200000, 0.200000, 5.000000>
  rotate <-20.000000, -40.000000, -0.000000>
  translate <-1.000000, -0.062500, 5.062500>
}

#declare Legpar11 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Carapace
  }
  scale <0.200000, 0.200000, 5.000000>
  rotate <22.000000, 15.000000, -0.000000>
  translate <-5.165174, 3.526066, 4.142381>
}

#declare Leg_Joint7 = object { 
  sphere {<0,0,0>,1}
  texture {
    Carapace
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <-4.073857, 1.847431, 8.504324>
}

#declare Legpar12 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Carapace
  }
  scale <0.200000, 0.200000, 6.250000>
  rotate <-5.000000, -10.000000, -0.000000>
  translate <-4.087260, 2.946890, -1.909865>
}

#declare Leg_Joint8 = object { 
  sphere {<0,0,0>,1}
  texture {
    Carapace
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <-5.176377, 3.490285, 4.173766>
}

#declare Leg6 = union {
  object { Legpar10 }
  object { Legpar11 }
  object { Leg_Joint7 }
  object { Legpar12 }
  object { Leg_Joint8 }
  texture {
    Carapace
  }
  bounded_by { Bound010 }
  translate <-0.500000, -1.250000, 2.000000>
}

#declare Bound008 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <2.555305, 4.667389, 1.753480>
  translate <-1.502002, 4.427310, 8.588401>
}

#declare Arm_par2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.250000, 0.250000, 5.000000>
  rotate <-120.000000, 35.000000, -0.000000>
  translate <-2.000000, 0.000000, 10.000000>
}

#declare Arm_par4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.250000, 0.250000, 4.000000>
  rotate <-90.000000, -0.000000, -37.500000>
  translate <-3.467447, 4.231968, 7.953857>
}

#declare Arm_J3 = object { 
  sphere {<0,0,0>,1}
  scale <0.500000, 0.500000, 0.500000>
  translate <-3.442228, 4.264242, 8.004361>
}

#declare Bound006 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <0.771539, 0.902789, 0.980723>
  translate <0.062500, 0.406250, 0.646684>
}

#declare Palm1 = object { 
  sphere {<0,0,0>,1}
  scale <0.300000, 0.300000, 0.300000>
}

#declare FingPar7 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.000000>
  rotate <-45.000000, -45.000000, -0.000000>
}

#declare FingPar8 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.000000>
  rotate <-90.000000, -0.000000, -0.000000>
}

#declare FingPar9 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.000000>
  rotate <-30.000000, 45.000000, -0.000000>
}

#declare FingPar10 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 0.500000>
  rotate <-10.000000, 5.000000, -0.000000>
  translate <0.625000, 0.500000, 0.575000>
}

#declare FingPar11 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 0.500000>
  rotate <-10.000000, -5.000000, -0.000000>
  translate <-0.500000, 0.650000, 0.450000>
}

#declare FingPar12 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 0.500000>
  rotate <-15.000000, -0.000000, -0.000000>
  translate <0.000000, 1.000000, 0.000000>
}

#declare FingJoint7 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <0.000000, 1.000000, 0.000000>
}

#declare FingJoint8 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <0.625332, 0.500000, 0.625000>
}

#declare FingJoint9 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <-0.500332, 0.675000, 0.500000>
}

#declare FingTip4 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.100000, 0.100000, 0.500000>
  rotate <-165.000000, -0.000000, -0.000000>
  translate <0.000000, 1.000000, 1.000000>
}

#declare FingTip5 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.100000, 0.100000, 0.500000>
  rotate <-180.000000, -0.000000, -0.000000>
  translate <0.650000, 0.575000, 1.550000>
}

#declare FingTip6 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.100000, 0.100000, 0.500000>
  rotate <-180.000000, -0.000000, -0.000000>
  translate <-0.525000, 0.750000, 1.425000>
}

#declare FingJoint10 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <0.000000, 1.125000, 0.500000>
}

#declare FingJoint11 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <0.650000, 0.575000, 1.075000>
}

#declare FingJoint12 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <-0.525000, 0.750000, 0.950000>
}

#declare ThumbPar2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 0.500000>
  rotate <30.000000, 5.000000, -0.000000>
  translate <0.000000, -0.078106, 0.151005>
}

#declare ThumbTip2 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.100000, 0.100000, 1.000000>
  rotate <-187.500000, -0.000000, -0.000000>
  translate <0.000000, -0.197869, 1.593368>
}

#declare ThumbJoint1 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <0.000000, -0.312500, 0.612672>
}

#declare Hand2 = union {
  object { Palm1 }
  object { FingPar7 }
  object { FingPar8 }
  object { FingPar9 }
  object { FingPar10 }
  object { FingPar11 }
  object { FingPar12 }
  object { FingJoint7 }
  object { FingJoint8 }
  object { FingJoint9 }
  object { FingTip4 }
  object { FingTip5 }
  object { FingTip6 }
  object { FingJoint10 }
  object { FingJoint11 }
  object { FingJoint12 }
  object { ThumbPar2 }
  object { ThumbTip2 }
  object { ThumbJoint1 }
  texture {
    Carapace
  }
  bounded_by { Bound006 }
  scale <1.250000, 1.250000, 1.250000>
  rotate <-0.000000, 90.000000, -0.000000>
  translate <-1.053485, 7.385871, 7.950000>
}

#declare Arm2 = union {
  object { Arm_par2 }
  object { Arm_par4 }
  object { Arm_J3 }
  object { Hand2 }
  texture {
    Carapace
  }
  bounded_by { Bound008 }
}

#declare Bound004 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <2.144011, 4.759738, 2.039528>
  translate <1.084644, 4.601669, 10.859129>
}

#declare Arm_par1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.250000, 0.250000, 5.000000>
  rotate <-100.000000, -45.000000, -0.000000>
  translate <2.000000, 0.000000, 10.000000>
}

#declare Arm_par3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.250000, 0.250000, 4.000000>
  rotate <-45.000000, -35.000000, -0.000000>
  translate <2.668000, 4.841133, 9.436265>
}

#declare Arm_J3 = object { 
  sphere {<0,0,0>,1}
  scale <0.500000, 0.500000, 0.500000>
  translate <2.613998, 4.903136, 9.434258>
}

#declare Bound005 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <0.771539, 0.902789, 0.980723>
  translate <0.062500, 0.406250, 0.646684>
}

#declare Palm = object { 
  sphere {<0,0,0>,1}
  scale <0.300000, 0.300000, 0.300000>
}

#declare FingPar1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.000000>
  rotate <-45.000000, -45.000000, -0.000000>
}

#declare FingPar2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.000000>
  rotate <-90.000000, -0.000000, -0.000000>
}

#declare FingPar3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.000000>
  rotate <-30.000000, 45.000000, -0.000000>
}

#declare FingPar4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 0.500000>
  rotate <-10.000000, 5.000000, -0.000000>
  translate <0.625000, 0.500000, 0.575000>
}

#declare FingPar5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 0.500000>
  rotate <-10.000000, -5.000000, -0.000000>
  translate <-0.500000, 0.650000, 0.450000>
}

#declare FingPar6 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 0.500000>
  rotate <-15.000000, -0.000000, -0.000000>
  translate <0.000000, 1.000000, 0.000000>
}

#declare FingJoint1 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <0.000000, 1.000000, 0.000000>
}

#declare FingJoint2 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <0.625332, 0.500000, 0.625000>
}

#declare FingJoint3 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <-0.500332, 0.675000, 0.500000>
}

#declare FingTip1 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.100000, 0.100000, 0.500000>
  rotate <-165.000000, -0.000000, -0.000000>
  translate <0.000000, 1.000000, 1.000000>
}

#declare FingTip2 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.100000, 0.100000, 0.500000>
  rotate <-180.000000, -0.000000, -0.000000>
  translate <0.650000, 0.575000, 1.550000>
}

#declare FingTip3 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.100000, 0.100000, 0.500000>
  rotate <-180.000000, -0.000000, -0.000000>
  translate <-0.525000, 0.750000, 1.425000>
}

#declare FingJoint4 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <0.000000, 1.125000, 0.500000>
}

#declare FingJoint5 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <0.650000, 0.575000, 1.075000>
}

#declare FingJoint6 = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <-0.525000, 0.750000, 0.950000>
}

#declare ThumbPar1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 0.500000>
  rotate <30.000000, 5.000000, -0.000000>
  translate <0.000000, -0.078106, 0.151005>
}

#declare ThumbTip1 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.100000, 0.100000, 1.000000>
  rotate <-187.500000, -0.000000, -0.000000>
  translate <0.000000, -0.197869, 1.593368>
}

#declare ThumbJoint = object { 
  sphere {<0,0,0>,1}
  scale <0.150000, 0.150000, 0.150000>
  translate <0.000000, -0.312500, 0.612672>
}

#declare Hand1 = union {
  object { Palm }
  object { FingPar1 }
  object { FingPar2 }
  object { FingPar3 }
  object { FingPar4 }
  object { FingPar5 }
  object { FingPar6 }
  object { FingJoint1 }
  object { FingJoint2 }
  object { FingJoint3 }
  object { FingTip1 }
  object { FingTip2 }
  object { FingTip3 }
  object { FingJoint4 }
  object { FingJoint5 }
  object { FingJoint6 }
  object { ThumbPar1 }
  object { ThumbTip1 }
  object { ThumbJoint }
  texture {
    Carapace
  }
  bounded_by { Bound005 }
  scale <1.250000, 1.250000, 1.250000>
  rotate <-0.000000, -90.000000, -0.000000>
  translate <1.047000, 7.653000, 11.784000>
}

#declare Arm1 = union {
  object { Arm_par1 }
  object { Arm_par3 }
  object { Arm_J3 }
  object { Hand1 }
  texture {
    Carapace
  }
  bounded_by { Bound004 }
}

#declare Bound12 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.581667, 1.581667, 12.956667>
  translate <0.000000, 0.000000, 12.750000>
}

#declare Haft = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Pine_Wood
  }
  scale <0.250000, 0.250000, 20.000000>
}

#declare Point = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Chrome_Texture
  }
  scale <0.250000, 0.250000, 5.000000>
  rotate <-180.000000, -0.000000, -0.000000>
  translate <0.000000, 0.000000, 25.500000>
}

#declare Bound009 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.415000, 1.415000, 0.290000>
  translate <0.000000, 0.000000, 20.250000>
}

#declare Guard_Middle = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.375000, 0.375000, 0.500000>
  translate <0.000000, 0.000000, 20.000000>
}

#declare Guard_Circle = quartic { 
           // Torus MinRadius=   0.188   MajRadius=   1.188 
           < 1.000,  0.000,  0.000,  0.000,  2.000,
             0.000,  0.000,  2.000,  0.000,  -2.891,
             0.000,  0.000,  0.000,  0.000,  0.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  0.000,  2.000,  0.000,
             -2.891,   0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  2.750, 0.000,  1.891 >
  translate <0.000000, 0.000000, 20.250000>
}

#declare Guard_Rod1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.250000>
  rotate <-90.000000, -0.000000, -0.000000>
  translate <0.000000, 0.000000, 20.250000>
}

#declare Guard_Rod2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.250000>
  rotate <-90.000000, -0.000000, -30.000000>
  translate <0.000000, 0.000000, 20.250000>
}

#declare Guard_Rod3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.250000>
  rotate <-90.000000, -0.000000, -60.000000>
  translate <0.000000, 0.000000, 20.250000>
}

#declare Guard_Rod4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.250000>
  rotate <-90.000000, -0.000000, -90.000000>
  translate <0.000000, 0.000000, 20.250000>
}

#declare Guard_Rod5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.250000>
  rotate <-90.000000, -0.000000, -120.000000>
  translate <0.000000, 0.000000, 20.250000>
}

#declare Guard_Rod6 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.250000>
  rotate <-90.000000, -0.000000, -150.000000>
  translate <0.000000, 0.000000, 20.250000>
}

#declare Guard_Rod7 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.250000>
  rotate <-90.000000, -0.000000, -180.000000>
  translate <0.000000, 0.000000, 20.250000>
}

#declare Guard_Rod8 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.250000>
  rotate <-90.000000, -0.000000, -210.000000>
  translate <0.000000, 0.000000, 20.250000>
}

#declare Guard_Rod9 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.250000>
  rotate <-90.000000, -0.000000, -240.000000>
  translate <0.000000, 0.000000, 20.250000>
}

#declare Guard_Rod10 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.250000>
  rotate <-90.000000, -0.000000, -270.000000>
  translate <0.000000, 0.000000, 20.250000>
}

#declare Guard_Rod11 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.250000>
  rotate <-90.000000, -0.000000, -300.000000>
  translate <0.000000, 0.000000, 20.250000>
}

#declare Guard_Rod12 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.250000>
  rotate <-90.000000, -0.000000, -330.000000>
  translate <0.000000, 0.000000, 20.250000>
}

#declare Guard = union {
  object { Guard_Middle }
  object { Guard_Circle }
  object { Guard_Rod1 }
  object { Guard_Rod2 }
  object { Guard_Rod3 }
  object { Guard_Rod4 }
  object { Guard_Rod5 }
  object { Guard_Rod6 }
  object { Guard_Rod7 }
  object { Guard_Rod8 }
  object { Guard_Rod9 }
  object { Guard_Rod10 }
  object { Guard_Rod11 }
  object { Guard_Rod12 }
  texture {
    Bronze_Texture
  }
  bounded_by { Bound009 }
}

#declare Pike1 = union {
  object { Haft }
  object { Point }
  object { Guard }
  texture {
    Pine_Wood
  }
  bounded_by { Bound12 }
  translate <0.000000, 7.637500, 0.000000>
}

union {
  object { BodySeg }
  object { BodySeg1 }
  object { Head_T }
  object { Leg1 }
  object { Leg2 }
  object { Leg5 }
  object { Leg6 }
  object { Arm2 }
  object { Arm1 }
  object { Pike1 }
  texture {
    Eye_T
  }
  bounded_by { Bound13 }
  scale <2.000000, 2.000000, 2.000000>
  rotate <-0.000000, -0.000000, -180.000000>
  translate <0.000000, 120.000000, 0.000000>
}

#declare Bound018 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <2.750000, 14.000000, 2.750000>
  translate <0.000000, 73.750000, 20.000000>
}

#declare FireBall1 = object { 
  sphere {<0,0,0>,1}
  texture {
    Fire_Ball_T
  }
  scale <2.500000, 7.500000, 2.500000>
  translate <0.000000, 80.000000, 20.000000>
}

#declare Tail1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    pigment{gradient z
        color_map{[0.0 color NeonBlue filter 1.0]
                  [1.0 color NeonBlue]}
        turbulence .25}
    finish{Luminous}
  }
  scale <2.500000, 2.500000, 20.000000>
  rotate <-90.000000, -0.000000, -0.000000>
  translate <0.000000, 60.000000, 20.000000>
}

union {   // FireBall
  object { FireBall1 }
  object { Tail1 }
  texture {
    Fire_Ball_T
    normal{wrinkles 1.0 scale 10}
  }
  no_shadow
  bounded_by { Bound018 }
}
