// Base is nominally 100x100
// Water level is -10, floor level is zero.  Floor center is origin.

#declare DELTA = 0.1 

#declare holes =
union
{
  cylinder { <-37.5, -30, -51>, <-37.5, -30, 51>, 25 }
  cylinder { <-12.5, -30, -51>, <-12.5, -30, 51>, 25 }
  cylinder { < 12.5, -30, -51>, < 12.5, -30, 51>, 25 }
  cylinder { < 37.5, -30, -51>, < 37.5, -30, 51>, 25 }
}

#declare baseblock = 
object
{
  difference 
  {
    box { <-50, -12, -50>, <50, 0, 50> }
    union 
    {
      object { holes }
      object { holes rotate y*90 }
    }
  }
  bounded_by 
  { 
    box { <-50-DELTA,-12-DELTA,-50-DELTA >, <50+DELTA,12+DELTA,50+DELTA > }
  }  
}

#declare butts =
union
{
  box { <-52, -12, -52>, <-48, 0, -48 > }
  box { <-27, -12, -52>, <-23, 0, -48 > }
  box { < -2, -12, -52>, <  2, 0, -48 > }
  box { < 23, -12, -52>, < 27, 0, -48 > }
  box { < 48, -12, -52>, < 52, 0, -48 > }
}

#declare walls = 
difference
{
  box { <-51, -0.5, -51>, <51, 2, 51> }
  union
  {
    box { <-49, 0, -49>, <49, 2.1,  49> }
    box { <-4,  0, -46>, <-1, 3,   -54> }
  }
}

#declare stepblock = box { <-4, -2, -60>, <-1, 0, -50> }

union 
{ 
  object { baseblock }
  object { box { <-51, -3, -51>, <51, -2, 51> } }
  object { butts }
  object { butts rotate y*90 }
  object { walls }
  object { stepblock }
  texture { pigment { Red } finish { crand 0.17 } }
}

//floor
box { <-45, 0, -45>, <45, 0.1, 45> texture { pigment { Gray70 } } }

