#declare SC_INNER = 0.5
#declare SC_OUTER = 1.0
#declare SC_WIDTH = 0.3
#declare SC_DEPTH = 0.05
#declare SC_HBAR  = 0.4
#declare SC_RBAR  = 0.03
#declare SC_ROT  = -15
#declare SC_YINC = 1/24


#declare DELTA = 0.001

#declare step =
intersection
{
  difference 
  {
				cylinder { <0,  0,     0>, <0, SC_DEPTH,       0 >, SC_OUTER }
				cylinder { <0, -DELTA, 0>, <0, SC_DEPTH+DELTA, 0 >, SC_INNER }
  }
  cone { <0, 0, 0>, 0, <SC_OUTER+DELTA, 0, 0>, SC_WIDTH/2 }
  bounded_by { 
    box { <SC_INNER-DELTA, -DELTA,         -SC_WIDTH-DELTA>,
          <SC_OUTER+DELTA,  SC_DEPTH+DELTA,  SC_WIDTH+DELTA>
    }
  }
  texture { Red_Marble }
}

#declare quarter_sweep = union
{
  object { step }
  object { step rotate y*SC_ROT   translate <0, SC_YINC, 0> }
  object { step rotate y*SC_ROT*2 translate <0, SC_YINC*2, 0> }
  object { step rotate y*SC_ROT*3 translate <0, SC_YINC*3, 0> }
  object { step rotate y*SC_ROT*4 translate <0, SC_YINC*4, 0> }
  object { step rotate y*SC_ROT*5 translate <0, SC_YINC*5, 0> }
}

#declare single_sweep = union 
{
  object { quarter_sweep }
  object { quarter_sweep rotate y*-90  translate <0, SC_YINC*6,  0> }
  object { quarter_sweep rotate y*-180 translate <0, SC_YINC*12, 0> }
  object { quarter_sweep rotate y*-270 translate <0, SC_YINC*18, 0> }
}

/****************************************************************************/
/* Parameters for "spiral" C program
#define START_RADIUS      1.0
#define END_RADIUS        1.0
#define NODE_SPHERE      0.03
#define LINK_SPHERE      0.02
#define NCIRCLES          1.0
#define NODES_PER_CIRCLE   24
#define LINKS_PER_NODE     12
#define HEIGHT            1.0
#define NODE_OBJECT         0   /* 0 = sphere, 1 = cylinder, 2 = box */
#define LINK_OBJECT         0   /* 0 = sphere, 1 = cylinder, 2 = box */
#define ORDER               0   /* 0 = arbitrary, 1 = n/l, 2 = l/n */
#define NODE_TEXTURE "nodeTexture"
#define LINK_TEXTURE "linkTexture"
#define NODE_TYPE    "union"
*/

/* comment out
#declare nodeTexture = texture { Polished_Brass }
#declare linkTexture = texture { Polished_Chrome }

#include "spiral.inc"
*/

#declare spiral = union
{
//  object { rail translate <0,SC_HBAR,0> }
  object { single_sweep }
  cylinder { <0,0,0>, <0,1.3,0>, 0.5 texture { pigment { Gray50 } } }
}


object { spiral scale <6,6,6> 
  bounded_by { cylinder { <0,0,0>, <0,8,0>, 7.2 } }
  translate <-7, -6, -60> 
}


union
{
  object { spiral scale <8,8,8> }
  object { spiral scale <8,8,8> translate <0,8,0>}
  object { spiral scale <8,8,8> translate <0,16,0>}
  object { spiral scale <8,8,8> translate <0,24,0>}
  object { spiral scale <8,8,8> translate <0,32,0>}
  bounded_by { cylinder { <0,0,0>, <0,45,0>, 9.6 } }
}
