
// For GPBRIDGE.POV

#declare Pyramid2 = intersection {
   plane { < 1, 0,  0>, 1  rotate <  0, 0,  40>}
   plane { <-1, 0,  0>, 1  rotate <  0, 0, -40>}
   plane { < 0, 0,  1>, 1  rotate <-40, 0,   0>}
   plane { < 0, 0, -1>, 1  rotate < 40, 0,   0>}
   plane { <0, -1, 0>, 0 }
   translate <0 ,-1, 0>
}

#declare BridgeTex = texture{
pigment{
    marble
    turbulence 1
    color_map{
        [0.0, 1.0 color rgb <.6, .6, .6> color rgb <.8, .8, .8>]
    }
}}

/////////////////////////////////////////////////////////////////////

#declare Pier = object{
union{
    cylinder{ <0, 0, 0> <0, -11, 0> 20 }
    cylinder{ <0, -1, 0> <0, -500, 0> 10 }
}
texture{ BridgeTex }
}

#declare Pylon = object{
union{
    box{ <4.5, 335, 9> <-4.5, 0, -9> }
    object{ Pyramid2
        scale <12, 10, 20>
        translate <0, 342, 0>
    }
    object{ Pyramid2
        rotate x*-180
        scale <12, 45, 20>
        translate <0, 287, 0>
    }
}
texture{ BridgeTex }
}

#declare RCables = object{
union{
    cylinder{ <0, 345, 0> <47.5, 0, -45.6> 2 }
    cylinder{ <0, 345, 0> <47.5, 0, -45.6-(1*35)> 2 }
    cylinder{ <0, 345, 0> <47.5, 0, -45.6-(2*35)> 2 }
    cylinder{ <0, 345, 0> <47.5, 0, -45.6-(3*35)> 2 }
    cylinder{ <0, 345, 0> <47.5, 0, -45.6-(4*35)> 2 }
    cylinder{ <0, 345, 0> <47.5, 0, -45.6-(5*35)> 2 }
    cylinder{ <0, 345, 0> <47.5, 0, -45.6-(6*35)> 2 }
    cylinder{ <0, 345, 0> <47.5, 0, -45.6-(7*35)> 2 }
    cylinder{ <0, 345, 0> <47.5, 0, -45.6-(7*35)-(11.5/2)> 2 }
    cylinder{ <0, 345, 0> <47.5, 0, -45.6-(7*35)-11.5> 2 }

    cylinder{ <0, 345, 0> <47.5, 0, 45.6> 2 }
    cylinder{ <0, 345, 0> <47.5, 0, 45.6+(1*35)> 2 }
    cylinder{ <0, 345, 0> <47.5, 0, 45.6+(2*35)> 2 }
    cylinder{ <0, 345, 0> <47.5, 0, 45.6+(3*35)> 2 }
    cylinder{ <0, 345, 0> <47.5, 0, 45.6+(4*35)> 2 }
    cylinder{ <0, 345, 0> <47.5, 0, 45.6+(5*35)> 2 }
    cylinder{ <0, 345, 0> <47.5, 0, 45.6+(6*35)> 2 }
    cylinder{ <0, 345, 0> <47.5, 0, 45.6+(7*35)> 2 }
    cylinder{ <0, 345, 0> <47.5, 0, 45.6+(8*35)> 2 }
    cylinder{ <0, 345, 0> <47.5, 0, 45.6+(9*35)> 2 }

}}

#declare LCables = object{
union{
    cylinder{ <0, 345, 0> <-47.5, 0, -45.6> 2 }
    cylinder{ <0, 345, 0> <-47.5, 0, -45.6-(1*35)> 2 }
    cylinder{ <0, 345, 0> <-47.5, 0, -45.6-(2*35)> 2 }
    cylinder{ <0, 345, 0> <-47.5, 0, -45.6-(3*35)> 2 }
    cylinder{ <0, 345, 0> <-47.5, 0, -45.6-(4*35)> 2 }
    cylinder{ <0, 345, 0> <-47.5, 0, -45.6-(5*35)> 2 }
    cylinder{ <0, 345, 0> <-47.5, 0, -45.6-(6*35)> 2 }
    cylinder{ <0, 345, 0> <-47.5, 0, -45.6-(7*35)> 2 }
    cylinder{ <0, 345, 0> <-47.5, 0, -45.6-(7*35)-(11.5/2)> 2 }
    cylinder{ <0, 345, 0> <-47.5, 0, -45.6-(7*35)-11.5> 2 }

    cylinder{ <0, 345, 0> <-47.5, 0, 45.6> 2 }
    cylinder{ <0, 345, 0> <-47.5, 0, 45.6+(1*35)> 2 }
    cylinder{ <0, 345, 0> <-47.5, 0, 45.6+(2*35)> 2 }
    cylinder{ <0, 345, 0> <-47.5, 0, 45.6+(3*35)> 2 }
    cylinder{ <0, 345, 0> <-47.5, 0, 45.6+(4*35)> 2 }
    cylinder{ <0, 345, 0> <-47.5, 0, 45.6+(5*35)> 2 }
    cylinder{ <0, 345, 0> <-47.5, 0, 45.6+(6*35)> 2 }
    cylinder{ <0, 345, 0> <-47.5, 0, 45.6+(7*35)> 2 }
    cylinder{ <0, 345, 0> <-47.5, 0, 45.6+(8*35)> 2 }
    cylinder{ <0, 345, 0> <-47.5, 0, 45.6+(9*35)> 2 }
}}

#declare Cables = object{
union{
    object{ RCables }
    object{ LCables }
}
texture{ pigment{ color Black } }
}


#declare Bridge = object{
union{

    object{
        Cables
        translate <0, 0, -378>
    }
    object{
        Cables
        translate <0, 0, -378>
        rotate y*180
    }

// Main stretch of bridge (plus siderails)
    
    box{
        <45, 6, 2310> <-45, -6, -2310>
        texture{ BridgeTex }
    }
    box{
        <45, 10, 2310> <50, -6, -2310>
        texture{ BridgeTex }
    }
    box{
        <-45, 10, 2310> <-50, -6, -2310>
        texture{ BridgeTex }
    }

// Strip down middle of road

    box{
        <5, 6.9999, 2310> <-5, 10, -2310>
        texture{ BridgeTex }
    }

// Pavement

    box{
        <44.9, 6.0001, 2310> <-44.9, 5.9999, -2310>
        texture{
            pigment{ color Gray30 }
        }
    }
    box{
        <24, 5.999, 2310> <26, 6.001, -2310>
        texture{
            pigment{
                gradient z
                color_map{
                    [0.0 0.5 color Yellow color Yellow]
                    [0.5 1.01 color White filter 1 color White filter 1]
                }
            }
            scale <1, 1, 100>
        }
    }
    box{
        <-24, 5.999, 2310> <-26, 6.001, -2310>
        texture{
            pigment{
                gradient z
                color_map{
                    [0.0 0.5 color Yellow color Yellow]
                    [0.5 1.01 color White filter 1 color White filter 1]
                }
            }
            scale <1, 1, 100>
        }
    }

// Pylons

    object{
        Pylon
        translate <0, 0, 378>
    }
    object{
        Pylon
        translate <0, 0, -378>
    }
                    
// Piers

    object{ Pier translate <0, 0, -(35/2)-315-45.5> }
    object{ Pier translate <0, 0, -(35/2)-315-45.5-45.5-245-11.5> }
    object{ Pier translate <0, 0, -(35/2)-315-45.5-45.5-245-11.5-(1*154)> }
    object{ Pier translate <0, 0, -(35/2)-315-45.5-45.5-245-11.5-(2*154)> }
    object{ Pier translate <0, 0, -(35/2)-315-45.5-45.5-245-11.5-(3*154)> }
    object{ Pier translate <0, 0, -(35/2)-315-45.5-45.5-245-11.5-(4*154)> }
    object{ Pier translate <0, 0, -(35/2)-315-45.5-45.5-245-11.5-(5*154)> }
    object{ Pier translate <0, 0, -(35/2)-315-45.5-45.5-245-11.5-(6*154)> }
    object{ Pier translate <0, 0, -(35/2)-315-45.5-45.5-245-11.5-(7*154)> }
    object{ Pier translate <0, 0, -(35/2)-315-45.5-45.5-245-11.5-(8*154)> }
    object{ Pier translate <0, 0, -(35/2)-315-45.5-45.5-245-11.5-(9*154)> }
    object{ Pier translate <0, 0, -(35/2)-315-45.5-45.5-245-11.5-(10*154)>}


    object{ Pier translate <0, 0, (35/2)+315+45.5> }
    object{ Pier translate <0, 0, (35/2)+315+45.5+45.5+245+11.5> }
    object{ Pier translate <0, 0, (35/2)+315+45.5+45.5+245+11.5+(1*154)> }
    object{ Pier translate <0, 0, (35/2)+315+45.5+45.5+245+11.5+(2*154)> }
    object{ Pier translate <0, 0, (35/2)+315+45.5+45.5+245+11.5+(3*154)> }
    object{ Pier translate <0, 0, (35/2)+315+45.5+45.5+245+11.5+(4*154)> }
    object{ Pier translate <0, 0, (35/2)+315+45.5+45.5+245+11.5+(5*154)> }
    object{ Pier translate <0, 0, (35/2)+315+45.5+45.5+245+11.5+(6*154)> }
    object{ Pier translate <0, 0, (35/2)+315+45.5+45.5+245+11.5+(7*154)> }
    object{ Pier translate <0, 0, (35/2)+315+45.5+45.5+245+11.5+(8*154)> }
    object{ Pier translate <0, 0, (35/2)+315+45.5+45.5+245+11.5+(9*154)> }
    object{ Pier translate <0, 0, (35/2)+315+45.5+45.5+245+11.5+(10*154)> }

}}
